;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define abe-lvl 3)
(define abe-species sp_human)
(define abe-occ nil)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Ф
;;----------------------------------------------------------------------------
(define abe-bed gt-abe-bed)
(define abe-mealplace gt-ws-tbl2)
(define abe-workplace gt-ruins)
(define abe-leisureplace gt-ws-hall)
(kern-mk-sched 'sch_abe
               (list 0  0 abe-bed          "sleeping")
               (list 7  0 abe-mealplace    "eating")
               (list 8  0 abe-workplace    "working")
               (list 12 0 abe-mealplace    "eating")
               (list 13 0 abe-workplace    "working")
               (list 18 0 abe-mealplace    "eating")
               (list 19 0 abe-leisureplace "idle")
               (list 22 0 abe-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (abe-mk) (list #f))
(define (abe-met? gob) (car gob))
(define (abe-met! gob) (set-car! gob #t))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ֤ǤΤȤ褯ΤؼԤǤ롣
;; ϣѻդȤȤ˥֥åȤƨ졢Ф˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (abe-hail knpc kpc)
  (kern-print "ʤϼ㤤ؼˤȲä\n")
  (if (abe-met? (gob knpc))
      (say knpc "ޤ񤤤ޤ͡")
      (begin
        (abe-met! (gob knpc))
        (say knpc "ˤϡΡ⤷¤͡")
        (if (yes? kpc)
            (say knpc "ƸɤǤʬιʤ"
                 "ʹȤǤ"
                 "⤷褫ä֤ȤʹƤ")
            (say knpc "Ϥߤޤ󡣤ĤĵˤʤǤ")))))

(define (abe-default knpc kpc)
  (say knpc "񤬤äĴ٤Ƥޤ"))

(define (abe-name knpc kpc)
  (say knpc "ͤϥ֡"))

(define (abe-join knpc kpc)
  (say knpc "䡢ϤǤޤͤϤͤǤϤʤΤǡ"))

(define (abe-job knpc kpc)
  (say knpc "ͤϳؼԤǤФˤפĴ٤Ƥޤ⤦ޤ")
  (if (no? kpc)
      (say knpc "פĮˤޤ̣ΤǤ")
      (begin
        (say knpc "ϲˤϤäȤ뤳ȤΤäƤޤ")
        (yes? kpc)
        (say knpc "֥åȤΤ褦ˡ"))))

(define (abe-absa knpc kpc)
  (say knpc "¿οͤϥ֥åȤβ˸ŤĮ뤳ȤΤޤ"
       "֥åȤϲΰפϡФΰפȤȤƤ褯Ƥޤ"
       "ͤƱʸο͡Ƥ˰㤤ʤȳοƤޤ"))

(define (abe-rune knpc kpc)
  (if (any-in-inventory? kpc rune-types)
      (begin
	 (say knpc "Ťˤ䤤"
	     "ȬĤθäƤΤǤ"
	     "Ĵ٤Ƥ")
		(quest-data-update 'questentry-runeinfo 'abe 1)
	 (quest-data-update-with 'questentry-runeinfo 'keys 1 (quest-notify (grant-party-xp-fn 20)))
	(if (any-in-inventory? kpc (list t_rune_k))
	    (say knpc "ǤĴ٤ϤμǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_p))
	    (say knpc "ǤĴ٤ϤϤǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_s))
	    (say knpc "ǤĴ٤ϤϵǽǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_c))
	    (say knpc "ǤĴ٤ϤϻθǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_f))
	    (say knpc "ǤĴ٤ϤϼͳǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_w))
	    (say knpc "ǤĴ٤ϤǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_d))
	    (say knpc "ǤĴ٤Ϥʬ̤ǤǤ")
	    )
	(if (any-in-inventory? kpc (list t_rune_l))
	    (say knpc "ǤĴ٤ϤǤǤ")
	    )
	(if (has-all-runes? kpc) 
	    (say knpc "ʤ"
	         "ȬĤΰθ·äƤޤ"
	         "ΤɤĤǤ")
	    )
	)
      (say knpc "Ǥ뤽Ǥºݤ˸뤳ȤǤСġ")))

(define (abe-demo knpc kpc)
  (say knpc "ϱΡԤˤäޤ"
       "ξϤ뵭ϿäޤǤϤɤ̤Τۤˤ뤽Ǥ")
		(quest-data-update 'questentry-runeinfo 'abe 1)
	     (quest-data-update 'questentry-runeinfo 'keys 1)
  		(quest-data-update-with 'questentry-runeinfo 'gate 1 (quest-notify (grant-party-xp-fn 30)))
       )

(define (abe-keys knpc kpc)
  (say knpc "Ϥ졢ȬĤʬޤ"
       "줾줬Ϥ᤿ǤǤ"
       "θ夽ϼ줿ޤ"))
       
(define (abe-eigh knpc kpc)
	(say knpc "ǤǤȬĤ뤽Ǥ¾ǤõƤΤǤ")
	(if (yes? kpc)
		(say knpc "ŤäǤϡӥθǤäȤλˤʤɤȸƤޤ")
		(say knpc "񿴤ϤʤΤǤƤΤäƤޤ")))

(define (abe-clov knpc kpc)
     (say knpc "ǤϥӥȤƻäƤǤ"
           "ϥ֥Ȥ̿Ȥޤ˴ϸĤޤǤ"
           "ï(⤷^c+m֥^c-)åäΤ⤷ޤ")
           (quest-data-assign-once 'questentry-rune-f)
           )
           
(define (abe-temp knpc kpc)
	(say knpc "ѡǤλϵ⤫Ǥޤï⤿ɤ夯ȤǤޤ󤬡"
			"ǤϤäΡǤ줿ȤƤޤ")
			(quest-data-assign-once 'questentry-rune-d)
			)
      
(define (abe-void knpc kpc)
  (say knpc "ΥɡƹʵˤΤǤ"
       "ĤƵҹԤꡢϤ褦˵ϤäǤ")
       (quest-data-update 'questentry-whereami 'shard 2)
       )

(define (abe-ship knpc kpc)
  (say knpc "ΤȤʹȤޤܤȤϤ狼ޤ"
       "ͤĺʤ餽μ줿¤狼뤫⤷ޤ")
       (quest-data-update 'questentry-whereami 'shard 2)
       )

(define (abe-wrig knpc kpc)
  (say knpc "ͤʪ뤳ȤĹԤǤ"
       "դϺǺǤʿͤǤ"))

(define (abe-quee knpc kpc)
  (say knpc "ΤȤ褯狼ޤ"))

(define (abe-civi knpc kpc)
  (say knpc "ΰפƤʸΤȤϤ褯狼ޤ󡣤Ǥ⤽μ꤬ϡ줬䤿δǸƤȤƤ⽹Ȥˤޤ̣뤫狼ޤ")
  (if (yes? kpc)
      (say knpc "ʤиʤǤޤ礦")
      (say knpc "ͤӡԤؤοҡ줿ԤνǤ")))

(define (abe-accu knpc kpc)
  (say knpc "Ϥ줿ԤˤĹˤޤŪʰ򤫤⤷ޤ"
       "餬ԤԤäȡ뤤¸ߤξڵϽʬˤޤ"))

(define (abe-bye knpc kpc)
  (say knpc "פˤĤƲ狼ä鶵Ƥ"))

(define (abe-alch knpc kpc)
  (say knpc "θť̥ǤٿƱΤǤǶϲäƤޤ"))

(define (abe-neig knpc kpc)
  (say knpc "֥åȤǡƨϤˤޤ"))

(define (abe-flee knpc kpc)
  (say knpc "Τ©äĹʤޤοͤʹƤߤƤ⤦ɤǤ⤤ȤǤ"))

(define (abe-gobl knpc kpc)
  (say knpc "ǥåĹʹƤߤƤ¿ΤȤΤäƤޤ"))

(define abe-conv
  (ifc green-tower-conv

       ;; basics
       (method 'default abe-default)
       (method 'hail abe-hail)
       (method 'bye abe-bye)
       (method 'job abe-job)
       (method 'name abe-name)
       (method 'join abe-join)
       

       (method 'absa abe-absa)
       (method 'rune abe-rune)
       (method 'demo abe-demo)
       (method 'gate abe-demo)
       (method 'keys abe-keys)
       (method 'key  abe-keys)
       (method 'eigh abe-eigh)
       (method 'quee abe-quee)
       (method 'king abe-clov)
       (method 'clov abe-clov)
       (method 'char abe-clov)
       (method 'temp abe-temp)
       (method 'civi abe-civi)
       (method 'accu abe-accu)
       (method 'bye  abe-bye)
       (method 'ruin abe-job)

       (method 'void abe-void)
       (method 'ship abe-ship)
       (method 'sail abe-ship)
       (method 'wrig abe-wrig)
       (method 'alch abe-alch)
       (method 'neig abe-neig)
       (method 'flee abe-flee)
       (method 'esca abe-flee)
       (method 'gobl abe-gobl)
       ))

(define (mk-abe)
  (bind 
   (kern-mk-char 
    'ch_abe           ; tag
    ""          ; name
    abe-species         ; species
    abe-occ              ; occ
    s_companion_wizard ; sprite
    faction-men      ; starting alignment
    2 1 1            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    abe-lvl
    #f               ; dead
    'abe-conv         ; conv
    sch_abe           ; sched
    'townsman-ai              ; special ai
    nil              ; container
    (list t_staff
					         t_armor_leather
					         )              ; readied
    )
   (abe-mk)))
