;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define alex-lvl 8)
(define alex-species sp_human)
(define alex-occ oc_wizard)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ݥꥹΤκ
;;----------------------------------------------------------------------------
(define alex-bed ph-bed3)
(define alex-mealplace ph-tbl3)
(define alex-workplace ph-hall)
(define alex-leisureplace ph-dine)
(kern-mk-sched 'sch_alex
               (list 0  0 alex-bed          "sleeping")
               (list 7  0 alex-mealplace    "eating")
               (list 8  0 alex-workplace    "working")
               (list 12 0 alex-mealplace    "eating")
               (list 13 0 alex-workplace    "working")
               (list 18 0 alex-mealplace    "eating")
               (list 19 0 alex-leisureplace "idle")
               (list 22 0 alex-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (alex-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; åϥ饹ɥ󷳤ĹǡݥꥹԻμԤγ
;; ϤǤ̳ˤĤƤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (alex-hail knpc kpc)
  (say knpc "褦Ԥ衣桹ɤθ¦Ͼϰ"))

(define (alex-name knpc kpc)
  (say knpc "饹ɥ󷳤ΥåĹ"))

(define (alex-job knpc kpc)
  (say knpc "ƮѻաƤϤλش桹̤ꤿΤ͡")
  (if (yes? kpc)
      (alex-pass knpc kpc)
      (say knpc "ѤäդˤĤƿҤͤƤ졣")))

(define (alex-bye knpc kpc)
  (say knpc "ɤγǤظ˵Ĥ"))

(define (alex-warm knpc kpc)
  (say knpc "ƮѻդϡƮˡȤκΤʤߤ狼뤫͡")
  (yes? kpc)
  (say knpc "ɤĤ뤫˹ԤΤ˺ʡ"))

(define (alex-garr knpc kpc)
  (say knpc "ϥݥꥹˤ뷳λĤϤΰĤ"
       "ϤϲʪϾؽФʤ褦˥ݥꥹäƤ롣")
  (prompt-for-key)
  (say knpc "ϤϲμƽԻμԤ򿩤ߤ롣")
  (prompt-for-key)
  (say knpc "軰ϤϡĤɤ³狼ʤƻäƤ롣")
  )

(define (alex-unde knpc kpc)
  (say knpc "ݥꥹΤؤˤϡԻμԤۤŤ֤롣ιͤΤꤿ")
  (if (yes? kpc)
      (say knpc "ԻμԤɤϥå˻ŤƤΤȹͤƤ롣")
      (say knpc "ʤз𤵤ʤᲿʤǤ")))

(define (alex-lich knpc kpc)
  (say knpc "åȤϲԻѻդǤ롣åϼʸƱ褦˻Ԥ뤳ȤǤ롣ǤⶲŨ"))

(define (alex-pass knpc kpc)
  (say knpc "դϡֿʥפ"))

(define (alex-thir knpc kpc)
  (say knpc "軰ϤȤϢʤʤäƤ롣"
       "ϢΤΰͤμƽˤ롣"
       "बˤʤäƤޤäΤǤϤʤȶƤ롣Ͽͤ򤽤Τ褦ˤƤޤ"))

(define (alex-pris knpc kpc)
  (say knpc "ƽعԤСϤ򲼤ʤ"))

(define (alex-firs knpc kpc)
  (say knpc "ϤعԤСϤꡢ̤عԤθعԤʤ"))

(define alex-conv
  (ifc kurpolis-conv

       ;; basics
       (method 'hail alex-hail)
       (method 'bye alex-bye)
       (method 'job alex-job)
       (method 'name alex-name)

       (method 'warm alex-warm)
       (method 'garr alex-garr)
       (method 'comm alex-garr)
       (method 'lich alex-lich)
       (method 'pass alex-pass)

       (method 'thir alex-thir)
       (method 'pris alex-pris)
       (method 'firs alex-firs)
       ))

(define (mk-alex)
  (bind 
   (kern-mk-char 
    'ch_alex           ; tag
    "å"       ; name
    alex-species         ; species
    alex-occ              ; occ
    s_companion_wizard     ; sprite
    faction-men      ; starting alignment
    2 5 1            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    alex-lvl
    #f               ; dead
    'alex-conv         ; conv
    sch_alex           ; sched
    'townsman-ai              ; special ai
    nil              ; container
    (list t_sword
    		t_shield
    		t_leather_helm
					         t_armor_leather_2
					         )               ; readied
    )
   (alex-mk)))
