;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define anaxes-lvl 6)
(define anaxes-species sp_lich)
(define anaxes-occ oc_wizard)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ֥ǥɤƶο
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (anaxes-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ʥϱλѻդΥå/ƤǡĤƥ饯ޥˤ˻ŤƤ
;; Υȿ
;; ʥϥ֥ǥɤμ줿ΰ衢ƶο¤ˤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (anaxes-hail knpc kpc)
  (meet "Τʤϸؤ餷ʡΤ˻ǤѻդαƤȲä")
  (say knpc "̤饯ޥˤλȤ")
  (if (yes? kpc)
      (say knpc "¾ïȡϻĵԤʾФ⤫٤"
           "̤ϻˤä"
           "򽾤碌뤳ȤϤǤ̡")
      (say knpc "ʡۤȿդκõƤ뤳ȤΤäƤ롪"))
  (aside kpc 'ch_nate 
         "Τ䤭öᡢ饯ޥˤϱΤ˻ϤǤ")
  )


(define (anaxes-default knpc kpc)
  (say knpc "ۤäƤʤ򸫤Ƥ롣"))

(define (anaxes-name knpc kpc)
  (say knpc "ϥʥĤƤϽͤΰͤǤä"))

(define (anaxes-luxi knpc kpc)
  (say knpc "饯ޥˤϿͤǤϤʤ̤򤷤Ǥ롪"
       "ȿμޤ꤬ФФ򴢤äƤ"
       "ƺǤϿफˡõäƤ롣")
  (prompt-for-key)
  (say knpc "ۤϤο¤ˤΤƤ褦̿"
       "в᤮Ȥۤؿ餫ˤʤä")
  (prompt-for-key)
  (say knpc "䤬Ƥ֤ϡΥ֥̤ο¤뤳ȤϤʤ")
  (aside kpc 'ch_nate "Ǹο̾ʱ˺줿ȻפäƤ")
  (cond ((has? kpc t_lich_skull 1)
         (say knpc "Ԥơϲϥ饯ޥˤƬغϤɤȤ饯ޥˤϻΤ")
         (yes? kpc)
         (say knpc "Ϥʤ̵뤷ܤθäϤᡢϤȼ夯ʤäϽäΤ")
         (prompt-for-key kpc)
         (say knpc "ϡĥ󡪡ĥ")
         (aside kpc 'ch_nate "Ĥηϲʪ")
         (kern-conv-end)
         (kern-char-kill knpc))))

(define (anaxes-gods knpc kpc)
  (say knpc "ϲ桹¤ܤꥷɤ"
       "饯ޥˤۤɿԤϡǸ襤ǾƤԤγŮǤ"
       "¤Ǥ졪"))

(define (anaxes-brun knpc kpc)
  (say knpc "ϲο֥̤ο¤Ǥ롣"
       "Ϥ˥饯ޥˤƤȤѤ٤̿ȿ"
       "ƥ֥̤μƤΤ")
  )

(define (anaxes-vigi knpc kpc)
  (say knpc "桹ϲ˺ƤΤ"
       "饯ޥˤϳ򵽤³Ʋ桹ϺʧͤФʤ̤Τ"))

(define (anaxes-fail knpc kpc)
  (say knpc "桹Ͽ΢ڤäְ㤤ʤϲ桹򸫼ΤƤ"))

(define (anaxes-twel knpc kpc)
  (say knpc "ϥ饯ޥˤνͤνԤΰͤä"
       "Ѥ٤Ȥˡۤۤ򤷤ƤޤäΤ"
       "ۼԤɤ⤿餷"
       "Ƽ줿Ԥμٶ򲡤ळȤǤȹͤƤ"
       "΢ڤ줿Τ"))

(define (anaxes-accu knpc kpc)
  (say knpc "󥰤θ塢"
       "Ԥ"
       "μԤϿۼԤǤȼĥζ򤫤ʹ԰٤ǿؤοĤ")
  (prompt-for-key)
  (say knpc "饯ޥˤβǲ桹Ϥμٶ̤ä"
       "ơλʺפз˽褷δΤ褦ʻٻԤϤˤ"))

(define (anaxes-bye knpc kpc)
  (say knpc "¤Ԥʤꡪ񹳤롣"
       "Ȥ襤ǵƤ⡢θǤ³Ǥ")
  (aside kpc 'ch_nate "ΤĤ֤䤭ϴˤƤ롪")
  (kern-being-set-base-faction knpc faction-monster)
  )

(define (anaxes-job knpc kpc)
  (say knpc "ϥ饯ޥˤνͤΰͤǡ"
       "ˤ֤ȴƻǤλشǤƤ"
       "饯ޥˤϤο¤¤̿"
       "椨˻ȿդΤǤ롪")
  (aside kpc 'ch_nate 
         "Τ䤭ϤΥåϼʬ饯ޥˤλƤȻפäƤޤ")
  )

(define (anaxes-fort knpc kpc)
  (say knpc "Υ֥̤ο¤ȴƻϡ֥̤μȸƤФƤ롣"
       "κ֤򹶤ȤȤϤǤ̤Ǥ"))

(define (anaxes-towe knpc kpc)
  (say knpc "֥̤μδƻϡʥƶĥäƤ롣"
       "󥰤顢ǲδȾƻ뤷³ƤΤ"))

(define (anaxes-sund knpc kpc)
  (say knpc "󥰤ȤۤɤưΤȤǤ롣"
       "̵̤Τ̤Ǥ"
       "ۤ褿Ǥʤ¤ϡ"))

(define anaxes-conv
  (ifc nil

       ;; basics
       (method 'accu anaxes-accu)
       (method 'assa anaxes-luxi)
       (method 'bye anaxes-bye)
       (method 'brun anaxes-brun)
       (method 'default anaxes-default)
       (method 'defe anaxes-fort)
       (method 'fail anaxes-fail)
       (method 'fait anaxes-vigi)
       (method 'fort anaxes-fort)
       (method 'god  anaxes-gods)
       (method 'gods anaxes-gods)
       (method 'hail anaxes-hail)
       (method 'job  anaxes-job)
       (method 'luxi anaxes-luxi)
       (method 'mast anaxes-luxi)
       (method 'name anaxes-name)
       (method 'rebe anaxes-luxi)
       (method 'shri anaxes-vigi)
       (method 'sund anaxes-sund)
       (method 'towe anaxes-towe)
       (method 'twel anaxes-twel)
       (method 'vigi anaxes-vigi)
       ))

(define (mk-anaxes)
  (let ((kchar
         (bind 
          (kern-char-force-drop
           (kern-mk-char 
            'ch_lux          ; tag
            "ʥ"     ; name
            anaxes-species   ; species
            anaxes-occ       ; occ
            s_lich           ; sprite
            faction-men      ; starting alignment
            0 0 0            ; str/int/dex
            0 0              ; hp mod/mult
            0 0              ; mp mod/mult
            max-health       ; hp
            -1               ; xp
            max-health       ; mp
            0
            anaxes-lvl       ; level
            #f               ; dead
            'anaxes-conv     ; conv
            nil              ; sched
            'lich-ai         ; special ai
            (mk-inventory
             ;; hack: as the kernel is currently written, he won't drop his
             ;; readied arms on death, and he won't ready arms from inventory
             ;; (its all messed up), but he will drop his inventory. So put
             ;; some decent arms in as loot.
             (list (list 1 t_armor_chain)
                   (list 1 t_chain_coif)
                   (list 1 t_morning_star)
                   (list 1 t_shield)
                   (list 3 mandrake)
                   (list 3 nightshade)
                   (list 8 sulphorous_ash)
                   (list 5 blood_moss)
                   (list 5 black_pearl)
                   (list 50 t_gold_coins)
                   (list 1 t_anaxes_letter)
                   (list 1 t_lichs_blood)
                   ))
            ;; readied
            (list
             t_armor_chain_4
             t_chain_coif_4
             t_morning_star_2
             t_shield_4
             )
            ) ; kern-mk-char
           #t) ; kern-char-force-drop
          (anaxes-mk)) ; bind
         ))
    (map (lambda (eff) (kern-obj-add-effect kchar eff nil))
         undead-effects)
    kchar))
