;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;;
;; In Glasdrin.
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_ange
               (list 0  0  ga-bed "sleeping")
               (list 6  0  ghg-s2     "eating")
               (list 7  0  gpi-counter       "working")
               (list 11 0  ghg-s2     "eating")
               (list 12 0  gpi-counter       "working")
               (list 17 0  ghg-s2     "eating")
               (list 18 0  gpi-counter "working")
               (list 23 0  ga-bed "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (ange-mk) (list 'townsman))

;;----------------------------------------------------------------------------
;; Conv
;;
;; 󥸥Ͻɲ־ɡפμνǡԻԥ饹ɥ˽Ǥ롣
;; Ͼʤ¿Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (ange-hail knpc kpc)
  (say knpc "Τʤ̥ŪʽȲäϤ褦ä㤤ޤι"))

(define (ange-default knpc kpc)
  (say knpc "ǰǤ狼ޤ"))

(define (ange-name knpc kpc)
  (say knpc "ϥ󥸥Ǥʤϡ")
  (let ((name (kern-conv-get-string kpc)))
    (say knpc "񤨤Ƥ줷Ǥ" name 
         "͡饹ɥںߤڤǤ")))

(define (ange-join knpc kpc)
  (say knpc "Ϥ褷ƤǯϤ褭ԤǤ"
       "⤦᤿ΤǤ"))

(define (ange-job knpc kpc)
  (say knpc "饹ɥνɲ򤷤Ƥޤ"
       "ɬפʤ餪դ"))

(define (ange-bye knpc kpc)
  (say knpc "褦ʤ顢ιޤ餷Ƥ"))

;; Trade...
(define (ange-trade knpc kpc)
  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "䤬ɤˤȤޤƤ"
           "־ɡפϸ711ޤǳƤޤ"
           "ޤǲ񤤤ޤ礦")
      (let ((door (eval 'glasdrin-inn-room-1-door)))
        ;; is the room still open?
        (if (not (door-locked? (kobj-gob door)))
            ;; yes - remind player
            (say knpc "1漼ĮΥޤǤϤʤǤ")
            ;; no - ask if player needs a room
            (begin
              (say knpc "ɬפǤ")
              (if (kern-conv-get-yes-no? kpc)
                  ;; yes - player wants a room
                  (begin
                    (say knpc 
                         "" glasdrin-inn-room-price "Ǥ"
                         "ĮФޤǤϤʤǤ"
                         "Ǥ")
                    (if (kern-conv-get-yes-no? kpc)
                        ;; yes - player agrees to the price
                        (let ((gold (kern-player-get-gold)))
                          ;; does player have enough gold?
                          (if (>= gold glasdrin-inn-room-price)
                              ;; yes - player has enough gold
                              (begin
                                (say knpc "꤬Ȥޤ1漼Ǥ"
                                     "äɤ")
                                (kern-player-set-gold 
                                 (- gold 
                                    glasdrin-inn-room-price))
                                (send-signal knpc door 'unlock)
                                (kern-conv-end)
                                )
                              ;; no - player does not have enouvh gold)
                              (say knpc "ǰǤ⤬­ޤ"
                                   "Ԥ餼Ҥ" )))
                        ;; no - player does not agree to the price
                        (say knpc "ޤäƤȤ줷ΤǤ"
                             "ͤǤ͡")))
                  ;; no - player does not want a room
                  (say knpc "ǰǤ"
                       "ѤäͤǤ͡"
                       "ޤεˤɤ")))))))

;; Inn...
(define (ange-inn knpc kpc)
  (say knpc "ɤϤФ餷ɤȻפäƤޤ"))

(define (ange-adve knpc kpc)
  (say knpc "ΤäƤ뤫⤷ޤ󤬡ƤΥ饹ɥ̱ˤʼε̳ޤ"
       "ϤĤ˽°ƤơΤƱԤƤޤ"))

(define (ange-patr knpc kpc)
  (say knpc "褤Ǥ̳ǤβοؤϤФ餷ΤǤ"
       "Ǥ⡢ͤνƤ̵ˤޤ"))

(define (ange-gint knpc kpc)
  (say knpc "ͤϻѤϿʹ֤ȻƤޤƬĤޤ"
       "Ĥƻˤ̤ˤޤ饹ɥηΤƶɤ뤳ȤǤޤ"
       "ϺǤ⶧˽Ƕ٤¸ߤǤ"
       "ͤΤФΤ褦ꤲĤΤ򸫤Ȥޤ"))

;; Townspeople...
(define (ange-glas knpc kpc)
  (say knpc "饹ɥϤФ餷ĮǤפޤ󤫡")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ޤäǤ")
      (say knpc "ιǤФ餷Į򤤤Ĥ⸫ƤΤǤ礦͡"
           "ϤĮ򰦤ƤޤϻβȤǤ")))

(define (ange-patc knpc kpc)
  (say knpc "ϤΤǺǤͥ줿դǤ"
       "ҤɤʤСǶ˴ʤäͤ뤳ȤǤޤ"))

(define ange-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default ange-default)
       (method 'hail ange-hail)
       (method 'bye ange-bye)
       (method 'job ange-job)
       (method 'name ange-name)
       (method 'join ange-join)
       
       ;; trade
       (method 'trad ange-trade)
       (method 'room ange-trade)
       (method 'buy ange-trade)
       (method 'sell ange-trade)

       ;; inn
       (method 'inn  ange-inn)
       (method 'adve ange-adve)
       (method 'gint ange-gint)
       (method 'patr ange-patr)

       ;; town & people
       (method 'glas ange-glas)
       (method 'patc ange-patc)

       ))

(define (mk-angela)
  (bind 
   (kern-mk-char 'ch_angela          ; tag
                 "󥸥"        ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townswoman        ; sprite
                 faction-glasdrin         ; starting alignment
                 0 1 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'ange-conv          ; conv
                 sch_ange            ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_dagger)))                 ; container
                 (list t_dagger
					         )                  ; readied
                 )
   (ange-mk)))
