;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define angriss-lvl 20)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 󥰥ꥹν߲
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (angriss-mk)
  (list #f (mk-quest)))

(define (angriss-quest angriss) (cadr angriss))
(define (angriss-spoke? angriss) (car angriss))
(define (angriss-spoke! angriss) (set-car! angriss #t))

;;----------------------------------------------------------------------------
;; Conv
;;
;; 󥰥ꥹϥ⤿νǡ󥰥ꥹν߲Ȥˤ롣
;; 꿼ʿ۷ΤΤǤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (angriss-hail knpc kpc)
  (say knpc "ޤ餫\n"
       "Τ衡\n"
       "Ҥफ"))

(define (angriss-default knpc kpc)
  (say knpc "֤Τ褦ȿʤä"))

(define (angriss-name knpc kpc)
  (say knpc "ͤˤϥ󥰥ꥹ\n"
       "֥ˤϥ륫\n"
       "ȥˤϥҥ֥ߥΥ\n"))

(define (angriss-join knpc kpc)
  (say knpc "Ȳ񤨤ɤ\n"
       "Τϵۤ\n"
       "ȿͤϤΤ褦ʤ"))

(define (angriss-job knpc kpc)
  (say knpc ""))

(define (angriss-bye knpc kpc)
  (say knpc "ϸλۤ\n"
       "ƤӽФ줷Ρɤ失ΤǤ\n"
       "뤬褤\n"))


(define (angriss-soft knpc kpc)
  (say knpc "Ť磻Ȥ\n"
       "ͤƺ٤Ͽͤ\n"
       "٤磻"))

(define (angriss-hung knpc kpc)
  (say knpc "\n"
       "ή\n"
       "ϹλȤȤ"))

(define (angriss-men knpc kpc)
  (say knpc "ȸؤ餷\n"
       "Ƚ餫\n"
       "ȴŤ򤫤"))

(define (angriss-gobl knpc kpc)
  (say knpc "Ǧ­μ\n"
       "ʤ⤬\n"
       "ĤˤĹ̲"))

(define (angriss-trol knpc kpc)
  (say knpc "ФꤲǤ\n"
       "Ĥ\n"
       "ĤؤѤ"))

(define (angriss-choose knpc kpc)
  (say knpc "ؤΤ")
  (let ((kchar (kern-ui-select-party-member))
        (quest (angriss-quest (kobj-gob-data knpc))))
    (if (null? kchar)
        (begin
          (say knpc "Ƥ֤ä")
          (harm-relations knpc kpc)
          (harm-relations knpc kpc)
          (kern-conv-end))
        (if (is-dead? kchar)
            (begin
              (say knpc "򾪤ϵࡪ\n"
                   "ǡԡϻष졪\n"
                   "¾")
              (kern-conv-end))
            (begin
              (say knpc "줿\n")
              (if (not (quest-done? quest))
                  (quest-done! quest #t))
              (kern-char-leave-player kchar)
              (kern-being-set-base-faction kchar faction-none)
              (improve-relations knpc kpc)
              (kern-conv-end))))))


(define (angriss-rune knpc kpc)
  (let ((quest (angriss-quest (kobj-gob-data knpc))))
    (if (quest-done? quest)
        (begin
          (say knpc "Ť̩\n"
               "Ϲؤθ\n"
               "ΤΤʤ")
          (kern-obj-remove-from-inventory knpc t_rune_f 1)
          (kern-obj-add-to-inventory kpc t_rune_f 1)
          (rune-basic-quest 'questentry-rune-f s_runestone_f)
         )
        (say knpc "õʪ򾪤Τ\n"
             "ޤ\n"
             "Ǿ"))))

(define (angriss-sacr knpc kpc)

  (define (player-alone?)
    (< (num-player-party-members) 
       2))

  (let ((quest (angriss-quest (kobj-gob-data knpc))))

    (define (refused)
      (say knpc "ä\n"
           "ܤ꤫ƨ褦\n"
           "뤳ȤϤǤ̤Ǥ")
      (harm-relations knpc kpc)
      (harm-relations knpc kpc)
      (kern-conv-end))

    (define (offer-quest)
      (display "offer-quest")(newline)
      (if (player-alone?)
          (begin
            (say knpc "Ĥ衡ʤ\n"
                 "򤫼ԤߡФ\n"
                 "򤫤ʤΤ\n"
                 "ΡĤɤ롩")
            (if (kern-conv-get-yes-no? kpc)
                (begin
                  (quest-accepted! quest)
                  (improve-relations knpc kpc)
                  (improve-relations knpc kpc))
                (refused)))
          (begin
            (say knpc "椫\n"
                 "ͤε\n"
                 "мͳˤʤ\n"
                 "ΡĤɤ롩")
            (if (kern-conv-get-yes-no? kpc)
                (angriss-choose knpc kpc)
                (refused)))))
            
    (if (quest-done? quest)
        (say knpc "뤲줿")
        (if (quest-accepted? quest)
            (if (player-alone?)
                (say knpc "ϰͤʤ\n"
                     "館ह٤\n"
                     "Ϥ")
                (choose-victim))
            (offer-quest)))))


(define (angriss-hono knpc kpc)
  (say knpc "ϿҤ\n"
       "Ƶ򡡾Ϳ\n"
       "餺ƨ˴फ"))

(define angriss-conv
  (ifc basic-conv

       ;; basics
       (method 'default angriss-default)
       (method 'hail angriss-hail)
       (method 'bye angriss-bye)
       (method 'job angriss-job)
       (method 'name angriss-name)
       (method 'join angriss-join)
       
       (method 'soft angriss-soft)
       (method 'hung angriss-hung)
       (method 'rune angriss-rune)
       (method 'men angriss-men)
       (method 'gobl angriss-gobl)
       (method 'trol angriss-trol)
       (method 'sacr angriss-sacr)
       (method 'hono angriss-hono)
       ))

(define (angriss-ai kchar)
  (if (angriss-spoke? (kobj-gob-data kchar))
      (spider-ai kchar)
      (begin
        (angriss-spoke! (kobj-gob-data kchar))
        (kern-conv-begin kchar))))

(define (mk-angriss)
  (bind 
   (kern-char-force-drop
    (kern-mk-char 
     'ch_angriss         ; tag
     "󥰥ꥹ"        ; name
     sp_queen_spider     ; species
     nil                 ; occ
     s_purple_spider     ; sprite
     faction-spider ; starting alignment
     20 0 20             ; str/int/dex
     10 5                ; hp mod/mult
     10 5                ; mp mod/mult
     max-health ;;..current hit points
     -1 ;;...........current experience points
     max-health ;;..current magic points
     0
     angriss-lvl
     #f                  ; dead
     'angriss-conv       ; conv
     nil                 ; sched
     'angriss-ai          ; special ai
     
     ;;..........container (and contents)
     (mk-inventory (list (list 1 t_rune_f)))
     nil                 ; readied
     )
    #t)
    (angriss-mk)))
