;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ѡ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_bart
               (list 0  0  black-barts-bed      "sleeping")
               (list 11 0  black-barts-ship     "working")
               (list 18 0  bilge-water-hall     "idle")
               (list 23 0  black-barts-bed      "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (bart-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; СȤϰΥ֥¤ͤǡѡ˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (bart-hail knpc kpc)
  (say knpc "ΤʤϸξʤʡνΤ르֥Ȳä"
       ""))

(define (bart-default knpc kpc)
  (say knpc ""))

(define (bart-name knpc kpc)
  (say knpc "Сȡ"))

(define (bart-join knpc kpc)
  (say knpc "Ϥʤ̯ˤߤơƬ򿶤ä"))

(define (bart-job knpc kpc)
  (say knpc "СȤ롣褤"))

(define (bart-bye knpc kpc)
  (say knpc "㡣"))

;; Trade...
(define (bart-trade knpc kpc)

  (define (buy-ship)
    (let* ((town (loc-place (kern-obj-get-location knpc)))
           (town-loc (kern-place-get-location town))
           (ship-loc (loc-offset town-loc east)))
      (if (ship-at? ship-loc)
          (say knpc "ࡣ졢ʤޤư")
          (begin
            (kern-obj-relocate (mk-ship) ship-loc nil)
            (take-player-gold oparine-ship-price)
            (say knpc "ˤ롣")
            ))))

  (define (sell-ship)
    (let* ((town (loc-place (kern-obj-get-location knpc)))
           (town-loc (kern-place-get-location town))
           (ship-loc (loc-offset town-loc east))
           (kship (kern-place-get-vehicle ship-loc)))
      (if (null? kship)
          (say knpc "Сʤߤޤ褤")
          (begin
            (say knpc "Υܥ롩Сȶ" 
                 oparine-ship-tradein-price
                 "Ϥ")
            (if (kern-conv-get-yes-no? kpc)
                (begin
                  (say knpc "Сȵ󤿱")
                  (kern-obj-remove kship)
                  (give-player-gold oparine-ship-tradein-price))
                (say knpc "ࡣࡣ"))))))

  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "Ưʤࡪ")
      (begin
        (say knpc "㤦")
        (if (yes? kpc)
            (begin
              (say knpc "" oparine-ship-price "硣ߤ")
              (if (kern-conv-get-yes-no? kpc)
                  (if (player-has-gold? oparine-ship-price)
                      (buy-ship)
                      (begin
                        (say knpc "­ʤСȤޤ"
                             "̤äǤ")
                        (kern-conv-end)))
                  (say knpc "ˤ")))
            (begin
              (say knpc "롩")
              (if (yes? kpc)
                  (sell-ship)
                  (begin
                    (say knpc "ʤССȲ롩")
                    (kern-conv-end))))))))

;; Drink...
(define (bart-drink knpc kpc)
  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "ࡪ")
      (say knpc "Ưࡣ")))


;; Townspeople...
(define (bart-opar knpc kpc)
  (say knpc "ν롣"))

(define (bart-gher knpc kpc)
  (say knpc "ġ϶˴̯ʿ޷"))

(define (bart-alch knpc kpc)
  (say knpc "ҡ塦ȡǳĮ褿"
       "²ܤƤ롣"))

(define (bart-seaw knpc kpc)
  (say knpc "ν롣"))

(define (bart-osca knpc kpc)
  (say knpc "ġȡСȤ褤Τʤ"))

(define (bart-henr knpc kpc)
  (say knpc "Сͧ褤롪СȰ๥"))

(define bart-conv
  (ifc basic-conv

       ;; basics
       (method 'default bart-default)
       (method 'hail bart-hail)
       (method 'bye bart-bye)
       (method 'job bart-job)
       (method 'name bart-name)
       (method 'join bart-join)
       
       ;; drink
       (method 'drin bart-drink)

       ;; trade
       (method 'trad bart-trade)
       (method 'ship bart-trade)
       (method 'buy bart-trade)
       (method 'sell bart-trade)

       ;; town & people
       (method 'opar bart-opar)
       (method 'alch bart-alch)
       (method 'gher bart-gher)
       (method 'witc bart-seaw)
       (method 'lia bart-seaw)
       (method 'osca bart-osca)
       (method 'henr bart-henr)
       (method 'ja   bart-bye)

       ))

(define (mk-bart)
  (bind 
   (kern-mk-char 'ch_bart           ; tag
                 "С"           ; name
                 sp_forest_goblin    ; species
                 nil                 ; occ
                 s_fgob_civilian     ; sprite
                 faction-men         ; starting alignment
                 0 0 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 1  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'bart-conv         ; conv
                 sch_bart           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_axe)))                 ; container
                 nil                 ; readied
                 )
   (bart-mk)))
