;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define bill-start-lvl 3)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ܥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_bill
               (list 0  0  bole-bed-bill "sleeping")
               (list 6  0  bole-table-1  "idle")
               (list 7  0  bole-n-woods  "working")
               (list 12 0  bole-table-2  "eating")
               (list 13 0  bole-n-woods  "working")
               (list 18 0  bole-table-2  "eating")
               (list 19 0  bole-dining-hall "idle")
               (list 21 0  bole-bills-hut "idle")
               (list 22 0  bole-bed-bill "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (bill-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ӥڤǡܥ˽Ǥ롣
;; ޤ긭ʤԤǤ롣
;;----------------------------------------------------------------------------
(define bill-catalog
  (list
   (list t_staff 10 "뤯餤ޤäʻޤϤʤʤĤʤ") ;; rather cheap
   (list t_torch  3 "⤯Τ龾äƤ롣") ;; rather cheap
   (list t_arrow  3 "Фη⤿ޤ˲äƤ롣")
   (list t_bolt   4 "ΤǥܥȤäƤĤϾʤ")
   ))

(define bill-merch-msgs
  (list nil ;; closed
        "ä" ;; buy
        nil ;; sell
        nil ;; trade
        "äƤ㤤ɡ" ;; sold-something
        "Ѥäޤʤ衣" ;; sold-nothing
        nil ;; bought-something
        nil ;; bought-nothing
        nil ;; traded-something
        nil ;; traded-nothing
        ))


(define (bill-buy knpc kpc) (conv-trade knpc kpc "buy" bill-merch-msgs bill-catalog))

(define (bill-goods knpc kpc)
  (say knpc "㤦")
  (if (kern-conv-get-yes-no? kpc)
      (bill-buy knpc kpc)
      (say knpc "ߤʤääƤ졣")))

(define (bill-may knpc kpc)
  (say knpc "ĮμäƤ롣"))

(define (bill-lady knpc kpc)
  (say knpc "Į˽衣ˤ줤ʡ"
       "Ǥ⡢ǤͤˤդƤ"))

(define (bill-bole knpc kpc)
  (say knpc "ϥܥ줬"
       "줬äơӿäơۤɿʧ"
       "ϲβȤ"))

(define (bill-wolves knpc kpc)
  (say knpc "ĤդƤ롣"
       "ĮΤäˤϤ󤤤ʡ"))

(define (bill-scared knpc kpc)
  (say knpc "ĮˤȤ衣"
       "ϵƤʤʤԤʤ"
       "礭ʡŤڤä"
       "ĤϤȻפä衣"
       "ǡĤڤȤ顢ưФ衪"))

(define (bill-thie knpc kpc)
  (say knpc "˥ꥫꤷĤˤʡ"
       "줤ʽäƤˤĤƥ󥫤ƤȻפĤĮε֡ɤ狼뤫عԤΤ򸫤"
       "줫äƤʤäɤعԤäϤ狼ͤε֤ϹԤߤޤ"
       "Ѥä"))

(define (bill-mous knpc kpc)
  (say knpc "ͥߤϤɤˤǤ⤤롣ͥߤߤƤäƤĤ⸫衪"))

(define (bill-tree knpc kpc)
  (say knpc "ˤϿڤ롣"
       "Ǥ衢ͩڤ򸫤衪"))

(define bill-conv
  (ifc nil
       (method 'default (lambda (knpc kpc) (say knpc "ϸ򤹤᤿")))
       (method 'hail (lambda (knpc kpc) (say knpc "衼")))
       (method 'bye (lambda (knpc kpc) (say knpc "ޤ")))
       (method 'job (lambda (knpc kpc) 
                      (say knpc "㤢ڤ")))
       (method 'name (lambda (knpc kpc) (say knpc "ӥȸƤФƤ롣")))
       (method 'join (lambda (knpc kpc) 
                       (say knpc "䡪󤿤ӲäƤ롢ڤꡣ"
                            "ͤ衣פǤ졣")))

       (method 'arro bill-goods)
       (method 'axe
               (lambda (knpc kpc)
                 (say knpc "ڤڤȤû褫")))
       (method 'buy bill-buy)
       (method 'bole bill-bole)
       (method 'chop
               (lambda (knpc kpc)
                 (say knpc "Ȥäơ")))
       (method 'fore
               (lambda (knpc kpc)
                 (say knpc "ˤϤۤȤˤڤ롣"
                      "ϵʡ")))
       (method 'haun
               (lambda (knpc kpc)
                 (say knpc "Ϥʤ˴꤫ꡢǸä"
                      "ĮǤФ衣"
                      "ӤӤäƨޤä衣ϥϡ")))
       (method 'jink bill-scared)
       (method 'ladi bill-lady)
       (method 'lady bill-lady)
       
       (method 'may bill-may)

       (method 'wood
               (lambda (knpc kpc)
                 (say knpc "ڤڤäơäơŤ롣"
                      "Ⱦ⡣")))
       (method 'shit
               (lambda (knpc kpc)
                 (say knpc "顣ʤȸĤϤʤä"
                      "ᥤϤĤⲶ˥θʤȸäƤ롣"
                      "ϤΤϷʡ")))
       (method 'scar bill-scared)
       (method 'thie bill-thie)
       (method 'mous bill-mous)
       (method 'man  bill-thie)
       (method 'scur bill-thie)
       (method 'torc bill-goods)
       (method 'town bill-bole)
       (method 'trad bill-buy)
       (method 'tree bill-tree)
       (method 'ki bill-tree) ; ڡפȡ֥(֥)פβƱǤ뤿
       (method 'wake
               (lambda (knpc kpc)
                 (say knpc "Ťߤڤ֤ä"
                      "ߤƤʳѤĤΤǤäܤäơˤǤ"
                      "ܥ󤫤ӽФơ"
                      "֤ƻ̤ۤäƨ衪")))
       (method 'wolv bill-wolves)
       (method 'wulv bill-wolves)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-bill)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     'ch_bill ;;......tag
     "ӥ" ;;.......name
     sp_human ;;.....species
     nil ;;..........occupation
     s_townsman ;;...sprite
     faction-men ;;..faction
     2 ;;............custom strength modifier
     0 ;;............custom intelligence modifier
     0 ;;............custom dexterity modifier
     0 ;;............custom base hp modifier
     0 ;;............custom hp multiplier (per-level)
     0 ;;............custom base mp modifier
     0 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     bill-start-lvl  ;;..current level
     #f ;;...........dead?
     'bill-conv ;;...conversation (optional)
     sch_bill ;;.....schedule (optional)
     'townsman-ai ;;..........custom ai (optional)

     ;;..............container (and contents)
     (mk-inventory
      (list
       (list 10  t_torch)
       (list 100 t_arrow)
       (list 1   t_2h_axe)
       ))
     nil ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (bill-mk)))
