;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;;
;; ȥꥰ쥤
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_chant
               (list 0  0  trigrave-east-west-road   "drunk")
               (list 2  0  trigrave-chants-bed       "sleeping")
               (list 12 0  trigrave-tavern-hall      "working")
               (list 23 0  trigrave-east-west-road   "drunk")               
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (chant-mk) (list 0))
(define (chant-get-gold knpc) (car (kobj-gob-data knpc)))
(define (chant-has-gold? knpc) (> (chant-get-gold knpc) 0))
(define (chant-set-gold! knpc amount) 
  (if (>= amount 0)
      (set-car! (kobj-gob-data knpc) 
                amount)))
(define (chant-dec-gold! knpc) (chant-set-gold! knpc 
                                                (- (chant-get-gold knpc)
                                                   1)))

;; ----------------------------------------------------------------------------
;; ɥ
;;
;; ɥιζͷͤ¿λ֤ȥꥰ쥤֤ǲᤴƤ롣Ϥ餫
;; ʼȤǡߤǤʤݿͤǤ⤢롣ˤ¿μꡢ蘆
;; ʹ򰦤Ƥơ͡ʿʬͧ(˸ʤƻդޤ)롣
;; ⤷ȡïΡץѥ⤷ʤϤ狼ʤ
;; ----------------------------------------------------------------------------
(define (chant-song knpc kpc)
  (if (isdrunk? knpc)
      (say knpc "ߤʤǡοʼ󡪡Υҥåҥåҡ")
      (begin
        (say knpc "βΤͤδȤݣθԤäƤ롪"
             "⤷Ⱦζߤݣ뤫⡩"
             "ϴԤ褦ˤʤ򸫤Ƥ롣ˤ餫ζߤͿ롩")
        (if (kern-conv-get-yes-no? kpc)
            ;; yes - give chant some gold
            (let ((amount (kern-conv-get-amount)))
              (display "amount=")(display amount)(newline)
              (cond ((= 0 amount) 
                     (say knpc "ʤߤˤʹʤΤ"
                          "ϥ塼ȤƤޤͤ򤷤"))
                    ((< amount 2)
                     (say knpc "Ĥ狼ޤޤ衣\n"
                          "\n"
                          " ȤäƤ⥱¤\n"
                          "򤤤äѤȤ\n"
                          "ʥɥ򤢤ФäΤ\n"
                          "ҤɤǼ򤤤äѤˤƤ롪\n"
                          "\n"
                          "ϹӡǲΤ򤷤"))
                    (else
                     (say knpc "ͤο줿"
                          "ɤ¡"
                          "Ȥ˺줿ꡩ")
                     (chant-set-gold! knpc amount))))
            ;; no -- don't give him some gold
            (say knpc "դλͤïˤⲿ⤷ʤΤ")))))

(define (chant-fen knpc kpc)
  (if (isdrunk? knpc)
      (say knpc "ͤȤΥҥå")
      (if (not (chant-has-gold? knpc))
          (chant-song knpc kpc)
          (begin
            (chant-dec-gold! knpc)
            (say knpc 
                 "\n"
                 "\n"
                 " ⤷⤢ʤʤ\n"
                 "ۤ¤\n"
                 "ͫݵʶͤ餤Υ뤬\n"
                 "κŤťͤޤä\n"
                 "˺줿⤬(褽ԤٲƤ)\n"
                 "ƻʤϤ\n"
                 "åͩ\n"
                 "Τ\n"
                 "ʤСͧ\n"
                 "̤ξϤعԤ\n"
                 "Ϥʤξ")))))

(define (chant-forest knpc kpc)
  (if (isdrunk? knpc)
      (say knpc "Υҥåҥåҡ")
      (if (not (chant-has-gold? knpc))
          (chant-song knpc kpc)
          (begin
            (chant-dec-gold! knpc)
            (say knpc 
                 "ο\n"
                 "\n"
                 " ŨʤȤŤƿ\n"
                 "ĤǤ⵲Ƥ롪\n"
                 "ιͤ򤿤󿩤٤\n"
                 "Ʋͤ߹\n"
                 "\n"
                 "֥ν߲Ȥ±α\n"
                 "Ƶ祯\n"
                 "˹ԤȤ˺\n"
                 "ΥޤʥХϢƹԤΤ\n"
                 )))))

(define (chant-forgotten knpc kpc)
  (if (isdrunk? knpc)
      (say knpc "˺줿ϵ㤭ʤФä")
      (if (not (chant-has-gold? knpc))
          (chant-song knpc kpc)
          (begin
            (chant-dec-gold! knpc)
            (say knpc 
                 "줿Ʋ \n"
                 "\n "
                 " Ȥ\n"
                 "ŤԤܤФޤ\n"
                 "ʪΤäƤ뤫\n"
                 "(ʪϸʤä)\n"
                 "˰⤻ͤϸ롪\n"
                 "\n "
                 "αդߤ᤿Ĵ٤˹ԤʤФʤʤʤä顢"
                 "αߤعԤФ")
		 (if (null? (quest-data-getvalue 'questentry-rune-l 'know-hall))
			(quest-data-update-with 'questentry-rune-l 'approx-hall 1 (quest-notify nil))
		)
		 ))))

(define (chant-thie knpc kpc)
  (if (isdrunk? knpc)
      (say knpc 
           "إऺʤʤ\n"
           "Ϥޤʤˤ롪\n"
           "륷ե˸äķͤ\n"
           "츫ƻѻդФ\n"
           "ťǤФ")
      (say knpc "ޡϷõťϤĮ򤱤ƤäϤ"
           "Ǥ⡢ιͤϸ⤷ʤ٥ʹƤߤʤ衣")))

(define (chant-man knpc kpc)
  (if (isdrunk? knpc)
      (begin
        (say knpc "ʤ̩뤫")
        (if (yes? knpc)
            (begin
              (say knpc "ˤ󤲤̩ƶˤ롣ɤΤäƤ뤫")
              (if (yes? kpc)
                  (say knpc "ͤΥҥåҥåҡ")
                  (say knpc "[" 
                       (loc-x the-mans-hideout-loc) "," 
                       (loc-y the-mans-hideout-loc) 
                       "]λλͤԤäƤӤӤ餻Ƥ졪")))
            (say knpc "ͤǤͤɡĤ餷")))
      (say knpc "ˤ󤲤󡩤ˤ󤲤ΤȤΤʤʤʤͤʹΡ")))

(define chant-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default 
               (lambda (knpc kpc) 
                 (if (isdrunk? knpc)
                     (say knpc "äƤġΥҥå")
                     (say knpc "äʤ"))))
       (method 'hail 
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "οäѤ餤ʤϾФäơ")
                     (say knpc "褦郎ͧ衪"))))
       (method 'bye 
               (lambda (knpc kpc) 
                 (if (isdrunk? knpc)
                 (say knpc "ХХХХХξФʤ")
                 (say knpc "ƻ­˥ޤ褦ˡ"))))
       (method 'job 
               (lambda (knpc kpc) 
                 (if (isdrunk? knpc)
                     (say knpc "Τʿȿǡϼʬܤغ"
                          "غƸɤư򤷤ơ"
                          "ޤǤʤ󥯤")
                     (say knpc "ηäȲΤαӼꤵ"))))
       (method 'name 
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ɥꡪΤ򤷤褦Ȥݤ줿")
                     (say knpc "ͷͤΥɥꡢʤǤɤ"
                          "Τ򤷤ä"))))
       (method 'join 
               (lambda (knpc kpc) 
                 (if (isdrunk? knpc)
                     (say knpc "֤"
                          "ԤäƤޤ")
                     (say knpc "ι򤹤ͤСؤʼԤ⤤롣"
                          "ͤϸʤΤ"))))

       (method 'chan
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ΥҥåϢ㤭礦ΡΡХϺϤ\n"
                          "ïäλҤ˫Τ")
                     (say knpc "\n"
                          "\n"
                          " ƤʻͤϤ졩\n"
                          "Τ˥塼ȤƤΤϤ졩\n"
                          "α̿Τää\n"
                          "ह٤̿ʱʤ顩"))))
       (method 'earl
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ʥܥۤϸȤͤ")
                     (say knpc 
                          "ͤΤФ餷Ź\n"
                          "\n"
                          " Τϱμä \n"
                          "̾夲 \n"
                          "Ǥ⡢Ƥ̤ \n"
                          "ˡ˼Ф \n"
                          "̾פФʤ"
                          ))))

       (method 'ench
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ޡǺ¤äơ"
                          "ˡؤʤ̿ᤷƤʤ")
                     (say knpc 
                          "ƻդι뤳Ȥ⤢ޤ衣"))))
       (method 'gwen
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "Ϥʤˤ⤿줫ꡢǸä"
                          "ϷäƤͤ")
                     (say knpc
                          "¿ɲν͡\n"
                          "\n"
                          " ȷޤήȤ\n"
                          "ߤ̲\n"
                          "̸Τ褦˴Ȥ\n"
                          "եϷ\n"
                          "Ť˿Ҥͤ\n"
                          "ΤäƤ롪"))))
       (method 'fen chant-fen)
       (method 'fore chant-forest)
       (method 'wood chant-forest)
       (method 'forg chant-forgotten)
       (method 'jim
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "Τ΢֤Υåס")
                     (say knpc
                          "äȡʤ蘆⤢ޤ衪\n"
                          "\n"
                          " ĵԤ\n"
                          "줬Ф餷\n"
                          "ϷǨƤ\n"
                          "ʤǤݤ\n"
                          "Ϥ򤫤ä\n"
                          "Ƽ줿Ź˾ä\n"
                          ))))
       (method 'roun
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ͤϸĥäƤ"
                          "Ĥ˵Ĥ")
                     (say knpc "ǤʤȤʹΡ"))))
       (method 'song chant-song)
       (method 'them
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "Τ䤭ϤĤ顪ԤŨá")
                     (say knpc "ε褦ˤʤ򸫤"
                          "礦֤"))))
       (method 'thie chant-thie)
       
       (method 'towe
               (lambda (knpc kpc)
                 (if (isdrunk? knpc)
                     (say knpc "ͫĤʤȤ")
                     (say knpc
                          "̤μӤǸޤ衣"
                          "Ǥ⤽عԤΤʤ顢"
                          "ƻդҤ򹥤ޤʤȤФƤƤ"))))

       (method 'wit
               (lambda (knpc kpc)
                 (say knpc "ϤΤ蘆ä"
                      "̾СοͤΤ蘆ʹޤ衣")))
       (method 'lost
               (lambda (knpc kpc)
                 (say knpc "Ūʼ줿ƲβΤΤʤСͤ϶ͷͤˤϤʤʤäǤ礦͡")))
       (method 'man chant-man)
       (method 'wrog chant-man)
       ))
