;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_ches
               (list 0  0  gc-bed       "sleeping")
               (list 7  0  ghg-s3       "eating")
               (list 8  0  gas-counter "working")
               (list 11 0  ghg-s3       "eating")
               (list 12 0  gas-counter "working")
               (list 18 0  ghg-s3       "eating")
               (list 19 0  ghg-hall     "idle")
               (list 21 0  gc-bed       "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (ches-mk) (list 'townsman))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ﲰˤǡ饹ɥ˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (ches-hail knpc kpc)
  (say knpc "ΤʤڤδΤ褦ӤˤȲä"
       "褪Τ"))

(define (ches-default knpc kpc)
  (say knpc "ϲμĶƤ롣"))

(define (ches-name knpc kpc)
  (say knpc "ȽפΥ"
       "ͤʿʪȸ뤿ˤϡͤ郎ɬפ"
       "̣ΤʪϤ뤫")
  (if (kern-conv-get-yes-no? kpc)
      (ches-trade knpc kpc)))

(define (ches-join knpc kpc)
  (say knpc "ݡͧ衣Ԥˤ򶡵뤹ïɬפ"))

(define (ches-job knpc kpc)
  (say knpc "ϤǺǤɤȳäƤ롣"
       "Ƥ")
       (if (kern-conv-get-yes-no? kpc)
           (ches-trade knpc kpc)
           (say knpc "ޤꤤʪϤʤ"
                "Ǹ롣")))

(define (ches-bye knpc kpc)
  (say knpc "Сͧ˲ŹΤȤäƤ졪"))

(define ches-catalog
  (list
   (list t_staff            20 "֤ѻդ˾С狼Ϥ")
   (list t_dagger           65 "˰ĤĤûǦФƤ")
   (list t_mace             80 "̷ƬդˤϤ")
   (list t_axe              85 "Ϥޤ˽뤿ΤΤ")
   (list t_sword            85 "ΤμϤ")
   (list t_2H_axe           90 "ξब򴢤褦Ũʤݤ롣")
   (list t_2H_sword        100 "ĿŪˤϤζϤξߤ")
   (list t_morning_star    105 "λդŴФСŨय")
   (list t_halberd         150 "ļԤˤС̤϶")
   
   (list t_sling            50 "⤷Ҷʤ顢ɳϺǽȤƤϤ")
   (list t_spear            15 "ϥ֥²褯ȤäƤ")

   (list t_self_bow        120 "ξʵݤϾưʪˤϤäƤ")
   (list t_bow             200 "Τ褦˿礤ԤˤϤεݤ")
   (list t_arrow             1 "⤷Ũľ̤ʤС̤˻äƤ٤")
   
   (list t_crossbow        380 "⤷ŨϤƨФʤ顢Υܥݤ")
   (list t_hvy_crossbow    600 "Ũ˰Ϥޤ줿顢ͦޤΤ⤳")
   (list t_bolt              1 "饹ɥηϺǹƤ롣ͣ첶ܥ򶡵뤷Ƥ롣")
   
   (list t_leather_helm     50 "ڤϱɮΤ褦ʼΤʤ餺ԤˤϤԤä")
   (list t_chain_coif      100 "ƬҤϻ볦פ餺˼롣")
   (list t_iron_helm       150 "ŴϤޤƬǤǤѤ")
   (list t_armor_leather   150 "γưΤޤˤʤʤ¤ɸϤʤ")
   (list t_armor_chain     330 "ӤΤ˺ŬγϤΤȤ褯狼äƤ롣")
   (list t_armor_plate    1000 "ɤԻȤΤˤʤ롣")
   
   (list t_shield           30 "פʽ⤬б󤯤äƤ벲¼ԤŨȤ롣")
   
   (list t_spiked_helm     250 "ϺɸλդƤ̤ǤϤʤ")
   (list t_spiked_shield   250 "λդ⤬ϤۤȤɤʤ")
   ))

(define ches-merch-msgs
  (list "ŹˤȤˡȽפƤ졣ǹɶ򤪸褦96ޤǤäƤ롣"
        "򸫤Ƥ졪" ;; buy
        "ȤäⲼꤹ뤾" ;; sell
        "ϤǺǹΤ򶡵뤷Ƥ롣ʤˤߤ" ;; trade
        "ŨƬդäȤΤߤʤäޤƤ졣" ;; sold-something
        "ޤϾŤӤƤʡͤʤۤ" ;; sold-nothing
        "Υܥ򲿤äƤʡ" ;; bought-something
        "Υ饯ߤۤ¾ˤȤϻפʤ" ;; bought-nothing
        "ͤ򽳻餹Ǥʡ" ;; traded-something
        "ʤƤʤ衣" ;; traded-nothing
        ))

;; Trade...
(define (ches-trade knpc kpc) (conv-trade knpc kpc "trade" ches-merch-msgs ches-catalog))
(define (ches-buy knpc kpc) (conv-trade knpc kpc "buy" ches-merch-msgs ches-catalog))
(define (ches-sell knpc kpc) (conv-trade knpc kpc "sell" ches-merch-msgs ches-catalog))

;; Paladins...
(define (ches-pala knpc kpc)
  (say knpc "ʼǤϲ٤ΤƱԤǤԤˡʤä"
       "ϤŹ򳫤"))

;; Townspeople...
(define (ches-glas knpc kpc)
  (say knpc "ʤĮΤʤ󤫤ˤˤϤäƤ"))

(define (ches-ange knpc kpc)
  (say knpc "ͤɲϤäȹӡΤߤʡ"))

(define (ches-patc knpc kpc)
  (say knpc "µˤʤäȤʤӤʹ"))

(define (ches-jess knpc kpc)
  (say knpc "ϼ㤤Τ뤤"
       "ǰðŤʤƱ"))

(define ches-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default ches-default)
       (method 'hail ches-hail)
       (method 'bye ches-bye)
       (method 'job ches-job)
       (method 'name ches-name)
       (method 'join ches-join)
       
       ;; trade
       (method 'trad ches-trade)
       (method 'buy ches-buy)
       (method 'sell ches-sell)

       ;; paladin
       (method 'pala ches-pala)

       ;; town & people
       (method 'glas ches-glas)
       (method 'ange ches-ange)
       (method 'patc ches-patc)
       (method 'jess ches-jess)

       ))

(define (mk-chester)
  (bind 
   (kern-mk-char 'ch_chester         ; tag
                 ""        ; name
                 sp_human            ; species
                 oc_warrior          ; occ
                 s_townsman          ; sprite
                 faction-glasdrin         ; starting alignment
                 5 0 2               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'ches-conv          ; conv
                 sch_ches            ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_mace)
                                     (list 1 t_armor_chain))) ; container
                 nil ;;  readied
                 )
   (ches-mk)))
