;;----------------------------------------------------------------------------
;; Ūʲ
;;----------------------------------------------------------------------------

;; 
(define (generic-hail knpc kpc)
  (say knpc "ˤϡ"))

(define (generic-unknown knpc kpc)
  (say knpc "ϸʤ"))

(define (generic-bye knpc kpc)
  (say knpc "褦ʤ顣")
  (kern-conv-end))

(define (generic-join knpc kpc)
  (say knpc "֤ˤϤʤʤ"))

(define (generic-leav knpc kpc)
  (cond ((is-player-party-member? knpc)
         (cond ((is-only-living-party-member? knpc)
                (say knpc "ޤ¤ͤʤФʤʤ"
                     "ȤΤѻդäƤޤ"))
               (else
                (say knpc "֤鳰ߤ")
                (cond ((yes? kpc)
                       (cond ((kern-char-leave-player knpc)
                              (say knpc "ԤäƤΤǡѤääߤ")
                              (kern-conv-end)
                              )
                             (else 
                              (say knpc "̤ʤ"))))
                      (else
                       (say knpc "ưž衣"))))))
         (else
          (say knpc "ʤãΰǤϤʤ"))))

;; 
(define (basic-ench knpc kpc)
  (say knpc "ƻդˡȤθԤ"
       "Ӥ˽Ǥ롣Τꤿ")
  (quest-wise-subinit 'questentry-enchanter)
  (quest-data-update 'questentry-enchanter 'general-loc 1)
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "Ϥ򲼤¦ؤƻ˹Ԥ롣"
                    "ˤ뵳ΤƻΤäƤ"))
              ((equal? kplace p_eastpass)
               (say knpc "ƻ˿ʤȥȥꥰ쥤֤ʹȤ褤"))
              ((equal? kplace p_trigrave)
                (quest-data-update 'questentry-calltoarms 'directions 1)
               (say knpc "ƻ̤عԤȼӤ"))
              (else 
               (say knpc "Ӥˤ롣"))
        ))))

;; Į
(define (basic-trig knpc kpc)
  (say knpc "ȥꥰ쥤֤Ĥήˤ뾮Į"))

(define (basic-gree knpc kpc)
  (say knpc "ФϿαˤ롣"
       "Τꤿ")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "ƻ˿ʤߡ롣"
                    "ƻ顢򤿤ɤäƤФ褤"))
              ((equal? kplace p_eastpass)
               (say knpc "ΤϤ򲼤ꡢ¦ؤƻǷ˿Ҥͤʤ"))
              ((equal? kplace p_trigrave)
               (say knpc "ƻ˿ʤ߻¦ؤƻ"
                    "ʹȤ褤"))
              ((equal? kplace p_enchanters_tower)
               (say knpc "عԤȥȥꥰ쥤֤ʹȤ褤"))
              ((equal? kplace p_oparine)
               (say knpc "̤عԤȥȥꥰ쥤֤ʹȤ褤"))
              ((equal? kplace p_moongate_clearing)
               (say knpc "ƻؿʤȸΤǡؿʤࡣ"
                    "ƻ̤ظä餽Τޤ޿ʤߡοȤ褤"))
              (else 
               (say knpc "ˤ롣"))
              ))))

(define (basic-bole knpc kpc)
  (say knpc "ܥ¼Ͽ̤ˤ뻳̮ë֤ˤ롣"
       "Τꤿ")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "ˤ롣̮򤿤ɤäƹԤȤ褤"))
              ((equal? kplace p_eastpass)
               (say knpc "ΤϤ򲼤ꡢ¦ؤƻǷ˿Ҥͤʤ"))
              ((equal? kplace p_trigrave)
               (say knpc "ƻ˿ʤ߻¦ؤƻ"
                    "ʹȤ褤"))
              ((equal? kplace p_green_tower)
               (say knpc "̤οȴ̮ΤդȤޤǿʤࡣ"
                    "θ塢ظȹԤ"))
              ((equal? kplace p_enchanters_tower)
               (say knpc "عԤȥȥꥰ쥤֤ʹȤ褤"))
              (else 
               (say knpc "̤ˤ뻳̮ΤդȤˤȻפ"))
              ))))
              
(define (basic-absa knpc kpc)
  (say knpc "Į֥åȤϡκ"))

(define (basic-opar knpc kpc)
  (say knpc "ѡοѤζ᤯ˤ롣"
       "Τꤿ")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "Ϥ򲼤ꡢƻˤɤȤ褤"))
              ((equal? kplace p_eastpass)
               (say knpc "ƻˤɤȤ褤"))
              ((equal? kplace p_trigrave)
               (say knpc "ƻˤɤꡢΤȳޤǤä˿ʤȤ褤"))
              ((equal? kplace p_green_tower)
               (say knpc "ƻ򤿤ɤꡢΤعԤ¦ؤƻǷ˿ҤͤȤ褤"))
              ((equal? kplace p_enchanters_tower)
               (say knpc "˥ȥꥰ쥤֤롣ǿҤͤȤ褤"))
              ((equal? kplace p_glasdrin)
               (say knpc "˿ʤȤ褤"))
              ((equal? kplace p_oparine)
               (say knpc ""))
              (else 
               (say knpc "ߤΤɤˤ롣"))
              ))))

(define (basic-east knpc kpc)
  (say knpc "Eastpass guards the eastern pass into the River Plain. Do you need directions?")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "Take the ladder down, you'll come out in Eastpass."))
              ((equal? kplace p_eastpass)
               (say knpc "You're here already."))
              ((equal? kplace p_trigrave)
               (say knpc "Follow the road east and you'll run right into it."))
              ((equal? kplace p_green_tower)
               (say knpc "Travel west through the woods, then follow the road west to Westpass and ask there."))
              ((equal? kplace p_enchanters_tower)
               (say knpc "Go south to Trigrave and ask there."))
              ((equal? kplace p_glasdrin)
               (say knpc "Take the road south as far as you can and ask there."))
              ((equal? kplace p_oparine)
               (say knpc "Take the road north to Trigrave and ask there."))
              (else 
               (say knpc "It's by the mountains west of the Great Forest."))
              ))))

(define (basic-west knpc kpc)
  (say knpc "Westpass guards the western pass into the Great Forest. Do you need directions?")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "This is it."))
              ((equal? kplace p_eastpass)
               (say knpc "Take the ladder down and you'll come out in it."))
              ((equal? kplace p_trigrave)
               (say knpc "Follow the road east and ask in Eastpass."))
              ((equal? kplace p_green_tower)
               (say knpc "Travel west through the woods, then follow the road west."))
              ((equal? kplace p_enchanters_tower)
               (say knpc "Go south to Trigrave and ask there."))
              ((equal? kplace p_glasdrin)
               (say knpc "Take the road south as far as you can."))
              ((equal? kplace p_oparine)
               (say knpc "Take the road north to Trigrave and ask there."))
              (else 
               (say knpc "Follow the road east from Trigrave."))
              ))))

(define (basic-glas knpc kpc)
  (say knpc "饹ɥΤξԻԤΤꤿ")
  (if (yes? kpc)
      (let ((kplace (get-place knpc)))
        (cond ((equal? kplace p_westpass)
               (say knpc "ƻعԤΤ̤عԤФ褤"))
              ((equal? kplace p_eastpass)
               (say knpc "عԤ¦ؤƻʹȤ褤"))
              ((equal? kplace p_trigrave)
               (say knpc "عԤ¦ؤƻʹȤ褤"))
              ((equal? kplace p_green_tower)
               (say knpc "οȴƻ롣̤˿ʤȤ褤"))
              ((equal? kplace p_enchanters_tower)
               (say knpc "ؿʤ߻ƻȴ򤿤ɤФ褤"))
              ((equal? kplace p_oparine)
               (say knpc "̤ƻʤȥȥꥰ쥤֤ʹȤ褤г̤˿ʤȹԤ"))
              (else 
               (say knpc "γߤζ᤯ˤ롣"))
              ))))

(define (basic-fens knpc kpc)
  (say knpc "Ӥˤ롣"))

(define (basic-kurp knpc kpc)
  (say knpc "ݥꥹϲθפ"
       "̤λ̮Τɤˤ롣"))

(define (basic-lost knpc kpc)
  (say knpc "줿ƲͷͤβΤǤʹȤʤ"
       "ϤɤˤΤΤʤ"))

;; establishments
(define (basic-whit knpc kpc)
  (say knpc "򤭲Фˤ롣"))

;; quests
(define (basic-thie knpc kpc)
  (say knpc "ťΤȤϤ狼ʤ"))

(define (basic-rune knpc kpc)
  (say knpc "ǤΤȤϤ褯ΤʤԤʹФ褤⤷ʤ"))

(define (basic-wise knpc kpc)
	(say knpc "ԤϤΥɤ礭ʱƶͿƤԤ̾Τꤿ")
	(if (yes? kpc)
		(begin
			(say knpc "ƻաѻաϣѻաˤ󤲤󡢵աƮΤ")
			(map quest-wise-subinit
				(list 'questentry-enchanter 'questentry-warritrix  'questentry-alchemist
						'questentry-the-man 'questentry-engineer  'questentry-necromancer)
			)
		)
	))

(define (basic-shar knpc kpc)
  (say knpc "ɤȤϤθƤ̾")
  (quest-data-update 'questentry-whereami 'shard 1)
  )

(define (basic-peni knpc kpc)
  (say knpc "ȾȤϲ桹Τ륷ɤüΤȤ"))

(define (basic-warr knpc kpc)
  (say knpc "ƮΤΤθԤ񤤤ΤǤХ饹ɥعԤФ褤")
  (quest-wise-subinit 'questentry-warritrix)
  (quest-data-update 'questentry-warritrix 'general-loc 1)
  )

(define (basic-engi knpc kpc)
  (say knpc "դϤϤǺǤͥ줿ͤʹȤ롣"
       "ʾΤȤΤʤ")
       (quest-wise-subinit 'questentry-engineer)
       (quest-data-update 'questentry-engineer 'common 1)
       )

(define (basic-man knpc kpc)
  (say knpc "ˤ󤲤Ϥʤ餺ԤĺɤˤΤïΤʤ"
       "ι򤷤ƤȤ蘆Ƥ롣")
       (quest-wise-subinit 'questentry-the-man)
       (quest-data-update 'questentry-the-man 'common 1)
       )

(define (basic-alch knpc kpc)
  (say knpc "ϣѻդϸԤοͤǡΤȤϲǤΤäƤ롣"
       "ѡǲ񤨤")
       (quest-wise-subinit 'questentry-alchemist)
       (quest-data-update 'questentry-alchemist 'general-loc 1)
       )

(define (basic-necr knpc kpc)
  (say knpc "ѻդϻˡ븭ԤˡȤ"
       "ϱ줿ƶ˽Ǥ餷")
       (quest-wise-subinit 'questentry-necromancer)
       (quest-data-update 'questentry-necromancer 'general-loc 1)
       )

(define (basic-drag knpc kpc)
  (say knpc "˽εγ߶᤯̤򶼤Ƥʹ"))

(define (basic-fire knpc kpc)
  (say knpc "ФγβлΤΤȤ"))

(define basic-conv
  (ifc '()
       ;; fundamentals
       (method 'hail generic-hail)
       (method 'default generic-unknown)
       (method 'bye generic-bye)
       (method 'join generic-join)
       (method 'leav generic-leav)
       
       ;; wise
       (method 'ench basic-ench)
       (method 'wise basic-wise)
       (method 'warr basic-warr)
       (method 'man basic-man)
       (method 'engi basic-engi)
       (method 'alch basic-alch)
       (method 'necr basic-necr)

       ;; towns & regions
       (method 'absa basic-absa)
       (method 'bole basic-bole)
       (method 'gree basic-gree)
       (method 'trig basic-trig)
       (method 'lost basic-lost)
       (method 'opar basic-opar)
       (method 'fens basic-fens)
       (method 'shar basic-shar)
       (method 'peni basic-peni)
       (method 'kurp basic-kurp)
       (method 'glas basic-glas)
       (method 'fire basic-fire)

       ;; establishments
       (method 'whit basic-whit)

       ;; quests
       (method 'thie basic-thie)
       (method 'rune basic-rune)

       ;; monsters
       (method 'drag basic-drag)

       ))

;; Helper(s)
(define (say knpc . msg) (kern-conv-say knpc msg))
(define (yes? kpc) (kern-conv-get-yes-no? kpc))
(define (no? kpc) (not (kern-conv-get-yes-no? kpc)))
(define (reply? kpc) (kern-conv-get-reply kpc))
(define (ask? knpc kpc . msg)
  (kern-conv-say knpc msg)
  (kern-conv-get-yes-no? kpc))
(define (prompt-for-key)
  (kern-log-msg "<򲡤³>")
  (kern-ui-waitkey))
(define (meet msg)
  (kern-log-msg msg))
(define (get-gold-donation knpc kpc)
  (let ((give (kern-conv-get-amount kpc))
        (have (kern-player-get-gold)))
    (cond ((> give have)
           (say knpc "⤬­ʤ")
           0)
          (else
           (kern-player-set-gold (- have give))
           give))))
(define (get-food-donation knpc kpc)
  (let ((give (kern-conv-get-amount kpc))
        (have (kern-player-get-food)))
    (cond ((> give have)
           (say knpc "⤬­ʤ")
           0)
          (else
           (kern-player-set-food (- have give))
           give))))
(define (working? knpc)
  (string=? "working" (kern-obj-get-activity knpc)))

;; Not really an aside in the theatrical sense, this routine causes a party
;; member to interject something into the conversation. kpc is the character
;; being conversed with, mem-tag is either nil or the party member who should
;; do the interjection. If mem-tag is nil then a party member (other than the
;; speaker) will be chosen at random. msg is the text of the comment. If kpc is
;; the only member of the party then the aside will not do anything.
(define (aside kpc kchar-tag . msg)
  ;;(println msg)
  (if (null? kchar-tag)
      (let ((members (filter (lambda (kchar)
                               (not (eqv? kchar kpc)))
                             (kern-party-get-members (kern-get-player)))
                     ))
        (if (not (null? members))
            (let ((kchar (random-select members)))
              (say kchar msg)
              #t)
            #f)
        )
      (if (in-player-party? kchar-tag)
          (begin
            (kern-conv-say (eval kchar-tag) msg)
            #t)
          #f)
      ))
         
;;----------------------------------------------------------------------------
;; 
;;----------------------------------------------------------------------------
(define (mk-quest) (list #f #f #f))
(define (quest-offered? qst) (car qst))
(define (quest-accepted? qst) (cadr qst))
(define (quest-done? qst) (caddr qst))
(define (quest-offered! qst val) (set-car! qst val))
(define (quest-accepted! qst val) (set-car! (cdr qst) val))
(define (quest-done! qst val) (set-car! (cddr qst) val))


;;----------------------------------------------------------------------------
;; Ȥβ
;;----------------------------------------------------------------------------
(define (ranger-ranger knpc kpc)
  (say knpc "ĮȹζäƤ롣"
       "桹ƻ뤷Ǥ뤫긭ԤϤƤ롣"))

(define (ranger-wise knpc kpc)
  (say knpc "ϸԤȤǤ롣"
       "ãϲ桹˱ȤƤʤͿΤ˲桹Ͼ󶡤Ƥ롣"
       "ˤϲ桹ϸã廡Ǥ̳롣"))

(define (ranger-join knpc kpc)
  (cond ((has? kpc t_ranger_orders 1)
         (say knpc "̿򸫤Ƥλ򡣤Ф餯δ֡ƱԤޤ")
         (take kpc t_ranger_orders 1)
         (join-player knpc)
         ;; NOTE: the following only permits one ranger at a time to join the
         ;; player!
         (kern-tag 'ch_ranger_merc knpc)
         (give kpc t_arrow 20)
         (kern-conv-end)
         )
        (else
         (say knpc "ǰǤλŻޤ"))))

(define (ranger-band knpc kpc)
  (say knpc "򵯤ԤƨΤ"
       "ˤϾ̵ˡԤ롣"))

(define ranger-conv
  (ifc basic-conv
       (method 'join ranger-join)
       (method 'rang ranger-ranger)
       (method 'wise ranger-wise)
       (method 'band ranger-band)
       ))


;; Knight conversation -- used by Lord Froederick's troops
(define knight-conv basic-conv)

;; 饹ɥ
(define (glasdrin-warr knpc kpc)
  (if (player-found-warritrix?)
      (say knpc "ߤλᤷǤ롣")
      (say knpc "ƮΤϤλǺǤѤΤɤˤΤΤʤԤե꡼ᴱʹФ褤")
  	)
  	(quest-data-update 'questentry-warritrix 'general-loc 1)
  )

(define (glasdrin-stew knpc kpc)
  (if (player-stewardess-trial-done?)
      (say knpc "Ԥä̾ϼ줿ΤȤʤäԤϤĤƤλᴱ륹")
      (say knpc "ԤϤĮȥ饹ɥڤäƤ롣ʤˤ롣")))

(define (glasdrin-jeff knpc kpc)
  (if (player-stewardess-trial-done?)
      (say knpc "褯äƤ⡢ե꡼ᴱȤƻشμԤ̳դä"
           "ƮΤؤ΢ڤ˶Ϥ"
           "桹οᴱϥ˥")
      (say knpc "ե꡼ϥ饹ɥηλᴱʤˤ롣")
      ))

(define (glasdrin-kurp knpc kpc)
         (say knpc "̤ζϤꡢ̮˱äƹԤȡ"
              "̤ë֤˸"))
(define (glasdrin-cita knpc kpc)
  (say knpc "¦κ֤ˤ롣"))
(define (glasdrin-ghol knpc kpc)
  (say knpc "ᤵ줿ťåȤȤ̾äȻפ֤ϲδƹǳΤȤ褤")
   (quest-data-update 'questentry-ghertie 'gholet-dungeon 1)
   )
(define (glasdrin-kurp knpc kpc)
  (say knpc "ߥݥꥹµܤˤΤۤȤɤ롣̮򤿤ɤäعԤȶëĤ"))

(define (glasdrin-glas knpc kpc)
  (say knpc "饹ɥΤĮ"))

(define (glasdrin-pala knpc kpc)
  (say knpc "饹ɥΤϤΤǺǤ⶯Ϥʷ"))

(define glasdrin-conv
  (ifc basic-conv
       (method 'warr glasdrin-warr)
       (method 'stew glasdrin-stew)
       (method 'jeff glasdrin-jeff)
       (method 'kurp glasdrin-kurp)
       (method 'cita glasdrin-cita)
       (method 'ghol glasdrin-ghol)
       (method 'kurp glasdrin-kurp)
       (method 'glas glasdrin-glas)
       (method 'pala glasdrin-pala)
       (method 'jani 
               (lambda (knpc kpc) 
                 (if (player-stewardess-trial-done?)
                      (say knpc "ɾĲϥ˥򥸥ե꡼θǤȤƻᴱФ")
                      (say knpc "ե꡼ͭǽʻᴱ亴Υ˥ΤȤΤïǤΤäƤ롣"))))
       (method 'valu
               (lambda (knpc kpc)
                 (if (player-stewardess-trial-done?)
                     (say knpc "륹ηԤ餫ˤʤä"
                          "˴ؤ뱳򿮤ƤޤäȤѤȤ"
                          "䤿򿷤ԤФ")
                     (say knpc "륹Ѥ٤Ԥ줿"
                          "˻ǰºɤ뾭ä"))))
       ))

;; Kurpolis
(define kurpolis-conv
  (ifc basic-conv
       ))

;; Green Tower
(define (gt-gobl knpc kpc)
  (say knpc "֥ʹߡä԰ʵ֤ˤ롣ϻΤᤳĮ롣ǲäȤϵĤʤФʤʤ"))
(define (gt-towe knpc kpc)
  (say knpc "Į̾ˤŤ㤫ȤäΤǡϷ"))
(define (gt-ruin knpc kpc)
  (say knpc "ŤפϤĮγѤˤ롣"))
(define (gt-band knpc kpc)
  (say knpc "±ΤȤϥǥåĹʹФ褤"
       "˼ȤǤԤΰͤ"))


(define green-tower-conv
  (ifc basic-conv
       (method 'gree
               (lambda (knpc kpc)
                 (say knpc "Į̾ˤŤ㤫ȤäΤ")))
       (method 'gobl gt-gobl)
       (method 'towe gt-towe)
       (method 'ruin gt-ruin)
       (method 'band gt-band)
       ))

;; Trigrave
(define trigrave-conv
  (ifc basic-conv
       (method 'thie 
               (lambda (knpc kpc) 
                 (say knpc "ťΤȤϤ狼ʤ٥ιͤȤ褯äƤΤǲΤäƤ뤫⤷ʤ")))
       ))

;;----------------------------------------------------------------------------
;; Ź

;; Indices into the merchant message list
(define merch-closed           0)
(define merch-buy              1)
(define merch-sell             2)
(define merch-trade            3)
(define merch-sold-something   4)
(define merch-sold-nothing     5)
(define merch-bought-something 6)
(define merch-bought-nothing   7)
(define merch-traded-something 8)
(define merch-traded-nothing   9)

(define (conv-trade knpc kpc menu msgs catalog)
  (println "conv-trade: " (kern-obj-get-activity knpc))
  ;;(println "conv-trade: " menu msgs catalog)
  (if (and (not (string=? "working" (kern-obj-get-activity knpc)))
           (not (null? (list-ref msgs merch-closed))))
      (say knpc (list-ref msgs merch-closed) 
           ""
           (cond ((string=? (kern-obj-get-activity knpc) "idle") "ٷ")
                 ((string=? (kern-obj-get-activity knpc) "eating") "")
                 ((string=? (kern-obj-get-activity knpc) "drunk") "Ǥ")
                 ((string=? (kern-obj-get-activity knpc) "commuting") "ư")
                 (else (kern-obj-get-activity knpc)))
           "")
      (cond ((string=? menu "buy")
             (say knpc (list-ref msgs merch-buy))
             (if (kern-conv-trade knpc kpc "buy" catalog)
                 (say knpc (list-ref msgs merch-sold-something))
                 (say knpc (list-ref msgs merch-sold-nothing))))
            ((string=? menu "sell")
             (say knpc (list-ref msgs merch-sell))
             (if (kern-conv-trade knpc kpc "sell" catalog)
                 (say knpc (list-ref msgs merch-bought-something))
                 (say knpc (list-ref msgs merch-bought-nothing))))
            (else
             (say knpc (list-ref msgs merch-trade))
             (if (kern-conv-trade knpc kpc "trade" catalog)
                 (say knpc (list-ref msgs merch-traded-something))
                 (say knpc (list-ref msgs merch-traded-nothing))))
            )))

;; 
(kern-dictionary
	""	"two"	""
	"˥"	"six"	""
	""	"eigh"	""
	""	"love"	""
	"ȥ"	"pass"	""
	"ĥ"	"them"	"Ĥ"
	"ʥ"	"inag"	"ʥ"
	""	"red"	""
	""	"evil"	""
	""	"demo"	""
	""		"open"	""
	""	"open"	""
	""	"leg"	"­"
	""	"play"	"ͷ"
	""	"play"	"ͷ"
	""	"loca"	""
	"ĥ"	"coll"	""
	""	"hole"	""
	"ӥ"	"abig"	"ӥ"
	"֥å"	"absa"	"֥å"
	"凉"	"reve"	"ɽ"
	""	"that"	""
	"ڥ"	"alop"	"ڥ"
	"󥰥ꥹ"	"angr"	"󥰥ꥹ"
	"󥵥ĥ"	"assa"	"Ż"
	""	"earl"	""
	""		"iki"	""
	""	"ways"	""
	"ĥ"	"more"	"Ĥ"
	"˥"	"sacr"	""
	""	"medi"	""
	""	"isin"	""
	""	"ruin"	""
	""	"ini"	""
	""	"dog"	""
	"Υ"	"life"	"̿"
	"ޥ"	"vigi"	""
	"ꥢ"	"ilya"	"ꥢ"
	"ꥰ"	"entr"	""
	""	"hung"	""
	""	"wake"	"ưФ"
	""	"song"	""
	""	"arm"	""
	""	"sea"	""
	"ߥإ"	"sea"	"إ"
	"饮"	"betr"	"΢ڤ"
	"饮쥿"	"betr"	"΢ڤ줿"
	"饮"	"betr"	"΢ڤ"
	""		"sell"	""
	"ĥƥ"	"skul"	"ĤƤ"
	""	"luck"	""
	""		"eh"	""
	""	"abe"	""
	"󥸥"	"ange"	"󥸥"
	""	"ord"	""
	""	"wolf"	"ϵ"
	""	"drun"	""
	""		"hill"	""
	""	"momm"	"줵"
	""	"stra"	""
	""	"woma"	""
	""	"gran"	""
	""	"stag"	""
	""	"osca"	""
	""	"afra"	""
	"å"	"gher"	"ä"
	"å"	"husb"	""
	"ȥ"	"dadd"	"㤵"
	"ȥ"	"maid"	""
	""		"axe"	""
	"ѡ"	"opar"	"ѡ"
	"ɥ"	"chan"	"ɥ"
	""	"lady"	""
	""		"ka"	""
	""		"stor"	""
	"奦"	"conv"	""
	""	"pira"	"±"
	"֥"	"mons"	"ʪ"
	""		"buy"	"㤦"
	""	"key"	""
	"ɥ"	"pick"	"ƻ"
	"ƥޥ"	"wore"	"ݤƤޤ"
	"ʥ"	"iron"	"ʪ"
	""	"kama"	""
	""		"god"	""
	"ߥ"	"gods"	""
	"륷ե"	"kalc"	"륷ե"
	"ӥ"	"calv"	"ӥ"
	""	"calv"	""
	""	"chan"	"Ѥ"
	"󥷥"	"jail"	"Ǽ"
	"ƥ"	"gher"	"ƥ"
	"󥿥"	"patc"	""
	""		"ki"	""
	""	"vani"	"ä"
	""	"dang"	""
	""	"wood"	"ڤ"
	""	"shor"	""
	""	"scar"	""
	""	"rule"	"§"
	"Υ"	"shro"	"Υ"
	"㥯"	"clie"	""
	"㥹"	"kath"	"㥹"
	"奦"	"camp"	"©"
	"祦"	"bord"	""
	"祦"	"less"	""
	"祦ܥ"	"sava"	"˽"
	"祸"	"gint"	""
	"饤"	"hate"	""
	""		"engi"	""
	""	"sacr"	""
	""	"poti"	""
	""		"shit"	""
	""		"spid"	""
	"åƥ"	"mad"	"äƤ"
	"ӥ"	"clov"	"ӥ"
	"󥸥"	"blac"	""
	"ݥꥹ"	"kurp"	"ݥꥹ"
	""		"gu"	""
	""		"guto"	""
	"Υ"	"guno"	"Υ"
	"٥"	"gwen"	"٥"
	"饹ɥ"	"glas"	"饹ɥ"
	"쥴"	"greg"	"쥴"
	""	"mili"	""
	""	"patr"	""
	"ӥ"	"rang"	""
	"ॷ"	"pris"	"̳"
	""	"affl"	""
	""	"brut"	""
	""	"swor"	""
	"󥸥"	"wise"	""
	""	"gaze"	""
	""	"lang"	""
	"󥷥ƥ"	"prim"	"Ū"
	""	"sail"	"ҹ"
	"˥"	"repl"	"Ǥ"
	""	"void"	""
	""	"void"	""
	""	"orph"	"ɻ"
	"å祦"	"bord"	""
	""		"hut"	""
	""	"this"	""
	""	"kill"	""
	""	"kill"	""
	"塞ʥ"	"afra"	"ݤʤ"
	""	"char"	""
	"֥"	"gobl"	"֥"
	"ۥ"	"blow"	""
	"ۥ"	"coug"	"ۥ"
	"å"	"ghol"	"å"
	""	"wors"	"ǰ"
	""	"firs"	"ǽ"
	""	"shri"	""
	""	"shri"	""
	"饹"	"sila"	"饹"
	""	"jugs"	""
	""	"tave"	""
	""	"sear"	"õ"
	"ʥ"	"bye"	"ʤ"
	""	"sund"	""
	""	"dead"	""
	"ԥ"	"shak"	"ԥ"
	"ԥ"	"shak"	"ԥ"
	""		"comm"	"ش"
	""	"job"	"Ż"
	"ȥʥ"	"luck"	"Żʤ"
	""	"lion"	""
	""	"bard"	""
	""	"want"	""
	"å"	"fens"	""
	"å"	"fens"	""
	""		"die"	""
	"ϥ"	"domi"	""
	"ߥ"	"civi"	"̱"
	""	"shar"	""
	"奦"	"pris"	""
	"奦ɥ"	"num"	"ƻ"
	"奦ɥ"	"brot"	"ƻ"
	"奦襦"	"pris"	"ƽ"
	"奦襦"	"pris"	"ƽ"
	"奦"	"tink"	""
	"奴"	"ward"	""
	"奴Υ"	"ward"	"μʸ"
	"奴"	"keep"	""
	"奸"	"innk"	""
	"롼"	"shro"	"롼"
	"祦"	"prom"	""
	"祦"	"evid"	"ڵ"
	"祦Х"	"deal"	""
	"祯"	"supp"	""
	"祯˥"	"wrig"	""
	"祯˥"	"wrig"	""
	"祯祦"	"food"	""
	"祦ĥ"	"necr"	"ѻ"
	"쥤"	"comm"	"ᴱ"
	""	"whit"	""
	""	"whit"	"򤭲"
	"󥨥"	"deep"	"ʥ"
	"󥸥"	"trut"	""
	"󥻥"	"cous"	""
	""	"dead"	""
	"ǥ"	"shri"	""
	"襦"	"trus"	""
	""	"temp"	""
	""	"jake"	""
	""	"jess"	""
	"ե꡼"	"jeff"	"ե꡼"
	""	"gen"	""
	""	"hell"	"Ϲ"
	""	"age"	""
	""	"merc"	""
	""	"jim"	""
	""	"ja"	""
	"㥢"	"wick"	"ٰ"
	"˥"	"jani"	"˥"
	"奦"	"twel"	""
	"奦˥"	"inha"	""
	""	"spel"	"ʸ"
	""		"jo"	""
	"硼"	"jorn"	"硼"
	"祦ۥ"	"news"	""
	"ϥ"	"hono"	""
	"٥"	"ques"	"٤"
	"ߥ䥭"	"char"	"úƤ"
	""		"zu"	""
	""	"zuka"	""
	""	"pala"	""
	""	"just"	""
	""	"sacr"	""
	""	"stud"	""
	"ϥ"	"holy"	""
	"˥"	"onus"	"Ǥ"
	"Х"	"rune"	""
	""	"sele"	""
	"󥻥"	"doc"	""
	"󥽥"	"wars"	""
	"祦"	"capt"	"Ĺ"
	"ȥ"	"warm"	"Ʈ"
	""	"good"	""
	"󥻥"	"outp"	""
	""	"equi"	""
	"ʥ"	"offe"	"ʪ"
	""	"reti"	""
	"ޥ"	"torc"	""
	""	"fort"	""
	""	"help"	""
	"å"	"batt"	"ä"
	""	"shie"	""
	"Υ"	"fun"	"ڤ"
	"ӥΥ"	"knig"	"ιε"
	"ӥӥ"	"trav"	"ι"
	"٥"	"food"	"ʪ"
	""	"reas"	""
	"󥱥"	"dagg"	"û"
	""		"da"	""
	""	"firs"	"裱"
	""	"seco"	"裲"
	""	"thir"	"裳"
	""	"firs"	""
	""	"pay"	""
	""	"thir"	"軰"
	"祦"	"fail"	""
	""	"love"	"繥"
	""	"seco"	""
	""	"free"	"Ф"
	""	"husb"	"ö"
	""	"ches"	""
	""	"wit"	"η"
	""	"unde"	"ϲ"
	""	"powe"	""
	""	"know"	"μ"
	""	"dadd"	""
	"Υ"	"int"	"ǽ"
	"奦ȥ"	"garr"	""
	""		"cho"	""
	"祦"	"heal"	""
	""		"tu"	""
	"ĥ"	"moon"	""
	"ĥ"	"spit"	"ͤɤ"
	"ĥ"	"make"	""
	"ĥʥ"	"pena"	""
	"ĥߥΥʥ"	"inno"	"Τʤ"
	"ĥ"	"thin"	"Ϣ"
	""	"hand"	""
	"ƥ"	"enem"	"Ũ"
	"ƥ"	"crew"	"겼"
	"ƥĥ"	"chor"	""
	"ƥ󥷥祯"	"voca"	"ŷ"
	"ǥ˥"	"denn"	"ǥ˥"
	"ǥå"	"deri"	"ǥå"
	"ǥɥ"	"lost"	"Ʋ"
	""		"to"	""
	"ȥ"		"towe"	""
	"ȥ"	"warr"	"Ʈ"
	"ȥ"	"band"	"±"
	"ȥ"	"stew"	""
	"ȥ"	"plac"	""
	"ȥ"	"civi"	"Ի"
	"ȥå"	"get"	"ä"
	"ȥ"		"kind"	"ͧ"
	"ȥꥰ쥤"	"trig"	"ȥꥰ쥤"
	"ȥ"	"fort"	""
	"ȥҥ"	"trad"	""
	"ȥ"		"get"	""
	"ȥ"	"trol"	"ȥ"
	"ɥ˥"	"inn"	"Ʊ"
	"ɥ"	"cave"	"ƶ"
	"ɥ֥"	"anim"	"ưʪ"
	"ɥ"	"pois"	""
	"ɥ㥯"	"nati"	""
	"ɥꥹ"	"dori"	"ɥꥹ"
	"ɥ쥤"	"slav"	""
	"ɥܥ"	"thie"	"ť"
	"ɥ"	"thud"	"ɥ"
	""		"na"	""
	"ʥ"	"join"	""
	"ʥޥ"	"name"	"̾"
	"ʥ饺"	"wrog"	"ʤ餺"
	"˥"	"hate"	""
	"˥"		"jink"	"ƨ"
	"˥ʥ"	"esca"	"ƨʤ"
	"˥"	"esca"	"ƨ"
	"˥å"	"diar"	""
	"˥"		"nin"	"˥"
	"˥󥲥"	"man"	"ˤ󤲤"
	"˥"	"erra"	"Ǥ̳"
	""		"nu"	""
	"̥"	"nuki"	"̥"
	"̥"	"fen"	""
	"ͥ"	"mous"	"ͥ"
	""		"no"	""
	"Υ"	"noor"	"Υ"
	"Υ"	"farm"	""
	"Υ祯"	"skil"	"ǽ"
	"Υ"	"esca"	"ƨ"
	"Υե"	"noss"	"Υե"
	"Υߥ"	"drin"	"ʪ"
	"Υ"	"drin"	""
	"Υ"	"curs"	""
	"Υ쥿"	"accu"	"줿"
	""		"ha"	""
	"ϥ"	"grav"	""
	"ϥ"		"ches"	"Ȣ"
	"ϥ"	"run"	""
	"ϥ"	"sham"	"Ѥ"
	"ϥå"	"hack"	"ϥå"
	"ϥʥ"	"stor"	""
	"ϥʥ"	"talk"	"ä"
	"ϥå"	"haml"	"ϥå"
	"ϥ"	"hame"	"ϥ"
	"ϥ󥮥㥯"	"rebe"	"ȿ"
	"ϥ󥷥"	"rebe"	"ȿ"
	"ϥȥ"	"peni"	"Ⱦ"
	"С"	"bart"	"С"
	"Х˥"	"sell"	""
	"Х륹"	"valu"	"Х륹"
	"Х"	"vale"	"Х"
	"ѡ"	"perc"	"ѡ"
	"ѡХ"	"perc"	"ѡХ"
	"ѥ"	"pusk"	"ѥ"
	""		"hi"	""
	"ҥ"	"enli"	""
	"ҥĥ"	"shee"	""
	"ҥ"	"men"	""
	"ҥȥӥ"	"peop"	"͡"
	"ҥȥ"	"alon"	"Ȥ"
	"ҥɥ"	"nast"	""
	"ҥɥ"	"hydr"	"ҥɥ"
	"ҥΥ"	"fire"	"Фγ"
	"ҥߥ"	"secr"	"̩"
	"ҥ䥯"	"reag"	""
	"ӥȥꥢ"	"vict"	"ӥȥꥢ"
	"ӥ祦"	"hosp"	"±"
	"ӥ"	"bill"	"ӥ"
	"ӥ󥷥祦"	"dex"	"Ҿ"
	"ե"	"fing"	"ե"
	"ե奦"	"reve"	""
	"ե"	"unde"	"Ի"
	"ե祦"	"crip"	""
	"ե"	"fail"	""
	"ե"	"guar"	"ɤ"
	"ե"	"two"	""
	"եƥ"	"unna"	"Ŭ"
	"ե"	"ship"	""
	"ե륤"	"old"	"Ť"
	"֥"	"brun"	"֥"
	"֥ǥ"	"brun"	"֥ǥ"
	"֥"	"cult"	"ʸ"
	"֥ᥤ"	"civi"	"ʸ"
	"إ"	"tour"	"ʼ"
	"إ"	"peac"	"ʿ"
	"إå"	"hung"	"ä"
	"إ"	"room"	""
	"إ꡼"	"henr"	"إ꡼"
	"ۡ"	"hole"	"ۡ"
	"ۥ"	"ruin"	""
	"ۥ"	"cita"	""
	""		"bo"	""
	"ܥ󥷥"	"adve"	""
	"ܥ쥤"	"ghos"	"˴"
	"ܥʥ"	"bona"	"ܥʥ"
	"ܥ"		"bole"	"ܥ"
	""		"ma"	""
	"ޥ"	"scro"	"ʪ"
	"ޥॹ"	"gran"	"¹̼"
	"ޥĥ"	"wiza"	"ѻ"
	"ޥ"	"witc"	""
	"ޥ"	"poor"	"Ϥ"
	"ޥ"		"town"	"Į"
	"ޥå"	"expe"	"Ԥä"
	"ޥɥ"	"ench"	"ƻ"
	"ޥۥ"	"mage"	"ˡ"
	"ޥۥ"	"roun"	"ˡ"
	"ޥۥĥ"	"wiza"	"ˡȤ"
	"ޥ襤ӥ"	"wand"	"¤"
	"ޥʥ"	"nigh"	""
	"ߡˡ"	"mean"	"ߡˡ"
	"ߥĥ"	"find"	"Ĥ"
	"ߥɥΥȥ"	"gree"	"Ф"
	"५"	"old"	""
	"ॹ"	"daug"	"̼"
	""		"folk"	"¼"
	""	"hord"	""
	""		"me"	""
	"ᥤ"		"may"	"ᥤ"
	"ᥤ奦"	"dung"	"µ"
	"奭"	"melu"	"奭"
	"ӥ"	"melv"	""
	""	"melv"	""
	"⥦⥯"	"blin"	""
	"⥯ƥ"	"aspi"	"Ū"
	""	"stuf"	"ʪ"
	""		"wood"	""
	""		"gate"	""
	""		"arro"	""
	"䥢"		"hail"	"䤢"
	"䥷"	"ambi"	""
	"å"	"trou"	"ä"
	"å"	"eigh"	"Ȭ"
	"ޥ"	"sick"	""
	""	"quit"	""
	"饫"	"soft"	"餫"
	"楦쥤"	"haun"	"ͩ"
	"ӥ"	"ring"	""
	"襯ܥ"	"desi"	"˾"
	"饯ޥ"	"luxi"	"饯ޥ"
	"ꥢ"	"lia"	"ꥢ"
	"å"	"lich"	"å"
	"㥯"	"sack"	"άå"
	""		"lu"	""
	"奦"	"drag"	"ε"
	"祦"	"real"	"ΰ"
	"祦"	"pare"	"ξ"
	"祦"	"real"	""
	"祦ۥ"	"both"	"ξ"
	"祦"	"cook"	""
	"祦˥"	"cook"	""
	"󥸥"	"neig"	"ٿ"
	""		"ru"	""
	"륫"	"ruka"	"륫"
	"ߥ"	"lumi"	"ߥ"
	"쥤"	"spir"	""
	"쥭"	"hist"	""
	"󥭥󥸥ĥ"	"alch"	"ϣѻ"
	"󥷥奦"	"prac"	""
	"륱"	"cape"	"륱"
	""	"cell"	"ϴ"
	"˥"	"six"	"ϻ"
	"參"	"leav"	"̤"
	"凉쥿"	"forg"	"˺줿"
	"å"	"chop"	"ä"
	"祯"	"stre"	""
	"륹"	"valu"	"륹"
	""	"vale"	""
	"ȥꥢ"	"vict"	"ȥꥢ"
	""		"tree"	""
	""		"eye"	""
	""		"fire"	""
)
