;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define dennis-lvl 3)
(define dennis-species sp_human)
(define dennis-occ oc_wright)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ť֥å
;;----------------------------------------------------------------------------
(define dennis-bed oa-bed2)
(define dennis-mealplace oa-tbl1)
(define dennis-workplace oa-slaves)
(define dennis-leisureplace oa-dining-hall)
(kern-mk-sched 'sch_dennis
               (list 0  0 dennis-bed          "sleeping")
               (list 7  0 dennis-mealplace    "eating")
               (list 8  0 dennis-workplace    "working")
               (list 12 0 dennis-mealplace    "eating")
               (list 13 0 dennis-workplace    "working")
               (list 18 0 dennis-mealplace    "eating")
               (list 19 0 dennis-leisureplace "idle")
               (list 22 0 dennis-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (dennis-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ǥ˥ϼ줿ԤοԤǡť֥åȤ˽Ǥ롣
;; Ͽ䤹ޤˤޤäƤʤ
;;----------------------------------------------------------------------------

;; Basics...
(define (dennis-hail knpc kpc)
  (say knpc "ˤϡ"))

(define (dennis-default knpc kpc)
  (say knpc "ΤΤȤϤ狼ޤ"))

(define (dennis-name knpc kpc)
  (say knpc "ǥ˥Ǥ"))

(define (dennis-join knpc kpc)
  (say knpc "ϤФäϤϻפޤιο͡"))

(define (dennis-job knpc kpc)
  (say knpc "饹դ̤Ǥ"))

(define (dennis-bye knpc kpc)
  (say knpc "褦ʤ顣"))

;; Tier 2
(define (dennis-stud knpc kpc)
  (say knpc "饹դ顢ʬΰջפ˽椹뤳ȡƻʤ˸ˤʤΤˤ뤳Ȥ򶵤äƤޤϼʬ˾ãǤ뤳ȤǤ礦ǤʤƤ⡢ʤȤ줿Ԥˤ뤳ȤǤǤ礦"))

(define (dennis-accu knpc kpc)
  (say knpc "줿Ԥϸ򤵤Ƥޤʤ˾ɤΤϡǤϤʤʤΤǤʤ桹ŨϤ줬狼ʤΤǤ礦"))

(define (dennis-enem knpc kpc)
  (say knpc "饹ɥεԻԤȶ򤫤ǯƻդϤʤƤΤǤ"))

(define (dennis-ways knpc kpc)
  (say knpc "줿ԤʳṲ̄Ƥޤ줾ʳǿԤϤƤޤʳã뤿ˤϡ̤Ϥդ路򤵤뵷ԤʤФʤޤ"))

(define (dennis-sacr knpc kpc)
  (say knpc "ε̩ˤƤޤʤΤ褦ʲΤʤͤˤäޤ"))

(define (dennis-powe knpc kpc)
  (say knpc "Ǥʤ褦ϤĤ߼ջ֤ΤԤԤäƤޤ"))

(define (dennis-sila knpc kpc)
  (say knpc "饹դϤΤѻաƸǤ"))

(define (dennis-absa knpc kpc)
  (say knpc "ζ򤫼Ԥϡ桹ˤȹͤƥ֥åȤ˲ޤĮοˤ뤳θŤ֥åȤΤȤΤޤǤ"))

(define (dennis-old knpc kpc)
  (say knpc "ΰפ⤤Ƥȡڷɤǰ˶ޤԵ̣Ǥο͡ϴ̯ʿĤäƤΤǤ͡"))

(define (dennis-sele knpc kpc)
  (say knpc "ϴ֤ϰȤϸޤˤ϶ŤʤۤǤ衪")
  (kern-conv-end)
  )

(define dennis-conv
  (ifc basic-conv

       ;; basics
       (method 'default dennis-default)
       (method 'hail dennis-hail)
       (method 'bye dennis-bye)
       (method 'job dennis-job)
       (method 'name dennis-name)
       (method 'join dennis-join)
       
       (method 'sele dennis-sele)
       (method 'stud dennis-stud)
       (method 'teac dennis-stud)
       (method 'accu dennis-accu)
       (method 'enem dennis-enem)
       (method 'ways dennis-ways)
       (method 'sacr dennis-sacr)
       (method 'powe dennis-powe)
       (method 'sila dennis-sila)
       (method 'absa dennis-absa)
       (method 'old dennis-old)
       ))

(define (mk-dennis)
  (bind 
   (kern-mk-char 
    'ch_dennis           ; tag
    "ǥ˥"             ; name
    dennis-species         ; species
    dennis-occ              ; occ
    s_townsman     ; sprite
    faction-men      ; starting alignment
    0 1 0            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    dennis-lvl
    #f               ; dead
    'dennis-conv         ; conv
    sch_dennis           ; sched
    'spell-sword-ai              ; special ai
    nil              ; container
    (list t_staff)              ; readied
    )
   (dennis-mk)))
