;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Ф
;;----------------------------------------------------------------------------
(define (mk-zone x y w h) (list 'p_green_tower x y w h))
(kern-mk-sched 'sch_deric
               (list 0  0 (mk-zone 17  4  1   1)  "sleeping")
               (list 6  0 (mk-zone 30 30  5   5)  "working")
               (list 12  0 (mk-zone 52 54  1   1)  "eating")
               (list 13  0 (mk-zone 30 30  5   5)  "working")
               (list 18  0 (mk-zone 52 54  1   1)  "eating")
               (list 19  0 (mk-zone 30 30  5   5)  "working")
               (list 21  0 (mk-zone 13  2  4   4)  "idle")
               (list 22  0 (mk-zone 17  4  1   1)  "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (deric-mk tell-secret?) (list tell-secret? (mk-quest)))
(define (deric-tell-secret? deric) (car deric))
(define (deric-set-tell-secret! deric) (set-car! deric #t))
(define (deric-bandit-quest deric) (cadr deric))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ǥåФηĹǤ롣
;;----------------------------------------------------------------------------

(define (deric-name knpc kpc)
  (say knpc "ϥǥåĹλᴱǤ롣ʤȿ褤"))

(define (deric-job knpc kpc)
  (say knpc "ش뤳ȤǤ롣ƻˤϤ礭Ū롣"
       "ϼʬǽϤǻشϰ̤˾ͤ᤿ʤ뤿ˤϡ"
       "ï̤ΤԤʤФʤʤ"))

(define (deric-health knpc kpc)
  (say knpc "Ϸ򹯤ΤΤǤ롪"))

(define (deric-rangers knpc kpc)
  (say knpc "Ϥιʿʿ¤̳äƤ롣"
       "ˡ餻֥ɤƻ뤹ʤɤ"
       "ϩݻΤ桹λŻ"
       "ʬȤΤȤС桹ϻΨΤȤФ餷Ż򤷤Ƥ롣"
       "Ư˴դƤ롣γФ餤"))

(define (deric-two knpc kpc)
  (say knpc "γΤۤȤɤɸ"
       "γϲļʼˡ˼ʤɤ"
       "Ϸ̳ˤʤäƤ롣"
       "γˤͩȹͤƤԤ⤤褦"))

(define (deric-haunted knpc kpc)
  (say knpc "γˤͩȸԤ롣̯ʪʹȤ롣"
       "ɤα顢褦ʡĤΤ褦"
       "ͩʤɸȤʤ"
       "ϤʤΤ϶ʤ"))

(define (deric-gen knpc kpc)
  (say knpc "̾⤭ԡǤʤʡ"
       "Υ֥ǤγϷδ֤ǤȤʤäƤ롣ƸŶԤκǸĤΰͤǤ⤢롣"
       "ǤΤĴҤϤ褵"
       "μԤˤʤäƤޤäɤ̣狼"))

(define (deric-native knpc kpc)
  (say knpc "Ͽ̱Ĥޤ꿹֥νƤ롣"
       "ब桹ȿտäƤȵäƤΤǤϤʤ"
       "⤷Ǥʤ顢ʤȤפäƤ롣"
       "Բǽ"
       ))

(define (deric-shroom knpc kpc)
  (say knpc "񤷤̤ǽϤ뤬ʤ"
       "Į򤷤Ƥ롣"))

(define (deric-abe knpc kpc)
  (say knpc "㤤ѤäˤѤԤȤꡢ̯ʡġ̤θ򤹤ȡĤޤʡ"
       "ȤˤĤĮΰפĴ٤Ƥ롣"
       "Ω޽ۤɤƯƤΤ"))


(define (deric-tower knpc kpc)
  (say knpc "Įˤ롢ФȸƤФ"
       "λشǤꡢǤ롣"
       "Ф餷ʪ"
       "줬Ťΰפξ˷Ƥ줿ΤΤäƤ뤫")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "򤤤Ȼפ󤫡ˤϾܤϤ狼ʤ"
           "äΤꤿʤ顢֤⤷ȥ롼äȤ褤⤷")
      (say knpc "ϡĤƤäΰˤʤ"
           "֤ȤԤΤȤ򿮤ʤ顢Ǥޤä"
           "ǤĤγĤäƤʤ")))

(define (deric-ambition knpc kpc)
  (say knpc "̤ꡣˤꡢǧ뤳Ȥ򶲤ʤ"
       "ͤļԤ԰¤˻פޤʤɤʤˤʤ"
       "̵Ϻϰ̤ˤɤ夯ʤȤϲ⤷Ƥʤ"
       "ϤΰȿοǤƤ롣ˤ뤫")
  (if (kern-conv-get-yes-no? kpc)
      (begin
        (say knpc "λϤ褤ϤĤˤʤꤿ"
             "ˤϤε񤬤Ȼפ")
        (if (kern-conv-get-yes-no? kpc)
            (begin
              (say knpc "狼äƤ롪ΤȤѤƤ櫓ǤϤʤ"
                   "ԤƶϤļԤΤ褦"
                   "ˤ̩򶵤褦")
              (deric-set-tell-secret! (kobj-gob-data knpc)))
            (say knpc "ξФϤޤʤոʤ褦ʡ"
                 "Ф줷ԤϤ褯פʤΤ")))
      (say knpc "Τ©¿μԤɤ̵ͤ˿ϲ񤷤Ƥ롣"
           "ΰͤǤʤȤǤ롪")))

(define (deric-secret knpc kpc)
  (if (deric-tell-secret? (kobj-gob-data knpc))
      (say knpc "ϲˤϱ줿ϩ롣"
           "ΤϤߤơν졣"
           "ɤ̩⤬롪"
           "ΤᤫϤ狼ʤʡ")
      (say knpc "ͤʤ褽ԤäȤϲʤ")))

(define (deric-afraid knpc kpc)
  (say knpc "ϾʪΥۥ֥֥"
       "䡢ۥ֥֥󤬾ʪζ줫"
       "礦ᡢФ󤷤פФʤ"))

(define (deric-prison knpc kpc)
  (say knpc "ȤƤ⶯Ǥʡߡͤϰͤʤ"
       "Τ򤦤ĤƤ֥"
       "˽ʽäȸۤˤʤ"
       "ϤĤ򶲤줿ϤʤγФ餤"))

(define (deric-gobl knpc kpc)
  (say knpc "ʤĤޤˤĤĮޤơ̳Ǥäʡ"))

(define (deric-brute knpc kpc)
  (say knpc "ȤƤ⵿路ԤʪäƤʤäΤǡ餫˾褿ΤǤϤʤ"
       "ƶ̸줬äʤä"
       "䡢ɤäȤʤäࡢϲˤоä褦ˤʤꤽʤΤ"
       "򤿤ǤΤͤߤʤС"))

(define (deric-default knpc kpc)
  (say knpc "̤ΤȤʹƤ졪"))

;; Scan the player party looking for mercs
                         

(define (deric-hail knpc kpc)

  (define (get-ranger-merc)
    (let ((mercs (filter (lambda (kchar)
                           (kbeing-is-npc-type? kchar 'ranger))
                         (kern-party-get-members (kern-get-player)))))
      (cond ((null? mercs) nil)
            (else
           (car mercs)))))

  (define (rm-ranger-merc)
    (let ((kmerc (get-ranger-merc)))
      (if (not (null? kmerc))
          (begin
            (prompt-for-key)
            (say knpc "Ͻ󤹤ƹʤФʤʤ")
            (kern-char-leave-player kmerc)
            ))))

  (cond ((in-player-party? 'ch_nate)
         (say knpc "±Ƭ館褦ʡ"
              "ϲη̳δǼϤƾäƤΤ")
         (rm-ranger-merc)
         (quest-data-update-with 'questentry-bandits 'captured-nate-and-talked-to-deric 1 (quest-notify nil))
         )        
        ((has? kpc t_prisoner_receipt 1)
         (say knpc "±ݣθ¦ɤäȤϡεϿˤʤǤ"
              "󽷤Ϥ")
         (give-player-gold 100)
         (kern-char-add-experience kpc 64)
         (take kpc t_prisoner_receipt 1)
         (quest-done! (deric-bandit-quest (kobj-gob-data knpc)) #t)
         (rm-ranger-merc)
         (quest-data-update-with 'questentry-bandits 'done 1 (grant-party-xp-fn 30))
         (quest-data-complete 'questentry-bandits)
         )
        (else
         (say knpc "褯褿ʡ")
         )))

(define (deric-bye knpc kpc)
  (say knpc "ޤ񤪤"))

(define (deric-thie knpc kpc)
  (say knpc "դࡣޤäΤ褦ʥ֥ťä˰㤤ʤ"
       "ۤϷ̳̤ä̤ذͤǸԤȤϤäŪϤϤ狼"
       "̤ˤϥܥ줷ʤʡ")
       (quest-data-update 'questentry-thiefrune 'tower 1)
       (quest-data-update-with 'questentry-thiefrune 'bole 1 (quest-notify (grant-party-xp-fn 10)))
       )

(define (deric-accu knpc kpc)
  (say knpc "Ǹ뤬Τ˼줿ԤϤʤ"))


(define (deric-band knpc kpc)
  (let ((quest (deric-bandit-quest (kobj-gob-data knpc))))
    (cond ((quest-done? quest) 
           (say knpc "䤬±Ƭ館ˤϡʾϵʤǤ"
                "󷯤Τ"
                "̿ΤϤλ"
                "γʧ"))
          ((quest-accepted? quest)
           (say knpc "οΤɤ±αȤ롣"
                "õ³뤳ȤƬˤϢƤΤ")
           )
          (else
           (say knpc "±ʹΤʡ"
                "ĤαȤϤοΤɤˤ롣"
                "äȰʤ䤬Ĥݤ˹Ԥ"
                "ΤäƤΤȤꡢϤʤ")
           (prompt-for-key)
           (say knpc
                "Ƥ졣ͦ"
                "⤷±Ƭ館Ϣ褿ʤ顢Ƿ˾޶Ϳ褦"
                "ɤ")
           (if (yes? kpc)
               (begin
                 (quest-accepted! quest #t)
                 (say knpc "Ф餷ˤϽɬפ\n"
                      "ϤʤʸϤ\n"
                      "̿ϡλش򷯤˰Ū˾ϤΤ"
                      "ΰ֤ͤ˲ä褦˸ޤ")
                 (give kpc t_ranger_orders 1)
                 (quest-data-update-with 'questentry-bandits 'talked-to-deric 1 (quest-notify nil))
                 )
               (say knpc "Τ褦٤ǤϡɸϷ褷ʤǤ")))
          )))
                       

(define deric-conv
  (ifc green-tower-conv
       (method 'abe        deric-abe)
       (method 'afra       deric-afraid)
       (method 'ambi       deric-ambition)
       (method 'aspi       deric-ambition)
       (method 'band       deric-band)
       (method 'brut       deric-brute)
       (method 'bye        deric-bye)
       (method 'comm       deric-rangers)
       (method 'default    deric-default)
       (method 'die        deric-ambition)
       (method 'gen        deric-gen)
       (method 'hail       deric-hail)
       (method 'haun       deric-haunted)
       (method 'heal       deric-health)
       (method 'job        deric-job)
       (method 'name       deric-name)
       (method 'nati       deric-native)
       (method 'pris       deric-prison)
       (method 'prom       deric-ambition)
       (method 'rang       deric-rangers)
       (method 'secr       deric-secret)
       (method 'shro       deric-shroom)
       (method 'skul       deric-brute)
       (method 'stor       deric-two)
       (method 'thie       deric-thie)
       (method 'towe       deric-tower)
       (method 'two        deric-two)
       (method 'gobl       deric-gobl)
))                

(define (mk-deric tag)
  (bind 
   (kern-mk-char tag                 ; tag
                 "ǥå"          ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_ranger_captain   ; sprite
                 faction-men         ; starting alignment
                 1 3 2               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 4  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'deric-conv        ; conv
                 sch_deric          ; sched
                 'townsman-ai        ;; special ai
                 nil                 ; container
                 (list  t_sword_2
					         t_armor_leather_2
					         t_leather_helm_2
					         )                  ; readied
                 )
   (deric-mk #f)))
