;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Ф
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_doris
               (list 0  0  doris-bed "sleeping")
               (list 8  0  white-stag-counter "working"))

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (doris-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ɥꥹФˤ򤭲νͤǤ롣
;;----------------------------------------------------------------------------
(define (doris-name kdoris kplayer)
  (say kdoris "ϥɥꥹ򤭲μͤ衣"))

(define (doris-default)
  (say kdoris "äԤäơĤɤ뤳ȤǤʤ"))

(define (doris-join kdoris kplayer)
  (say kdoris "ξФϤǤ衪ɤΤȤդ"))

(define (doris-doris knpc kpc)
  (say knpc "ΤȤ衣"))

(define (doris-trade knpc kpc)
  (let ((door (eval 'white-stag-door))
        (price 15))
    ;; is the room still open?
    (if (not (door-locked? (kobj-gob door)))
        ;; yes - remind player
        (say knpc "ХͤϤ⤦Ƥ"
             "ĮޤǽǤΤ衣")
        ;; no - ask if player needs a room
        (begin
          (say knpc "϶" price "硢ĮФޤǲ٤ǤǤޤ"
               "Ǥ")
          (if (kern-conv-get-yes-no? kpc)
              ;; yes - player agrees to the price
              (let ((gold (kern-player-get-gold)))
                ;; does player have enough gold?
                (if (>= gold price)
                    ;; yes - player has enough gold
                    (begin
                      (kern-player-set-gold (- gold price))
                      (say knpc "Τޤ¦ϭʤǤ"
                           "֤üκǽ衣")
                      (send-signal knpc door 'unlock)
                      (kern-conv-end)
                      )
                    ;; no - player does not have enouvh gold)
                    (say knpc "⤬­ʤ褦͡"
                         "­ޤǤΤ⤭äơï򻦤ƻΤ򤢤äƤƤϡ"
                         "ͦԤϳƤޤ衣"
                         "̥ŪФ")))
              ;; no - player does not want the room
              (say knpc "ǤϤޤεˡ"))))))

(define (doris-lodge knpc kpc)
  (say knpc "Ƥ衣ĤƤΤΤäɡŷ˾Ƥޤޤ"
       "ҤΤۤȤɤϤΤοͤιͤ衣"))

(define (doris-daddy knpc kpc)
  (say knpc "ϼ٤ǤνɤΩƤޤ㤬Ǥϻ䤬ѤΤǤ"))

(define (doris-local knpc kpc)
  (say knpc "ΤˤϡѤԤ̩Τꤽʿͤޤǿ"
       "ѤǤͭǽ򤤿ͤǤ⤢뤱ɡ"
       "ʤϡοãɤͧ⡢Ũ⸫Ĥ뤳ȤϤǤʤǤ礦͡"))

(define (doris-woodsman knpc kpc)
  (say knpc "͡ڤꡢμ褹ãϡΤƤ̤̤᤮ƹԤޤ"
       "ĮΤϼͷӤФޤޤ"
       "Ǥ⡢οƯԤ̤Ͽǥפޤ"
       "ΤϾࡢ񡢤ȤΤǤ"))

(define (doris-travelers knpc kpc)
  (say knpc "ʤΤ褦ʿͤ衣"))

(define (doris-gen knpc kpc)
  (say knpc "ΤΥ֥ΡΤǤߤʿͤ衣"
       "ڡδ֤ǤƤΤĤ뤫⤷ޤ͡Ϥ褯ߤƤޤ衣"))

(define (doris-deric knpc kpc)
  (say knpc "ǥåġġ񤨤Фɤʿͤ狼"
       "Ωɤɡնϰ̤˿䤹ĤϤʤ褦͡"))

(define (doris-shroom knpc kpc)
  (say knpc "ǡ֥ѤΤäƤȸԤ⤤ޤ"
       "ïµˤʤäȤˤʤΤ衣"
       "ˤ褯٤ޤ衣"))

(define (doris-abe knpc kpc)
  (say knpc "饹ɥγؼԤΤ褦͡פĴˤۤȤɤλ֤䤷Ƥ"
       "ܤߤʿͤ衣"))

(define (doris-abigail knpc kpc)
  (say knpc "ϸɻʤΡǻ䤬ܻҤˤΤ衣äȼʬλҶߤäɡ"
       "ǤʤäλҤξ褬԰¡ġ"
       "ˤϤλҤäΤϤǤʤ"))

(define (doris-goblins knpc kpc)
  (say knpc "Įοͤȸפ򤷤Ƥ"
       "餫㤤ޤ"
       "Ǥ⡢ϤĤⷲƤ뤫顢Į뤳ȤˡǶػߤƤΡ"
       "ΤۤȤɤϾ򤹤ڤ夲ơؤäƹԤ"))

(define (doris-orphaned knpc kpc)
  (say knpc "롼बΤȤˤλҤϢƤȤޤ֤ä"
       "ǸĤȤ¦ˤξƤϻǤȸäƤ"
       "ʤǤΤȤ⻦줿Τ롼ϲʤä"
       "⤷䤬ΤꤿʤΤ⤷ʤ"))

(define (doris-hail knpc kpc)
  (say knpc "򤭲ؤ褦"))

(define (doris-bye knpc kpc)
  (say knpc "ޤɤ"))

(define (doris-default knpc kpc)
  (say knpc "ɤ뤳ȤǤʤ"))

(define (doris-thie knpc kpc)
  (say knpc "ǶϲͤϸƤޤ󡣥ǥåĹʹƤ뤫Τޤ"
       "⳰ǲƤ뤫⤷ޤ͡"))

(define (doris-band knpc kpc)
  (say knpc "ιͤϤߤʺäƤ롪"
       "ǥåˤɤˤߤΤޤޤǤϾˤʤޤ"))

(define doris-conv
  (ifc green-tower-conv
       (method 'band      doris-band)
       (method 'hail      doris-hail)
       (method 'bye       doris-bye)
       (method 'default   doris-default)
       (method 'name      doris-name)
       (method 'room      doris-trade)
       (method 'defa      doris-default)
       (method 'job       doris-trade)
       (method 'join      doris-join)
       (method 'dori      doris-doris)
       (method 'buy       doris-trade)
       (method 'innk      doris-trade)
       (method 'whit      doris-lodge)
       (method 'stag      doris-lodge)
       (method 'lodg      doris-lodge)
       (method 'dadd      doris-daddy)
       (method 'loca      doris-local)
       (method 'wood      doris-woodsman)
       (method 'trav      doris-travelers)
       (method 'gen       doris-gen)
       (method 'deri      doris-deric)
       (method 'shro      doris-shroom)
       (method 'abe       doris-abe)
       (method 'abig      doris-abigail)
       (method 'orph      doris-orphaned)
       (method 'gobl      doris-goblins)
       (method 'thie      doris-thie)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-doris tag)
  (bind 
   (kern-mk-char tag                 ; tag
                 "ɥꥹ"            ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townswoman   ; sprite
                 faction-men         ; starting alignment
                 0 1 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 2  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'doris-conv         ; conv
                 sch_doris           ; sched
                 'townsman-ai        ; special ai
                 nil                 ; container
                 (list t_dagger)     ; readied
                 )
   (doris-mk)))
