;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ݥꥹ
;;----------------------------------------------------------------------------
(define doug-bed ke-bed1)
(define doug-mealplace ke-tbl1)
(define doug-workplace ke-hall)
(define doug-leisureplace ke-dine)
(kern-mk-sched 'sch_doug
               (list 0  0 doug-bed          "sleeping")
               (list 11 0 doug-mealplace    "eating")
               (list 12 0 doug-workplace    "working")
               (list 18 0 doug-mealplace    "eating")
               (list 19 0 doug-leisureplace "idle")
               (list 24 0 doug-workplace    "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (doug-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 饹ϥݥꥹϤλشǡ֥βγΥݥ
;; ˿ؤ֤Ƥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (doug-hail knpc kpc)
  (say knpc "ΤʤϸĤΤȲäϹؤ褦ιͤ衣")
  (if (and (in-player-party? 'ch_mesmeme)
           (is-alive? ch_mesmeme))
      (begin
        (say knpc "ϥ᥹򸫤Ϥµܤ館Τ")
        (if (yes? kpc)
            (say knpc "軰ؤΤκ֤βˤ롣"
                 "ƽˤ줬Ȥϻפʤ"
                 "Ĥ᤯ۤ褤")
            (say knpc "ʤ˻ʤ餵줿ΤϸȤʤ΢ڤ˵Ĥ")))))

(define (doug-default knpc kpc)
  (say knpc "Ϥ狼"))

(define (doug-name knpc kpc)
  (say knpc "ϥ饹ĹΥݥꥹϤλش"))

(define (doug-join knpc kpc)
  (say knpc "ƤȡΤ褦ʹͤϤʤˤ⤽Τ褦ʤȤҤͤʡʤϾؤФ"))

(define (doug-job knpc kpc)
  (say knpc "ϤǻشƤ롣"))

(define (doug-bye knpc kpc)
  (say knpc "˹ԤȤϵĤ"))

;; Special
(define (doug-garr knpc kpc)
  (say knpc "饹ɥϥݥꥹβʪ򲡤뤿ᡢϤ֤Ƥ롣βˤϤ롣"))

(define (doug-mons knpc kpc)
  (say knpc "ؤˤΤϡۤȤɤ֥ȥȥȤǤǰμԤ뤳Ȥ롣"))

(define (doug-gobl knpc kpc)
  (say knpc "ƶ֥󤬤ؤۤƤ롣ۤ϶˽"
       "ƶˤ̤ϴǤϤʤ֥⤤롣"
       "ƶΥ֥礬줬桹λۤνˤʤäƤ롣"))

(define (doug-trol knpc kpc)
  (say knpc "֥¼θ¦ˤϢ"
       "ٰݤƤ⡢˸̤ˤʤ롣"
       "ޤǴ䤫ޤƤ뤫Τ褦"))

(define (doug-wors knpc kpc)
  (say knpc "䤬äǺǰΤΡۤϴͤäƤ롣ˤΤ⤤롣פФ衣Ͽ̤ʤؤ")
  (kern-conv-end)
  )

(define (doug-kurp knpc kpc)
  (say knpc "ݥꥹϲʪɤޤϤۤݤ뤳ȤϤǤ̤桹ϤȤʤ뤳ȤϤǤ롣"))

(define (doug-seco knpc kpc)
  (say knpc "ϤؤϡθؿʤߡϤ򲼤йԤ롣"))

(define (doug-gaze knpc kpc)
  (say knpc "ϰ̴ޤ줿褦ʲʪĹԤ¾ʪˤʬ碌ǽϤ롣"))

(define doug-conv
  (ifc kurpolis-conv

       ;; basics
       (method 'default doug-default)
       (method 'hail doug-hail)
       (method 'bye doug-bye)
       (method 'job doug-job)
       (method 'name doug-name)
       (method 'join doug-join)

       (method 'garr doug-garr)
       (method 'mons doug-mons)
       (method 'gobl doug-gobl)
       (method 'trol doug-trol)
       (method 'wors doug-wors)
       (method 'kurp doug-kurp)
       (method 'hell doug-kurp)
       (method 'door doug-kurp)
       (method 'seco doug-seco)
       (method 'gaze doug-gaze)
       ))

(define (mk-douglas)
  (bind 
   (kern-mk-char 'ch_douglas        ; tag
                 "饹"          ; name
                 sp_human            ; species
                 oc_warrior          ; occ
                 s_companion_paladin ; sprite
                 faction-men         ; starting alignment
                 2 2 1               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 4  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'doug-conv         ; conv
                 sch_doug           ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
                 (list t_armor_chain
                       t_chain_coif
                       t_sword
                       ))         ; readied
   (doug-mk)))
