;;----------------------------------------------------------------------------
;; Schedule
;;
;; ȥꥰ쥤
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_earl
               (list 0  0  trigrave-earls-bed        "sleeping")
               (list 5  0  trigrave-tavern-table-3a  "eating")
               (list 6  0  trigrave-earls-counter    "working")
               (list 12 0  trigrave-tavern-table-3a  "eating")
               (list 13 0  trigrave-earls-counter    "working")
               (list 18 0  trigrave-tavern-table-3a  "eating")
               (list 19 0  trigrave-tavern-hall      "idle")
               (list 20 0  trigrave-earls-room       "idle")
               (list 21 0  trigrave-earls-bed        "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (earl-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ŹǡŻ򤷤Ƥ֤ʤмǤ롣
;;----------------------------------------------------------------------------
(define earl-merch-msgs
  (list "ƤȤŹȤ졣ξʪγѤˤäơ66ޤǤäƤ롣"
        "֤Ƥʪ򸫤Ƥ"
        "ꤿʪ򸫤Ȥ졣"
        "äƸƤ졣"
        "ŹäΤͧã˸äȤƤ졣"
        "ޤ䡣"
        "֤ȤƸǤ줤ˤ衣"
        "ꤿʪäޤȤ졣"
        "⤦Τޤˤʤ衣"
        "ޤääȤ졣"
   ))

(define earl-catalog
  (list
   (list t_torch               5 "µܤαǾڤ餻ʤ")
   (list t_sling              50 "ɳƤ㤤ʤۤˤԤä")
   (list t_staff              25 "ΤʤˡȤʤʤߤʤ")
   
   (list t_heal_potion        22 "ѤȤƤ󤤤Ϥ")
   (list t_cure_potion        22 "̤ظӤ˹ԤȤϤĤäƤۤ")
   (list t_mana_potion        22 "ϤȤ̤ƵٷƤǤʤȤϤ")
   
   (list t_arrow               1 "ݤäƤС¿ȤȤϤʤ")
   (list t_bolt                1 "Τǰְ¤ܥ")
   (list t_smoke_bomb          3 "αƤŨμͼꤲСϤ餬ʤʤ")
   
   (list t_shovel             50 "줿򸫤Ĥ餳Υ٥뤬")
   (list t_pick               50 "ĤϤƻɤˤФɬפ")
   
   (list t_sextant           500 "䴬ʪʤǹǤε꤬狼롣")
   (list t_chrono            300 "ξʻפСפʤǤ郎狼롣")
   (list t_grease             23 "ʤ餺ԤϤ줬ʤʹʡ")
   ))

(define (earl-trade knpc kpc) (conv-trade knpc kpc "trade" earl-merch-msgs earl-catalog))

(define earl-conv
  (ifc trigrave-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default (lambda (knpc kpc) (say knpc "˺줿ʤ")))
       (method 'hail (lambda (knpc kpc) (say knpc "ä㤤Τ")))
       (method 'bye (lambda (knpc kpc) (say knpc "󤿤äƤä")))
       (method 'job (lambda (knpc kpc) (say knpc "ŹäƤ롣뤫")
                            (if (kern-conv-get-yes-no? kpc)
                                (earl-trade knpc kpc)
                                (say knpc ""))))
       (method 'name (lambda (knpc kpc) (say knpc "ϤФ餯ͤϥ롪")))
       (method 'buy (lambda (knpc kpc) (conv-trade knpc kpc "buy"  earl-merch-msgs earl-catalog)))
       (method 'sell (lambda (knpc kpc) (conv-trade knpc kpc "sell"  earl-merch-msgs earl-catalog)))
       (method 'trad earl-trade)
       (method 'join (lambda (knpc kpc) (say knpc "٤衪ʸϤߤ˺ޤä")))

       (method 'batt
               (lambda (knpc kpc)
                 (say knpc "ϥ󲦤Ȱ˥֥ɤηäΤ")))
       (method 'calv
               (lambda (knpc kpc)
                 (say knpc "ĤƤ𾭡"
                      "ϳγ̤üޤƤ")))
       (method 'hord
               (lambda (knpc kpc)
                 (say knpc "Τ֥ɤϰͤμĹβǷ«Ƥ"
                      "ơȾ˽Ƥ"
                      "󲦤ĤݤƤϥХХˤʤꡢ֤˱褦ˤʤä"
                      "ˤˤϻĤäƤʤʡ")))
       (method 'mage
               (lambda (knpc kpc)
                 (say knpc "ˡϤߤ˺줿ʤ"
                      "ΤϷݤݤʸΤäƤ")))
       (method 'spel
               (lambda (knpc kpc) 
                 (say knpc "ˡȤȤäƤ衣Τ")))
       (method 'thie
               (lambda (knpc kpc)
                 (say knpc "ĤƨƤä䡢ġáפФͤ")))
       ))
