;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define edward-start-lvl 4)

;;----------------------------------------------------------------------------
;; Schedule
;;
;; Фϲ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_edward
               (list 0  0  gtl-jailor-bed "sleeping")
               (list 7  0  gtl-jail       "working" )
               (list 21 0  gtl-jailor-bed "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (edward-mk) (list #f #f))
(define (edward-met? gob) (car gob))
(define (edward-meet! gob) (set-car! gob #t))
(define (edward-has-nate? gob) (cadr gob))
(define (edward-has-nate! gob) (set-car! (cdr gob) #t))

;;----------------------------------------------------------------------------
;; Conv
;;
;; ɥɤܤϷͤǡФϲǴǼλŻ򤷤Ƥ롣
;;----------------------------------------------------------------------------
(define (edward-hail knpc kpc)
  (meet "ʤϿܤäϷͤȲä")
  (let ((edward (kobj-gob-data knpc)))
    (cond ((not (edward-met? edward))
           (say knpc "ïΤ̾졪")
           (reply? kpc)
           (edward-meet! edward)
           (say knpc "ΤʤĤæΤ")
           (if (yes? kpc)
               (say knpc "äȹԤ󤿤ߤˤǯꤹƤ롣")
               (say knpc "¿ïä꤬ʤΤǤ͡")
               )
           )
          (else
           (say knpc "ޤ褿͡­Ǥ狼ä衣")
           ))))

(define (edward-give-nate knpc kpc)
  (say knpc "ͤϢƤΤ")
  (cond ((yes? kpc)
         (cond ((is-only-living-party-member? ch_nate)
                (say knpc "⤷ʤ顢󤷤ʤ"
                     "λΤ򲿤ȤƤ"
                     "ϻ֤ǤϤʤ")
                )
               (else
                (say knpc "֤襤ϥͥȤꡢ˼츰򤫤")
                (kern-char-leave-player ch_nate)
                (kern-obj-relocate ch_nate (mk-loc p_green_tower_lower 9 10) nil)
                (prompt-for-key)
                (say knpc "줬ĹϤʤ")
                (give (kern-get-player) t_prisoner_receipt 1)
                (edward-has-nate! (kobj-gob-data knpc))
                (quest-data-update-with 'questentry-bandits 'nate-given-to-jailor 1 (quest-notify nil))                
                )))
        (else
         (say knpc "ϥͥȤ򤹤᤿")
         )))

(define (edward-pris knpc kpc)
  (cond ((in-player-party? 'ch_nate) (edward-give-nate knpc kpc))
        (else
         (let ((edward (kobj-gob-data knpc)))
           (if (edward-has-nate? edward)
               (say knpc "Ͽ֥ȡ󤿤ϢƤۤ롣")
               (say knpc "ǶΌ֥ä"
                    "ĤȤϸߤ򤷤ʤȤää򤷤ʤ櫓ǤϤʤ"))))
        ))

(define (edward-gobl knpc kpc)
  (say knpc "ȤϤʤĤϴäʤ"))

(define (edward-stor knpc kpc)
  (say knpc "ˤĤʹȤ뤫")
  (cond ((no? kpc)
         (say knpc "ϤĤƤο˸줿"
              "礬ƤΤΤȤ")
         (prompt-for-key kpc)
         (say knpc "ο˰ͤ¤Ȥ"
              "ϴΩΤ褤ͤȤƻѤ򸽤"
              "̼ϿαؤͶޤ졢ĤڤˤʤäƤޤä")
         (prompt-for-key kpc)
         (say knpc "줬ιολϤޤ"
              "ƺǤ¿ͩΤ褦ڡͳ")
         )
        (else
         (say knpc "ȤϲʤΤïΤʤ"
              "¾οƱ褦")
         )))

(define (edward-gate knpc kpc)
  (say knpc "ΤȤϤ狼ʤĤƤϤäΤäƤΤϤ"))

(define (edward-gods knpc kpc)
  (say knpc "Ťä򤹤ΤϤ褯ʤ"
       "ʹȼȸƤ롣"))

(define (edward-accu knpc kpc)
  (say knpc "Ťμ줿ϡġ"
       "ϴˤ⤽Ϥ롣"))

(define (edward-talk knpc kpc)
  (say knpc "Ǥϼͤä꤬ʤ"))

(define (edward-blin knpc kpc)
  (say knpc "ŰǤϲǤʤ˸иⲿǤʤ"
       "ɤƱȤ"))

(define (edward-guar knpc kpc)
  (say knpc "ľ˸ȡޤȤϻפʤ"))

(define (edward-jail knpc kpc)
  (cond ((in-player-party? 'ch_nate) (edward-give-nate knpc kpc))
        (else
         (say knpc "ͤ˿Ϳä򤹤롣"
              "Ĥ餬ƨΤɤܤ⤢롣")
         )))

(define edward-conv
  (ifc ranger-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default 
               (lambda (knpc kpc) 
                 (say knpc "ϸ򤹤᤿")))
       (method 'hail edward-hail)
       (method 'bye 
               (lambda (knpc kpc) 
                 (say knpc "Ť鵤Ĥơ")))
       (method 'job 
               (lambda (knpc kpc) 
                 (say knpc "Ǽ")))
       (method 'name 
               (lambda (knpc kpc) 
                 (say knpc "ɥɤ󤿤̾ʹƤ롣")))
       (method 'join 
               (lambda (knpc kpc) 
                 (say knpc "͡ΤǤʤ")))
       (method 'accu edward-accu)
       (method 'blin edward-blin)
       (method 'esca edward-guar)
       (method 'gate edward-gate)
       (method 'gobl edward-gobl)
       (method 'god  edward-gods)
       (method 'gods edward-gods)
       (method 'guar edward-guar)
       (method 'jail edward-jail)
       (method 'old  edward-gods)
       (method 'pris edward-pris)
       (method 'stor edward-stor)
       (method 'talk edward-talk)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-edward)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     'ch_edward ;;..........tag
     "ɥ" ;;.......name
     sp_human ;;.....species
     oc_ranger ;;.. .occupation
     s_old_townsman ;;..sprite
     faction-men ;;..faction
     0 ;;...........custom strength modifier
     0 ;;...........custom intelligence modifier
     0 ;;...........custom dexterity modifier
     0 ;;............custom base hp modifier
     0 ;;............custom hp multiplier (per-level)
     0 ;;............custom base mp modifier
     0 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     edward-start-lvl  ;;..current level
     #f ;;...........dead?
     'edward-conv ;;...conversation (optional)
     sch_edward ;;.....schedule (optional)
     'townsman-ai ;;..........custom ai (optional)

     ;;..............container (and contents)
     (mk-inventory
      (list
       (list 1 t_torch)
       (list 1 t_dagger)
       ))
     (list t_armor_leather)                ; readied ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (edward-mk)))
