;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define enchanter-start-lvl 8)

;;----------------------------------------------------------------------------
;; Schedule
;;
;; ƻդ1
;; 
;; (ϼʬ2ˬ뤳ȤϤʤϻ䤿ʣξΥ
;; 򤤤ϺʤФʤʤȻפ碌ưդˤʤäƤ :-)
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_enchanter
               (list 0  0  enchtwr-ench-bed        "sleeping")
               (list 8  0  enchtwr-dining-room-2   "eating")
               (list 9  0  enchtwr-hall            "idle")
               (list 12 0  enchtwr-dining-room-2   "eating")
               (list 13 0  enchtwr-hall            "idle")
               (list 19 0  enchtwr-dining-room-2   "eating")
               (list 20 0  enchtwr-bedroom-1       "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (enchanter-mk)
  (list #f 
        (mk-quest) ;; get stolen rune
        (mk-quest) ;; learn the purpose of the runes
        (mk-quest) ;; get all runes
        (mk-quest) ;; open demon gate
        ))
(define (ench-met? gob) (car gob))
(define (ench-first-quest gob) (cadr gob))
(define (ench-second-quest gob) (caddr gob))
(define (ench-quest gob n) (list-ref gob n))
(define (ench-met! gob val) (set-car! gob val))

;;----------------------------------------------------------------------------
;; Conv
;;
;; ƻդϤΤѻդǡԤΰͤǤ롣
;; ƻդ˽Ǥ롣
;; ϼפ¿ǽפ餸롣
;;----------------------------------------------------------------------------
(define (ench-hail knpc kpc)
  (let ((ench (gob knpc)))

    ;; Fourth Quest -- open the demon gate
    (define (check-fourth-quest)
      (say knpc "ξϤ狼ä")
      (if (yes? kpc)
          (begin
            (say knpc "ʤǤθǳϸĤä")
            (if (yes? kpc)
                (say knpc "ʤΤˤΤ򤦤Ĥƻ̵֤̤ˤƤΤ")
                (say knpc "϶餯κŤΤ褦ʤΤǤ"
                     "ϱ졢⤷ȰŹǻѤ򸽤⤷ʤ"
                     "줿ԤõĴ٤衣ϼ꤬ΤäƤ˰㤤ʤ")))
          (say knpc "֥åȤο޽ۤ褯õΤ")))

    ;; Third Quest -- find all the Runes
    (define (finish-third-quest)
      (say knpc "ǤƸĤΤʡ"
           "ࡢξʤäǤ")
      (prompt-for-key)
      (say knpc "ǸǤ̳"
           "õФƤӳͤФʤʤ"
           "Ϥ狼äƤ뤫")
      (if (yes? kpc)
          (say knpc "򤬲ľ̤뤫Ϥ狼̡"
               "ȤǤ褯衣"
               "֤ˤʤۤɤζ򤫼ԤϢƤ椱")
          (say knpc "줿ԤΤäƤ˰㤤ʤ"
               "֥åȤο޽ۤˤϤޤ꤬꤬ĤäƤ뤫Τ̡"
               "褯Ĵ٤Τ")
          )
      (quest-done! (ench-quest ench 3) #t)
      (kern-char-add-experience kpc 100)
      (quest-accepted! (ench-quest ench 4) #t)      
      )

    (define (check-third-quest)
	(define (missing-only-s-rune?)
		(all-in-inventory? kpc
                         (filter (lambda (ktype)
                                   (not (eqv? ktype t_rune_s)))
                                 rune-types)))
	(cond			 
		((has-all-runes? kpc)
		(finish-third-quest)
		)
		
		((missing-only-s-rune? kpc)
		(say knpc "ۤȤɤǤ򸫤Ĥ褦ʡ")
		(prompt-for-key)
		(say knpc "ġ")
		(prompt-for-key)
		(say knpc "ΤȤΤƤǽϤʤǤǤ")
		(prompt-for-key)
		(say knpc "줿ԤޤǤõƤ롣μˤϤäĤʤȤ򹬱˻פͤФʤޤ")
		(prompt-for-key)
		(say knpc "Ũ濴ϡ֥åȤҤĴ٤ͤФʤ̤Ǥ")
		(quest-data-assign-once 'questentry-rune-s)
		)
		
		(else
		(say knpc "ƤǤ򸫤Ĥä褿ޤ"
		     "¾θԤ˽衣Ǥξμ꤬äƤ뤫Τ̡")
		)
	)
    )

    ;; Second Quest -- find out what the Runes are for
    (define (second-quest-spurned)
      (say knpc "ϰΩʤԤε̳Ǥ롣"
           "ƤФ䤹֤ϤʤǤϤʤ"
           "󽷤äФƹԤޤ")
      (kern-obj-remove-from-inventory kpc t_rune_k 1)
      (kern-obj-add-to-inventory knpc t_rune_k 1)
      (quest-accepted! (ench-second-quest ench) #f)
      (kern-conv-end))

    (define (start-second-quest)
      (quest-accepted! (ench-second-quest ench) #t)
      (say knpc "˻ǤƼΤ")
      (quest-data-update 'questentry-rune-k 'entrusted-with-rune 1)
      (prompt-for-key)
      (say knpc "ˡ¾θԤȲ񤤡ǤˤĤƿҤͤΤ"
           "ѡˤϣѻդϤΤ褤"
           "ߤʼԤ"
           "Ȥ˿䤷Ƥ롣")
      (quest-data-assign-once 'questentry-runeinfo)
      (quest-wise-subinit 'questentry-alchemist)
      (quest-wise-init)
      (kern-conv-end)
      )

    (define (offer-second-quest-again)
      (say knpc "äƤʡɿդ򴶤Τ⤷̤ʡ"
           "ϲ桹ˤȤäƺǤⰭȤ"
           "ơ줿ԤϤǤ")
      (if (kern-conv-get-yes-no? kpc)
          (begin
            (kern-obj-remove-from-inventory knpc t_rune_k 1)
            (kern-obj-add-to-inventory kpc t_rune_k 1)
            (start-second-quest))
          (begin
            (say knpc "ޤǱ¤˸ڤΤ褦"
                 "Ԥϼζ򤫤˵롣"
                 "ߤ˵뤬褤")
            (kern-conv-end)))
      )
    
    (define (finish-second-quest)
      (say knpc "ϽšͻҤ"
           "ĤޤǤϰȬĤθΰĤʤΤʡ"
           "ϻĤõͤФʤ̡"
           "줿Ԥϲ桹ԤäƤ롣"
           "ĤǤƤΤϵ;Ϥʤ"
           "ƤǤ򸫤Ĥ顢θäƤߤ")
      (quest-done! (ench-second-quest ench) #t)
      (quest-data-update 'questentry-runeinfo 'abe 1)
      (quest-data-update 'questentry-runeinfo 'keys 1)
      (quest-data-update 'questentry-runeinfo 'gate 1)
      (quest-data-update 'questentry-rune-k 'entrusted-with-rune 1)
      (quest-data-update-with 'questentry-runeinfo 'done 1 (grant-party-xp-fn 30))
      (quest-data-complete 'questentry-runeinfo)
      ;; temporary setup- will require information gathering first when done
      (prompt-for-key)
      (quest-data-assign-once 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-k 'questentry-allrunes)
      (quest-data-assign-once 'questentry-rune-k)
      (quest-data-convert-subquest 'questentry-rune-c 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-d 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-l 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-p 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-s 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-w 'questentry-allrunes)
      (quest-data-convert-subquest 'questentry-rune-f 'questentry-allrunes)
      (quest-accepted! (ench-quest ench 3) #t)
      )

    (define (check-second-quest)
      (say knpc "ǤΤȤϤ狼ä͡")
      (if (yes? kpc)
          (begin
            (say knpc "ࡢϲ")
            (let ((reply (kern-conv-get-string kpc)))
              (if (or (string=? reply "demon") (string=? reply "gate") (string=? reply "key") (string=? reply "") (string=? reply "") (string=? reply ""))
                  (finish-second-quest)
                  (begin
                    (say knpc "Ϥϻפ̡ƤθԤ^c+m^c-ˤĤƿҤͤ")
                    (if (yes? kpc)
                        (say knpc "ʤФΤΰ꤬ͤͿϤ")
                        (say knpc "ƤõΤ"))))))
          (say knpc "ƤθԤ^c+m^c-ΤȤҤͤΤ")))

    ;; First Quest -- find the stolen Rune
    (define (finish-first-quest)
      (say knpc "Ĥ˻Ǥ򸫤Ĥ褦ʡ")
      (kern-obj-add-gold kpc 200)
		(quest-data-update-with 'questentry-thiefrune 'done 1 (grant-party-xp-fn 20))
		(quest-data-complete 'questentry-thiefrune)
      (say knpc "ΩĤ褦ʡ"
           "Ρġ񹳤˲äʡ")
      (kern-conv-get-yes-no? kpc)
      (say knpc "ťθˤϼ줿Ԥ롣"
           "ǤʤΤĴ٤ͤФʤ̡"
           "ߤƤ뤫")
      (quest-offered! (ench-second-quest ench) #t)
      (if (kern-conv-get-yes-no? kpc)
          (start-second-quest)
          (second-quest-spurned)))

    (define (check-first-quest)
      (if (in-inventory? kpc t_rune_k)
          (finish-first-quest)
          (say knpc "ࡣޤΤ򸫤ĤƤ̤褦ʡ"
               "¤֤ͤ򸫤ˤĤ֤䤤")
            ))
    
    ;; Main
    (if (ench-met? ench)
        (if (quest-done? (ench-quest ench 4))
            (say knpc "褦Ԥͧ衣")
            (if (quest-accepted? (ench-quest ench 4))
                (check-fourth-quest)
                (if (quest-accepted? (ench-quest ench 3))
                    (check-third-quest)
                    (if (quest-offered? (ench-second-quest ench))
                        (if (quest-accepted? (ench-second-quest ench))
                            (check-second-quest)
                            (offer-second-quest-again))
                        (if (quest-accepted? (ench-first-quest ench))
                            (check-first-quest)
                            (say knpc "ࡣ٤ϲ"))))))
        (begin
          (quest-data-update-with 'questentry-calltoarms 'talked 1 (quest-notify (grant-xp-fn 10)))
          (kern-log-msg "ǯϷ뤳ȤʤΤ褦ѻդϡʤ򸫤Ƥäʤä")
          (say knpc "褯줿"
               "ԤäƤä")
          (ench-met! ench #t)))))

(define (ench-name knpc kpc)
  (say knpc "ƻդȤΤƤ롣"))

(define (ench-job knpc kpc)
  (say knpc "ǽʸ¤갭臘Ȥ뤳ȤǤ롣"))

(define (ench-default knpc kpc)
  (say knpc "Ͻ̡"))

(define (ench-bye knpc kpc)
  (say knpc "줿Ԥ˵Ĥ衪"))

(define (ench-join knpc kpc)
  (say knpc "ݡΤ٤Ǥ롣"
       "֤ʤ顢ƮΤõΤ褤"))


(define (ench-warr knpc kpc)
  (say knpc "ƮΤϹӡԤǤ롣"
       "Τ褦ϲƤ롣"
       "ºݤΤȤɤΤΤ̡"
       "饹ɥʹФ褫")
       (quest-wise-subinit 'questentry-warritrix)
       (quest-data-update 'questentry-warritrix 'general-loc 1)
       )

(define (ench-wand knpc kpc)
  (say knpc "ꡣĤƲäȤ롣ͽ̤ȤǤä"
       "Ȥʤ뤫Ȥʤ뤫ϡ򤷤Ǥ롣"))

(define (ench-offer-first-quest knpc kpc)
  (say knpc "ȤϡȤϲ򤴤ޤϤʤ"
       "Ͻв񤨤ưפ˶̤Ǥ롣"
       "ϤϤԤʤĤ꤫")
  (if (kern-conv-get-yes-no? kpc)
      ;; yes - player intends to do good
      (begin
        (say knpc "ʤϤȤʤ"
             "Ĥ衪¿ĥԤϡºݤˤϤǤʤ"
             "ƻæ롣ˤϻи礬뤫")
        (if (kern-conv-get-yes-no? kpc)
            ;; yes - player is ready to be tested
            (begin
              (say knpc "ǶᤢΤޤ줿"
                   "ť򸫤ĤФ᤹Ԥ򸫤ĤͤФʤʤäΤ"
                   "뤫")
              (if (kern-conv-get-yes-no? kpc)
                  ;; yes -- player is willing
                  (begin
                    (say knpc "ťɤäƥȥꥰ쥤֤ؤȸä"
                         "عԤ^c+mť^c-ˤĤƿҤͤȤ褤")
							(quest-data-assign-once 'questentry-thiefrune)
              		(quest-data-complete 'questentry-calltoarms)
                  	;; if you dont read the letter, you might not get the quest till now!
              		(quest-data-assign-once 'questentry-calltoarms)
                  	(quest-data-update-with 'questentry-calltoarms 'done 1 (grant-xp-fn 10))
                    (quest-accepted! (ench-first-quest (gob knpc)) #t)
                    )
                  ;; no -- player is not willing
                  (say knpc "򸫸ä⤷̡")))
            ;; no -- player is not ready
            (say knpc "ʤȤˤĤäǤԽʬǤ롣"
                 "ʤȤʤˡˤʤ뤳ȤϤǤ̡")))
      ;; no -- player does not intend to do good
      (say knpc "狼äԤ򤽤ΰ̣狼餺ʤȤǤ롣"
           "øʼԤϤɿ̵Ǥ̤Ȥ˵Ť")))

(define (ench-good knpc kpc)
  (if (quest-accepted? (ench-first-quest (gob knpc)))
      (say knpc "ɤԤʤƨΤǤ롣"
           "εΤȤ")
      (ench-offer-first-quest knpc kpc)))

(define (ench-gate knpc kpc)
  (say knpc "ϤˤϷȶ˸¾ȤĤʤä¿礬롣"
       "ŤϰĤʤ䤬ΤäƤμ¤ʤȤϡ̤ȤĤʤäƤȤȤ"))

(define (ench-wise knpc kpc)
  (say knpc "ԤϤϤǺǤϤΤΡѻա͡Ƥʤ餺ԤǤ롣"
       "ܤϥɤ뤳ȤǤˤ⤫餺ƤԤǤ櫓ǤϤʤ"))

(define (ench-accu knpc kpc)
  (say knpc "줿ԤϰνĤǡ¿ȺȻĵԹ԰٤˴ؤäƤ롣"
       "֥åȤϽᤷϤä"
       "ä"
       "Ϥ궯ˤʤäƤ뤳Ȥ򶲤Ƥ롣"))

(define (ench-moon knpc kpc)
  (say knpc "ΤȤϥ륷ե˿Ҥͤ衣"
       "Ϥ褯ΤäƤ롣"))

(define (ench-shri knpc kpc)
  (say knpc "ŤϤĳΤͽ¬ǤʤƳΤϾδ֤"
       "äΤϷ褷äƤʤ"
       "Τ褦¤ͤѤ򸽤Ȥ롣"))

(define (ench-rune knpc kpc)
  (say knpc "Ǥϱλվäʪ"
       "վϤ줬Τˤ뤫ΤʤäĴ٤Ū狼ʤä"
       "ϽפǤϤʤʪȻפäƤ"
       "ʤܤˤˤϤ˴ؤ뵭ҤʤΤ"))

(define (ench-wiza knpc kpc)
  (say knpc "Ρ͡ʤ餺ԤϤϤߤʿμΤǤ롣"
       "ѻդϤΤǤ롣"))

(define (ench-know knpc kpc)
  (say knpc "ܤθ̼ԤϿ򤹤뤳ȤϤǤʤ褦ˡ"
       "ʤܤΤʤԤѤϤ򤹤뤳ȤϤǤ̡"
       "ܤ򳫤Ԥϡܤ˸̸ȷ̤򤹤뤳ȤǤ褦"))

(define (ench-wrog knpc kpc)
  (say knpc "Ǥ⸭ʤ餺ԤϤˤ󤲤ǡ˿ᤫƹԤꤷƤ롣"
       "ˤ󤲤˵٤꤬ȤСϹ̯˱Ƥ"
       "μԤ˿Ҥͤ衣ߤԤȤϴ˲äƤ뤫Τ̡")
       (quest-wise-subinit 'questentry-the-man)
       (quest-data-update 'questentry-the-man 'common 1)
       )

(define (ench-wrig knpc kpc)
  (say knpc "Ǥ⸭ͤϸȤ򹥤ࡣ"
       "򸫤Ĥ뤳ȤǤ褦ĮǤϤʤ"
       "ѻդΥ륷եõϵդΤȤ褯ΤäƤ롣")
       (quest-wise-subinit 'questentry-engineer)
       (quest-data-update 'questentry-engineer 'kalcifax 1)
       )

(define (ench-necr knpc kpc)
  (say knpc "ƤθԤǺǤٰʼԤ"
       "郎ŨѻդϲǤ롣"
       "϶ǡԤ줿Ԥ")
       (quest-wise-subinit 'questentry-necromancer)
       (quest-data-update 'questentry-necromancer 'general-loc 1)
      )

(define (ench-alch knpc kpc)
  (say knpc "ϣѻդϥѡˤ롣"
       "߿ȤƤѤˤϵĤͤФʤ̡")
       (quest-wise-subinit 'questentry-alchemist)
       (quest-data-update 'questentry-alchemist 'oparine 1)
       )

(define (ench-thie knpc kpc)
	;;in case quest generated once in progress
	(quest-data-assign-once 'questentry-thiefrune)
  (if (quest-done? (ench-first-quest (gob knpc)))
      (say knpc "ǤʤΤñʤԤǤ"
           "򤢤ޤ˸ʤȤ˾ࡣ")
      (say knpc "Τť˹ߤǤ"
           "ϥȥꥰ쥤֤Ǹä"
           "äԤ^c+mť^c-ˤĤƿҤͤ衣")))

(define (ench-kalc knpc kpc)
  (say knpc "륷եǰεϤ狼ʤ"))

(define (ench-demo knpc kpc)
  (say knpc "ϸŤѻդ̤ؤϤ뤿˻ȤäȤ"
       "θ͡ʸ롣ϼ줿줿˺줿˲줿ʤɤ"
       "ϤäȺäȹͤƤ"))

(define (ench-ench knpc kpc)
  (say knpc ""))

(define enchanter-conv
  (ifc basic-conv
       (method 'default ench-default)
       (method 'hail ench-hail)
       (method 'name ench-name)
       (method 'bye ench-bye)
       (method 'job ench-job)
       (method 'join ench-join)
       
       (method 'ench ench-ench)
       (method 'accu ench-accu)
       (method 'alch ench-alch)
       (method 'evil ench-good)
       (method 'gate ench-gate)
       (method 'good ench-good)
       (method 'know ench-know)
       (method 'moon ench-moon)
       (method 'necr ench-necr)
       (method 'rune ench-rune)
       (method 'shri ench-shri)
       (method 'thie ench-thie)
       (method 'wand ench-wand)
       (method 'warr ench-warr)
       (method 'wise ench-wise)
       (method 'wiza ench-wiza)
       (method 'wrog ench-wrog)
       (method 'wrig ench-wrig)
       (method 'emgi ench-wrig)
       (method 'kalc ench-kalc)
       (method 'demo ench-demo)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-enchanter-first-time tag)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     tag ;;..........tag
     "ƻ" ;;.......name
     sp_human ;;.....species
     oc_wizard ;;.. .occupation
     s_old_mage ;;..sprite
     ;;(mk-composite-sprite (list s_hum_body s_hum_belt s_hum_beard))
     faction-men ;;..faction
     0 ;;...........custom strength modifier
     7 ;;...........custom intelligence modifier
     0 ;;...........custom dexterity modifier
     10 ;;............custom base hp modifier
     2 ;;............custom hp multiplier (per-level)
     20 ;;............custom base mp modifier
     5 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     enchanter-start-lvl  ;;..current level
     #f ;;...........dead?
     'enchanter-conv ;;...conversation (optional)
     sch_enchanter ;;.....schedule (optional)
     'townsman-ai ;;..........custom ai (optional)
     ;;..............container (and contents)
     (mk-inventory
      (list
       (list 10  t_food)
       (list 100 t_arrow)
       (list 1   t_bow)
       (list 1   t_dagger)
       (list 1   t_sword)
       (list 1   t_leather_helm)
       (list 1   t_armor_leather)
       (list 5   t_torch)
       (list 5   t_cure_potion)
       (list 5   t_heal_potion)
       ))
     nil ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (enchanter-mk)))
