;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define engineer-start-lvl 8)

(define voidship-parts
  (list 
  	(list t_power_core 1)
	(list sulphorous_ash 20)
	(list t_gem 10)
  ))

(define voidship-loc (mk-loc 'p_shard 50 3))

;;----------------------------------------------------------------------------
;; Schedule
;;
;; դξ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_engineer
               (list 0  0  eng-workshop   "working")
               (list 1  0  eng-bed        "sleeping")
               (list 10 0  eng-workshop   "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (engineer-mk)
  (list #f 
        (mk-quest)))
(define (eng-met? gob) (car gob))
(define (eng-quest gob) (cadr gob))
(define (eng-met! gob val) (set-car! gob val))

;; ----------------------------------------------------------------------------
;; Voidship plans
;; ----------------------------------------------------------------------------
(mk-reusable-item 
 't_voidship_plans "ײ" s_lexicon norm
 (lambda (klexicon kuser)
   (kern-ui-page-text
   "ײ"
   "ʰ:"
   "βγ (20)"
   " (10)"
   "ϧ (1)"
   )))

;;----------------------------------------------------------------------------
;; Conv
;;
;; դμΤʿͤǡԤΰͤǤ롣
;; ϥɤüΤɤ夯Τʵι⸶()Ⱦ˽
;; Ǥ롣
;;----------------------------------------------------------------------------
(define (eng-hail knpc kpc)
  (say knpc "ΤʤϤ䤻򤯥ܥܥȱˤȲä"
       "ϺǽϤʤ˵ŤƤʤ褦äϤäȡˤϡ"))

(define (eng-name knpc kpc)
  (say knpc "ɥդդȸä狼䤹"))

(define (eng-job knpc kpc)
  (say knpc "ȤΤΤʤ衣"))

(define (eng-default knpc kpc)
  (say knpc "狼ʤʡƻդʹƤ졣"))

(define (eng-bye knpc kpc)
  (say knpc "ϤǤˤʤΤȤ򵤤ˤƤʤ褦"))

(define (eng-join knpc kpc)
  (say knpc "˻ʡƮΤǤߤʤ顣"))

(define (eng-warr knpc kpc)
  (say knpc "ϤޤǤǺǤͥ줿ΤΰͤȹͤƤ롣"
       "Ǥⵤ⤭ԤΰͤȤȤΤäƤ롣"
       "ʤ褦ͦ롢ƶ򤫤ʤȤ򤷤ΤǤʤ"
       "饹ɥǲ񤨤")
    (quest-wise-subinit 'questentry-warritrix)
  	(quest-data-update 'questentry-warritrix 'general-loc 1)
       )

(define (eng-make knpc kpc)
  (say knpc "ϤɤʼΤΤǤ롣ǶιΤ˶̣ʡ"
       "㤨С硢ʤɤ"
       "ۤƬ椬äѤ衣"))

(define (eng-wand knpc kpc)
  (say knpc "¤ͤäȲ񤤤ȻפäƤ"
       "ϼʬǺäΤ")
  (kern-conv-get-yes-no? kpc)
  (say knpc "äȤ줬ɤʤäƤΤͤƤ롣"
       "ĤͤƤ˵߷פΤ"
       "ޤϽФƤʤ"))

(define (eng-void knpc kpc)
  (let* ((eng (kobj-gob-data knpc))
         (quest (eng-quest eng)))

    (define (remove-stuff)
      (map (lambda (ktype) 
             (kern-obj-remove-from-inventory kpc (car ktype) (cadr ktype)))
           voidship-parts))

	;;FIXME: the grammer here needs work
	
    (define (really-has-parts?)
      (display "really-has-parts?")(newline)
      (let ((missing (filter 
				(lambda (ktype)
					(let ((nrem (- (cadr ktype) (num-in-inventory kpc (car ktype)))))
						(cond 
							((> nrem 1)
								(begin
									(say knpc "ޤ" nrem "" (kern-type-get-name (car ktype)) "ɬפ")
									#t))
							((> nrem 0)
								(begin
									(say knpc "ޤ" (kern-type-get-name (car ktype)) "ɬפ")
									#t))
							(else #f))))
					voidship-parts)))
		
        (if (null? missing)
			#t
            #f)))

    (define (build-ship)
      (say knpc "褷Ƥä褦ʡ"
           "ǤϼݤȤ褦")
      (remove-stuff)
      (kern-log-msg "ο¿ϡϫԡԤθġ")
      (prompt-for-key)
      (kern-log-msg "κƻԡƼԡʤäơȱȴġ")
      (prompt-for-key)
      (kern-log-msg "Τ˶ϫľޤԡġ")
      (prompt-for-key)
      (kern-log-msg "κƻԡƼԡޡġ")
      (prompt-for-key)
      (kern-log-msg "ġ")
      (prompt-for-key)
      (kern-log-msg "ΡĤĤˡġ")
      (prompt-for-key)
      (kern-log-msg "ΡĤäȡ礦٤ϲġ")
      (prompt-for-key)
      (kern-log-msg "ΡĤޤʤġ")
      (prompt-for-key)
      (kern-obj-relocate (mk-voidship) (eval-loc voidship-loc) nil)
      (kern-log-msg "ͤȤƥܥܥ")
      (say knpc
           "ġʤƷΤΤ"
           "ԤäƤ뤾򵧤롪")
      (kern-log-msg "ϤӤ򤫤Ϥ᤿")
      (kern-obj-add-effect knpc ef_sleep nil)
      (quest-done! quest #t)
      (kern-conv-end))

    (define (missing-power-core?)
      (not (in-inventory? kpc t_power_core)))

    (define (has-plans)
      (say knpc "줬εηײ"
           "ɬפʤƤ뤫͡")
      (if (kern-conv-get-yes-no? kpc)
          (if (really-has-parts?)
              (build-ship))
          (if (missing-power-core?)
              (say knpc "οܤϤäΤɤ˰夲줿롣"
                   "ܤϤˡ򸫤ĤСϧФȤǤ")
              (say knpc "ࡢԤäƤΤʡäƤʤ")
              )))
      
    (define (no-plans)
      (say knpc "ɤμˤϹʵäƤ롣"
           "ϵϤ߷פ򤷤ޤƤʤ"
           "ɤ˷ײ񤬤롣ĤƤ鶵Ƥ")
           (quest-data-update 'questentry-whereami 'shard 2)
           )

    (if (quest-done? quest)
        (say knpc "ƴ")
        (if (in-inventory? kpc t_voidship_plans)
            (has-plans)
            (no-plans)))))

(define (eng-gate knpc kpc)
  (say knpc "ȺŤƤ롣"
       "Ϥ"
       "ΤäƤ뤫͡")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ˤΤǤϤʤΤΤꤿΤ")
      (say knpc "ʸ롣"
           "ϡ̤ؤȤĤʤäƤ롣"
           "ۤ줿ԤĤɤꤲΤƤ"
           "⤷줬ʤǰʤȤ")))
  
(define (eng-key knpc kpc)
  (say knpc "ϤĤǤǡϼ줿ХХˤʤäȤƤ롣"
       "褯ĤޤʤȤä⤷Ȥ˿¤γˤΤ⤷ʤ"))

(define (eng-wise knpc kpc)
  (say knpc "򸭼ԤȸƤʼԤϡְܴۤ㤤ʤ򤫤ʼԤ"
       "󤲤Х饹ɥԤ"))

(define (eng-stew knpc kpc)
  (say knpc "Ĺ֡ԤΰͤȤƿƤ"
       "ơΤȤǤɤη줬ή줿Τ狼ʤ"
       "֥åȤΤȤʹʡ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ϤΰѤδᤷȤ")
      (say knpc "Ԥ¾Įƻդ٤֥åȤĮԻԤäΤ"
           "֥åȤϼ줿ԤβȤƤ"
           "⤷줿Ԥ鷺ʾڵǤ⤢СĤĮƱ褦˾Ƥʧä")))

(define (eng-accu knpc kpc)
  (say knpc "ϰȷ󤷤ԤνĤȤƤ롣"
       ";פʤȤФ굤ˤƤԤϡ⤭­ΩäƤ롣"
       "ˤƤʤ"))

(define (eng-shri knpc kpc)
  (say knpc "ŤεϿ䤽ξ褯Ĵ٤Ƥߤ"
       "줬ɤʤäƤΤɤǤΤ򼨤Τϲʤä"
       "Ǹˤ줬ΤɴǯʾΤȤȻϹͤƤ롣"))

(define (eng-rune knpc kpc)
  (say knpc "ǤϰϤĤǤ줿ȸƤ롣"
       "̤äǤǤ٤򳫤ʤ褦ХХˤ줿Ȥ⡢"
       "ñ˱줿ȤƤ롣"
       "󤽤ϤθǡΤ褦Ǥ䡢¸ߤ狼ʤΤ"))

(define (eng-wiza knpc kpc)
  (say knpc "ѻդϤ˿å줬"))

(define (eng-wrog knpc kpc)
  (say knpc "ۤȤɤΤʤ餺ԤϤ¤Τ褦ʤΤϤˤ롣"))

(define (eng-wrig knpc kpc)
  (say knpc "ͤϻΤ褦ʼԤ"
       "ʪ뤳Ȥ򹥤ߡʪλȤߤ򸫤ĤФ"
       "Ƽͳ˶̣Τʪɤ褦Ȥ롣"))

(define (eng-necr knpc kpc)
  (say knpc "ԤǤϤʤ٤١ȵȤ롣")
  (quest-data-update 'questentry-necromancer 'nonevil 1)
  )

(define (eng-alch knpc kpc)
  (say knpc "ǤǤʤǥʥºɤ٤Ȥ⤢롣"))

(define (eng-man knpc kpc)
  (say knpc "ʤ餺ԡˤʤԤȤޤäƤ衣"))

(define (eng-ench knpc kpc)
  (say knpc "˸碌оŪʤȤ롣ͤϳ"))

(define eng-merch-msgs
  (list "ϥ"
        "䤬ȯʪΰ򸫤Ƥ"
        nil
        nil
        "Ĥ֤ν˴դƤ衣"
        ""
   ))

(define eng-catalog
  (list
   ;; Various tools and devices
   (list t_picklock       10 "Ĥͽθɬפˤʤäɤʾˤ礦ʤΤ")  ;; high prices, not his specialty
   (list t_shovel        100 "Υ٥ϼʤʡɤΩĤˤϤ狼ʤ")  ;; high prices, not his specialty
   (list t_pick          100 "ΤĤϤϻȤäΤ٤ϼƤ⤤")  ;; high prices, not his specialty
   (list t_sextant       200 "ϻκǹΰĤϻʬС󡦥<In Wis>μʸʤϾǤΰ֤狼롣")
   (list t_chrono        200 "Ͼʡ٤פ򤤤ϳڤΤޤФä")
   
   ;; A bit of oil and grease, for a grease-monkey:
   (list t_grease         20 "Ϥ󤢤롣ʤȤ˻ȤäƤ롣")
   (list t_oil            10 "ȯϤλȤƻϤǤ⤢롣϶餯ưϸˤʤ")  ;; high prices, not his specialty

   ;; Crossbows and bolts, as he likes intricate devices
   (list t_lt_crossbow    50 "襤餷ʥܥξʥСȵˤ褯ǤƤ롣")
   (list t_crossbow      100 "ϷĤΤ϶˸äƼʬǰʷ򶵤뤳ȤǤȻפȡǤؤǤФ褫äȻפ衣")
   (list t_hvy_crossbow  300 "ɸŪʥܥɤˤϤʤäդƤߤФ˷Ȥ狼")
   (list t_trpl_crossbow 500 "⤷٤˰ȯ¿Ƥ륯ܥä顩ĩ路ƤߤƤä") ;; a mechanism of his devising
   (list t_bolt            2 "ܥɤƤȤ¿ɬפäǤⲿȢĤäƤ롣")
   ))

(define (eng-trade knpc kpc) (conv-trade knpc kpc "buy" eng-merch-msgs eng-catalog))

(define engineer-conv
  (ifc nil
       (method 'default eng-default)
       (method 'hail eng-hail)
       (method 'name eng-name)
       (method 'bye eng-bye)
       (method 'job eng-job)
       (method 'engi eng-job)
       (method 'join eng-join)

       (method 'trad eng-trade)
       (method 'buy  eng-trade)
       (method 'inve eng-trade)

       (method 'make eng-make)
       (method 'thin eng-make)
       (method 'wand eng-wand)
       (method 'void eng-void)
       (method 'gate eng-gate)
       (method 'key eng-key)
       (method 'wise eng-wise)
       (method 'stew eng-stew)
       (method 'accu eng-accu)
       (method 'shri eng-shri)
       (method 'rune eng-rune)
       (method 'wiza eng-wiza)
       (method 'wrog eng-wrog)
       (method 'wrig eng-wrig)
       (method 'necr eng-necr)
       (method 'alch eng-alch)
       (method 'man eng-man)
       (method 'ench eng-ench)
       (method 'warr eng-warr)
       ))

(define (mk-engineer)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     'ch_engineer ;;..........tag
     "" ;;.......name
     sp_human ;;.....species
     oc_wright ;;.. .occupation
     s_companion_tinker ;;..sprite
     faction-men ;;..faction
     2 ;;...........custom strength modifier
     10 ;;...........custom intelligence modifier
     2 ;;...........custom dexterity modifier
     10 ;;............custom base hp modifier
     2 ;;............custom hp multiplier (per-level)
     20 ;;............custom base mp modifier
     5 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     engineer-start-lvl  ;;..current level
     #f ;;...........dead?
     'engineer-conv ;;...conversation (optional)
     sch_engineer ;;.....schedule (optional)
     'townsman-ai ;;..........custom ai (optional)
     ;;..............container (and contents)
     (mk-inventory
      (list
       (list 1   t_dagger)
       (list 1   t_doom_staff)
       (list 1   t_trpl_crossbow)
       (list 100 t_bolt)
       (list 5   t_cure_potion)
       (list 5   t_heal_potion)
       ))
     nil ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (engineer-mk)))
