;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ѡ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_fing
               (list 0  0  sea-witch-bay        "idle")
               (list 6  0  sea-witch-shore      "idle")
               (list 8  0  sea-witch-bay        "idle")
               (list 20 0  sea-witch-shore      "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (fing-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; եϥ˥ǡ²βҤǤ롣
;; ϡʹ֤νꥢζ᤯ˤ뤿ᡢѡ˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (fing-hail knpc kpc)
  (say knpc "Τʤϥ˥ȲäϤˤϡΦο͡"))

(define (fing-default knpc kpc)
  (say knpc "⤷ȡ̤ΦοͤʤΤäƤ뤫⤷ޤ"))

(define (fing-name knpc kpc)
  (say knpc "ϥեǤ"))

(define (fing-join knpc kpc)
  (say knpc "δߤΥ뤳ȤϤǤʤΤǤ"))

(define (fing-job knpc kpc)
  (say knpc "ϤëĤοͤβҤǤ"))

(define (fing-bye knpc kpc)
  (say knpc "褦ʤ顢Φο͡"))

;; Shores...
(define (fing-shor knpc kpc)
  (say knpc "ϰͤ¦ˤ뤿ᡢδߤΥ櫓ˤϤʤΤǤ"))

(define (fing-love knpc kpc)
  (say knpc "ʤ顢ΰͤΦΥ뤳ȤǤʤΤǤ"
       "ϳοͤβǤ"
       "ڤ¡ƼȤμˤ⤫餺˾ΤƤƤʤΤǤ"))

(define (fing-sea knpc kpc)
  (say knpc "βˤϤβ񡢤ΰסƶ"
       "ƤФ餷ޤˡȤ"
       "ʼΤ϶ʪޤʬ򳲤뤫⤷ޤ󤬡"
       "٤ȴϤϤȤƤǤ礦͡"
       ))

(define (fing-curs knpc kpc)
  (say knpc "ϳοͤǤ"))

;; Townspeople...
(define (fing-opar knpc kpc)
  (say knpc "ʤΤ褦ΦοͤˤϤ褤Ȼפޤ"))

(define (fing-gher knpc kpc)
  (say knpc "䤿򲼤޻Ƥޤ"
       "᤯ȹӡ"
       "ȸޤ褦ʽǤ"
       "μ겼ϡɤỴʺǴ뤲褦Ǥ"))

(define (fing-crew knpc kpc)
  (say knpc "ƥμ겼ؤʤޤ"
       "ƾΦ٤äƤ뤳ȤϤޤǤ"
       "⼺ޤ"))

(define (fing-alch knpc kpc)
  (say knpc "ΰͤȤ褯äƤޤʤϤƤޤ"
       "ϤޤˤФȤäƤơɤʤۤεܤˤϸʤǤ"))

(define (fing-osca knpc kpc)
  (say knpc "ΤȤΤޤ"))

(define (fing-henr knpc kpc)
  (say knpc "ͦΦοͤʹޤ"))

(define (fing-bart knpc kpc)
  (say knpc "֥Ϥޤ긫Ȥޤϳ򶲤ƤȻפޤ"
       "ϥ֥δ֤ǤѤԤǤ礦"))


(define fing-conv
  (ifc nil

       ;; basics
       (method 'default fing-default)
       (method 'hail fing-hail)
       (method 'bye fing-bye)
       (method 'job fing-job)
       (method 'name fing-name)
       (method 'join fing-join)
       
       ;; Shores
       (method 'shor fing-shor)
       (method 'love fing-love)
       (method 'sea fing-sea)
       (method 'deep fing-sea)
       (method 'bay  fing-sea)
       (method 'curs fing-curs)

       ;; town & people
       (method 'opar fing-opar)
       (method 'alch fing-alch)
       (method 'gher fing-gher)
       (method 'crew fing-crew)
       (method 'osca fing-osca)
       (method 'henr fing-henr)
       (method 'bart fing-bart)
       (method 'lia  fing-love)

       ))

(define (mk-fing)
  (bind 
   (kern-mk-char 'ch_fing           ; tag
                 "ե"           ; name
                 sp_nixie           ; species
                 oc_warrior         ; occ
                 s_nixie_civilian    ; sprite
                 faction-men         ; starting alignment
                 1 2 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'fing-conv         ; conv
                 sch_fing           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 10 t_spear)))                ; container
                 nil                 ; readied
                 )
   (fing-mk)))
