(define (gsstatue-unknown knpc kpc)
  (say knpc "ۤޤޤ"))

(define (gsstatue-hail knpc kpc)
  (say knpc "äƤ")
  (gamestart-statue-clean knpc "statspeak")
  )
    
(define gsstatue-conv
  (ifc '()
       ;; fundamentals
       (method 'default gsstatue-unknown)
       (method 'hail gsstatue-hail)
       )
       )

(define (gsstatue-dostat knpc kpc iname iset iget dname dset dget initial)
	(define (gs-check-upper value)
		(if (> value 11)
			(begin
				(say knpc "ʾ塢" iname "夲뤳ȤϤǤ̡")
				#t
				)
			#f))
	(define (gs-check-lower value)
		(if (< value 1)
			(begin
				(say knpc "ʾ塢" dname "򲼤٤ǤϤʤ")
				#t
				)
			#f))
	(define (gs-initialcheck)
		(say knpc dname "" iname "˴뤫")
		(if (kern-conv-get-yes-no? kpc)
			#f #t)
		)
	(define (gs-repeatcheck)
		(say knpc "³뤫")
		(if (kern-conv-get-yes-no? kpc)
			#f #t)
		)
	(let ((ival (iget kpc))
			(dval (dget kpc))
			)
		(cond ((gs-check-upper ival))
			((gs-check-lower dval))
			((and initial (gs-initialcheck)) (say knpc "ΰդΤޤޤˡ"))
			((and (not initial) (gs-repeatcheck)) (say knpc "ΰդΤޤޤˡ"))
			(#t
				(iset kpc (+ ival 1))
				(dset kpc (- dval 1))
				(say knpc "[ʤ" iname "夬ä]")
				(say knpc "[ʤ" dname
					(cond ((< dval 3) "ޤä]")
						((< dval 9) "ä]")
						(#t " wanes]")
					)
				)
				(gamestart-reset-lamps kpc)
				(gsstatue-dostat knpc kpc iname iset iget dname dset dget #f)
			)
		)	
	))
		       
;; Statue of intelligence

(define (gs-int-hail knpc kpc)
  (say knpc "褦õԤ衣ΤˤǽͿ褦")
  (gamestart-statue-clean knpc "statspeak")
  )
  
(define (gs-int-job knpc kpc)
	(say knpc "I represent the force of reason, and can assist you in endeavors of magic or wit.")
	)
  
(define (gs-int-assi knpc kpc)
	(say knpc "I can raise your intellect, but it will cost you some of your strength or dexterity")
	)

(define (gs-int-rais knpc kpc)
	(say knpc "You will need to say which attribute you want to suffer the penalty")
	)
		
;; expand on this as other abilities become available
(define (gs-int-inte knpc kpc)
  (say knpc "ԤϤ߽ФդԤνѤǤä򤫤ʼԤǤ蘆졢ưפ˵롣"
       "õԤ衢Ĥ뤬褤ٰǽԤιԤƻԤƤ롣"
       "μԤۤˤϤɬפϤߤ뤫")
  (if (yes? kpc)
      (say knpc "Ϥ뤿ˤϡϤҾΤ줫򺹤ФͤФʤʤ")
      (say knpc "Ϥ󤶤Ԥϰ򴿴")
      )
  )
	
(define (gs-int-stre knpc kpc)
  (say knpc "ʹõԤ衪ϤǤϰǤκǤ⶯ϤΩȤϤǤ̤Ǥ")
  (gsstatue-dostat knpc kpc "ǽ" kern-char-set-intelligence kern-char-get-base-intelligence 
                   "" kern-char-set-strength kern-char-get-base-strength #t)
  )
      
	
(define (gs-int-dext knpc kpc)
  (say knpc "ͤ衢õԡǤ®ΰ⡢ٰʹѻդˤ̤"
       "Ϥ줿Ϥ뤳ȤǤʤ")
  (gsstatue-dostat knpc kpc "ǽ" kern-char-set-intelligence kern-char-get-base-intelligence 
                   "Ҿ" kern-char-set-dexterity kern-char-get-base-dexterity #t)
  )

(define (gs-int-bye knpc kpc)
  (say knpc "ԤõԤ衣Ϥ򼫿ȤꡢԤ줿ԤԾʼԤξ˱ι뱫ߤ餻󤳤Ȥ")
  )

(define gs-int-conv
  (ifc '()
       ;; fundamentals
       (method 'default gsstatue-unknown)
       (method 'bye gs-int-bye)
       (method 'hail gs-int-hail)
       (method 'job gs-int-inte)
       (method 'inte gs-int-inte)
       (method 'int gs-int-inte)
       (method 'wis gs-int-inte)
       (method 'wisd gs-int-inte)
       (method 'stre gs-int-stre)
       (method 'str gs-int-stre)
       (method 'dext gs-int-dext)
       (method 'dex gs-int-dext)
       )
  )
       
;; Statue of might

(define (gs-str-hail knpc kpc)
  (say knpc "褦õԤ衣ԤˤϤͿ褦")
  (gamestart-statue-clean knpc "statspeak")
  )
  
;; expand on this as other abilities become available
(define (gs-str-stre knpc kpc)
	(say knpc "ϤСŨγꡢդʴդǤǤ"
             "ǤŤ뤳ȤǤŨǷϰ̣ʤ̤Ǥ"
             "ϤϺǤפʤΤǤϤʤͣɬפʤΤǤ롪"
             "Ϥ뤫")
        (if (yes? kpc)
            (say knpc "ϤΤ衣ǽȤҾ")
            (say knpc "ιԤ򼫿ȤߤΤϤΤߤǤ롣")
            ))
	
(define (gs-str-inte knpc kpc)
  (say knpc "ΤˤѤɬפǤɬפʤΤϤǤ롪")
  (gsstatue-dostat knpc kpc "" kern-char-set-strength kern-char-get-base-strength 
                   "ǽ" kern-char-set-intelligence kern-char-get-base-intelligence #t)
  )
	
(define (gs-str-dext knpc kpc)
  (say knpc "ͧҾ̯ܤ"
       "ŨϤǤΤǤǤ")
  (gsstatue-dostat knpc kpc "" kern-char-set-strength kern-char-get-base-strength 
                   "Ҿ" kern-char-set-dexterity kern-char-get-base-dexterity #t)
  )

(define (gs-str-bye knpc kpc)
  (say knpc "Ԥư˰ͿΤ"))

(define gs-str-conv
  (ifc '()
       ;; fundamentals
       (method 'default gsstatue-unknown)
       (method 'bye gs-str-bye)
       (method 'hail gs-str-hail)
       (method 'job gs-str-stre)
       (method 'stre gs-str-stre)
       (method 'inte gs-str-inte)
       (method 'int gs-str-inte)
       (method 'dext gs-str-dext)
       (method 'dex gs-str-dext)
       )
  )
       
;; Statue of agility

(define (gs-dex-hail knpc kpc)
  (say knpc "褯äõԤ衣٤μԤΤ褦ˡ˽äϤ⡢ζγؼԤϤͿ뤳ȤǤ̡"
       "Ҿ뤳ȤϤǤ롣")
  (gamestart-statue-clean knpc "statspeak")
  )
  
(define (gs-dex-dext knpc kpc)
  (say knpc "ҾͭǽԤɬפǤ롣ɤΤ褦˸γݤäǤˤ롩\n\n"
       "ȤȴѤưפ˸ĤȤɤΤ褦ˤӽѽܤƨ롩\n\n"
       "Ũ󤯤Ť˷äƤȤɤΤ褦˺Ǥ褤򤹤롩\n\n"
       "ˡ٤ȽǤ٤ϵϤ򾷤ᤤȤΤʤȷǤϾ⤿餹Ǥ"
       "⤽ͤ뤫")
  (if (yes? kpc)
      (say knpc "̤ꡣҾ϶ߤϤܤǽˤͤ롣")
      (say knpc "ࡣͧ衢ۤ˵Ĥ衣ͤϤΤޤʵԤ򹥤Τ")
      )
  )
	
(define (gs-dex-inte knpc kpc)
  (say knpc "ǽɾ줹ƤȲϻפ"
       "˴άåǤȤˡï⤽˴褦ʤɤȤϻפʤȤȤ")
       (gsstatue-dostat knpc kpc "Ҿ" kern-char-set-dexterity kern-char-get-base-dexterity 
                        "ǽ" kern-char-set-intelligence kern-char-get-base-intelligence #t)
       )
	
(define (gs-dex-stre knpc kpc)
  (say knpc "Ϥϱƶ䤹ԤˤͦޤƶͿ"
       "ȳ֤Τ̵̣ʶϫΤ褦˻פ롣")
  (gsstatue-dostat knpc kpc "Ҿ" kern-char-set-dexterity kern-char-get-base-dexterity 
                   "" kern-char-set-strength kern-char-get-base-strength #t)
  )

(define (gs-dex-bye knpc kpc)
  (say knpc "С˵ΤȤȤˤ졣"
       "ൡ⡢ʭ뵡⡢ƨƤϤʤ̡"
       "ƤʤȤ⡢õԤ衢褤򤹤뤳Ȥ˺ƤϤʤ̡")
  )

(define gs-dex-conv
  (ifc '()
       ;; fundamentals
       (method 'default gsstatue-unknown)
       (method 'bye gs-dex-bye)
       (method 'hail gs-dex-hail)
       (method 'job gs-dex-dext)
       (method 'dex gs-dex-dext)
       (method 'dext gs-dex-dext)
       (method 'stre gs-dex-stre)
       (method 'str gs-dex-stre)
       (method 'inte gs-dex-inte)
       (method 'int gs-dex-inte)
       )
  )
