;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Ф
;;----------------------------------------------------------------------------
(define (mk-zone x y w h) (list 'p_green_tower x y w h))
(kern-mk-sched 'sch_gen
               (list 0  0  (mk-zone 2  13 1  1)  "sleeping")
               (list 4  0  (mk-zone 3  12 3  3)  "eating")
               (list 5  0  gt-woods  "idle")
               (list 10 0  (mk-zone 26 27 2  12) "idle")
               (list 12 0  (mk-zone 49 54 1  1)  "eating")
               (list 13 0  (mk-zone 49 3  7  2)  "idle")
               (list 14 0  (mk-zone 7  20 5  5)  "idle")
               (list 18 0  (mk-zone 49 54 1  1)  "eating")
               (list 19 0  (mk-zone 3  12 3  3)  "idle")
               (list 0  0  (mk-zone 2  13 1  1)  "sleeping")
               )

;; ----------------------------------------------------------------------------
;; Υ֥ñ콸
;; ----------------------------------------------------------------------------
(mk-reusable-item 
 't_goblin_lexicon "֥ñ콸" s_lexicon norm
 (lambda (klexicon kuser)
   (kern-ui-page-text
   "֥ñ콸"
   "ϥ֥ؤֽȤ뤿˽񤫤줿"
   "ΤǤ롣ΩĤȤ˾ࡣ"
   "ݥ"
   ""
   "ܡġĻΡ伫"
   "Ŀʹ"
   "ġĲȡ"
   "ġֲ"
   "ġĺ"
   "ϡġɤϤߤ"
   "ҡġļ"
   "ĹԤ"
   "Ĳä"
   "ġĻ롢"
   "ġķ򹯡̿ϡ"
   "ĸ򴹡Ѳѿ"
   "ޡġĿ줿ƻ"
   "ġܡŻ̿"
   "ʡġĤʤΡʤ"
   "̡ġࡢ롢Ϥޤ"
   "Ρġ̾"
   "˥ı줿"
   "ġĸ塢ϡƶ"
   "ȡġļ"
   "ġġĤ"
   "ġĸ롢õ"
   )))

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (gen-mk will-join? gave-notes?) (list will-join? gave-notes?))
(define (gen-will-join? gen) (car gen))
(define (gen-gave-notes? gen) (cadr gen))
(define (gen-set-will-join! gen val) (set-car! gen val))
(define (gen-set-gave-notes! gen val) (set-car! (cdr gen) val))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ϷФ˽Ǥ롣
;; ϥ֥μꡢޤͧͤǤ⤢롣
;; ֤ˤʤ롣
;;----------------------------------------------------------------------------
(define (gen-hail     gen player) (say gen "ˤϡ¤ͤ"))
(define (gen-bye      gen player) (say gen "褦ʤ顣"))
(define (gen-default  gen player) (say gen "Ϥ狼ޤ"))
(define (gen-name     gen player) (say gen "ϥ"))
(define (gen-woodsman gen player) (say gen "򿹿ͤȸƤּԤ⤤ޤ" ))
(define (gen-job      gen player) (say gen "ĤƻϷǤζФ򽪤ޤǤϼʬΤ˿⤭äƤޤ" ))
(define (gen-reasons  gen player) (say gen "ʬΤˤǤ" ))

(define (gen-captain gen player) 
  (say gen "ǥåĹФǷشƤޤ⤦񤤤ޤ")
  (if (kern-conv-get-yes-no? player)
      (say gen "ͭǽˤǤŪǤ")
      (say gen "ˤޤλ̳󳬤ˤޤ")))

(define (gen-ambitious   gen player) (say gen "ʿ¤ʤȤˤϡͤϤĤĤޤˤϤʤʤΤǤ"))
(define (gen-culture     gen player) 
  (say gen "ȼʸǤʸäƤޤ(ȥʤȤϰä)"
       "ԥˤ褦ˡϰۤʤ͡Ķ¸ߤΤǤ"))
(define (gen-shakespeare gen player)
  (say gen "ΤäƤΤǤФ餷")
  (if (in-player-party? 'ch_kama)
      (say gen "ϥޤ򸫤ϤλͤΤ⤦ͤǤθϥåȤϤʹ٤Ǥ")
      ))

(define (gen-ranger gen player) (say gen "ϥ֥δ֤ο襤ޤǤϷŪ¸ߤǤ"))
(define (gen-wars   gen player) (say gen "ϤϷȤƥ֥襤ޤΤȤǡ͡˺Ƥޤ"
				     "͡ϥ֥ä¸ߡԤä٤¸ߤȤߤʤƤޤ"))
(define (gen-goblin gen player) (say gen "̣²ǤȼθȤޤʸäƤޤ"
				     "ͤȻƤޤ궧˽ǡ긶ŪǤ"
				     "ʼΤ϶ΤǡѻդȤƤޤ"))
(define (gen-primal gen player) (say gen "ºɤƤޤΤΤȤΤޤǤ"
				     "ǤϿ֥ͧͤޤƶ֥Ϥޤ̤Ǥ" ))
(define (gen-cave   gen player) (say gen "ƶ֥ϡμԤ礭Ϥα뤳Ȥ򹥤ԤǤ"
				     "ΰǤοӤޤƶõȤ˵Ĥ뤳ȤǤοϿʹ֤ؤߤǳƤޤ" ))

(define (gen-language kgen player)
  (let ((gen (kobj-gob-data kgen)))
    (say kgen "ǤϾ֥äޤΤꤿǤ")
    (if (kern-conv-get-yes-no? player)
        (if (gen-gave-notes? gen)
            (say kgen "ñ콸ǳؤǤƻƤ")
            (begin
              (say kgen "θˤĤƤޤȤ᤿ΤǤäƤ˼ͳƤ")
              (kern-obj-add-to-inventory player t_goblin_lexicon 1)
              (gen-set-gave-notes! gen #t)))
        (say kgen "Ǥ̤εˡ"))))


(define (gen-practice gen player) (say gen "֥ä򤷤ΤǤС˥֥äƤ" ))

(define (gen-join gen player)
  (if (gen-will-join? (kobj-gob-data gen))
      (begin
        (say gen "狼ޤ֤˲äޤ礦"
             "ɬפǤĮˤξعԤäơȢΤΤ˹Ԥޤ礦"
             "Ǥϲơͧ衪")
             (join-player gen))
      (say gen "θդǻ̾äƤ")))

;; SAM: Added a few words from the Lexicon which were not defined as responses.
;;      These were (Iki, Lu, Nin)
;;      Also enhanced a few responses such as for (Eh).
;; Added responses having to do with the concepts of Wanderer, Warrior, Wizard, Rogue, Wright.
;; A bit of organization/tidying may still be wanted, to make sure there are no loose ends .

(define (gen-da  gen player) (say gen "ϡޡȤϿ֥̣ޤ" ))
(define (gen-gu  gen player) (say gen "ϡȤ̣Ǥ" ))
(define (gen-ru  gen player) (say gen "ϡ롦Ȥƶ֥̣ޤ" ))
(define (gen-no  gen player) (say gen "ܡΡ󡣤Ǥ⥴֥󤿤ϻޡȤȸƤӤޤ" ))
(define (gen-ki  gen player) (say gen "ܡϡϸǤ" ))
(define (gen-jo  gen player) (say gen "ȤƤ⤹Ф餷ȤǤ֥νɬפʤ顢Ϥʤ˲äǤ礦"))
(define (gen-cho gen player) (say gen "ϡ硦ȤϿʹ֤̣ޤ" ))
(define (gen-nu  gen player) (say gen "ϡ̡ϥ֥θդǡֿʪפǤ" ))
(define (gen-ha  gen player) (say gen "ϤϹɽդǤ" ))
(define (gen-tu  gen player) (say gen "̤ꡣĤθդǤ" ))
(define (gen-bo  gen player) (say gen "ܡϤʤκŪΤʤ̣ޤ" ))
(define (gen-na  gen player) (say gen "Ϥܡʤϡֻ䤿סޤϡְ²פǤܡʡޤϿ֥̤ؤޤ" ))
(define (gen-to  gen player) (say gen "̤ꡣȤդȲ򤹤Ԥɽޤ" ))
(define (gen-ma  gen player) (say gen "ޡȤڤɽդǤ" ))
(define (gen-eh  gen player) (say gen "ʡϤʤλŻޤϲǤȤ̣Ǥ" ))
(define (gen-iki gen player) (say gen "ϡܡϡֻϲȤפȤ̣Ǥ"))

(define (gen-me  gen player) (say gen "ܡޡϿƻ뤷Ƥ롢ޤϱ줿ƻõƤ롣ᡦ롦ĹѲؤӡõᡢ¤ͤƻǤ"))
(define (gen-ka  gen player) (say gen "ϡϡȤΤ򡢤ƥᡦϤΤͤɽޤ"))
(define (gen-hi  gen player) (say gen "ϡҡޡȤϡּѻաפΤȤǤơ֥ᡦϡפѻդͤǤ"))
(define (gen-nin gen player) (say gen "ϡ˥󡦥ޡȤϿα̩Ǥƥᡦϡ˥󡦥Ϥʤ餺ԤͤǤ"))
(define (gen-lu  gen player) (say gen "ϡ塦ȤϺԤǤƥᡦϡ塦繩ͤǤ"))

(define (gen-zu       gen player) (say gen "Ф餷ƥȤõԡޤ¤ͤΤȤǤϱԤܤǤʤ򸫤ϥ奭"))
(define (gen-meluki   gen player) (say gen "ʤõԤǤ⤷ʤΥޤʤ֤ˤʤޤ礦"))
(define (gen-gunodama gen player) (say gen "˽κͿ줿̤̾θդǸп֥θդΤȤǤ"))

(define (gen-nuki knpc kpc)
  (say knpc "ϥ֥ǡֿʪפǤ"))

(define (gen-bonaha gen player) 
  (say gen "Ф餷ϥ֥θդͧͤǤ֥θդ狼äƤ褦Ǥ͡")
  (gen-set-will-join! (kobj-gob-data gen) #t))

(define (gen-shroom gen player) (say gen "ϸŤͧͤǤ֥κβäȸä鿮ޤ"))
(define (gen-maiden gen player) (say gen "Ǥ©ڤ餻Ƽμʸ򾧤ʤ顢ǵǥ֥ʤݤƻڤ곫Ѥ򺣤ǤФƤޤ"
                                   "γܤĥΤޤ"))

(define (gen-thie knpc kpc)
  (say knpc "ΤǤϲԤϸޤǤ"
       "Ǥ⡢̤ο˽ॴ֥󤬡ǶΥܥ˰ͤǸԤ򸫤Ǥ")
       (quest-data-update 'questentry-thiefrune 'tower 1)
       (quest-data-update-with 'questentry-thiefrune 'bole 1 (quest-notify (grant-party-xp-fn 10)))
       )

(define (gen-kama knpc kpc)
  (if (is-player-party-member? ch_kama)
      (begin
        (say knpc "ޤϤʤ˲ää褦Ǥ͡ܥʥϡޡ")
        (say ch_kama "󡣡ܥʥϡޥȡ"))
      (begin
        (say knpc "ޤϥ֥μͤǤȤϤĮγѤǲ˲񤦤ȤˤʤäƤΤǤޤǤȲäȤޤ")
        (if (yes? kpc)
            (begin
              (say knpc "äƤޤ")
              (if (yes? kpc)
                  (say knpc "Ǥʤ˹Ԥ")
                  (say knpc "¿ޤ")))
            (say knpc "⤷äΤ餻ƤۤǤ")))))
            
(define (gen-ruka knpc kpc)
  (say knpc "륫Ȥϥ֥󤿤Υ󥰥ꥹνθƤ̾Ǥ"
       "󥰥ꥹοδ֥֡ؤȶΩƤƤޤ"
       "ؤοĤ餱ƤѤƤޤޤ")
  (prompt-for-key)
  (say knpc "ǤϻҶ򿹤˶ŤʤñʤǤ"
       "ˤϤäȴʤΤޤ͡"))

(define (gen-clov knpc kpc)
  (say knpc "ӥϥ֥ΤƳԤǤ"
       "⤷ͧͤΥޤȲ񤨤С˴ɤʤäʹȤǤޤ")
       (quest-data-update-with 'questentry-rune-f 'kama 1 (quest-notify nil))
       )

(define (gen-band knpc kpc)
  (say knpc "֥ã±ξΤɤˤȸäƤޤ"
       "ǥåĹϤäȾܤȤΤäƤ뤫⤷ޤ"))

(define gen-conv
  (ifc basic-conv
       ;;;; Goblin root words:
       (method 'bo  gen-bo)  ; My, Myself
       (method 'cho gen-cho) ; Mankind
       (method 'da  gen-da)  ; Abode, World
       (method 'eh  gen-eh)  ; What?
       (method 'gu  gen-gu)  ; Spirit, Ancestor
       (method 'ha  gen-ha)  ; Good, yes, skillful
       (method 'hi  gen-hi)  ; Magic
       (method 'iki gen-iki) ; Go
       (method 'jo  gen-jo)  ; Join
       (method 'ka  gen-ka)  ; Kill
       (method 'ki  gen-ki)  ; Health
       (method 'lu  gen-lu)  ; Change
       (method 'me  gen-me)  ; Forest
       (method 'ma  gen-ma)  ; Duty, Job, Destiny
       (method 'na  gen-na)  ; Your, yourself
       (method 'nin gen-nin) ; Stealth
       (method 'no  gen-no)  ; Name
       (method 'nu  gen-nu)  ; Give birth, Create, Begin
       (method 'ru  gen-ru)  ; Ancient, Primordial, Deep, Cave
       (method 'to  gen-to)  ; Individual
       (method 'tu  gen-tu)  ; No, Bad
       (method 'zu  gen-zu)  ; Watch, Seek

       ;;;; Goblin composite words / phrases:
       (method 'bona gen-bonaha)   ; Friend
       (method 'kama gen-kama)     ; Kama, the goblin friend of Gen
       (method 'nuki gen-nuki)     ; Food
       (method 'ruka gen-ruka)     ; Angriss, the Spider Queen
       (method 'melu gen-meluki)   ; Seeker, Wanderer
       (method 'guno gen-gunodama) ; the language of the Forest Goblins

       ;;;; Responses in human speech:
       ;; Standard responses:
       (method 'default gen-default)
       (method 'hail gen-hail)
       (method 'name gen-name)
       (method 'job  gen-job)
       (method 'join gen-join)
       (method 'bye  gen-bye)

       ;; Having to do with the goblin language:
       (method 'gobl gen-goblin)
       (method 'lang gen-language)
       (method 'prac gen-practice)

       ;; Other responses:
       (method 'admi gen-primal)
       (method 'ambi gen-ambitious)
       (method 'band gen-band)
       (method 'capt gen-captain)
       (method 'deri gen-captain)
       (method 'cave gen-cave)
       (method 'fore gen-job)
       (method 'maid gen-maiden)
       (method 'prim gen-primal)
       (method 'rang gen-ranger)
       (method 'reas gen-reasons)
       (method 'sava gen-primal)

       (method 'cult gen-culture)
       (method 'shak gen-shakespeare)
       (method 'bard gen-shakespeare)  ;; synonyn
       (method 'haml gen-shakespeare)  ;; synonyn

       (method 'shro gen-shroom)
       (method 'thie gen-thie)
       (method 'wars gen-wars)
       (method 'wood gen-woodsman)
       (method 'clov gen-clov)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-gen tag)
  (bind 
   (kern-mk-char tag                 ; tag
                 ""            ; name
                 sp_human            ; species
                 oc_ranger           ; occ
                 s_old_ranger  ; sprite
                 faction-men         ; starting alignment
                 4 2 4           	 ; str/int/dex
                 pc-hp-off  ; hp bonus
                 pc-hp-gain ; hp per-level bonus
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'gen-conv           ; conv
                 sch_gen             ; sched
                 'townsman-ai        ; special ai
                 (mk-inventory (list (list 1 t_dagger) 
				     (list 1 t_playbook_hamlet)
				     ))  ; container
                 (list t_armor_leather)                ; readied
                 )
   (gen-mk #f #f)))
