;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ѡ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_ghertie
               (list 0  0  cheerful-room-3      "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (ghertie-mk) 
  (list (mk-quest)))

(define (ghertie-quest gob) (car gob))



;;----------------------------------------------------------------------------
;; Conv
;; 
;; ƥϽγ±Ĺǡǳ˴ȤʤäƤ롣
;; ϥѡνɤ˽Ф롣
;;----------------------------------------------------------------------------

;; Quest...
(define (ghertie-give-instr knpc kpc)
  (say knpc "μ겼ϥɥΰΤĤ줿ؤȤˤĤƤ롣"
       "򳰤ȤϤǤʤ"
       "硼󡢥åȡƥߡˡϤޤƤ롣"
       "λؤä褤줬ξ"
       "θ夳˱롣")
	(quest-data-update-with 'questentry-ghertie 'questinfo 1 (quest-notify nil))
)

(define (ghertie-update-quest knpc kpc)
  (let ((nrem (- 3 (num-in-inventory kpc t_skull_ring))))
    (if (= nrem 0)
        (begin
          (say knpc "Ͽ뤲줿ǵ٤ġ"
               "ῼ[" merciful-death-x "," merciful-death-y "]̲äƤ롣"
               "ϳˤ롣ɤäΤϤ"
               "ʾФȶ˾ää")
			(quest-data-update-with 'questentry-rune-c 'shiploc 1 (quest-notify nil))
			(quest-data-assign-once 'questentry-ghertie)
			(quest-data-update-with 'questentry-ghertie 'done 1 (grant-party-xp-fn 20))
			 (kern-conv-end)
          (kern-obj-remove knpc)
          (kern-map-set-dirty))
        (begin
          (say knpc "ޤؤ" nrem "­ʤ"
               "λؼ˺줿Τ")
           (if (kern-conv-get-yes-no? kpc)
               (begin
                 (say knpc "ޤ겼ä鲥껦Ƥʡ")
                 (ghertie-give-instr knpc kpc))
               (say knpc "ʤʤ֤äƤ롩"
                    "⤷̤ʤСκ򤢤μǲ껦Ƥ뤫ʡ"))))))

;; Basics...
(define (ghertie-hail knpc kpc)
  (let ((quest (ghertie-quest (kobj-gob-data knpc))))
		(quest-data-update 'questentry-ghertie 'ghertieloc 1)
		(quest-data-assign-once 'questentry-ghertie)
    (display "quest:")(display quest)(newline)
    (if (quest-accepted? quest)
        (ghertie-update-quest knpc kpc)        
        (say knpc "ΤʤϹӡѤνͩȲä"
             "⤹ȤϤٶϵ"))))

(define (ghertie-default knpc kpc)
  (say knpc "ʤȤäƤ󤸤ͤ"))

(define (ghertie-name knpc kpc)
	(quest-data-update 'questentry-ghertie 'ghertieid 1)
  (say knpc "ȥ롼ɤ"))

(define (ghertie-join knpc kpc)
  (say knpc "ϤʱΥʤ"))

(define (ghertie-job knpc kpc)
  (say knpc "ƤȤϳ±äϤͩ"))

(define (ghertie-bye knpc kpc)
  (if (quest-accepted? (ghertie-quest (kobj-gob-data knpc)))
      (say knpc "᤯ߤ餷Ƥ졪")
      (say knpc "ʬμ겼򿮤ʡ")))

;; Pirate...
(define (ghertie-pira knpc kpc)
  (say knpc "γߤǲǯⳤ±äơߤ"
       "±򼭤롢겼΢ڤ줿"
       "ߤʤ©Ҥߤ˻פäƤΤˤΤ餺ᡪ"))

(define (ghertie-betr knpc kpc)
  (say knpc "ȴ򿲤Ƥ֤˻åäƤäΤ"))

(define (ghertie-ship knpc kpc)
  (say knpc "ֻῼ׹®Τä"
       "ꤤϤʤ͡Ƥʤʤꡢ⤦⤫⽪"
       "åä겼Ф˵ͤ"))

(define (ghertie-haun knpc kpc)
  (say knpc "ΥʤΤ"
       "΢ڤä겼ϤŤ˻ǤʤȹͤƤ"
       "ۤϼǤɤ餻ۤɤȤǤʤΤ"
       "եۤϤμΤʤΤ"))

(define (ghertie-curs knpc kpc)
  (say knpc "ϼʬ˼򤫤"
       "⤷ޤ줿鼫ʬư褦ˤ"
       "γϤΤäƤġ"))

(define (ghertie-grav knpc kpc)
  (say knpc "ʤʤʤ"))

(define (ghertie-reve knpc kpc)
  (let ((quest (ghertie-quest (kobj-gob-data knpc))))
    (if (quest-accepted? quest)
        (say knpc "ޤä"
             "򥴥㥴äƤ롩")
        (begin
          (say knpc "䤿ܤǤʤ򸫤"
               "ޤϤλߤդä"
               "ߤ餹˼ߤƤΤ")
	(quest-data-update 'questentry-ghertie 'revenge 1)
          (if (kern-conv-get-yes-no? kpc)
              (begin
                (say knpc "겼Ȱ櫓ͤ"
                     "ۤõͤʤۤ"
                     "Ĥäۤ򸫤ĤФ"
                     "Фɤˤ뤫Ƥ"
                     "Ϥʡ")
                (if (kern-conv-get-yes-no? kpc)
                    (begin
                      (say knpc "Ωह٤Ԥ衣")
                      (quest-accepted! quest #t)
                      (ghertie-give-instr knpc kpc))
                    (say knpc "ñ˷󤷤ʤΤϤȤ"
                         "ˤäۤ򤳤Ԥ³뤳Ȥˤʤ뤫ʡ")))
              (begin
                (say knpc "ʤڡʡХϺ")
                (kern-conv-end)))))))

(define (ghertie-fort knpc kpc)
  (say knpc "⡢Сˡʪ˳Ǥ")
	(quest-data-assign-once 'questentry-rune-c)
	)

(define ghertie-conv
  (ifc basic-conv

       ;; basics
       (method 'default ghertie-default)
       (method 'hail ghertie-hail)
       (method 'bye ghertie-bye)
       (method 'job ghertie-job)
       (method 'name ghertie-name)
       (method 'join ghertie-join)
       
       ;; special
       (method 'pira ghertie-pira)
       (method 'betr ghertie-betr)
       (method 'crew ghertie-betr)
       (method 'ship ghertie-ship)
       (method 'haun ghertie-haun)
       (method 'curs ghertie-curs)
       (method 'grav ghertie-grav)
       (method 'fort ghertie-fort)
       (method 'reve ghertie-reve)

       ))

(define (mk-ghertie)
  (bind 
   (kern-mk-char 'ch_ghertie           ; tag
                 "ƥ"            ; name
                 sp_ghast            ; species
                 oc_warrior                 ; occ
                 s_ghost               ; sprite
                 faction-men         ; starting alignment
                 0 0 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 6  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'ghertie-conv         ; conv
                 sch_ghertie           ; sched
                 nil                 ; special ai
                 nil                 ; container
                 nil                 ; readied
                 )
   (ghertie-mk)))
