;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define gholet-lvl 4)
(define gholet-species sp_human)
(define gholet-occ nil)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥϲδƹ
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (gholet-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; åȤϤĤƤϳ±ǡϥ饹ɥϲδƹˤ롣
;; ϻῼξȰĤΰͤǡ˴ȤʤäƥĹ
;; ΤɤƤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (gholet-hail knpc kpc)
  (say knpc "衼öᤢ"))

(define (gholet-default knpc kpc)
  (say knpc "ΤȤǤ줬öΤꡪ"))

(define (gholet-name knpc kpc)
  (say knpc "åȤǤǤⵤˤʤǤöᡣ")
  (quest-data-update 'questentry-ghertie 'gholet-dungeon 1))

(define (gholet-join knpc kpc)
  (say knpc "ǤäФǤäơХХ䡪"))

(define (gholet-job knpc kpc)
  (say knpc "äȡͤ䡢ä"
       "ˤ衢ǸƤ̤οŷǤ"))

(define (gholet-bye knpc kpc)
  (say knpc "򤤤äǡöᡣ"))

;; Tier 2 replies
(define (gholet-cook knpc kpc)
  (say knpc "ͭ̾ʹڵͤä櫓衪"
       "ῼ桢ʹȤ뤫")
  (if (yes? kpc)
      (say knpc "㤢ͭ̾äƸä")
      (say knpc "Τͭ̾ä"
           "ɤʤäƤ뤫Ϥ狼ͤ")))

(define (gholet-merc knpc kpc)
  (say knpc "ƬϤФ餷ä"
       "ƥäƤ"))

(define (gholet-gher knpc kpc)
  (say knpc "äꤤƬϤͤ"))

(define (gholet-voca knpc kpc)
  (say knpc "줬ޤǤǰֳڤʻŻǤ"))

(define (gholet-mean knpc kpc)
  (say knpc "ߡˡΥȤĹȲäƤͤʡ"
       "ϱäƤʹʤ"))

(define (gholet-jorn knpc kpc)
  (say knpc "Ĥˤ٤衢öᡣ"
       "ϤΤޤޤˤƤʤ衣"))

(define (gholet-dog knpc kpc)
  (say knpc "򤭲ǿƤʹʤ")
  (quest-data-update 'questentry-ghertie 'jorn-loc 1))

;; Quest-related
(define (gholet-ring knpc kpc)

  (if (not (in-inventory? knpc t_skull_ring_g))
      (say knpc "ءλء")
      (begin

        (define (take-picklocks)
          (if (< (num-in-inventory kpc t_picklock) 12)
		(begin
		(quest-data-update-with 'questentry-ghertie 'gholet-price 1 (quest-notify nil))
              (say knpc "ࡢ꤬ʤöᡣ"
                   "ƻ­ͤ衣"
                   "Ǥ⤳λؤϼ֤ˤƤ衣")
		   )
              (begin
                (say knpc "󤿤ϻäƤϽФƤ"
                     "ޤäޤäؤڤǤ졢öᡪ")
                (kern-obj-remove-from-inventory kpc t_picklock 12)
                (kern-obj-add-to-inventory knpc t_picklock 12)
                (kern-obj-remove-from-inventory knpc t_skull_ring_g 1)
		(skullring-g-get nil kpc)
		)))

        (say knpc "θŤ֥ĤڤƤ礦ͤ"
             "ĤΤˤͤ"
             "Ĥϳؤˤ"
             "ͤߤ")
        (if (yes? kpc)
            (begin
              (say knpc "ˤʤ衣"
                   "Ĥˤʪ"
                   "Ǥ⡢Ȥ򤹤СȤˤʤä֤äƤ롣"
                   "öᡩ")
              (if (yes? kpc)
                  (begin
                    (say knpc "󤽤ʤöᡪ"
                         "ĻĤäƥĤ衪"
                         "ƻ1ƻ1ХĤϤ󤿤Υ"
                         "ɤ衩")
                    (if (yes? kpc)
                        (take-picklocks)
                        (begin
			(quest-data-update-with 'questentry-ghertie 'gholet-price 1 (quest-notify nil))
                          (say knpc "줬λؤʤ"
                               "ʧˤʤäޤƤ졣")
                          (kern-conv-end))))
                  (begin
                    (say knpc "ä鵢ʤ衣")
                    (kern-conv-end))))
            (say knpc "㤴㤤䤬äơ"
                 "λؤΤˤ褿ΤΤäƤ")))))
      
(define gholet-conv
  (ifc basic-conv

       ;; basics
       (method 'default gholet-default)
       (method 'hail gholet-hail)
       (method 'bye  gholet-bye)
       (method 'job  gholet-job)
       (method 'name gholet-name)
       (method 'join gholet-join)
       
       ;; other responses
       (method 'cook gholet-cook)
       (method 'merc gholet-merc)
       (method 'gher gholet-gher)
       (method 'voca gholet-voca)
       (method 'ring gholet-ring)

       (method 'mean gholet-mean)
       (method 'jorn gholet-jorn)
       (method 'dog  gholet-dog)
       ))

(define (mk-gholet)
  (bind 
   (kern-char-force-drop
   (kern-mk-char 
    'ch_my           ; tag
    "å"             ; name
    gholet-species         ; species
    gholet-occ              ; occ
    s_brigand     ; sprite
    faction-men      ; starting alignment
    1 0 3            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health; hp
    -1                   ; xp
    max-health ; mp
    0
    gholet-lvl
    #f               ; dead
    'gholet-conv         ; conv
    nil              ; sched
    nil              ; special ai
    ;;..........container (and contents)
    (mk-inventory
              (list
               (list 1 t_skull_ring_g)
               ))
    nil              ; readied
    )
   #t)
  (gholet-mk)))
