;;----------------------------------------------------------------------------
;; gregor.scm - úƤͤΥ쥴
;;----------------------------------------------------------------------------
;;----------------------------------------------------------------------------
;; Schedule
;; 
;; κ (moongate-clearing.scm)
;; 쥴ξ (gregors-hut.scm).
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_gregor
               (list 0  0  gh-gregors-bed   "sleeping")
               (list 6  0  gh-graveyard     "idle")
               (list 7  0  mgc-roadbend     "idle")
               (list 13 0  gh-table-2       "eating")
               (list 14 0  gh-pasture       "working")
               (list 17 0  gh-table-2       "eating")
               (list 18 0  gh-living-room   "idle")
               (list 20 0  gh-gregors-bed   "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
(define (gregor-mk) (list (mk-quest)))
(define (gregor-quest gob) (car gob))


;;----------------------------------------------------------------------------
;; Conv
;; 
;; 쥴úƤͤϷͤǡκŤζ᤯˽Ǥ롣
;; ϺŤζ᤯ˤ褯롣¹̼Υꥢä򤷤Ƥ롣
;; 
;; 쥴ϥץ쥤䡼ǽ˲NPCǤ롣ơƥץ졼Ԥ¿
;; ̤ʽˤʤ򤹤롣
;;----------------------------------------------------------------------------

(define (gregor-kill-nate knpc kpc)
  (say knpc "Υ쥴Ͽ̤ؤͥȤ˸ϤϤΤ롣")
  (aside kpc 'ch_nate "ΤĤ֤䤭ϤϷܤϲġ")
  (prompt-for-key)
  (say knpc "ϴʪФϤˤ¿ʧä亮ˤɤ̤ɤФ褤϶ä")
  (aside kpc 'ch_nate "ԤơĤϡġ")
  (prompt-for-key)
  (say knpc "󡦥<Xen Corp>")
  (cast-missile-proc knpc ch_nate t_deathball)
  (aside kpc 'ch_nate "á")
  (prompt-for-key)
  (if (equal? kpc ch_nate)
      (kern-conv-end)
      (say knpc "Ͽ֤äϤΤ褦ʼԤȤ٤ǤϤʤä͡ϤʤˤĤƤ褫̹ͤ"))
  )
  

(define (gregor-hail knpc kpc)
  (if (in-player-party? 'ch_nate)
      (gregor-kill-nate knpc kpc)
      (if (in-inventory? kpc t_letter_from_enchanter)
           (say knpc "ʪäƤ褦ʡƻդμ椬롣"
                "Τ˺ƤϤʤ̡"
                "ϤȤƤ")
           (say knpc "ΤʤȱޤפϷͤȲä\n"
                "褦¤ͤ衣ȻפäƤ"
                "ʤλʪϡƶˤ롣"
                "ԤäȢ򳫤ʪäƤ졣"
                "ƤʤΤʪ"))
      ))

;; Some prompting with initial commands:
;; 
;; Hmmm...perhaps it would be desirable to have game-UI promts
;; spoken out-of-character, so that the NPCs don't break the game fiction...
(define (gregor-open knpc kpc)
  (say knpc "Ȣ^c+b^c-Τ'o'"))

(define (gregor-get knpc kpc)
  (say knpc "'g'֤줿Τ^c+b^c-ȤǤ롣"))

(define (gregor-read knpc kpc)
  (say knpc "ɶ'r'^c+b^c-"
       "Ƥʤ襤ǻȤȤǤʤ"))

(define (gregor-camp knpc kpc)
  (say knpc "'k'^c+b©^c-ϤǤ롣"))


(define (gregor-dang knpc kpc)
  (say knpc "ȤƤ⤷ɬפʤ顢Įνɤʾ"
       "ǵ©뤳ȤǤ뤬ͤǸĥ֤ʤΤϴ"
       "̵ʸǲ뤳ȤǤ롣"))

(define (gregor-dead knpc kpc)
  (say knpc "ᤷȤ亮̼Ȥפ϶ˡ"
       "ȥɤ˻줿Τ"))

(define (gregor-charcoal knpc kpc)
  (say knpc "úĮػäƹԤ롣"
       "줫¼μԤ亮ν㤤롣"))

(define (gregor-hut knpc kpc)
  (say knpc "οˤ롣"
       "ǥ亮¹̼ȽǤ롣"))

(define (gregor-ench knpc kpc)
  (quest-data-assign-once 'questentry-calltoarms)
  (say knpc "ƻդϸԤΰͤ"
       "亮ˤʤΤ褦¤ͤõ褦˸äƤ"
       "ƻդβƳͤФʤ̡ƻΤꤿ")
  (quest-wise-subinit 'questentry-enchanter)
  (quest-data-update 'questentry-enchanter 'common 1)
  (cond ((yes? kpc)
         (quest-data-update 'questentry-calltoarms 'directions 1)
         (quest-data-update 'questentry-enchanter 'general-loc 1)
         (say knpc "ƻդλθˤ¤ˤ롣"
	      "ؿʤߡƻ򤿤ɤꡢˤ˿ҤͤȤ褤")
	  )
         (else 
          (say knpc "˾ʤ顣ɬפˤʤä顢ƻաפȿҤͤʤ")
          )
        ))

(define (gregor-cave knpc kpc)
  (say knpc "ƻʬ줿٤ƻ򤿤ɤäʤ"
       "Ȣ򳫤ʪäƤ졣"
       "ޤʹȤСäƤä"))

(define (gregor-ches knpc kpc)
  (say knpc "Τޤ޿ʤǡʪäƤ졣"))

(define (gregor-stuf knpc kpc)
  (say knpc "¼μԤʪ򤷤롣ޤĤ¤ͤȹͤƤʡ"))

(define (gregor-leav knpc kpc)
  (say knpc "Υ줿ʤ顢ƻؿʤФ褤"))

(define (gregor-band knpc kpc)
  (let ((quest (gregor-quest (kobj-gob-data knpc))))
    (cond ((quest-accepted? quest)
           (say knpc "±ɤΤͤϸĤä")
           (cond ((yes? kpc)
                  (say knpc "Ť衢դޤ")
                  (quest-done! quest #t)
                  )
                 (else 
                  (say knpc "ФعԤ±ˤĤʹȤ褤")
                  )))
          (else
           (say knpc "±ɤ⤬ˤΤ"
                "ĤϤĤƥ亮ξӤ餷褿Ȥ롣"
                "亮ϤĤä"
                "Τ­ʤ󤬤褦ˤʤä")
           (prompt-for-key)
           (say knpc "亮ˤϰ˽Ǥ¹̼롣"
                "ޤʻҶʤȤϰĤϤʤ"
                "Ĥ餬ޤ뤳Ȥ򶲤Ƥ롣")
           (prompt-for-key)
           (say knpc "Τ褦ʤȤߤϤʤĤ¤ͤ¼μԤʹ亮Ƥ")
           (cond ((yes? kpc)
                  (say knpc "꤬Ȥ"
                       "äʤ顢ФعԤȤ褤"
                       "±ΤȤҤͤ"
                       "꤬ʬ뤫⤷")
                  (quest-data-assign-once 'questentry-bandits)
                  (quest-accepted! quest #t)
                  )
                 (else
                  (say knpc "ᤷ˵ä")
                  (kern-conv-end)
                  ))))))

(define (gregor-bye knpc kpc)
  (let ((quest (gregor-quest (kobj-gob-data knpc))))
    (cond ((quest-accepted? quest)
           (say knpc "ĤΤ"))
          (else
           (say knpc "ԤäƤ졪ߤΤ")
           (prompt-for-key)
           (gregor-band knpc kpc)
           ))))

(define (gregor-fore knpc kpc)
  (say knpc "οȤ˹ԤäƤϤʤ̡±⡢Τɤ⤬롣"))

(define gregor-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default (lambda (knpc kpc) (say knpc "ϼǤʡ")))
       (method 'hail gregor-hail)
       ;;(method 'heal (lambda (knpc kpc) (say knpc "γФ餤¹̼Ϥ褯äƤƤ롣")))
       (method 'bye gregor-bye)
       (method 'job (lambda (knpc kpc) (say knpc "亮úƤͤƤκŤδ⤷Ƥ롣")))
       (method 'join (lambda (knpc kpc) (say knpc "䡢亮ˤ̤λŻ롣")))
       (method 'name (lambda (knpc kpc) (say knpc "亮̾ϥ쥴")))

       (method 'open gregor-open)
       (method 'get  gregor-get)

       (method 'cave gregor-cave)
       (method 'ches gregor-ches)

       (method 'stuf gregor-stuf)
       (method 'equi gregor-stuf)  ;; A synonym
       (method 'gear gregor-stuf)  ;; A synonym

       (method 'read gregor-read)
       (method 'dang gregor-dang)

       (method 'camp gregor-camp)
       (method 'kamp gregor-camp) ;; A synonym

       (method 'band gregor-band)
       (method 'leav gregor-leav)

;; SAM -- This response seems to be shadowed by the gregor-band declaration above?
       (method 'band (lambda (knpc kpc) (say knpc "A band of rogues been raiding the shrine "
                                             "when I'm not around. They haven't attacked me, "
                                             "so they're probably just vagabonds, "
                                             "afraid of an old man's cudgel.")))

       (method 'char gregor-charcoal)
       (method 'burn gregor-charcoal)  ;; A synonym

       (method 'daug (lambda (knpc kpc) (say knpc "̼ϤȾƤΤ褦ˤʤ줿"
                                             "ǽϤäʬ˸ԤȤʤä")))
       (method 'dead gregor-dead)
       (method 'ench gregor-ench)
       (method 'folk (lambda (knpc kpc) (say knpc "ȻȤФäƤΤ")))
       (method 'fore gregor-fore)
       (method 'wood gregor-fore)
       (method 'gate (lambda (knpc kpc) (say knpc "줬ĳΤ"
                                             "Ƥ˲Τϡïʬ̡"
                                             "ˤ̤礬ʹȤ롣"
                                             "äϱΤ˺Ƥޤä")))
       (method 'gran (lambda (knpc kpc) (say knpc "亮ˤϥꥢȤ̾¹̼롣")))
       (method 'help (lambda (knpc kpc) (say knpc "¼ˤϤĤƤԤ롣"
                                             "ѤʾǡѤʻ")))
       (method 'hill (lambda (knpc kpc) (say knpc "ȥɤϾ˵֤򶼤Ƥ"
                                             "ΤȤäˤ")))
       (method 'husb (lambda (knpc kpc) (say knpc "̼̻Ϥפä"
                                             "ʤȥɤ˽줿Τʬ"
                                             "⤷ȤĤϲԤ˵֤ɤ줿ΤΤ̡")))
       (method 'hut gregor-hut)
       (method 'ilya (lambda (knpc kpc) (say knpc "ϰ˽Ǥ롣"
                                             "λҤξƤϻǤޤä")))

;; SAM: I dont' see any reference to this lake anywhere, commenting this one out for now...
;;       (method 'lake (lambda (knpc kpc) (say knpc "Exit this shrine and ye'll find yourself in a "
;;                                             "hidden valley. Head south and you'll see the Gray Lake "
;;                                             "to the west.")))

       (method 'offe (lambda (knpc kpc) (say knpc "ƶȢ롣"
                                             "椫äƤ졣¤ͤϤۤȤʪˤˤ롣"
                                             "ƴͤϤФ餷Ԥ򤷤"
                                             ""
                                             "¼μԤϼΤʪ֤ƤΤ")
                                             (quest-data-update 'questentry-whereami 'wanderer 2)
       										))
       (method 'pare gregor-dead)
       (method 'plac gregor-hut)

       (method 'shar (lambda (knpc kpc) (say knpc "ɡϤ亮ϤƤǤ롣¤ͤ衣")
       				(quest-data-update 'questentry-whereami 'shard 1)
       			))

       (method 'shri (lambda (knpc kpc) (say knpc "κŤ̤äƤԤΤˤ롣"
                                             "ʤΤ褦¤ͤΤˤ"
                                             "¼μԤϡʤιɬפʪ򶡤ʪȤ֤ƤΤ")
                                             (quest-data-update 'questentry-whereami 'wanderer 1)
       											))

       (method 'spid (lambda (knpc kpc) (say knpc "αˤϲʪΤ褦ʥ⤬롣ͺۤɤ礭"
					     "󥰥ꥹλҶ亮ϤƤǤ롣")))
       (method 'angr (lambda (knpc kpc) (say knpc "θ"
					     "ƤΥ졢"
                                             "Ҷݤ餻Ҷʤͤˤ뤿ΤΤ")))

       (method 'town (lambda (knpc kpc) (say knpc "ȥꥰ쥤ֶ֤ᤤĮ"
					     "ƻ˱äƤ¤ȤϤʤ")))

       (method 'trol (lambda (knpc kpc) (say knpc "ȥ¼μԤ򿩤"
					     "ꡢοޤǿäƤޤΤ"
					     "ˤϲĤƤʤä")))

       (method 'wand (lambda (knpc kpc) (say knpc "亮̤äԤ¤ͤȸƤǤ롣"
                                             "μԤɤơɤعԤΤïΤ̡"
                                             "ʤϤĹĹƻΤνˤΤ")
                                             (quest-data-update 'questentry-whereami 'wanderer 1)
       										))

       (method 'wise (lambda (knpc kpc) (say knpc "Ԥ϶ƤۤȤɤԤ"
                                             "ϤǤ¤ꤳϤ"
					     "Ƽ줿ԤäƤ롣")))
       (method 'accu (lambda (knpc kpc) 
                       (say knpc "줿ԡ蘆ǤϤΤ˺ä餷"
                            "⤷ԤʤСΥɤϤĤƧߤˤ˰㤤ʤ")))

       (method 'witc (lambda (knpc kpc) (say knpc "ǤϤնǤϤʤ褦")))
       ))

;;----------------------------------------------------------------------------
;; Ctor
(define (mk-gregor)
  (bind 
   (kern-mk-char 'ch_gregor ; tag
                 "쥴"        ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_old_townsman          ; sprite
                 faction-men         ; starting alignment
                 0 10 5              ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 2  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'gregor-conv        ; conv
                 sch_gregor          ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
					   (list t_axe
					         t_armor_leather
					         )              ; readied
                 )
   (gregor-mk)
   ))
