;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;;
;; ȥꥰ쥤
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_gwen
               (list 0  0  trigrave-gwens-bed        "sleeping")
               (list 8  0  trigrave-tavern-table-1a  "eating")
               (list 9  0  trigrave-inn-counter      "working")
               (list 13 0  trigrave-tavern-table-1d  "eating")
               (list 14 0  trigrave-inn-counter      "working")
               (list 20 0  trigrave-tavern-table-1a  "eating")
               (list 21 0  trigrave-inn-counter      "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (gwen-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ٥Ͻɲμͤǡͥ¿Ǥ롣
;;----------------------------------------------------------------------------
(define (gwen-trade knpc kpc)
  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "ŹƤȤƤ"
           "ɲֳȷפϤĮˤޤ"
           "9˳ơŹޤ")
      (let ((door (eval 'trigrave-inn-room-1-door)))
        ;; is the room still open?
        (if (not (door-locked? (kobj-gob door)))
            ;; yes - remind player
            (say knpc "ʤΤϤ⤦Ƥޤ")
            ;; no - ask if player needs a room
            (begin
              (say knpc "ѤǤ")
              (if (kern-conv-get-yes-no? kpc)
                  ;; yes - player wants a room
                  (begin
                    (say knpc 
                         "϶" trigrave-inn-room-price "硢"
                         "Įˤ֡٤ǤǤޤ"
                         "Ǥ")
                    (if (kern-conv-get-yes-no? kpc)
                        ;; yes - player agrees to the price
                        (let ((gold (kern-player-get-gold)))
                          ;; does player have enough gold?
                          (if (>= gold trigrave-inn-room-price)
                              ;; yes - player has enough gold
                              (begin
                                (kern-player-set-gold 
                                 (- gold 
                                    trigrave-inn-room-price))
                                (say knpc "1漼Ǥäɤ")
                                (send-signal knpc door 'unlock)
                                (kern-conv-end)
                                )
                              ;; no - player does not have enouvh gold)
                              (say knpc "ǰǤ⤬­ޤ")))
                        ;; no - player does not agree to the price
                        (say knpc 
                             "ɤɤϡȾˤϤޤ衪")))
                  ;; no - player does not want a room
                  (say knpc "ޤεˤɤ")))))))

(define (gwen-thie knpc kpc)
  (say knpc "Ф㤫Ƕ褿ҤλƻǤȤƤޤǤͤ򸫤Ǥ衣ФΤʹƤߤФ褤⤷ޤ")
  (quest-data-update-with 'questentry-thiefrune 'tower 1 (quest-notify (grant-party-xp-fn 10)))
  )

(define (gwen-news knpc kpc)
  (say knpc "ƻդפʤΤʤǤ衣"))

(define gwen-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default (lambda (knpc kpc) 
                          (say knpc "ǰʤ餪Ǥޤ")))
       (method 'hail
               (lambda (knpc kpc)
                 (kern-print "Τʤϳ夿̥ŪʽȲä"
                             "Υ٥ȤˤϺ٤Ĺ^c+m^c-롣\n")
                 (say knpc "褦ι")))
       (method 'bye (lambda (knpc kpc) (say knpc "꤬Ȥޤ")))
       (method 'job 
               (lambda (knpc kpc) 
                 (say knpc "ȥꥰ쥤֤νɲ򤷤Ƥޤ")
                 (gwen-trade knpc kpc)))
       (method 'name (lambda (knpc kpc) (say knpc "ϥ٥Ǥ")))
       (method 'trad gwen-trade)
       (method 'join 
               (lambda (knpc kpc) 
                 (say knpc "ιϤ⤦ޤ"
                      "Ǥ⡢Ͷ꤬Ȥޤ")))
       (method 'chan
               (lambda (knpc kpc)
                 (say knpc "ΤĴҼԤʤϼˤޤ"
                      "٤ʤߤ˿ääƤޤ")))
       (method 'civi 
               (lambda (knpc kpc) 
                 (say knpc "ΤΤȤäԻԤοͤϤޤꤤޤ")))
       (method 'earl
               (lambda (knpc kpc)
                 (say knpc "ŨʡǤʪ˺η㤷ϷͤǤ"
                      "ϻνɤŹڤꤷƤޤ")))
       (method 'enem 
               (lambda (knpc kpc) (say knpc "ʤˤϴطΤʤȤǤ")))
       (method 'esca 
               (lambda (knpc kpc)
                 (say knpc "⤷ŨѤ٤ԤȤ򱣤ʤ顢"
                      "Υɤ˺줿ϤɤϤʤǤ礦")))
       (method 'inn  
               (lambda (knpc kpc)
                 (say knpc "ɲϳڤŻǤ"
                            "ιͤ鿧äʹޤ顣")))
       (method 'jim
               (lambda (knpc kpc)
                 (say knpc "ϥ󥵥ʡǤ⾯ӤäݤͤǤ"
                      "ü결ĤǤޤ")))
       (method 'news gwen-news)
       (method 'stor gwen-news)
       (method 'room gwen-trade)
       (method 'sham 
               (lambda (knpc kpc) (say knpc "ʤˤϴطΤʤȤǤ")))
       (method 'swor
               (lambda (knpc kpc) 
                 (say knpc "ͧͤΤǤ")))
       (method 'tave
               (lambda (knpc kpc)
                 (say knpc "۵աפϤĮ¦ˤޤ")))
       (method 'thie gwen-thie)
       (method 'trig 
               (lambda (knpc kpc) 
                 (say knpc "ԻԤΥ줿ĮǤ"
                      "οͤƨ뤿ˤˤޤ")))

       ))
