;;----------------------------------------------------------------------------
;; Schedule
;;
;; ܥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_hackle
               (list 0  0  bole-hackles-hut "idle")
               (list 2  0  bole-bed-hackle "sleeping")
               (list 10 0  bole-hackles-hut "idle")
               (list 20 0  bole-hackles-yard "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (hackle-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ϥåǥܥ˽Ǥ롣
;; ϱвäˤäǤդ줿
;; ˤϤޤŤǽϤ롣
;;----------------------------------------------------------------------------
(define (hackle-trade knpc kpc)
  (say knpc "Ϥ줫ͧŤ뤳ȤǤ롣"
       "̿ϤȤ˶Ҥ׵᤹롣Ʊդ뤫")
  (define (hackle-heal)
    (say knpc "ϤɤŤ뤫")
    (let ((kchar (kern-ui-select-party-member)))
      (if (null? kchar)
          (say knpc "Ϥ̤β򤹤뤫")
          (let* ((gold (kern-player-get-gold))
                 (pts (- (kern-char-get-max-hp kchar)
                         (kern-char-get-hp kchar))))
            (if (= 0 gold)
                (say knpc "⤬ʤ̿ʤ줬ˡ")
                (begin
                  (if (= 0 pts)
                      (say knpc "Ϥ褯ʤäϤˤ뤳ȤϤ⤦ʤ")
                      (let ((n (min gold pts)))
                        (say knpc "ϼŤ")
                        (kern-obj-heal kchar n)
                        (kern-player-set-gold (- gold n))))
                  (say knpc "̤ΤŤ뤫")
                  (if (kern-conv-get-yes-no? kpc)
                      (hackle-heal)
                      (say knpc "ʤФ̤ΤΤ˾ࡣ")
                      )))))))
  (if (kern-conv-get-yes-no? kpc)
      (hackle-heal)
      (say knpc "ϤƻԤ")))
                   
              
        

;; basics...
(define (hackle-default knpc kpc)
  (say knpc "ϤǤʤ"))

(define (hackle-hail knpc kpc)
  (if (in-player-party? 'ch_mesmeme)
      (begin
        (say knpc "ϥ᥹򸫤ȶݤǽ̤ޤäϤä")
        (aside kpc 'ch_mesmeme "")
        )
      (say knpc "[ʤȱ줿ǯνȲä] Ȳä"
           "Ƥ롪")
  ))

(define (hackle-name knpc kpc)
  (say knpc "ϥϥå롣"))

(define (hackle-job knpc kpc)
  (say knpc "϶äƤ롪ϼŤǤ롪"))

(define (hackle-join knpc kpc)
  (say knpc "֤ˤϤʤʤӤ򵤤ˤƤ롪"))

(define (hackle-bye knpc kpc)
  (say knpc "Ϥ褦ʤȸäϤ줬äƤ뤳ȤΤäƤ롪"))


;; other characters & town...
(define (hackle-may knpc kpc)
  (say knpc "ϤĤϥåˤϤĤڤǤ롪"))

(define (hackle-kath knpc kpc)
  (say knpc "֤夿夿⡪"))

(define (hackle-bill knpc kpc)
  (say knpc "ΨĤڤοϤͼˤ"))

(define (hackle-thud knpc kpc)
  (say knpc "ϾФäϤϴǤϤʤ"
       "ͤȤƸƤФ줿ԡǤ롣"))

(define (hackle-melv knpc kpc)
  (say knpc "Ǥ롣"))

(define (hackle-bole knpc kpc)
  (say knpc "ܥ(Bole)ǤϤʤۡ(Hole)Ǥ롪ؤθꡪΤäƤ롪"))

;; misc...
(define (hackle-mesm knpc kpc)
  (say knpc "ϤλҶǤ롣Ʊ²μԤȤϸʹʤ"
       "Ϥͤˤ")
  (aside kpc 'ch_mesmeme "ˤ餺")
  )

(define (hackle-shee knpc kpc)
  (say knpc "Ӥäϵ"
       "ӤĤȤɤΤ褦ϵʤ뤫"))

(define (hackle-wood knpc kpc)
  (say knpc "ϸŤߤڤǤ򸫤ϵʤä"
       "򹥤ޤʤƤ򹥤ޤʤ"
       "֥ϤŤ᤿ϤθդΤʤ"))

(define (hackle-mad knpc kpc)
  (say knpc "ҶΤȤ館ƨ"
       "οƨ٤줿"))

(define (hackle-gaze knpc kpc)
  (say knpc "⤷äʤ顢ϤʤǤ⻦ʤФʤʤ"
       "Ϥʤ䤤ΤäƤ롣ƤϹ«롪")
  (aside kpc 'ch_mesmeme "԰¤˽֤Ƥ롣")
)

;; thief quest...
(define (hackle-thie knpc kpc)
  (say knpc "Ͽ˶ʤ餺Ԥѻդåä"))

(define (hackle-robs knpc kpc)
  (say knpc "åξʥͥߤηä"))

(define (hackle-hole knpc kpc)
  (say knpc "椬\n"
       "'o'ˤϷ(hole)롪\n"
       "Ʒˤ'o'롪\n"
       "ƥͥ(mouse)ˤξ롪\n"
       "\n"
       "ϹԤ\n"
       "^c+mɽ^c-狼뤫")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ʤФ^c+mɽ^c-򤻤衪")
      (begin
        (say knpc "<Wis Quas>֤ѤϴʪäƤ롣äƤʤ")))
  )

(define (hackle-reve knpc kpc)
  (say knpc "ӥ˷ϥͥߤɤ˾äΤäƤ롪"
       "^c+mɽ^c-"))

(define (hackle-midd knpc kpc)
  (say knpc "桪"))

(define hackle-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default hackle-default)
       (method 'hail hackle-hail)
       (method 'bye  hackle-bye)
       (method 'job  hackle-job)
       (method 'name hackle-name)
       (method 'join hackle-join)

       (method 'trad hackle-trade)
       (method 'buy hackle-trade)
       (method 'sell hackle-trade)
       (method 'heal hackle-trade)

       (method 'bill hackle-bill)
       (method 'kath hackle-kath)
       (method 'red  hackle-kath)
       (method 'bitc hackle-kath)
       (method 'may  hackle-may)
       (method 'melv hackle-melv)
       (method 'thud hackle-thud)
       
       (method 'bole hackle-bole)
       (method 'gaze hackle-gaze)
       (method 'god  hackle-wood)
       (method 'gods hackle-wood)
       (method 'hole hackle-hole)
       (method 'mad  hackle-mad)
       (method 'mesm hackle-mesm)
       (method 'migh hackle-robs)
       (method 'mous hackle-hole)
       (method 'reve hackle-reve)
       (method 'rob  hackle-robs)
       (method 'robs hackle-robs)
       (method 'wrog hackle-robs)
       (method 'wiza hackle-robs)
       (method 'shee hackle-shee)
       (method 'thie hackle-thie)
       (method 'wood hackle-wood)
       (method 'midd hackle-midd)
       (method 'nigh hackle-midd)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-hackle)
  (bind 
   (kern-mk-char 'ch_hackle          ; tag
                 "ϥå"          ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_beggar             ; sprite
                 faction-men         ; starting alignment
                 0 0 1            ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 6  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'hackle-conv        ; conv
                 sch_hackle          ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
                 nil                 ; readied
                 )
   (hackle-mk)))
