;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ѡ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_henry
               (list 0  0  bilge-water-bed     "sleeping")
               (list 8  0  bilge-water-counter "working")
               (list 23 0  bilge-water-bed     "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (henry-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; إ꡼ϥѡҼμμǡǤ롣
;; ϤĤƶǤä
;;----------------------------------------------------------------------------

;; Basics...
(define (henry-hail knpc kpc)
  (say knpc "Τʤ۵ʡҼ꤬ˤȲä"
       "褪"))

(define (henry-default knpc kpc)
  (say knpc "ʹƤ褦ʤ"))

(define (henry-name knpc kpc)
  (say knpc "ϥإ꡼Υإ꡼"))

(define (henry-join knpc kpc)
  (say knpc "٤ʡ㤤Ρ"
       "줬ФƹԤäïǴʡ"))

(define (henry-job knpc kpc)
  (say knpc "ʤ줬һդˤʤäϤδ()"))

(define (henry-bye knpc kpc)
  (say knpc "ŷդ衪"))

(define henry-catalog
  (list
   (list t_food 5 "̾ʪΥ㥦­ޤǲʤ뤾")
   (list t_beer 5 "ǳڤ⤦Ȥī˻̤ȤƤ⡪")
   (list t_wine 7 "»ͤ褿ȤΤͥʥΤѰդƤ롣")
   ))

(define henry-merch-msgs
  (list "줤ޤä鲿Ф"
        "۵ˤ"
        "٤ߤϤ"
        "äƤ롪"
        "˾ʡ"
        "֥֥餷ʤ줬"
        "ǥ塼Ǥʡ"
        "ޤ"
        "ʢääƤʡ"
        "֥֥餷ʤ줬"
        ))

;; Trade...
(define (henry-buy knpc kpc) (conv-trade knpc kpc "buy" henry-merch-msgs henry-catalog))
(define (henry-sell knpc kpc) (say knpc "ϤǤ"))

;; Hook...
(define (henry-hook knpc kpc)
  (say knpc "Ϥʤʤäޤäζʪä衪"))

(define (henry-mons knpc kpc)
  (say knpc "顼ϥӤ򤢤äȸ֤˱ͤХǤ⤮ä"
       "ĤͦΤͤإӤΤ褦˱󤯤ϷäƤʤä"
       "ˤԤäȵۤդơĤ򿩤ˤä"))

(define (henry-serp knpc kpc)
  (say knpc "إӤĤȤϤ롣"
       "Ĥϲ¤ǡ󤯤Фζ̤ǤΤ򹥤ࡣ"))

;; Townspeople...
(define (henry-opar knpc kpc)
  (say knpc "Ϥ"))

(define (henry-gher knpc kpc)
  (say knpc "ݤΥƥʹʡ"
       "ŤĻҤͤƤ⤤ʤٹ1ĤƤ"
       "˴򤱤衪ĤܤƤ롪")
	(quest-data-assign-once 'questentry-ghertie))

(define (henry-ghos knpc kpc)
  (say knpc "ϻͤǤäѤƤβͤϥƥˤΤ"
       "롢Ĥ餬ǭΤ褦˲ʤʪõΤ򸫤Ȥ롪"
       "٤Ԥϻƥإ꡼νɤ˵¤ä")
	(quest-data-assign-once 'questentry-ghertie))

(define (henry-alch knpc kpc)
  (say knpc "ʥĤ"))

(define (henry-bart knpc kpc)
  (say knpc "ǡϥСȤϤȾǺǹ¤ͤ"
       "δ꤫ꡢǡϤͣ¤ͤǤ⤢롪"))

(define (henry-seaw knpc kpc)
  (say knpc "襤̼ΦεΤ褦ѤԤ"))

(define (henry-osca knpc kpc)
  (say knpc "ߤǡʹͤΥĤǤ⤳Ǥϰ˰Ǥ롣"))

(define henry-conv
  (ifc basic-conv

       ;; basics
       (method 'default henry-default)
       (method 'hail henry-hail)
       (method 'bye  henry-bye)
       (method 'job  henry-job)
       (method 'name henry-name)
       (method 'join henry-join)
       
       ;; trade
       (method 'trad henry-buy)
       (method 'buy  henry-buy)
       (method 'sell henry-sell)
       (method 'sacr henry-buy)

       ;; hand
       (method 'hook henry-hook)
       (method 'hand henry-hook)
       (method 'mons henry-mons)
       (method 'deep henry-mons)
       (method 'sea  henry-serp)
       (method 'serp henry-serp)

       ;; town & people
       (method 'opar henry-opar)
       (method 'alch henry-alch)
       (method 'gher henry-gher)
       (method 'ghas henry-gher)
       (method 'bart henry-bart)
       (method 'witc henry-seaw)
       (method 'lia  henry-seaw)
       (method 'osca henry-osca)

       ))

(define (mk-henry)
  (bind 
   (kern-mk-char 'ch_henry           ; tag
                 "إ꡼"          ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townsman          ; sprite
                 faction-men         ; starting alignment
                 1 0 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 6  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'henry-conv         ; conv
                 sch_henry           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_dagger)))     ; container
                 nil                 ; readied
                 )
   (henry-mk)))
