;;----------------------------------------------------------------------------
;; Schedule
;;
;; 쥴ξ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_ilya
               (list 0  0  gh-ilyas-bed   "sleeping")
               (list 6  0  gh-stable      "working")
               (list 7  0  gh-kitchen     "working")
               (list 12 0  gh-table-1     "eating")
               (list 13 0  gh-pasture     "working")
               (list 15 0  gh-all         "idle")
               (list 17 0  gh-table-1     "eating")
               (list 18 0  gh-living-room "idle")
               (list 20 0  gh-ilyas-bed   "sleeping"))

;;----------------------------------------------------------------------------
;; Gob
;;
;; ꥢ˴ؤϡβ²򻦤ȥ뤫ƨȤȤ֤˺
;; ϤΤ̤ߤõȤǤ롣Υե饰gob˳Ǽ롣
;;----------------------------------------------------------------------------
(define (ilya-mk gave-quest? finished-quest?) 
  (list gave-quest? finished-quest?))
(define (ilya-gave-quest? ilya) (car ilya))
(define (ilya-quest-done? ilya) (cadr ilya))
(define (ilya-give-quest ilya) (set-car! ilya #t))
(define (ilya-finish-quest ilya) (set-car! (cdr ilya) #t))

;;----------------------------------------------------------------------------
;; ѥ
;;
;; Puska -- ilya's stuffed horse toy -- is a quest item. Nothing special about
;; it really but it is unique and needs its own object type. The object itself
;; is declared in the p_abandoned_cellar constructor. But the type declaration
;; needs to be in a file that is reloaded, so here is as good a place as any.
;;----------------------------------------------------------------------------
(define puska-ifc
  (ifc '()
       (method 'get (lambda (kobj getter)
                      (kern-log-msg "ҶʤΤ˰㤤ʤ")
                      (kobj-get kobj getter)))))

(mk-obj-type 't_puska "ϤΤ̤" s_toy_horse layer-item puska-ifc)

;;----------------------------------------------------------------------------
;; Quest
;;
;; This is a single response in Ilya's conversation. I've called it our here
;; separately to make it obvious.
;;----------------------------------------------------------------------------
(define (ilya-quest knpc kpc)
  (let ((ilya (kobj-gob-data knpc)))
    (display ilya)(newline)
    (if (ilya-gave-quest? ilya)

        ;; yes - gave quest already
        (if (ilya-quest-done? ilya)
            (say knpc "ѥϺȤäƤ⹬")
            (begin
              (say knpc "ѥϸĤä")
              (if (kern-conv-get-yes-no? kpc)

                  ;; yes - puska found
                  (begin 
                    (say knpc "֤Ƥ롩")
                    (if (kern-conv-get-yes-no? kpc)

                        ;; yes - ilya may have puska
                        (if (kern-obj-has? kpc t_puska)

                            ;; yes - player has puska
                            (begin
                              (kern-obj-remove-from-inventory kpc t_puska 1)
                              (say knpc "衢ѥ"
                                   "⤦¿衣Ͽ֤äϤ꤬Ȥ餬ǤФɡ"
                                   "ԤäơäƤäơˡȤȤΤäơ줵󤬸äƤĤȤϤĤäƤΡ")
                              (ilya-finish-quest ilya)
                              (kern-obj-add-to-inventory kpc nightshade 23)
                              )

                            ;; no - puska not in player inventory
                            (begin
                              (say knpc "ε㤭ʤϤʤʤ")
                              (kern-conv-end)))

                        ;; no - ilya can't have puska
                        (begin
                          (say knpc "ͤˤʤäˡȤˤʤ롪"
                               "ƤʤäúˤƤΡ")
                          (kern-conv-end))))

                  ;; no - didn't find her yet
                  (begin
                    (say knpc "ξϤܤƤ롩")
                    (if (kern-conv-get-yes-no? kpc)
                        (say knpc "äȤˤΡ")
                        (say knpc "عԤäƻƻ̤ꡢ̤˵֤˹ԤФΡ"))))))

        ;; no - didn't give quest yet
        (begin
          (say knpc "ѥϻϤΤ̤ߤʤΡǤʤƤޤä"
               "Ĥ鶵Ƥ롩")
          (if (kern-conv-get-yes-no? kpc)
              (begin
                (say knpc "¦ؤƻ̤ε֤ˤ"
                     "ȥ˵Ĥơ")
                (ilya-give-quest ilya))
              (begin
                (say knpc "ѥäꤷ顢ͤˤʤäȤʤ򸫤Ĥ")
                (kern-conv-end)))))))

(define (ilya-join knpc kpc)
  (say knpc "ҶʤΤˡѤʤΡ")
  )

;;----------------------------------------------------------------------------
;; ưʪ
;;
;; Ilya has an odd relationship with spiders. She'll teach the player a spell
;; to ward off spiders if he plays along. Spiders will dominate the woods
;; around the Abandoned Farm (Ilya's old home). In fact, I intend to have them
;; locked in a battle with the trolls the first time the player enters the
;; Abandoned Farm. I'm planning on having a "great mother" spider known around
;; these parts as Angril or Angriss, perhaps she was one of Ilya's pets as a
;; child - I'm not sure how I want to play that one out yet.
;;----------------------------------------------------------------------------
(define (ilya-animals knpc kpc)
  (say knpc "ӤȡǭΥ㡼ȡܤäƤΡ"
       "ưʪϹ")
  (if (kern-conv-get-yes-no? kpc)

      ;; yes - the player likes animals
      (begin
        (say knpc "ɤưʪ")
        (let ((fav (kern-conv-get-string kpc)))
          (if (or (string=? fav "spider") (string=? fav ""))

              ;; yes - the player's favorite animal is spiders
              (begin
                (say knpc "⡪ɤнʤΤäƤΡ"
                     "ߤ")
                (if (kern-conv-get-yes-no? kpc)

                    ;; yes - the player wants to learn the spider ward
                    (say knpc "ñλǤ򺮤ơ"
                         "󡦥󡦥٥å<An Xen Bet>ȾΡ")

                    ;; no - the player does not want to learn the spider ward
                    (say knpc "Ǥͤ򽱤Ȥ⤢Τ衣")))
                    

              ;; no - the player's favorite animal is NOT spiders
              (say knpc "ϥ⤬"))))

      ;; no - the player does not like animals
      (say knpc "ݤʤ衪")))

(define (ilya-fire knpc kpc)
  (say knpc "Ф򤪤ΤϴñʤΡβ򺮤ơ"
       "βĳϤɤ"
       "ƥե<Vas Flam>ȸΡ"))

(define (ilya-died knpc kpc)
  (say knpc "ȥ뤬򽱤äΡ"
       "줵ϻϲ˱"
       "ƥȥ뤬Ƥ֤ȴФ"
       "Ǥ⡢ѥ˺Ƥޤäġ"))

;;----------------------------------------------------------------------------
;; Conv
;;----------------------------------------------------------------------------
(define ilya-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default (lambda (knpc kpc) (say knpc "Τʤ")))
       (method 'hail (lambda (knpc kpc) (say knpc "ˤϡ")))
       (method 'bye (lambda (knpc kpc) (say knpc "ХХ")))
       (method 'job (lambda (knpc kpc) (say knpc "μ򤷤ƤΡ")))
       (method 'name (lambda (knpc kpc) (say knpc "ꥢ")))
       (method 'age (lambda (knpc kpc) (say knpc "8С")))
       (method 'chor (lambda (knpc kpc) (say knpc "ưʪä򤷤ꡢФ򤪤ꡢꤹΡ")))
       (method 'anim ilya-animals)
       (method 'gran (lambda (knpc kpc) (say knpc "㤵Ȥ줵󤬻Ǥޤä顢ȽǤΡ")))
       (method 'died ilya-died)
       (method 'dead ilya-died)
       (method 'trol (lambda (knpc kpc) (say knpc "ȥͤˤʤäߤʻƤޤ")))
       (method 'hate (lambda (knpc kpc) (say knpc "ĤˡȤˤʤäơʤĤ򻦤Ƥޤ"
                                              "ޤƱȤäƤݤʤ")))
       (method 'afra (lambda (knpc kpc) (say knpc "ϲˤȤݤä"
                                                "㤵Ȥ줵󤬥ȥ˿٤줿Ȥʹ"
                                                "ޤǡϤ⤷ĤäƤ顢äƱ褦˿٤Ƥġ")))
       (method 'momm (lambda (knpc kpc) (say knpc "줵Ϥ⤦ʤФΤ򶵤Ƥ줿ȤפФ"
                                               "ȥ뤬äƤȤɤǳ䤷Ƥ")))
       (method 'dadd (lambda (knpc kpc) (say knpc "㤵Ϥ⤦ʤ"
                                               "ȥäɡɤ뤳ȤǤʤä")))
       (method 'pusk ilya-quest)
       (method 'home (lambda (knpc kpc) (say knpc "ã̤ˤϿäΡ")))
       (method 'spid (lambda (knpc kpc) (say knpc "Τοˤϥ⤬󤤤äơ󤬸äƤ")))
       (method 'wood (lambda (knpc kpc) (say knpc "ʤäơ󤬸äƤ")))
       
       (method 'fire ilya-fire)
       (method 'hi ilya-fire)
       (method 'vas ilya-fire)
       (method 'flam ilya-fire)
       (method 'greg (lambda (knpc kpc) (say knpc "Τ衣")))
       (method 'join ilya-join)
       ))

