;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_ini
               (list 0  0  gi-bed      "sleeping")
               (list 5  0  gs-altar    "idle")
               (list 6  0  gc-train    "working")
               (list 12 0  ghg-s2      "eating")
               (list 13 0  gc-hall     "working")
               (list 18 0  ghg-s2      "eating")
               (list 19 0  ghg-hall    "idle")
               (list 21 0  gi-bed      "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (ini-mk) (list 'townsman #f))
(define (ini-will-join? ini) (cadr ini))
(define (ini-will-join! ini) (set-car! (cdr ini) #t))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ˤΤǡ饹ɥ˽Ǥ롣
;; ƮΤιͤ¤ǡΰŻƤԤФܤ򴶤Ƥ롣
;; ˤ֤ˤʤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (ini-hail knpc kpc)
  (say knpc "ΤʤͫݵΤȲäϤ䤢"))

(define (ini-default knpc kpc)
  (say knpc "狼̡"))

(define (ini-notyet knpc kpc)
  (say knpc "̿ͤˤϤΤȤä٤ǤʤȹͤƤ롣"))

(define (ini-name knpc kpc)
  (say knpc "ʥϥˤȸƤǤ롣"))

(define (ini-join knpc kpc)
  (if (is-player-party-member? knpc)
      (say knpc "Ǥ֤Ԥ")
      (let ((ini (kobj-gob-data knpc)))
        (if (ini-will-join? ini)
            (begin
              (say knpc "꤬ȤΤӤꤷƤ֤ϤʤƮΤõФ")
              (kern-conv-end)
              (join-player knpc))
            (say knpc "Τ©ΤǤ̳Τ")
            ))))
        
(define (ini-lost knpc kpc)
   (let ((ini (kobj-gob-data knpc)))
     (if (ini-will-join? ini)
			(begin
  			(say knpc "줿ƲϤ뤫󤯤ƶ"
  				"["
           (loc-x lost-halls-loc) ","
           (loc-y lost-halls-loc) "]ޤǹҹԤиĤ")
			(quest-data-update-with 'questentry-rune-l 'know-hall 1 (quest-notify nil))
			(quest-data-update 'questentry-warritrix 'lost-hall-loc 1)
			)
  			(say knpc "줿ƲϤȤƤʾŤʤۤ"))))
     		
(define (ini-cave knpc kpc)
   (let ((ini (kobj-gob-data knpc)))
     (if (ini-will-join? ini)
     		(begin
     			(say knpc "줿ƲϤ켫Τƶˤ롣")
     			(say knpc (if (is-player-party-member? knpc) "" "") "ƶ̤ˤ糬ʤ򸫤ĤʤФʤʤ")
     			(say knpc "µܤνͤˤϵĤʤФʤʤ")
     			)
     		(ini-notyet knpc kpc))))
     		
(define (ini-inha knpc kpc)
   (let ((ini (kobj-gob-data knpc)))
     (if (ini-will-join? ini)
     		(begin
     			(say knpc "ͤȥνĤ뤿Ӥˡ桹Ϥݤ褦ȤƤ")
     			(say knpc (if (is-player-party-member? knpc) "" "") "Ĺ줷襤٤")
     			)
     		(ini-notyet knpc kpc))))

(define (ini-stair knpc kpc)
   (let ((ini (kobj-gob-data knpc)))
     (if (ini-will-join? ini)
     		(begin
     			(say knpc "̤Τɤ˳ʤ뤳ȤΤäƤ롣󤯤鸫ʤΤǡΤʰ֤Ϥ狼ʤ")
     			)
     		(ini-notyet knpc kpc))))
     			
(define (ini-job knpc kpc)
  (say knpc "ΤޤꤳλŻǤϤʤ"))

(define (ini-bye knpc kpc)
  (say knpc "Ф"))

(define (ini-warr knpc kpc)
  (cond ((player-stewardess-trial-done?)
                (say knpc "ϲ̤줿äλᤷळȤǤ롣" ))
	((player-found-warritrix?)
                (if (ask? knpc kpc "ԤϤ̤ƻ롣Ťƻƻʹ")
                    (say knpc "饹ɥ롣"
                         "ǤƤФĮǺǤŤƤӽФȤǤ롣ƺۤϤޤΤ"
                         "ԤйǤξڵʤǤäƤϤʤʤڵ򤬤ʤƤ˲桹ۤ")
                    (say knpc "Ԥ򤳤ΤޤޤˤƤϤʤïʤФʤʤ")))
	((quest-data-assigned? 'questentry-wise)
		 (say knpc "Ͼضڤ򿭤ФϲΤ"
		      "ƮΤϤä˲鷺˹ԤäƤޤä"
		      "ᴱϺܺ٤ϲ⤻̤˵Ƥ롣"
		      "ͽ롣ʤõƤΤ")
		 (if (kern-conv-get-yes-no? kpc)
		     (begin
		       (say knpc "֤˲äߤ"
		            "ʥΤȤϤ褯ΤäƤ롣ϤǤ̳˽ƤΤ"
		            "षƤդ̸̤¤ꡢʳ̿˽ĤϤʤ")
		       (ini-will-join! (kobj-gob-data knpc)))
		     (say knpc "ïԤ٤ˤԤϳ礭ʼڤ꤬롣")))
	(else
		(say knpc "ƮΤ˲񤤤Τ")
		(if (kern-conv-get-yes-no? kpc)
			(begin
				(say knpc "˲񤦤ΤϺϷ˽ФƤΤȻפ")
				(say knpc "⤷ʤޤΤǤСäƤΤ餻褦")
			)
		))
	))

;; Paladin...
(define (ini-pala knpc kpc)
  (say knpc "ϤλŻ̿򤫤ƤɤΤǤϤʤ"
       "襤٤˵ʬʤΤΤȤαޤ褦˸뤬"
       "ȤʤΩߤǤ"
       "켭Ǥ¾˲Ǥ"))

(define (ini-quit knpc kpc)
  (say knpc "Ǥ褦ˤƤ롣򤷤顢ȥꥰ쥤֤ζ᤯Ϥ㤤Υ褦ȻפäƤ롣"
       "Τ褦ʤȤФͤƤ롣ĹԿʤʤФ餱οðŤʿʥ̲뤳Ȥʤ"
       "֤ʪ˿ܤФ뤳Ȥʤ"))

;; Townspeople...
(define (ini-glas knpc kpc)
  (say knpc "ͫݵʽפ̤")
  (kern-conv-get-yes-no? kpc)
  (say knpc "ФعԤ򸫤ƤȤĤͤƤ롣"))

(define (ini-ange knpc kpc)
  (say knpc "ޤʤƶ֥ûͤɤΤ٤Ȥ롣"))

(define (ini-spit knpc kpc)
  (say knpc "֤Ǥ̾Ʊä"
       "ƶ֥Ȥ襤ǳھȻפäƤȤ줿ͤ鶦˿ɤӤ"
       "ΤȤϴʤä"))

(define (ini-patc knpc kpc)
  (say knpc "̿βͤ"))

(define (ini-life knpc kpc)
  (say knpc "ϰٻ줿褦ʤΤʥƤȤΤȤ"
       "桹ΰդ򻦤εΤ⤫Ĥ줭äƤ"
       "ΤȤ̲ΥȥνĤ¤ǤޤäΤ")
  (prompt-for-key)
  (say knpc "ϤܳФ᤿"
       "̿äĤ±Ǵ򸫾夲Ƥ"
       "¾ĤäԤϤʤ"))

(define ini-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default ini-default)
       (method 'hail ini-hail)
       (method 'bye  ini-bye)
       (method 'job  ini-job)
       (method 'name ini-name)
       (method 'join ini-join)

       (method 'warr ini-warr)
       (method 'pala ini-pala)
       (method 'quit ini-quit)
       (method 'glas ini-glas)
       (method 'ange ini-ange)
       (method 'spit ini-spit)
       (method 'dagg ini-spit)
       (method 'patc ini-patc)
       (method 'life ini-life)
       
       (method 'lost ini-lost)
       (method 'hall ini-lost)
       (method 'cave ini-cave)
       (method 'entr ini-cave)
       (method 'stai ini-stair)
       (method 'nort ini-stair)
       ;(method 'deep ini-stair)
       (method 'deep ini-lost)
       (method 'grea ini-stair)
       (method 'inha ini-inha)
       (method 'bewa ini-inha)
       (method 'dung ini-inha)
       
       ))
       
(define (mk-ini)
  (bind 
   (kern-mk-char 'ch_ini           ; tag
                 ""            ; name
                 sp_human            ; species
                 oc_warrior          ; occ
                 s_companion_paladin ; sprite
                 faction-glasdrin         ; starting alignment
                 5 0 5               ; str/int/dex
                  pc-hp-off  ; hp bonus
                  pc-hp-gain ; hp per-level bonus
                  0 ; mp off
                  0 ; mp gain
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'ini-conv         ; conv
                 sch_ini           ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
                 (list t_armor_chain
                       t_chain_coif
                       t_halberd
                       ))         ; readied
   (ini-mk)))
