;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define jake-lvl 2)
(define jake-species sp_gint)
(define jake-occ nil)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 
;;----------------------------------------------------------------------------
(define jake-bed )
(kern-mk-sched 'sch_jake
               (list 0  0 cantina-counter-zzz "sleeping")
               (list 9  0 cantina-counter "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (jake-mk) (list #t))
(define (jake-left? gob) (car gob))
(define (jake-left! gob val) (set-car! gob val))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ȥѡϵ(2ĤƬΤ)ǡʪ¼˽Ǥ롣
;; ڤʺƬǡѿ򤷤Ƥ롣
;; ѡϾʤʱ¦ƬǡμͤȤƷбĤ򤷤Ƥ롣
;;----------------------------------------------------------------------------

(define (left-head? knpc)
  (jake-left? (gob knpc)))
(define (left-head! knpc)
  (jake-left! (gob knpc) #t)
  (say knpc ""))
(define (right-head! knpc)
  (jake-left! (gob knpc) #f)
  (say knpc "ʤޤ"))

;; Basics...
(define (jake-hail knpc kpc)
  (kern-log-msg "ʤ2ĤƬΤͤȲäϹӡ⤦ϡȸġġ"
                "мȸäƤ᤮ǤϤʤ")
  (if (left-head? knpc)
      (say knpc "褪˷䡪")
      (say knpc "褦")
      ))

(define (jake-default knpc kpc)
  (if (left-head? knpc)
      (say knpc "եΤ뤫衪ѡʹ")
      (say knpc "񤷤äǤޤ")
      ))

(define (jake-name knpc kpc)
  (if (left-head? knpc)
      (say knpc "ƤäѡκƬϱ")
      (say knpc "ѡХǤޤƤ餬錄αʱͧǤޤκƬ¦ˤʤ")
      ))

(define (jake-join knpc kpc)
  (if (left-head? knpc)
      (say knpc "ϥáϥáϥá")
      (say knpc "ޤ󡣿Ȥ;뤪ͶǤޤ")
      ))

(define (jake-job knpc kpc)
  (if (left-head? knpc)
      (say knpc "ѿफФƹԤ")
      (begin
        (say knpc "錄ŹСƥǤޤߤˤʤޤ")
        (if (yes? kpc)
            (jake-trade knpc kpc)
            (say knpc "ͤľƤޤǹΤΤ򤪽Фޤ")
            ))))

(define (jake-bye knpc kpc)
  (if (left-head? knpc)
      (say knpc "㤢ʡ")
      (say knpc "褦ʤ顣ޤ񤤤ޤ礦")
      ))

(define (jake-jake knpc kpc)
  (if (left-head? knpc)
      (say knpc "Ѥ")
      (begin
        (say knpc "˥äΤǤ")
        (if (yes? kpc)
            (left-head! knpc)))
      ))

(define (jake-perc knpc kpc)
  (if (left-head? knpc)
      (begin
        (say knpc "ʤˡѡäΤ")
        (if (yes? kpc)
            (right-head! knpc)
            ))
      (say knpc "ϤϤ錄ǤʤȤդޤ")
      ))

(define (jake-drin knpc kpc)
  (if (left-head? knpc)
      (say knpc "ѡ˸")
      (jake-trade knpc kpc)))


;; Trade...
(define jake-merch-msgs
  (list nil ;; closed
        "˥塼Ǥޤ" ;; buy
        nil ;; sell
        nil ;; trade
        "ǤȤФפޤ" ;; bought-something
        "Τ©Ϥ錄ޤ" ;; bought-nothing
        nil
        nil
        nil
        nil
   ))

(define jake-catalog
  (list
   (list t_food 7 "Ф餷ӥȤǤޤʤ顢ʹ֤ˤϤäʤΤˤޤ")
   (list t_beer 4 "Ϥ뤫󤯤ͭ̾ʥ㥤ȥѡξ¤Ԥ󤻤饬ӡǤޤ")
   (list t_wine 6 "磻ť󶡤줿ǹΥ磻ǤޤۥĸФΤʤܥȥȤ褤ΤǤ")
   ))

(define (jake-trade knpc kpc) (conv-trade knpc kpc "buy" jake-merch-msgs jake-catalog))

;; Town & Townspeople

;; Quest-related

(define jake-conv
  (ifc basic-conv

       ;; basics
       (method 'default jake-default)
       (method 'hail jake-hail)
       (method 'bye  jake-bye)
       (method 'job  jake-job)
       (method 'name jake-name)
       (method 'join jake-join)
       
       ;; trade
       (method 'drin jake-drin)
       (method 'trad jake-trade)
       (method 'buy  jake-trade)

       ;; town & people
       (method 'jake jake-jake)
       (method 'perc jake-perc)
       ))

(define (mk-jake)
  (bind 
   (kern-mk-char 
    'ch_jake           ; tag
    "ȥѡХ"             ; name
    jake-species         ; species
    jake-occ              ; occ
    s_gint     ; sprite
    faction-men      ; starting alignment
    0 0 0            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    jake-lvl
    #f               ; dead
    'jake-conv         ; conv
    sch_jake           ; sched
    'townsman-ai              ; special ai
    nil              ; container
    nil              ; readied
    )
   (jake-mk)))
