;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_jeff
               (list 0  0  gcj-bed      "sleeping")
               (list 7  0  gs-altar    "idle")
               (list 8  0  ghg-s6      "eating")
               (list 9  0  gc-hall     "working")
               (list 12 0  ghg-s3      "eating")
               (list 13 0  gc-train    "working")
               (list 18 0  ghg-s3      "eating")
               (list 19 0  ghg-hall    "idle")
               (list 21 0  gcj-bed      "sleeping")
               )

;; Make another schedule which will be assigned when Jeffreys resigns after the
;; trial.
(kern-mk-sched 'sch_jeff_resigned
               (list 0 0 kun-road "sleeping")
               (list 9 0 campfire-4 "idle")
               (list 13 0 cantina-5 "idle")
               (list 20 0 kun-road "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (jeff-mk) nil)
               
;;----------------------------------------------------------------------------
;; Conv
;; 
;; ե꡼ϥ饹ɥΤλᴱǤ롣
;; ϥ饹ɥ˽ǤơǻƳԡߤԤΥȥꥢľ
;; 𤷤Ƥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (jeff-hail knpc kpc)
  (cond	((player-stewardess-trial-done?)
         (say knpc "¤ͤ衢ΤȤϤ狼äƤ졣ƮΤ΢ڤäƤϤʤԤΤȤϲΤʤΤ"
              "ϤĤǴְäƤȻפǰäȤ˹ư٤ä"
              "饹ɥλᴱϷ褷ϤդäƤϤʤʤ"
              "椨˻ϼǤΤ")
         (aside kpc 'ch_ini "Τʤäդ򤹤ʡΥҥᡣ"
                "˲äȤϡɤ餫ǤӤޤ臘Ȥˤʤ")
         (kern-conv-end)
         )
        (else
         (say knpc "ΤʤΩɤʻѤΤȲäϤ褯줿")
         )))

(define (jeff-default knpc kpc)
  (say knpc "Τ褦ʤȤϼǤʤ"))

(define (jeff-name knpc kpc)
  (say knpc "ᴱΥե꡼Ǥ롣"))

(define (jeff-join knpc kpc)
  (say knpc "ˤϤǤ˻Ż롣"))

(define (jeff-job knpc kpc)
  (say knpc "饹ɥΤش뤳Ȥ"))

(define (jeff-bye knpc kpc)
  (say knpc "Ф"))

;; Special
(define (jeff-comm knpc kpc)
  (say knpc "ᴱϥ饹ɥǤκǹ̤򿦤ǡԤԤ"
       "饹ɥηƻλشˤ롣"))

(define (jeff-mili knpc kpc)
  (say knpc "饹ɥԻԤ"
       "Ƥλ̱ˤʼε̳롣ΤȤ廊褦δäƤΤ"))

(define (jeff-pala knpc kpc)
  (say knpc "饹ɥΤϤΥɤˤƺޤǤͥ줿Τ"
       "ĿͤǽϤϤζķϤޤΤ"))

(define (jeff-skil knpc kpc)
  (say knpc ""
       "̿ΤȿʼƮΤݤȤʤä臘饹ɥΤԤ뤳ȤϤʤ"))

(define (jeff-warr knpc kpc)
  (cond ((player-found-warritrix?)
         (if (ask? knpc kpc "ΥۥϤԹʤȤ桹ϤߤλᤷǤ롣"
                   "⤬ǤΤȽǤˤĤθ꤬äǤϤʤ"
                   "פ̤")
             (say knpc "̤ϲ桹κǹμԤˤⵯꤦ롣뷳λƳԤ⼺ԤȤǽ롣"
                  "Ƥ̿˴ؤ뤳Ȥޤ̤˻ΤФ")
             (if (ask? knpc kpc "櫤äȤǤΤ")
                 (say knpc "äˤʤ̡Ф褤Τ"
                      "⤷ΤǤСԤ˸褤"
                      "򵯤ΤǤСʼޤ򤳤ĮɤФǤ"
                      "ºݤˤϺΩΤǤ褤Τ")
                 (say knpc "襤Ǥϴְ㤤ꤦ롣ˤŨȸäͧ򻦤Ȥ⤢롣"
                      "Ĥ뤳Ȥʡͧ衣Ф")
                 ))
         (kern-conv-end)
         )
	 ((quest-data-assigned? 'questentry-wise)
         (say knpc "ƮΡλǺǤѤ¿ͤΤ"
              "ʬܤ⤢ˤݤäݤѤ򸫤Ȥ롣"
              "ߤϤǤ̳οǤ롣")
              (quest-data-update 'questentry-warritrix 'assignment 1)
         )
	 (else
         (say knpc "ƮΡλǺǤѤ¿ͤΡ"
              "ʬܤ⤢ˤݤäݤѤ򸫤Ȥ롣"
              "ߤϷ˽ФƤ롣")
              (quest-data-update 'questentry-warritrix 'general-loc 1)
         )
	 ))

(define (jeff-warr-ready subfn)
	(if (quest-data-assigned? 'questentry-wise)
		(subfn)
		(jeff-default knpc kpc)
		))

(define (jeff-erra knpc kpc)
	(jeff-warr-ready (lambda ()
  (say knpc "Ͼ񤷤ʴ򤷤"
       "Ϣ졢줿Ʋظä"
       "̯ʤȤˤ줫鲿ϢޤʤΤ"
       "̾ʤܺФȤϤ˳䤱⤬ʤ")
      (quest-data-update-with 'questentry-rune-l 'located 1 (quest-notify nil)) 
      (quest-data-update 'questentry-warritrix 'lost-hall 1)
       )))

(define (jeff-sear knpc kpc)
	(jeff-warr-ready (lambda ()
	(say knpc "ϤΩäƮΤܺ˳䤱Ϥʤ"
	   "餹롣˻Τ")
  (kern-conv-end)
  (if (is-player-party-member? ch_ini)
      (say ch_ini "ԤΤˤ롣"
           "õͤС"))
  )))

;; Townspeople...
(define (jeff-glas knpc kpc)
  (say knpc "ǤĮ饹ɥϿάԤˤäƴ뤳ȤϤʤǤ"))

(define (jeff-ange knpc kpc)
  (say knpc "󥸥ϺǤ鵷ͥ"))

(define (jeff-patc knpc kpc)
  (say knpc "ӤϷи˭ʰդǡ桹±αĹ"))

(define (jeff-stew knpc kpc)
  (say knpc "ԤΥȥꥢϤ褯νŤߤѤƤ롣"))

(define (jeff-ini knpc kpc)
  (say knpc "ʥޤʤΤǡͥ줿δ"))

(define (jeff-jess knpc kpc)
  (say knpc "뤤"
       "ƶ줷ꡢΤڤ褦˸롣"))

(define (jeff-ches knpc kpc)
  (say knpc "桹Ϥ򼺤äƤޤä"
       "ϺǤ桹Ƥ롣"))

(define (jeff-lost knpc kpc)
  (say knpc "줿ƲϤȤƤʽ̿ͤιԤȤǤϤʤ"
       "˶ŤƤϤʤ̤Ǥϼ餹롪")
  (kern-conv-end)
  (if (is-player-party-member? ch_ini)
	(begin
      (say ch_ini "Ƥʡ줿ƲξΤäƤ롣"
           "["
           (loc-x lost-halls-loc) ","
           (loc-y lost-halls-loc) "]ޤǹҹԤиĤ")
	   (quest-data-update-with 'questentry-rune-l 'know-hall 1 (quest-notify nil))
	   (quest-data-update 'questentry-warritrix 'lost-hall-loc 1)
	   )
	   )
  )

(define jeff-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default jeff-default)
       (method 'hail jeff-hail)
       (method 'bye  jeff-bye)
       (method 'job  jeff-job)
       (method 'name jeff-name)
       (method 'join jeff-join)

       (method 'comm jeff-comm)
       (method 'jeff jeff-comm)
       (method 'jani (lambda (knpc kpc) (say knpc "亴Υ˥ѲȤȤƷפΤʤۤɽפǤ롣")))
       (method 'mili jeff-mili)
       (method 'pala jeff-pala)
       (method 'warr jeff-warr)
       (method 'erra jeff-erra)
       (method 'glas jeff-glas)
       (method 'ange jeff-ange)
       (method 'lost jeff-lost)
       (method 'patc jeff-patc)
       (method 'stew jeff-stew)
       (method 'vict jeff-stew)  ;; A synonym
       (method 'ini  jeff-ini)
       (method 'inag jeff-ini)
       (method 'jess jeff-jess)
       (method 'ches jeff-ches)
       ))

(define (mk-jeffreys)
  (bind 
   (kern-mk-char 'ch_jeffreys       ; tag
                 "ե꡼"     ; name
                 sp_human            ; species
                 oc_warrior          ; occ
                 s_companion_paladin ; sprite
                 faction-glasdrin         ; starting alignment
                 2 1 1               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 5  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'jeff-conv         ; conv
                 sch_jeff           ; sched
                 'townsman-ai                 ; special ai
                 nil                 ; container
                 (list t_armor_chain
                       t_chain_coif
                       t_sword
                       ))         ; readied
   (jeff-mk)))
