;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_jess
               (list 0  0  gj-bed      "sleeping")
               (list 7  0  ghg-counter "working")
               (list 9  0  g-fountain  "idle")
               (list 10 0  ghg-counter "working")
               (list 13 0  gc-hall     "idle")
               (list 14 0  ghg-counter "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (jess-mk) (list 'townsman))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ϥ饹ɥμաפμνǤ롣
;; δˤϡܥʼȤƥ饹ɥʼ˽Ƥ֥
;; 󤫤롣
;;----------------------------------------------------------------------------

;; Basics...
(define (jess-hail knpc kpc)
  (if (string=? "working" (kern-obj-get-activity knpc))
      (say knpc "ΤʤϿͤĤ褦ʼ㤤Ȳä¦˿롣"
           "ĤǤĤˤʤդˤޤ")
      (say knpc "ΤʤϿͤĤ褦ʼ㤤Ȳä¦˿롣"
           "ŷ͡")))

(define (jess-default knpc kpc)
  (say knpc "Ĥ狼ޤ"))

(define (jess-name knpc kpc)
  (if (working? knpc)
      (say knpc "ϥηƤξμǤ")
      (say knpc "ϥƤξաפμǤ"
           "餤顢ƤȤƤʡ")))

(define (jess-join knpc kpc)
  (say knpc "ǰʪФΤդǤ˻ʼϤ⤦ޤ"))

(define (jess-job knpc kpc)
  (say knpc "ʪ뤫ۤǤƤ館ޤ")
  (if (kern-conv-get-yes-no? kpc)
      (begin
        (say knpc "ϥ󥯤ϤȻפäƤޤ")
        (jess-trade knpc kpc))
      (say knpc "ǰ͡")))

(define (jess-bye knpc kpc)
  (say knpc "褦ʤ顣ޤƤ"))

(define jess-catalog
  (list
   (list t_food 7  "ΤγϤ֤繥Ǥ")
   (list t_beer 12 "դޤ礦")
   ))

(define jess-merch-msgs
  (list "䤬ȤˡաפƤīϸ79뿩1012鿼ޤǺƳŹޤ"
        "˥塼Ǥ"
        nil ;; sell
        nil ;; trade
        "ڤǤ" ;; sold-something
        "ǥѥá줿ߤǤ" ;; sold-nothing
        nil ;; the rest are nil
        ))

;; Trade...
(define (jess-buy knpc kpc) (conv-trade knpc kpc "buy" jess-merch-msgs jess-catalog))

;; Holy Grail
(define (jess-grai knpc kpc)
  (say knpc "Ǥ¤ͤ̾ˤȤ"
       "Ǥ褯Τ줿äˤʤäƤ뤽Ǥ衣"))

;; Scar
(define (jess-scar knpc kpc)
  (say knpc "ƶ֥ȡƤʼΤǤ"
       "̲԰ǤοϤˤ˼ޤ"
       "ǤΤ̿ˤϤʤޤǤ"
       "襤äϹǤ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ĮοͤϤäĤ餤ϻäƤޤ䤿ϳʼ˽ޤ顣")
      (say knpc "ǰǤ͡ǤϤäФǤ")))

(define (jess-serv knpc kpc)
  (say knpc "饹ɥλ̱Ϥߤʼε̳ޤ"
       "ϥܥʼǡʼظ夫ٱ礹ΤŻǤ"
       "Ͽ¦ζˤޤ"))

(define (jess-wood knpc kpc)
  (say knpc "Ϥ褯äƤȻפޤ"
       "Ǥ⡢ǯˤƶ֥ȥȥ緲󤻤Ƥޤ"))

;; Townspeople...
(define (jess-glas knpc kpc)
  (say knpc "ϤǤ뤳ȤͤСʬˤ褤Ǥ"))

(define (jess-ange knpc kpc)
  (say knpc "Ф餷ͤǤΤȤƤϳǤޤǤˤܤޤ"))

(define (jess-patc knpc kpc)
  (say knpc "α줿ǯꡪ̤Ǥ衣"))

(define jess-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default jess-default)
       (method 'hail jess-hail)
       (method 'bye  jess-bye)
       (method 'job  jess-job)
       (method 'name jess-name)
       (method 'join jess-join)
       
       ;; trade
       (method 'grai jess-grai)
       (method 'holy jess-grai)
       (method 'trad jess-buy)
       (method 'room jess-buy)
       (method 'buy  jess-buy)
       (method 'drin jess-buy)
       (method 'ware jess-buy)
       (method 'food jess-buy)

       ;; scar
       (method 'trade jess-buy)
       (method 'scar  jess-scar)
       (method 'serv  jess-serv)
       (method 'tour  jess-serv)
       (method 'wood  jess-wood)

       ;; town & people
       (method 'glas jess-glas)
       (method 'ange jess-ange)
       (method 'patc jess-patc)

       ))

(define (mk-jess)
  (bind 
   (kern-mk-char 'ch_jess           ; tag
                 ""           ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townswoman        ; sprite
                 faction-glasdrin         ; starting alignment
                 0 0 1               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'jess-conv         ; conv
                 sch_jess           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_dagger)))                 ; container
                 nil                 ; readied
                 )
   (jess-mk)))
