;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define jones-lvl 6)
(define jones-species sp_human)
(define jones-occ nil)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ݥꥹκ
;;----------------------------------------------------------------------------
(define jones-bed ph-bed1)
(define jones-mealplace ph-tbl1)
(define jones-workplace ph-arms)
(define jones-leisureplace ph-hall)
(kern-mk-sched 'sch_jones
               (list 0  0 jones-bed          "sleeping")
               (list 7  0 jones-mealplace    "eating")
               (list 8  0 jones-workplace    "working")
               (list 12 0 jones-mealplace    "eating")
               (list 13 0 jones-workplace    "working")
               (list 18 0 jones-mealplace    "eating")
               (list 19 0 jones-leisureplace "idle")
               (list 22 0 jones-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (jones-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 硼󥸡ϥ饹ɥ󷳤ƯƤ롣
;; ϥݥꥹκ֤ˤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (jones-name knpc kpc)
  (say knpc "硼󥸡Ǥɤ"))

(define (jones-job knpc kpc)
  (say knpc "饹ɥ󷳤ƯƤ롣äƤ")
  (if (yes? kpc)
      (jones-trade knpc kpc)
      (say knpc "ʤˤΤäƤ졣")))

;; Trade...
(define jones-merch-msgs
  (list "96δ֤ϤƤ졣"
        "ŪʪϤäƤ롣"
        nil
        nil
        "ǽʬäȤäΤǤϡ"
        "Ͻʬˤä"
   ))

(define jones-catalog
  (list
   (list t_arrow        1 "Ǥϥȥ뤬褦ȤȤˤʤ뤾")
   (list t_bolt         1 "֤Ƥ֤ƤȤ̤Ƥޤ")
   (list t_oil          6 "бӥϤäƤϤäȤҤɤ")
   (list t_torch        6 "Ǿڤ餻Ϥʤ")
   (list t_heal_potion 23 "⤤ǤϲϼˤФɬפ")
   (list t_mana_potion 23 "Ϥ¿äۤ褤֤ѻդϤĤƯʤФʤʤ")
   (list t_food        10 "ؤ¤äȤʤʤäǰ")
   ))

(define (jones-trade knpc kpc) (conv-trade knpc kpc "buy" jones-merch-msgs jones-catalog))

;; Quest-related

(define jones-conv
  (ifc kurpolis-conv

       ;; basics
       (method 'job jones-job)
       (method 'name jones-name)
       
       ;; trade
       (method 'trad jones-trade)
       (method 'buy jones-trade)

       ))

(define (mk-jones)
  (bind 
   (kern-mk-char 
    'ch_jones        ; tag
    "硼󥸡"      ; name
    jones-species         ; species
    jones-occ              ; occ
    s_townsman     ; sprite
    faction-men      ; starting alignment
    2 0 0            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    jones-lvl
    #f               ; dead
    'jones-conv         ; conv
    sch_jones           ; sched
    'townsman-ai              ; special ai
    nil              ; container
    (list t_axe
    		t_armor_chain)              ; readied
    )
   (jones-mk)))
