;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define kama-lvl 4)
(define kama-species sp_forest_goblin)
(define kama-occ oc_wrogue)
(define kama-exit-x 6)
(define kama-exit-y 2)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Фϲ˼
;;----------------------------------------------------------------------------
(define kama-cell gtl-cell1)
(kern-mk-sched 'sch_kama
               (list 0  0 kama-cell        "sleeping")
               (list 7  0 kama-cell        "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (kama-mk jail-door-tag) (list #f #f jail-door-tag))
(define (kama-gave-food? gob) (car gob))
(define (kama-gave-food! gob) (set-car! gob #t))
(define (kama-joined-once? gob) (cadr gob))
(define (kama-joined-once! gob) (set-car! (cdr gob) #t))
(define (kama-get-jail-door-tag gob) (caddr gob))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ޤϿ֥μͤǡФϲ˼ƤƤ롣
;; ͧͤǡޤϲ񤤤Աˤ⹴«줿
;; ֥줬狼Сޤ֤ˤʤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (kama-default knpc kpc)
  (say knpc "ȿʤ"))

(define (kama-hail knpc kpc)
  (meet "Τʤ夤ͻҤΥ֥ȲäͻҤϤʤͤǤ褦ܤǤ򸫤Ƥ롣")
  (if (kama-gave-food? (gob knpc))
      (say knpc "ܥʥϡ")
      (say knpc "̥")
      ))

(define (kama-bye knpc kpc)
  (say knpc "ɽѤʤä"))

;; No == Name
(define (kama-no knpc kpc)
  (if (kama-gave-food? (gob knpc))
      (say knpc "ϼʬغϥޡ")
      (kama-default knpc kpc)))

;; Me == Job
(define (kama-me knpc kpc)
  (if (not (kama-gave-food? (gob knpc)))
      (kama-default knpc kpc)
      (begin
        (say knpc "˥ȡϤʤغϥȡ")
        (if (yes? kpc)
            (say knpc "Ϥʤ")
            (say knpc "Ϥʤ򵿤褦ܤǾФä")))))

;; Jo == Join
(define (kama-jo knpc kpc)
  (define (exit-point)
    (mk-loc (kobj-place knpc)
            kama-exit-x
            kama-exit-y))
  (define (door-still-locked?)
    (let ((kdoor (eval (kama-get-jail-door-tag (gob knpc)))))
      (cond ((null? kdoor) (error "Kama's door tag is undefined!") #t)
            (else
             (let ((gob (kobj-gob kdoor)))
               (or (door-locked? gob)
                   (door-magic-locked? gob)))))))
  (define (rejoin)
    (say knpc "ϡ")
    (join-player knpc)
    (kern-conv-end)
    )
  (define (join-first-time)
    (say knpc "ϥ硪ܥʡ륫")
    (say knpc "ξξ˿դϿޤΤ褦ʤΤƿüλ̮ܤϤƲ٤Хİ")
    (quest-data-update-with 'questentry-rune-f 'angriss 1 (quest-notify nil))
    (kama-joined-once! (gob knpc))
    (join-player knpc)
    ;; Improve the player's relations with forest goblins
    (kern-dtable-inc faction-player faction-forest-goblin)
    (kern-dtable-inc faction-player faction-forest-goblin)
    (kern-conv-end)
    )
  (if (is-player-party-member? knpc)
      (say knpc "ϺǤͻҤϥϡġ")
      (if (kama-joined-once? (gob knpc))
          (rejoin)
          (if (not (kama-gave-food? (gob knpc)))
              (kama-default knpc kpc)
              (if (door-still-locked?)
                  (say knpc "˼غ򤹤᤿")
                  (join-first-time)
                  )))))

(define (kama-food knpc kpc)
  (kern-log-msg "˿Ϳ롩")
  (define (no-food)
    (say knpc "Ϥʤ򤢤ؤ")
    (kern-conv-end))
  (define (yes-food)
    (kama-gave-food! (gob knpc))
    (say knpc "Ϥ򥬥ĥĤȿ٤"
         "ϡ̥Ϥʤغϥܥʥϡ"))
  (if (yes? kpc)
      (if (> (get-food-donation knpc kpc) 0)
          (yes-food)
          (no-food))
      (no-food)))
          
(define (kama-rune knpc kpc)
  (if (not (kama-gave-food? (gob knpc)))
      (kama-default knpc kpc)
      (if (any-in-inventory? kpc rune-types)
          (say knpc "ΤʤǤ򸫤ȡ԰¤ˤʤϥ륫")
          (say knpc "ǤˤĤ褦ȤϺǤƤ褦"))))

;; Ruka == Rune
;; Having a goblin spout out *sextant coordinates* is just daft. Changing to something descriptive
;; Maybe for the repeat, give a pointed direction based on the parties location on the worldmap? "He points south" or whatever direction is appropriate
(define (kama-ruka knpc kpc)
  (if (kama-joined-once? (gob knpc))
  		(begin
	      (say knpc "륫")
    	  (say knpc "ξξ˿դϿޤΤ褦ʤΤƿüλ̮ܤϤƲ٤Хİ")
    	  (quest-data-update-with 'questentry-rune-f 'angriss 1 (quest-notify nil))
      	)
      (begin
        (say knpc "˼ξΤۤ˴ݤȡˤĤʤäϥΤ褦ä줫Ϥʤȼʬغγä")
        (prompt-for-key)
        (say knpc "ΤɤϤʤ˲äꥯ臘ȤƤƤ褦"))))

;; King Clovis (leader of the human forces in the war against the Goblins, one generation ago.
(define (kama-clov knpc kpc)
  (if (not (kama-gave-food? (gob knpc)))
      (kama-default knpc kpc)  
      (say knpc "ϺǽϤ狼ʤ褦äϤʤƸäϥ륫ȡ")))

(define (kama-leav knpc kpc)
  (if (is-player-party-member? knpc)
      (begin
        (say knpc "ޡĥ硩")
        (if (yes? kpc)
            (begin
              (if (kern-char-leave-player knpc)
                  (begin
                    (say knpc "ޡ")
                    (kern-conv-end))
                  (say knpc "ޡġ")))
            (kern-log-msg "ϰ¿褦")))
      (kern-log-msg "Ϻ𤷤Ƥ褦")))

;; Shakespeare
(define (kama-zukakiguru knpc kpc)
  (begin
    (say knpc "ϡ롪")
    (aside kpc 'ch_gen "䤿ζ̤δؿȤǤ")
    (say knpc "ϤʤκäĤ򸫤ơäȸľϥ롢祰ϡޡ̡ϥȡ")
    (aside kpc 'ch_gen "κԤΤäȤζäƤߤƤ")
    ))

;; Hameluto == Good/yes/skillful, Destiny change individual (Prince Hamlet)
(define (kama-hameluto knpc kpc)
  (begin
  (say knpc "ϥȡϡΥޤθѤäƿʴĤǺƤӤʤ")
  (aside kpc 'ch_gen "ʤʹƤ뤽Ǥ衪Υ϶̣˸Ƥ롣")
  (prompt-for-key)
  (say knpc "̥ܥĥܥ塪")
  (aside kpc 'ch_gen "٤̤٤줬")

  (say knpc "ܥϥҥᡢʥĥޥʡޥ")
  (aside kpc 'ch_gen "ɤ餬⤤Ǥƻʱ̿ΤĤ֤ƤѤ뤫")

  (say knpc "ܥᥫ硢ĥ硪")
  (aside kpc 'ch_gen "꺤γΩ򽪤뤫")

  (say knpc "ϤΤޤĹָĤΤ褦ϯɤǸޤʹ")
  (if (yes? kpc)
      (say knpc "Τθ塢äۤĹָ³")
      (say knpc "ܥʡϡϻߤ᤿äȸꤿ褦ä")
      )
  (aside kpc 'ch_gen "ηγ˿ʬϡƤˤʤäƤȻפޤ󤫡")
  ))

(define kama-conv
  (ifc nil
       (method 'default kama-default)
       (method 'hail kama-hail)
       (method 'bye  kama-bye)
       (method 'leav kama-leav)

       (method 'no   kama-no)
       (method 'me   kama-me)
       (method 'jo   kama-jo)
       (method 'food kama-food)
       (method 'rune kama-rune)
       (method 'ruka kama-ruka)
       (method 'clov kama-clov)

       (method 'shak kama-zukakiguru) ;; synonym
       (method 'bard kama-zukakiguru) ;; synonym
       (method 'zuka kama-zukakiguru)

       (method 'haml kama-hameluto) ;; synonym
       (method 'hame kama-hameluto)
    ))

(define (mk-kama jail-door-tag)
  (bind 
    (kern-mk-char 
     'ch_kama           ; tag
     ""             ; name
     kama-species         ; species
     kama-occ              ; occ
     s_fgob_civilian  ; sprite
     faction-men      ; starting alignment
     2 0 10            ; str/int/dex
     pc-hp-off  ; hp bonus
     pc-hp-gain ; hp per-level bonus
     0 ; mp off
     0 ; mp gain
     max-health ; hp
     -1                   ; xp
     max-health ; mp
     0
     kama-lvl
     #f               ; dead
     'kama-conv         ; conv
     sch_kama           ; sched
     nil              ; special ai
     nil              ; container
     nil              ; readied
     )
   (kama-mk jail-door-tag)))
