;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define kathryn-start-lvl  6)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; In Bole.
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_kathryn
               (list 0  0  bole-bed-kathryn "sleeping")
               (list 9  0  bole-table-1 "eating")
               (list 10 0  bole-courtyard   "idle")
               (list 12 0  bole-table-1 "eating")
               (list 13 0  bole-dining-hall "idle")
               (list 18 0  bole-table-1 "eating")
               (list 19 0  bole-dining-hall "idle")
               (list 23 0  bole-bed-kathryn "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (kathryn-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 㥹϶ߤʽѻդǡƻդϤǤळȤ󤷤ť
;; (ͥ)餽᤹ܥˤ롣ĳμ¤ƻդϲäƤ
;; 
;; ϸޤǤ롣
;; 
;; 㥹֤ˤʤ(ƺǸˤ΢ڤ)
;; ˤϹӡɥ󤬤ĤƤơ֤ˤʤ֤ˤʤ롣
;;----------------------------------------------------------------------------
(define (kathryn-hail knpc kpc)
  (say knpc "ΤʤΤܤǸ뤭줤ʽȲäϤϤ"))

(define (kathryn-default knpc kpc)
  (say knpc "Ϥʤ虜̵뤷"))

(define (kathryn-name knpc kpc)
  (say knpc "褽Ԥˤ̾ʤ褦ˤƤΡ"
       "ꡢΤꤿȤ̤ۤˤʤ衣"
       "ܤ󤤤դΡġ"))

(define (kathryn-join knpc kpc)
  (say knpc "ϤऻۤɾФä"))

(define (kathryn-job knpc kpc)
  (say knpc "ΤФʤϽƻ衣500ǤŤޤ礦"))


(define (kathryn-blowjob knpc kpc)
  (say knpc "̣衣äȾäʤ"))

(define (kathryn-clients knpc kpc)
  (say knpc "εҤ̾ʤΤ衣"
       "ΤäƤ٤ʤΤϡܤ餻ƤϤʤʤȤȤ衣"))

(define (kathryn-things knpc kpc)
  (say knpc "ʤΤ褦ʿͤˤϤ狼ʤΤ衣"))

(define (kathryn-thief knpc kpc)
  (say knpc "ѤܤǤʤ򸫤Ϥʤۤɤ͡⤷ȶϤ礨뤫⤷ʤ"
       "ؤϵҤ̾ʤͤΤ뤿褿Ρ"))

(define (kathryn-seller knpc kpc)
  (say knpc "Τޤ줿Ȥ狼äȤΥåƤߤơ"
        "Ȱ˥Τ׵ᤷ顢ܤäΤ衪"))

(define (kathryn-vanish knpc kpc)
  (say knpc "ѥäȡʤʤäƩλؤäƤ˰㤤ʤ"
       "ɥȰˤ餸夦õ"))

(define (kathryn-search knpc kpc)
  (define (do-join)
    (say knpc "Ф餷ΤťˤĤƲΤäƤ뤫ʹƤߤޤ礦")
    (if (in-inventory? knpc t_wis_quas_scroll)
        (begin
          (say knpc "δʪϤäΩĤ"
               "äƤơˡۤϤ褯狼ʤɡ")
          (kern-obj-remove-from-inventory knpc t_wis_quas_scroll 1)
          (kern-obj-add-to-inventory kpc t_wis_quas_scroll 1)))
    (kern-char-join-player knpc)
    (if (and (defined? 'ch_thud)
             (is-alive? ch_thud))
        (begin
          (say knpc "̤ΥɥääƤ顣"
               "ĤϥߤʤΤǡ䤬ʤȤɤ褦ʤ顣")
          (kern-char-join-player ch_thud)))
    (kern-conv-end))
  (say knpc "䤿ŪƱ褦͡ȤǰޤޤƥΤ֤ޤ礦"
       "󽷤ϽФ"
       "⤷Τ᤻СȥɥˤϽʬʳۤˤʤΡ"
       "ɤդ֤˲äʤ")
  (if (kern-conv-get-yes-no? kpc)
      (do-join)
      (begin
        (say knpc "ưɤϤɤơ"
             "Υܥ϶˽ʤΡ"
             "⤷õƤΤ֤ʤСƤʤФʤʤ"
             "ɤ֤˲ääơ")
        (if (kern-conv-get-yes-no? kpc)
            (do-join)
            (begin
              (say knpc "ϿȤޤĤŤ"
                   "դʤξ衣ʤΤϤɤǤ⤤"
                   "ʤʳˤϤʤΤ衣õޤ礦"
                   "ɤꤤꤤޤġ")
              (if (kern-conv-get-yes-no? kpc)
                  (do-join)
                  (say knpc "ܤǴ֤ڤ夲ϥХ"
                       "褹ˡʤˡ"
                       "ʤõƤΤϡϤǺǤŤѻդˤǤʪʤΤ衪"
                       "ťޤƱʱζˤͿƤ"
                       "ʤϴؤʤۤȤΤ衪")
                  (kern-conv-end)))))))

(define (kathryn-tavern knpc kpc)
  (say knpc "衣ʤ֥ʤ͡"))

(define (kathryn-companion knpc kpc)
  (say knpc "ɥ󡩻ΡĿ̤衣"))

(define (kathryn-cousin knpc kpc)
  (say knpc "󤤿̡"))

(define (kathryn-bill knpc kpc)
  (say knpc "¼ΥХäȿƻȤ˽ФƹԤäΤǤ礦"
       "˹ԤäƤ顩"))

(define (kathryn-hackle knpc kpc)
  (say knpc "Υ줿ѡ򺹤ˤ롩"
       "νϼʤǤ礦͡ǰɡ"))

(define (kathryn-may knpc kpc)
  (say knpc "ɲΡΥХХ衣ʤ϶äƤʤɡ"
       "⤷äƤСȤβ˱ƤȤ͡"))

(define (kathryn-melvin knpc kpc)
  (say knpc "ͤΡǯ衣"))

(define (kathryn-sorceress knpc kpc)
  (say knpc "϶äդ򤷤ƼǸʤäϤξʱ줿̩˵Ť͡"
       "äʤʤȾΤ褦ǳ䤹衣"))

(define (kathryn-scro knpc kpc)
  (if (is-player-party-member? knpc)
      (say knpc "äƤΤϤʤˤ衣"
           "ɤǼΤ狼ʤ")
      (say knpc "ʪϾФäϻΥݥåȤ˼Ƥߤ롩"
           "ʬοۤ򤷤ʤ衣")))


(define kathryn-conv
  (ifc nil
       (method 'default kathryn-default)
       (method 'hail kathryn-hail)
       (method 'bye  (lambda (knpc kpc) (say knpc "")))
       (method 'job  kathryn-job)
       (method 'name kathryn-name)
       (method 'join kathryn-join)

       (method 'blow kathryn-blowjob)
       (method 'bill kathryn-bill)
       (method 'clie kathryn-clients)
       (method 'comp kathryn-companion)
       (method 'cous kathryn-cousin)
       (method 'fait kathryn-seller)
       (method 'hack kathryn-hackle)
       (method 'item kathryn-seller)
       (method 'inn  kathryn-tavern)
       (method 'may  kathryn-may)
       (method 'meet kathryn-thief)
       (method 'melv kathryn-melvin)
       (method 'nun  kathryn-blowjob)
       (method 'ring kathryn-search)
       (method 'sear kathryn-search)
       (method 'sell kathryn-seller)
       (method 'sorc kathryn-sorceress)
       (method 'witc kathryn-sorceress)
       (method 'tave kathryn-tavern)
       (method 'thud kathryn-companion)
       (method 'thie kathryn-thief)
       (method 'vani kathryn-vanish)
       (method 'vill kathryn-search)
       (method 'scro kathryn-scro)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-kathryn)
  (bind 
   (kern-char-force-drop
    (kern-char-arm-self
     (kern-mk-char 
      'ch_kathryn ;;..tag
      "㥹" ;;....name
      sp_human ;;.....species
      oc_wizard ;;....occupation
      s_wizard ;;.....sprite
      faction-men ;;..faction
      0 ;;............custom strength modifier
      4 ;;............custom intelligence modifier
      0 ;;............custom dexterity modifier
      2 ;;............custom base hp modifier
      1 ;;............custom hp multiplier (per-level)
      4 ;;............custom base mp modifier
      2 ;;............custom mp multiplier (per-level)
      max-health ;; current hit points
      -1  ;;...........current experience points
      max-health ;; current magic points
      0
      kathryn-start-lvl  ;;..current level
      #f ;;...........dead?
      'kathryn-conv ;;conversation (optional)
      sch_kathryn ;;..schedule (optional)
      'spell-sword-ai ;;...custom ai (optional)
      ;;..............container (and contents)
      (mk-inventory
       (list
        (list 1 t_kathryns_letter)
        (list 100 t_gold_coins)
        (list 5 sulphorous_ash )
        (list 5 ginseng )
        (list 5 garlic )
        (list 3 spider_silk )
        (list 3 blood_moss )
        (list 2 black_pearl )
        (list 1 nightshade )
        (list 1 mandrake )
        (list 1 t_wis_quas_scroll)
        ))
      ;;..............readied arms (in addition to the container contents)
      (list
       t_staff
       )
      nil ;;..........hooks in effect
      ))
    #t)
   (kathryn-mk)))
