;; Reagent-seller
;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; In Oparine.
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_lia
               (list 0  0  sea-witch-bed        "sleeping")
               (list 6  0  sea-witch-beach      "idle")
               (list 8  0  sea-witch-counter    "working")
               (list 20 0  sea-witch-beach      "idle")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (lia-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ꥢϥѡ˽ѻդǡäƤ롣
;; ˥βҤΥեζ᤯ˤ롣
;; 
;; Ϥ褯狼ʤ򤫤ƤȸƤ롣
;; ϥ˥¾γ̱ǡʹ֤λѤѿȤƤ⤷ʤ
;;----------------------------------------------------------------------------

;; Basics...
(define (lia-hail knpc kpc)
  (say knpc "Τʤ˺ʤ褦ͤȲäϤä㤤ޤ"))

(define (lia-default knpc kpc)
  (say knpc "ϤǤޤ"))

(define (lia-name knpc kpc)
  (say knpc "ϥꥢǤ"))

(define (lia-join knpc kpc)
  (say knpc "δߤΥ뤳ȤϤǤޤ"))

(define (lia-job knpc kpc)
  (say knpc "äƤޤ⤢ޤ衣"))

(define (lia-bye knpc kpc)
  (say knpc "褦ʤ顢¤ͤ"))

;; Trade...
(define lia-merch-msgs
  (list "Źϸ88ޤǳƤޤ"
        "ʤޤ"
        "褤ʪ㤤ޤ"
        "㤤ޤȤꤿʪޤ"
        "ʤˡ˲øޤ褦ˡ"
        "狼ޤ"
        "¾ɬפʪϤޤ"
        "Ŭʲʤ󼨤Ǥ"
        "ʤǤ礦"
        "˾ʤ顣"
   ))

(define lia-catalog
  (list
   (list sulphorous_ash         (*  2 reagent-price-mult) "γϲФγˤεοäƤΤǤ")
   (list garlic                 (*  4 reagent-price-mult) "ǤϤ褯롢ǤʸǻȤ䤹Ǥ")
   (list ginseng                (*  4 reagent-price-mult) "οͻϥޥɥ쥤Ȱ˼ʬǰƤΤǤ")
   (list black_pearl            (*  4 reagent-price-mult) "̤ʾǼäΤǤ¾ǤϸĤʤǤ礦")
   (list blood_moss             (*  6 reagent-price-mult) "ΤǤϷݤϤʤʤĤޤ")
   (list nightshade             (* 11 reagent-price-mult) "ʥȥɤϤΤǤΤǤ")
   (list mandrake               (* 11 reagent-price-mult) "ޥɥ쥤ϿͻȰ˰ƤƤޤ")
   
   (list t_in_an_scroll         (*  3 base-scroll-cost) "ϤǾԤľ̤Ƥ⡢줬Ʊʤˤʤޤ")
   (list t_in_mani_corp_scroll  (*  8 base-scroll-cost) "֤ݤƤ⤳줬ᤷळȤϤޤ")
   (list t_vas_rel_por_scroll   (*  3 base-scroll-cost) "δʪС󤯤ι뤳Ȥ⡢Ỵʾ֤ƨ뤳ȤǤޤ")
   (list t_vas_mani_scroll      (*  2 base-scroll-cost) "ҤɤäƤ⤳ǲ뤳ȤǤޤ")
   (list t_wis_quas_scroll      (*  2 base-scroll-cost) "δʪǸʤؤܤǤ礦")
   ))

(define (lia-trade knpc kpc)  (conv-trade knpc kpc "trade" lia-merch-msgs lia-catalog))
(define (lia-buy knpc kpc)  (conv-trade knpc kpc "buy" lia-merch-msgs lia-catalog))
(define (lia-sell knpc kpc)  (conv-trade knpc kpc "sell" lia-merch-msgs lia-catalog))

(define (lia-pear knpc kpc)
  (say knpc "I have my own source for the rare black pearl. "
       "Would you like to purchase some?")
  (if (kern-conv-get-yes-no? kpc)
      (lia-buy knpc kpc)
      (say knpc "You won't get this quality anywhere else!")))

;; Shores...
(define (lia-shor knpc kpc)
  (say knpc "ͤζ᤯ˤ뤿ᡢϤˤʤФʤޤ"))

(define (lia-love knpc kpc)
  (say knpc "ΰͤϳΥ뤳ȤǤޤ"
       "ϳοͤβҤʤΤǤ"
       "ͦ¡ƻμˤ⤫餺򸫼ΤƤʤǤޤ"
       ))

;; Sea
(define (lia-sea knpc kpc)
  (say knpc "Ĺ֡ζäƤޤ"
       ""
       "ŷ򤫤"
       "Ʊ󤯤᤯͡βä"))

(define (lia-curs knpc kpc)
  (say knpc "äޤ"))

;; Townspeople...
(define (lia-opar knpc kpc)
  (say knpc "Įο͡ϻˤϴƤޤ"))

(define (lia-gher knpc kpc)
  (say knpc "λ꤬褯ɤäƤޤ"
       "εԤǤ褯Ƥޤ"))

(define (lia-alch knpc kpc)
  (say knpc "ϻơˡä򤷤ޤ"
       "οʹ֤ͧãΰͤǤ"))

(define (lia-osca knpc kpc)
  (say knpc "ΤȤϡ˹ԤäȤʤȰʳϤ褯Τޤ"))

(define (lia-henr knpc kpc)
  (say knpc "ϤĤƤФ餷Ǥ"
       "ΰʼԤͦäƤޤ"))

(define (lia-bart knpc kpc)
  (say knpc "Ϲ⤯ɾƤޤ"
       "Ǥ⡢ˤȤäԳʹǽšΤǤ"))

(define lia-conv
  (ifc basic-conv

       ;; basics
       (method 'default lia-default)
       (method 'hail lia-hail)
       (method 'bye  lia-bye)
       (method 'job  lia-job)
       (method 'name lia-name)
       (method 'join lia-join)
       
       ;; Shores
       (method 'shor lia-shor)
       (method 'love lia-love)
       (method 'sea  lia-sea)
       (method 'deep lia-sea)
       (method 'curs lia-curs)

       ;; trade
       (method 'trad lia-trade)
       (method 'reag lia-buy)
       (method 'buy  lia-buy)
       (method 'sell lia-sell)
       (method 'blac lia-buy)
       (method 'pear lia-buy)

       ;; town & people
       (method 'opar lia-opar)
       (method 'alch lia-alch)
       (method 'gher lia-gher)
       (method 'osca lia-osca)
       (method 'henr lia-henr)
       (method 'bart lia-bart)
       (method 'fing lia-love)

       ))

(define (mk-lia)
  (bind 
   (kern-mk-char 'ch_lia           ; tag
                 "ꥢ"            ; name
                 sp_human            ; species
                 oc_wizard           ; occ
                 s_townswoman        ; sprite
                 faction-men         ; starting alignment
                 0 2 1               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'lia-conv         ; conv
                 sch_lia           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_dagger)))    ; container
                 nil                 ; readied
                 )
   (lia-mk)))
