(kern-mk-map 'm_losthalls_cpassage 21 21 pal_expanded
	(list
		"rn rn rn rn rn r4 {{ {2 .. .. .. {4 {{ {{ ra rn rn rn rn rn rn "
		"rn rn rn rn rn rc {{ {2 .. {8 .. .. {1 bb {{ r2 rn rn rn rn rn "
		"rn rn rn rn rn {{ {{ {2 {4 {{ {2 .. .. {4 {{ ra rn rn rn rn rn "
		"rn rn rn rn r8 {{ {3 .. .. {1 .. .. .. {4 {{ {{ rn rn rn rn rn "
		"rn rn rn r4 .. {1 .. .. .. .. .. .. .. .. {1 {1 rn rn rn rn rn "
		"rc {{ {{ {{ {2 .. {8 .. .. .. .. .. {c {{ {2 .. .. ra r8 rn rn "
		"{{ {{ {{ {3 .. {c {{ {a .. .. .. {4 {{ {{ {2 .. {4 {{ {{ ra r8 "
		"{1 bb {{ {2 .. {{ r7 {{ {2 .. .. {4 {{ {3 .. .. .. {5 {{ {{ {2 "
		".. .. {1 .. .. r9 r4 {{ {2 .. .. .. {1 .. .. .. .. .. {5 {{ {2 "
		".. .. .. .. .. {{ re {{ {2 .. .. .. {8 .. .. .. .. .. .. {1 .. "
		".. {8 .. .. .. {5 {{ {3 .. .. {8 {c {{ {a .. .. .. .. .. {8 .. "
		"{4 {{ {2 .. {8 .. {1 .. .. {4 {{ {{ r7 {{ {2 .. .. .. {4 {{ {2 "
		"{4 {{ {2 {4 {{ .. .. .. .. .. {5 {{ r6 {{ {2 .. .. .. bb {{ {2 "
		".. {1 .. {c {{ .. .. bb .. .. {4 {{ ra rd {8 .. .. {c {{ {b .. "
		".. .. {c {{ {{ .. .. .. .. .. .. {5 {{ {{ {{ {2 {4 {{ {{ {{ {2 "
		"r1 r5 {{ {{ {{ .. .. .. .. .. .. .. .. .. .. .. {4 {{ r3 r1 r1 "
		"rn rn rn rn rn {{ {2 .. bb .. .. .. .. .. {4 {{ r4 {1 r2 rn rn "
		"rn rn rn rn rn r5 .. {8 {8 .. .. .. .. .. {8 {1 rn r1 rn rn rn "
		"rn rn rn rn rn r4 {c {{ {{ {2 .. .. .. bb {{ r3 rn rn rn rn rn "
		"rn rn rn rn rn r4 {{ {{ rf .. .. .. {4 {{ r3 rn rn rn rn rn rn "
		"rn rn rn rn rn r4 bb {1 .. .. .. .. {4 {{ r2 rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_cwall 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn r4 bb "
		"rn rn rn rn rn rn rn rn rn rn r8 r8 rn rn rn rn rn rn rn rn r1 "
		"rn rn rn rn rn rn rn rn r8 rc {{ {a ra rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn r8 rc {4 {{ bb {{ {2 ra r8 r8 r8 r8 r8 rn rn "
		"rn rn rn rn rn r4 {{ {{ {2 {5 {{ {{ {2 {4 {{ {2 {4 {{ {{ r2 rn "
		"rn rn rn rn r8 bb {5 {{ {2 .. {1 {1 .. {4 {{ {{ .. {1 {1 r2 rn "
		"rn rn rn rc .. {4 {{ {a {8 .. .. r7 .. .. {4 {{ .. .. r3 rn rn "
		"rn rn rc .. .. .. {5 {{ {{ r3 r1 rn r1 r1 rd {1 .. .. r2 rn rn "
		"rn r4 {8 {8 .. r1 r5 {{ {{ r2 rn rn r8 rc .. .. .. r3 rn rn rn "
		"rn r4 {{ {{ {2 r8 r8 r1 r1 rn rn r4 .. .. bb .. .. r2 rn rn rn "
		"rn rn r5 {{ {2 .. .. ra rn rn rn r4 .. .. {8 {8 .. r2 rn rn rn "
		"rn rn r4 {{ {2 .. bb .. r2 rn r8 rn r5 {4 {{ {{ .. r2 rn rn rn "
		"rn rn r4 {1 .. .. .. .. r2 rc {{ ra rc .. {5 {{ .. ra rn rn rn "
		"rn rn rn rd .. .. .. rb rc {{ {{ {{ {2 .. .. {1 .. .. r2 rn rn "
		"rn rn rc {8 {8 {8 .. .. {8 {9 {1 {1 .. {8 .. r3 .. .. ra rn rn "
		"rn r4 {4 {{ {{ {{ {2 {4 {{ {{ {2 .. {c {{ r3 rn r5 .. .. r2 rn "
		"rn r4 {4 {{ r2 r4 .. .. {4 {{ {2 bb {{ {{ r2 rn r4 .. r2 rn rn "
		"rn rn r1 r1 rn rn r1 r5 .. r7 .. {4 {{ r3 rn rn rn r1 rn rn rn "
		"rn rn rn rn rn rn rn rn r1 r4 .. r3 r1 rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn r1 rn rn rn rn rn rn rn rn rn r8 "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn r4 {C "
	)
	)
	
(kern-mk-map 'm_losthalls_cpassage2 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn r4 {8 .. .. .. r2 rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn r8 rc {{ {2 .. r3 rn r8 rn rn rn rn rn rn "
		"rn rn rn rn rn r8 rc {{ {{ {3 .. .. r2 rc .. ra rn rn rn rn rn "
		"rn rn rn rn r8 {4 {{ {{ {{ {2 .. .. re .. .. .. rn rn rn rn rn "
		"rn rn rn r4 .. .. {1 {1 {1 .. .. .. .. .. bb .. rn rn rn rn rn "
		"rn rn rn rc .. .. .. .. .. .. .. {8 .. .. .. .. .. .. .. ra rn "
		"rn r8 r4 {{ {a .. .. .. .. .. {4 {{ {a .. .. .. {8 {8 .. .. r2 "
		"r4 .. re {{ {{ .. .. .. .. .. {4 {{ {{ {a .. .. {{ {{ {2 r3 rn "
		"rc .. .. {1 {1 .. .. .. bb .. {4 {{ {7 {{ {2 .. {5 {{ {2 ra r8 "
		".. .. .. .. .. bb .. .. .. .. .. {1 .. {1 .. .. .. bb .. .. .. "
		".. .. .. .. .. rd .. .. .. .. .. .. {8 {8 .. .. .. .. .. .. .. "
		"r5 .. .. r7 .. .. .. {8 .. .. .. r7 {{ {{ {2 .. .. {8 {8 {8 .. "
		"rn r1 r1 r4 {8 .. {4 {{ {2 .. rb rc {{ {3 .. .. {4 {{ {{ {{ r3 "
		"rn rn rn rc {{ {8 .. {1 .. .. {4 {{ {3 .. .. .. {4 {{ {{ r3 rn "
		"rn rn r4 {{ {{ {{ {a .. .. .. .. {1 .. .. bb .. .. {1 r3 rn rn "
		"rn rn rn r5 {{ {{ {{ {2 .. .. .. .. .. .. .. .. .. r3 rn rn rn "
		"rn rn rn rn rn .. .. .. .. {8 .. .. .. .. .. .. .. r2 rn rn rn "
		"rn rn rn rn rn r1 r5 .. r7 {{ {2 .. .. r7 .. r3 r1 rn rn rn rn "
		"rn rn rn rn rn rn rn r1 r4 {{ {2 .. .. r2 r1 rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn r5 .. .. .. ra rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn r4 .. .. .. .. r2 rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_croom 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn r4 .. .. .. .. .. .. r2 rn rn rn rn rn r4 bb "
		"rn rn rn rn rn rn r4 .. .. .. .. .. .. r2 rn rn rn rn rn rn r1 "
		"rn rn rn rn rn xx xx bb w+ xx d, xx w+ xx xx rn rn rn rn rn rn "
		"rn rn rn rn rn rc .. .. .. .. .. .. .. .. ra r8 rn rn rn rn rn "
		"rn rn rn rn rn .. .. .. .. .. .. .. .. {4 {{ {{ rn rn rn rn rn "
		"rn rn r4 {{ {{ .. .. .. bb .. .. .. .. .. .. .. {{ ra rn rn rn "
		"rn r8 xx {5 {{ .. .. .. .. .. .. .. .. .. .. .. {1 .. xx r8 r8 "
		"rc .. xx .. {1 .. .. bb xx xx w+ xx xx xx .. .. .. .. xx .. .. "
		".. .. w+ .. .. .. .. xx ,, ,, ,, ,, ,, rr .. .. .. .. w+ .. .. "
		".. .. xx .. .. .. .. xx ,, ,, .. ,, ,, xx .. .. .. .. rr .. .. "
		".. .. d, .. .. .. .. w+ ,, ,, ,, ,, ,, w+ .. bb .. .. d, .. .. "
		".. .. rr .. .. .. .. xx ,, ,, .. bb .. xx .. .. .. .. xx .. .. "
		".. .. w+ .. .. .. .. rr .. ,, ,, .. ,, xx .. .. .. .. w+ .. .. "
		".. r3 xx .. {8 .. .. rr xx d, xx w+ xx rr .. .. {8 .. xx .. .. "
		"r1 r4 bb {4 {{ .. .. .. .. .. ,, .. .. .. .. .. {{ {a xx r1 r1 "
		"rn rn r1 r5 {1 .. .. .. ,, .. .. .. .. .. .. .. {{ {{ xx rn rn "
		"rn rn rn rn rn {{ {a .. .. .. .. .. .. .. .. .. {{ r2 rn rn rn "
		"rn rn rn rn rn {{ {{ {2 .. .. .. .. .. .. .. r3 r1 rn rn rn rn "
		"rn rn rn rn rn r1 xx xx w+ xx d, xx w+ rr xx xx rn rn rn rn rn "
		"rn rn rn rn rn rn rn rc .. .. .. .. .. .. r2 rn rn rn rn rn r8 "
		"rn rn rn rn rn rn r4 .. .. .. .. .. .. .. r2 rn rn rn rn r4 {C "
	)
	)
	
(kern-mk-map 'm_losthalls_cruin 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn r4 .. bb .. .. .. .. r2 rn rn rn rn rn r4 bb "
		"rn rn rn rn rn rn r4 .. {8 .. .. .. .. r2 rn rn rn rn rn rn r1 "
		"rn rn rn rn rn xx xx bb {{ xx .. rr w+ xx xx rn rn rn rn rn rn "
		"rn rn rn rn rn rc .. .. {1 .. .. bb .. .. ra r8 rn rn rn rn rn "
		"rn rn rn rn rn .. .. .. .. .. .. .. .. {4 {{ {{ rn rn rn rn rn "
		"rn rn rr {{ {{ .. .. .. bb .. .. .. .. .. .. .. {{ ra rn rn rn "
		"rn r8 xx {5 {{ .. .. .. .. .. .. .. .. .. bb .. {1 .. xx r8 r8 "
		"rc .. xx .. {1 .. .. rr xx .. w+ bb .. rr .. .. .. .. xx .. .. "
		".. .. rr bb .. .. .. xx .. ,, ,, .. .. rr .. .. .. .. {8 bb .. "
		".. bb {{ {2 .. .. .. bb ,, .. .. .. ,, xx .. .. .. {4 {{ {2 .. "
		".. .. {9 .. .. bb .. w+ .. ,, ,, ,, ,, d, .. bb .. .. d, .. .. "
		".. {4 {C bb .. .. .. .. ,, .. .. bb .. xx .. ,, .. bb .. .. .. "
		".. bb w+ .. .. .. .. rr .. ,, .. .. ,, .. .. .. .. .. w+ bb .. "
		".. r3 xx .. {8 .. .. xx rr .. rr .. xx rr bb .. {8 .. xx .. .. "
		"r1 r4 bb {4 {{ .. .. .. .. bb .. .. .. .. .. .. {{ {a xx r1 r1 "
		"rn rn rr r5 {1 .. .. .. .. .. .. .. .. .. .. .. {{ {{ xx rn rn "
		"rn rn rn rn rn {{ {a .. .. .. .. .. bb .. .. .. {{ r2 rn rn rn "
		"rn rn rn rn rn {{ {{ {2 {8 bb .. .. .. .. .. r3 r1 rn rn rn rn "
		"rn rn rn rn rn rr xx xx {{ xx .. .. bb rr xx xx rn rn rn rn rn "
		"rn rn rn rn rn rn rn rc {1 .. .. .. .. .. r2 rn rn rn rn rn r8 "
		"rn rn rn rn rn rn r4 .. .. bb .. .. .. bb r2 rn rn rn rn r4 {C "
	)
	)
	
(kern-mk-map 'm_losthalls_cblock 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn r4 bb "
		"rn rn rn rn rn rn rn rn r8 rn rn rn rn rn rn rn rn rn rn rn r1 "
		"rn rn rn rn rn xx xx xx bb xx xx r8 xx xx xx rn rn rn rn rn rn "
		"rn rn rn rn rn rc .. .. .. .. .. .. .. .. ra r8 rn rn rn rn rn "
		"rn rn rn rn rn .. .. .. .. .. .. .. .. {4 {{ {{ rn rn rn rn rn "
		"rn rn rr {{ {{ xx xx ,, ,, xx xx xx w+ w+ xx xx {{ ra rr rn rn "
		"rn rn xx {5 {{ rr ,, ,, .. ,, xx @@ @@ bb @@ xx {1 .. xx rn rn "
		"rn rn xx .. {1 ws ,, .. ,, ,, xx ,, ,, ,, ,, rr .. .. bb r2 rn "
		"rn rn xx bb .. bb ,, ,, ,, ,, ,, ,, ,, .. ,, w+ .. .. xx rn rn "
		"rn r4 bb .. .. rr ,, ,, ,, ,, xx ,, ,, ,, ,, rr .. .. xx rn rn "
		"rn rn rr .. .. ws .. .. ,, ,, xx xx bb w+ xx xx .. .. xx rn rn "
		"rn rn xx bb .. xx ,, ,, ,, ,, xx ,, ,, ,, ,, xx .. .. rr rn rn "
		"rn rn xx .. .. ,, ,, bb ,, ,, ,, ,, ,, .. ,, ,, .. .. rr rn rn "
		"rn rn rr .. {8 ,, ,, ,, .. ,, ,, ,, ,, ,, ,, ,, {8 .. xx rn rn "
		"rn rn xx {4 {{ xx ,, .. ,, ,, xx ,, .. ,, ,, xx {{ {a xx rn rn "
		"rn rn rn r5 {1 rr rr ,, ,, xx xx xx rr ws xx xx {{ {{ xx rn rn "
		"rn rn rn rn rn {{ {a .. .. .. .. .. .. .. .. {4 {{ r2 rn rn rn "
		"rn rn rn rn rn {{ {{ {2 .. .. .. .. .. .. .. r3 r1 rn rn rn rn "
		"rn rn rn rn rn rr xx xx rr rr xx rr xx xx xx xx rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn r8 "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn r4 {C "
	)
	)

(kern-mk-map 'm_losthalls_special 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 r8 rn rn rn "
		"rn rn r4 .. .. .. .. .. .. .. .. .. .. .. .. {8 .. .. r2 rn rn "
		"rn rn rn rn rn .. .. .. bb .. .. .. .. .. {4 {{ rn rn rn rn rn "
		"rn rn rn rn rn rd .! {8 {8 .. .! .. .. .! {8 {1 rn rn rn rn rn "
		"rn rn rn rn rn {{ {e {{ {{ {2 .. .. .. bb {{ {2 rn rn rn rn rn "
		"rn rn rn rn rn {5 {{ {{ rf .! .. .! {4 {{ {{ r3 rn rn rn rn rn "
		"rn rn rn rn rn .! bb .! .! .! .! .! .! {A {{ r2 rn rn rn rn rn "
	)
	)


(kern-mk-map 'm_losthalls_stairu 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx xx xx xx xx xx xx xx xx xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. ,, .. ,, .. .. .. ,, .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. ,, .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. ,, ,, ,, ,, .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. ,, .. .. .. ,, ,, ,, ,, .. .. xx rn rn rn "
		"rn rn rn xx .. .. xx ,, ,, ,, ,, ,, ,, ,, xx .. .. xx rn rn rn "
		"rn rn rn xx .. xx xx xx cc cc cc cc cc xx xx xx .. xx rn rn rn "
		"rn rn rn xx .. xx xx xx ,, ,, ,, ,, ,, xx xx xx .. xx rn rn rn "
		"rn rn rn xx .. .. xx xx cc cc cc cc cc xx xx .. .. xx rn rn rn "
		"rn rn rn xx .. .. xx xx xx ,, ,, ,, xx xx xx .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. xx xx cc cc cc xx xx .. .. .. xx rn rn rn "
		"rn rn rn xx xx .. .. xx xx ,, ,, ,, xx xx .. .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx xx xx cc cc cc xx xx xx xx xx rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx ,, ,, ,, xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx d, d, d, xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx xx xx xx xx rn rn rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_rhall 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn xx .. ,, .. .. .. xx rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx .. .. .. ,, .. xx rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx .. .. ,, ,, .. rr rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx rr xx bb .. .. .. .. xx xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. bb .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. @@ @@ @@ @@ .. .. .. @@ @@ @@ @@ .. xx rn rn rn "
		"xx rr xx xx .. .. .. .. .. .. ,, .. .. .. .. .. .. xx rr xx xx "
		".. bb .. .. .. @@ @@ @@ @@ .. .. .. @@ @@ @@ @@ .. .. .. .. .. "
		".. .. .. ,, .. .. ,, .. .. .. .. .. .. .. .. .. .. .. .. ,, .. "
		",, .. ,, ,, .. .. .. .. bb .. .. .. .. .. ,, .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. ,, .. .. .. bb .. .. ,, .. ,, "
		",, .. .. .. .. @@ @@ @@ @@ .. ,, .. @@ @@ @@ @@ .. .. .. .. .. "
		"xx xx rr xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx xx rr xx "
		"rn rn rn xx .. @@ bb @@ @@ .. .. .. @@ @@ @@ @@ .. xx rn rn rn "
		"rn rn rn rr .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx xx .. .. .. .. .. xx xx rr xx rn rn rn rn "
		"rn rn rn rn rn rn r4 bb .. .. ,, .. ,, xx rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx .. .. ,, bb .. rr rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx .. ,, .. .. .. xx rn rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_rwall 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn r8 rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx xx rr bb rr xx xx xx xx xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. .. pp .. .. .. .. bb pp .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn rr .. pp bb pp .. .. .. .. .. pp .. pp .. rr rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. rr rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. bb .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. bb .. pp .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn rr .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. pp .. pp .. .. .. .. .. pp .. pp .. bb r2 rn rn "
		"rn rn rn xx .. .. bb .. .. .. .. .. .. .. .. bb .. xx rn rn rn "
		"rn rn rn rr .. .. .. pp .. .. .. .. .. pp .. .. .. xx rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx rr xx xx bb xx rr rr xx xx xx rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn r1 rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_rrooms 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn xx .. .. ,, xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx xx d, xx xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rr .. .. .. xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx xx xx xx .. ,, .. xx xx xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. xx xx .. .. .. rr xx .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. .. .. xx xx d, xx xx ,, .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. ,, .. ws .. .. .. ws ,, ,, .. .. xx rn rn rn "
		"rn rn rn xx xx .. ,, .. xx .. ,, .. xx .. .. ,, xx xx rn rn rn "
		"xx xx xx rr xx xx d, xx xx .. .. .. xx xx d, xx rr xx rr xx xx "
		".. xx .. .. .. xx .. .. .. .. .. .. .. .. .. xx .. .. .. xx ,, "
		".. d, ,, .. .. d, .. ,, .. ,, .. ,, .. .. ,, d, .. ,, .. d, .. "
		",, xx .. .. .. xx .. .. .. .. ,, .. .. .. .. xx .. .. .. xx .. "
		"xx xx xx xx xx xx d, rr xx .. .. .. xx xx d, xx xx xx xx xx xx "
		"rn rn rn rr xx .. ,, .. xx .. .. ,, xx .. .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. ,, ,, ws .. ,, .. ws .. ,, ,, .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. xx xx d, xx xx .. ,, .. .. xx rn rn rn "
		"rn rn rn xx xx .. .. xx rr .. .. .. xx xx .. .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx xx xx ,, .. .. xx xx xx xx xx rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx .. ,, .. rr rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx xx d, xx xx rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn xx .. .. .. xx rn rn rn rn rn rn rn rn "
	)
	)

(kern-mk-map 'm_losthalls_rwall 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn r8 rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx xx rr bb rr xx xx xx xx xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn xx .. .. .. pp .. .. .. .. bb pp .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn rr .. pp bb pp .. .. .. .. .. pp .. pp .. rr rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. rr rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. bb .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. bb .. pp .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn rr .. .. .. .. .. .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx .. pp .. pp .. .. .. .. .. pp .. pp .. bb r2 rn rn "
		"rn rn rn xx .. .. bb .. .. .. .. .. .. .. .. bb .. xx rn rn rn "
		"rn rn rn rr .. .. .. pp .. .. .. .. .. pp .. .. .. xx rn rn rn "
		"rn rn rn xx xx .. .. .. .. .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx rr xx xx bb xx rr rr xx xx xx rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn r1 rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn rn "
	)
	)
	
(kern-mk-map 'm_losthalls_rrockfall 21 21 pal_expanded
	(list
		"rn rn rn rn rn rn rn xx r8 rn rn r8 rn rn rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx bb ra rc bb ra xx rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn rr rd bb .. .. bb xx rn rn rn rn rn rn rn "
		"rn rn rn rn xx xx xx xx .. .. ,, bb .. rr xx xx xx rn rn rn rn "
		"rn rn rn xx xx .. .. .. bb .. .. .. .. .. .. .. xx xx rn rn rn "
		"rn rn rn rr .. .. bb {8 .. .. .. bb .. bb .. .. .. xx rn rn rn "
		"rn rn rn xx .. {4 {{ {{ {2 .. .. .. .. .. bb {8 .. xx rn rn rn "
		"rn xx xx xx .. .. {1 bb .. bb .. r3 r5 .. {4 {{ {2 xx rr xx rn "
		"r4 bb .. bb .. bb {4 {{ {2 bb r3 r8 r4 bb .. {1 .. .. bb ra rn "
		"rn r5 bb .. .. .. bb {1 rf .. r6 bb re .. .. bb .. .. bb .. r2 "
		"rn rn rd .. .. .. bb r7 bb bb re bb .. bb {8 .. .. .. bb r3 rn "
		"rn r4 bb .. .. .. .. ra rd .. bb r7 .. {4 {{ {2 .. bb .. ra rn "
		"rn rn r5 .. .. bb .. bb .. rf bb re .. bb bb bb .. .. .. bb r2 "
		"rn xx xx xx .. bb .. .. .. .. .. .. .. bb rf bb .. xx xx xx rn "
		"rn rn rn xx .. .. bb .. .. bb .. .. bb .. bb rf .. rr rn rn rn "
		"rn rn rn xx .. {4 {{ {2 bb .. .. .. .. .. .. .. .. xx rn rn rn "
		"rn rn rn xx xx .. {1 .. bb .. .. .. bb .. bb .. xx xx rn rn rn "
		"rn rn rn rn xx xx xx xx bb .. .. .. bb xx xx rr xx rn rn rn rn "
		"rn rn rn rn rn rn rn xx .. .. bb .. r3 rr rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx bb r3 r5 bb r2 xx rn rn rn rn rn rn rn "
		"rn rn rn rn rn rn rn xx r1 rn rn r1 rn xx rn rn rn rn rn rn rn "
	))



;probability for edge terrains... out of 83
(define losthalls-terrain-edges
	(list
		(list 20 'm_losthalls_cwall #f)
		(list 30 'm_losthalls_cblock #f)
		(list 50 'm_losthalls_cpassage #t)
		(list 60 'm_losthalls_cpassage2 #t)
		(list 75 'm_losthalls_cruin #t)
		(list 90 'm_losthalls_croom #t)
		(list 999 'm_test2templ_room #t 'test2-room-n 'test2-room-w 'test2-room-e 'test2-room-s)
	))

;probability for area terrains... out of 149
(define losthalls-terrain-area
	(list
		(list 30 'm_losthalls_cwall)
		(list 40 'm_losthalls_cblock)
		(list 65 'm_losthalls_cpassage)
		(list 95 'm_losthalls_cpassage2)
		(list 115 'm_losthalls_cruin)
		(list 990 'm_losthalls_croom)
	))
	
(define losthalls-passable-edges
	(list
		(list 60 'm_losthalls_cpassage)
		(list 90 'm_losthalls_cpassage2)
		(list 110 'm_losthalls_croom)
		(list 999 'm_test2templ_room 'test2-room-n 'test2-room-w 'test2-room-e 'test2-room-s)
	))
	
;probability for edge terrains... out of 83
(define losthalls-ruin-edges
	(list
		(list 20 'm_losthalls_rwall #f)
		(list 30 'm_losthalls_rrockfall #f)
		(list 50 'm_losthalls_rhall #t)
		(list 60 'm_losthalls_rhall #t)
		(list 75 'm_losthalls_rrooms #t)
		(list 90 'm_losthalls_rhall #t)
		(list 999 'm_test2templ_room #t 'test2-room-n 'test2-room-w 'test2-room-e 'test2-room-s)
	))

;probability for area terrains... out of 149
(define losthalls-ruin-area
	(list
		(list 30 'm_losthalls_rwall)
		(list 40 'm_losthalls_rwall)
		(list 65 'm_losthalls_rrooms)
		(list 95 'm_losthalls_rrockfall)
		(list 115 'm_losthalls_rhall)
		(list 990 'm_losthalls_rhall)
	))

;map areas replaced by the various blitting ops
(define losthalls-room-blitstats
	(prmap-mk-blitstats 21 21 5 4 5))
	
(define losthalls-ruin-blitstats
	(prmap-mk-blitstats 21 21 4 4 4))
	
;parameters to random number generators
(define losthalls-random-type-ew (prmap-mk-prng-params (deep-rno) (deep-rno) (deep-rno) (deep-rno) 83))
(define losthalls-random-type-ns (prmap-mk-prng-params (deep-rno) (deep-rno) (deep-rno) (deep-rno) 83))
(define losthalls-random-type-area (prmap-mk-prng-params (deep-rno) (deep-rno) (deep-rno) (deep-rno) 149))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; critters

;; critter types, list of lists of (value, critter tag)
(define losthalls-monster-types
	(list 
		(list 
			(list 100 'bat)
		)
		(list
			(list 100 'rat)
			(list 200 'bat)
		)
		(list
			(list 100 'giant-spider)
			(list 150 'queen-spider)
		)
		(list
			(list 100 'cave-goblin-slinger)
			(list 200 'cave-goblin-berserker)
			(list 250 'cave-goblin-priest)
		)
		(list
			(list 50 'cave-goblin-slinger-m)
			(list 100 'cave-goblin-berserker-m)
			(list 300 'troll-m)
			(list 350 'troll-geomancer-m)
		)
		(list
			(list 100 'green-slime)
			(list 200 'yellow-slime)
		)	
		(list
			(list 50 'cave-goblin-slinger-m)
			(list 100 'cave-goblin-berserker-m)
			(list 150 'troll-m)
			(list 350 'gint-warrior-m)
			(list 400 'gint-mage-m)
		)
	)
)

;; group types list of lists of
;; (randomnumber offset, type index, total value, number)
(define losthalls-group-types
	(list
		(list 10 0 100 "1d4+3") ;bats
		(list 20 1 100 "1d4+3") ;rats
		(list 30 1 200 "1d6+4") ;bats n rats
		(list 40 5 100 "1d3+2") ;slime
		(list 50 2 100 "1d4+3") ;spiders
		(list 60 3 100 "1d3+1") ;goblins
		(list 70 2 110 "1d4+3") ;spiders 1q
		(list 90 2 150 "1d6+4") ;spiders +qs
		(list 100 5 200 "1d6+3") ;slime+
		(list 110 3 200 "1d6+4") ;goblin war
		(list 140 4 300 "1d6+3") ;trolls
		(list 160 6 350 "1d6+3") ;gint
		(list 200 3 210 "1d6+5") ;goblin war +p
		(list 220 3 250 "2d4+4") ;goblin tribe
		(list 230 4 350 "1d6+5") ;trolls +m
		(list 240 6 400 "2d4+4") ;gint + m
	)
)

; creates new objects for a room
;    uses lost halls critter types, and difficulty increases a bit northwards and a lot downwards
(define (losthalls-room-init-contents kplace roomdata)
	(let* (
			(ryloc (prmap-roomdata-y roomdata))
			(rzloc (prmap-roomdata-z roomdata))
			(distance (+ (* rzloc 20) ryloc))
		)
		(if (and (null? (kern-place-get-beings kplace))
				(< (kern-dice-roll "1d100") 
					(min 75 (+ 25 (* 2 distance)))))
			(begin 
			(map (lambda (monster)
				(begin 
					(prmap-room-addmonster kplace monster)))
				(prmap-mk-monster-group losthalls-group-types losthalls-monster-types 
					(string-append "1d" (number->string (min 300 (ceiling (* 25 distance)))))
					(+ 250 (* 25 distance) (kern-dice-roll "1d200"))
					)))
		)
	))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Time memory - move to prmap?

(define (losthalls-timekeeper-mkobj time)
  (list 'losthalls time))
(define (losthalls-timekeeper-get tk) (cadr tk))
(define (losthalls-timekeeper-set! tk val) (set-car! (cdr mm) val))

(mk-obj-type 't_losthalls_timekeeper nil nil layer-none nil)

(define (losthalls-timekeeper-mk)
  (bind (kern-obj-set-visible (kern-mk-obj t_losthalls_timekeeper 1) #f)
        (losthalls-timekeeper-mkobj (map - game-start-time
                        (time-mk 0 0 0 1 1 1)))))


(define (losthalls-room-store-time kplace roomdata)
	(let* (
			(ryloc (prmap-roomdata-y roomdata))
			(rzloc (prmap-roomdata-z roomdata))
			(distance (+ (* rzloc 20) ryloc))
		)
		(if (and (null? (kern-place-get-beings kplace))
				(< (kern-dice-roll "1d100") 
					(min 75 (+ 25 (* 2 distance)))))
			(begin 
			(map (lambda (monster)
				(begin 
					(prmap-room-addmonster kplace monster)))
				(prmap-mk-monster-group losthalls-group-types losthalls-monster-types 
					(string-append "1d" (number->string (min 300 (ceiling (* 25 distance)))))
					(+ 250 (* 25 distance) (kern-dice-roll "1d200"))
					)))
		)
	))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; timer object

;; one hour wait
(define (losthalls-respawn-time? oldtime)
  (let ((curtime (kern-get-time)))
    (or (> (time-year curtime) (time-year oldtime))
        (> (time-month curtime) (time-month oldtime))
        (> (time-week curtime) (time-week oldtime))
        (> (time-day curtime) (time-day oldtime))
        (and (= (time-day curtime) (time-day oldtime))
             (> (time-hour curtime) (time-hour oldtime))))))

(define (losthalls-timer-time timer) (cadr (gob timer)))
(define (losthalls-timer-set! timer val) (set-car! (cdr (gob timer)) val))

(mk-obj-type 't_losthalls_timer nil nil layer-none nil)

(define (losthalls-mk-timer)
  (bind (kern-obj-set-visible (kern-mk-obj t_losthalls_timer 1) #f)
        (list 'timer (time-mk -1 0 0 0 0 0))))
      
(define (losthalls-timer-check kplace)
	(let ((timerlist (kplace-get-objects-of-type kplace t_losthalls_timer)))
		(if (equal? (length timerlist) 0)
			(let ((newtimer (losthalls-mk-timer)))
				(kern-obj-put-at newtimer (list kplace 0 0))
				(losthalls-timer-set! newtimer (kern-get-time))
				#t
				)
			(let* ((timer (car timerlist))
					(respawn (losthalls-respawn-time? (losthalls-timer-time timer))))
				(losthalls-timer-set! timer (kern-get-time))
				respawn
				))
		))
          
(define (losthalls-do-prmap-content kplace roomdata)
	(if (losthalls-timer-check kplace)
		(losthalls-room-init-contents kplace roomdata)))
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; handles
  
(define (losthalls-link-factory x y z map dir)
		(list 'm_losthalls_cpassage2 nil)
		)  

(define (losthalls-link-factory-ruin x y z map dir)
		(list 'm_losthalls_rhall nil)
		)  
  
(define (losthalls-init-cohesion mapdata ruindata)
	(if (list-ref mapdata 10)
		(begin
			;;(kern-log-msg "begin cohesion check")
			(prmap-ensure-cohesion mapdata -3 3 1 7 0 losthalls-link-factory)
			(prmap-ensure-cohesion ruindata 0 5 0 5 1 losthalls-link-factory-ruin)
			;;(kern-log-msg "end cohesion check")
			(mutable-list-set mapdata 10 #f)
		)))
  
(define (losthalls-room-custom-hardlinks rxloc ryloc rzloc hardlinks)
	(vector-merge
		(prmap-room-hardlinkentry-get rxloc ryloc rzloc hardlinks)
		(vector
			(if (> ryloc 7) (list nil 'm_losthalls_cwall) nil)
			(if (< rxloc -3) (list nil 'm_losthalls_cwall) nil)
			(if (> rxloc 3) (list nil 'm_losthalls_cwall) nil)
			(if (< ryloc 1) (list nil 'm_losthalls_cwall) nil)
		)
	))
	
(define (losthalls-ruin-custom-hardlinks rxloc ryloc rzloc hardlinks)
	(vector-merge
		(prmap-room-hardlinkentry-get rxloc ryloc rzloc hardlinks)
		(vector
			(if (> ryloc 4) (list nil 'm_losthalls_rwall) nil)
			(if (< rxloc 1) (list nil 'm_losthalls_rwall) nil)
			(if (> rxloc 4) (list nil 'm_losthalls_rwall) nil)
			(if (< ryloc 1) (list nil 'm_losthalls_rwall) nil)
		)
	))

(define (losthalls-room-handle-deeps kplace kplayer)
	(let* (
			(roomdata (get-roomdata kplace))
			(smapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
			(mapdata 
				(if (zero? (prmap-roomdata-z roomdata))
					smapdata
					(prmap-get-mapdata (eval 'p_lost_halls_r2)))
			)
		)
		(prmap-room-freeze-current smapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)
		(prmap-room-cleanout kplace)
		(prmap-room-thaw kplace smapdata)		
		(prmap-room-blit-map kplace roomdata mapdata)
		(losthalls-do-prmap-content kplace roomdata)
	))
	
(define (losthalls-room-handle-staird kplace kplayer)
	(let* (
			(roomdata (get-roomdata kplace))
			(mapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
		)
		(prmap-room-freeze-current mapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)		
		(prmap-room-blit-map-edges kplace roomdata mapdata)
		;;(losthalls-room-init-contents kplace roomdata)
	))
	
(define (losthalls-room-handle-stairu kplace kplayer)
	(let* (
			(roomdata (get-roomdata kplace))
			(smapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
			(mapdata (prmap-get-mapdata (eval 'p_lost_halls_r2)))
		)
		(prmap-room-freeze-current smapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)		
		(prmap-room-blit-map-edges kplace roomdata mapdata)
		(kern-place-set-neighbor south kplace nil)
		;;(losthalls-room-init-contents kplace roomdata)
	))
	
(define (losthalls-room-handle-croom kplace kplayer)
	(let* (
			(roomdata (get-roomdata kplace))
			(mapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
		)
		(prmap-room-freeze-current mapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)		
		(prmap-room-blit-map-edges kplace roomdata mapdata)
		;;(losthalls-room-init-contents kplace roomdata)
	))
	
(define (losthalls-room-handle-rroom kplace kplayer)
	(let* (
			(roomdata (get-roomdata kplace))
			(smapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
			(mapdata (prmap-get-mapdata (eval 'p_lost_halls_r2)))
		)
		(prmap-room-freeze-current smapdata)
		(prmap-room-init-neighbors kplace roomdata)
		(prmap-room-init-links kplace roomdata mapdata)		
		(prmap-room-blit-map-edges kplace roomdata mapdata)
		;;(losthalls-room-init-contents kplace roomdata)
	))

(define (losthalls-room-handle-start kplace kplayer)
	(let* (
		(roomdata (get-roomdata (eval 'p_lost_halls_r1)))
		(mapdata (prmap-get-mapdata (eval 'p_lost_halls_r1)))
		(ruindata (prmap-get-mapdata (eval 'p_lost_halls_r2)))
		)
		(losthalls-init-cohesion mapdata ruindata)
		(prmap-room-freeze-current mapdata)
		(prmap-roomdata-setxyz roomdata 0 0 0)
		(kern-place-set-neighbor north kplace (eval 'p_lost_halls_r1))
	))	
	
(define (losthalls-handle-rshrine kplace kplayer)
	(if (and (quest-data-assigned? 'questentry-wise)
			(null? (quest-data-getvalue 'questentry-warritrix 'reached)))
		(begin
			(kern-obj-put-at (mk-corpse2
			       '(
			        (1 t_rune_l_init)
			        (1 t_armor_chain_4)
			        (1 t_chain_coif_4)
			        (1 t_sword_4)
			        (1 t_shield_4)
			        (1 t_warritrix_orders)
			        )) (list p_lost_halls_rshrine 10 10))
			(drop-random-corpses p_lost_halls_rshrine 5)
			(quest-data-update 'questentry-warritrix 'reached 1)
		)
	)
	)
	
