;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define lux-lvl 7)
(define lux-species sp_ghast)
(define lux-occ oc_wizard)

;;----------------------------------------------------------------------------
;; Schedule
;;
;; Ф
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (lux-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 饯ޥˤϥå(ƬƤƤӽФ)ǡݥꥹΰ
;; ˤʪˤۤƤ롣ϥɤ줷ʲä
;; ƺǸˤϸԤȤΤ褦ˤʤԤˤäݤ줿
;;----------------------------------------------------------------------------

;; Basics...
(define (lux-hail knpc kpc)
  (say knpc "ΤʤϻդǳƤȲäϲ˾ߤ"
       "ह٤Ԥ衣"))

(define (lux-default knpc kpc)
  (say knpc "λ̵֤̤ˤʡ"))

(define (lux-name knpc kpc)
  (say knpc "ϰʥ饯ޥˡβǤ롣"))

(define (lux-rune knpc kpc)
  (say knpc "𤵤줿褦˸"
       "ϰ뤿ᡢԤˤäƺ줿ȬĤθΰĤ"))

(define (lux-gate knpc kpc)
  (say knpc "줾θˤϼԤꡢߤ˲񤦤ȤػߤƤ"
       "ƤϰѤƤϼԤ")
  (if (yes? kpc)
      (begin
        (say knpc "ʤФʤϤǤΤȤʹΤμϲʤäΤ")
        (if (yes? kpc)
            (say knpc "ϰդ򤳤ƾФäϲ򤫤ȻפäƤΤ"
                 "פäƤԤ򤫤ʤΤǤǤθλǤθǤ롪")
            (say knpc "ǤϿͤ˺줿夫Ϥޤ롣")))
      (begin
        (say knpc "ͤ")
        (if (yes? kpc)
            (say knpc "λह٤Ǥͤ⼫餬ΤβͤΤʤ")
            (say knpc "ʤ϶ǤˤȤΤ"
                 "λν϶ᤤ")))))

(define (lux-age knpc kpc)
  (say knpc "礬줿ȤѻդλϽä"
       "줬桢Υɤ줷ԡ饯ޥˤλλϤޤä"
       "θλۼԤۤȤ˰ʤꡢĤ˲ҤȤʤä"
       "Ƽ줿塢κϤޤä"
       "礤ʤ̩Τꤿ")
  (if (yes? kpc)
      (say knpc "ʤ褦ǸμԤ衣")
      (say knpc "\n˶Ф\n"
           "ΤǤǸμԤ衪"))
  (say knpc "礬줿Ȥ줿ϽǤ"))

(define (lux-keep knpc kpc)
  (say knpc "ϺǸμԤǤˤΰ̣Τ롣"
       "ƤǤ򤬼٤ΤƤμˤ뤫")
  (if (yes? kpc)
      (say knpc "ʤΤʡ·ʤϳʤ")
      (say knpc "õФͤ̾Ԥѿߤ"
           "༫Ȥ򡢤ǤϤʤ")))

(define (lux-wise knpc kpc)
  (say knpc "ԡϾФä\n"
       "λۼԤȿդԤ衪\n"
       "\n"
       "ΤΥ\n"
       "μԤϲηǤ餫\n"
       "ƼηΨ\n"
       "ѻդΥա\n"
       "μԤȿռԤش\n"
       "ƲŽѻդ˻ä\n"
       "ʤ餺ԤΥʡȥϥå\n"
       "μԤͤϤ郎Ṳ̃\n"
       "̩ϩ򸫤ĤФ\n"
       "ͤΥɡ\n"
       "μԤϤ郎֤ܺԤ\n"
       "\n"
       "\n"
       "̤ˤؤ餺ϻह٤ˤä"
       "\n")
  (say knpc "\nϤʤԤܤǸ\n"
       "̾Τ̤")
  (if (yes? kpc)
      (say knpc "ʤжò衣郎")
      (begin
	(say knpc
	     "\n䤿ܤܤǵ\n"
	     "λθԤȸƤФԤٻΤʡ\n"
	     "Τ褦ʤĤޤ̼ԤΤ̡\n"
	     "졢ह٤Τ衪")
	(kern-conv-end)
	))
  )

(define (lux-accu knpc kpc)
  (say knpc "줿ԡ\n"
       "줾λˤϡΤ褦Ϥԡ"
       "Τ褦ʷٶƻäǤ蘆ʤԤ롣\n"
       "\n"
       "ԤǤܤ졢"
       "ޤԤϿϤ¾ˤ롣\n"
       "\n"
       "Ϥޤ˴Τ褦ʤΤǤ롣")
  )


(define lux-conv
  (ifc basic-conv

       ;; basics
       (method 'default lux-default)
       (method 'hail lux-hail)
       (method 'name lux-name)

       (method 'rune lux-rune)
       (method 'key  lux-rune) ;; A synonym

       (method 'demo lux-gate) ;; A synonym
       (method 'gate lux-gate)

       (method 'wise lux-wise)
       (method 'accu lux-accu)

       (method 'age  lux-age)
       (method 'keep lux-keep)

       ))

(define (mk-luximene)
  (bind 
   (kern-mk-char 
    'ch_lux           ; tag
    "饯ޥ"          ; name
    lux-species         ; species
    lux-occ              ; occ
    s_ghost     ; sprite
    faction-men      ; starting alignment
    0 0 0            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    lux-lvl
    #f               ; dead
    'lux-conv         ; conv
    nil           ; sched
    nil              ; special ai
    nil              ; container
    nil              ; readied
    )
   (lux-mk)))

(define (mk-lich-king)
  (let ((kchar 
         (bind 
          (kern-char-force-drop
           (kern-mk-char 
            'ch_lich_king           ; tag
            "åβ" ; name
            sp_lich         ; species
            oc_wizard              ; occ
            s_lich     ; sprite
            faction-monster      ; starting alignment
            10 10 10            ; str/int/dex
            10 1              ; hp mod/mult
            0  0              ; mp mod/mult
            max-health ; hp
            -1                   ; xp
            max-health ; mp
            0
            8
            #f               ; dead
            nil              ; conv
            nil             ; sched
            'lich-ai        ; special ai
            (mk-inventory
             (list (list 1 t_morning_star)
                   (list 1 t_armor_chain_4)
                   (list 1 t_chain_coif_4)
                   (list 100 t_gold_coins)
                   (list 3 t_mana_potion)
                   (list 3 t_heal_potion)
                   (list 1 t_lich_skull)
                   (list 1 t_lichs_blood)
                   ))
            nil              ; readied
            )
           #t)
          (lux-mk))))
    (map (lambda (eff) (kern-obj-add-effect kchar eff nil))
         undead-effects)
    kchar))

