;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define may-start-lvl  6)
(define inn-room-price 30)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ܥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_may
               (list 0  0  bole-bed-may "sleeping")
               (list 6  0  bole-dining-hall "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (may-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ᥤϽɲμͤνǡܥ˽Ǥ롣
;; (7ܤ)פǤ롣
;;----------------------------------------------------------------------------
(define (may-trade knpc kpc)
  (say knpc "˼ˤöΥ˸äȤ졣"))

(define (may-hail knpc kpc)
  (say knpc "ΤʤäνȲäԤܤǤ򸫤Ƥ롣"
       "äʤΤ褿͡Ǥ⤤ä㤤"))

(define (may-job knpc kpc)
  (say knpc "ܥΤμöڤꤷƤΤ衣"))

(define (may-husband knpc kpc)
  (say knpc "öΥΤߤΥǥʥɡӤϤΤ衣"
       "¾ϻͤö᤬ɡ"
       "νɤäƤɬפä뺧ͳϤ衣"))

(define (may-other-husbands knpc kpc)
  (say knpc "ۤöϤäƥХäΤ˲ͤϹä"
       "ǤߤʼʬΥХΤǻ󤸤ޤä"
       "󤿤Хߤ͡ĤΥХΤǻ̤衣"))

(define (may-tavern knpc kpc)
  (say knpc "ƤҤ˽Ф"
       "ʪ俩ΡȤ٤"))

(define (may-guests knpc kpc)
  (say knpc "ϤʤԤܤǸϤ뤪ʽȤΡϢ졣"
       "Ǥ⡢֤̤ۤõƤ󤸤ʤͤ")
  (if (kern-conv-get-yes-no? kpc)
      (begin
        (say knpc "äѤͤǡĤϲ򤤤ΤäƤ")
        (if (kern-conv-get-yes-no? kpc)
            (begin
              (say knpc "ͤҤⲿõƤ衣"
                   "ˤϴطʤɡ"
                   "⤷ȡνȤ󤿤õƤۤϲäƤ󤸤ʤ͡"
                   "¿ʬĸ򴹤Ƥ"))
            (say knpc "󡢤äޤ̤ˤɡ"
                 "Ǥ⤢󤿤ˤ˹ԤäƤޤä衣")))
      (say knpc "⤷ļˤФФäʤΤ")))

(define (may-woman knpc kpc)
  (say knpc "ΤǤϤʤ줤ʿͤȤϤۤȤɲʤ"
       "襤ʥӥϹ줳Ǥ衣"
       "ƤΥХöϤȤ뤴Ȥˤ餷ܤǸƤ롣"
       "϶᤯ˤäƤ䤤ϤǤ⡢νν衪"))

(define (may-companion knpc kpc)
  (say knpc "νڤۤϢƤ롣ηƤ󤸤ʤ͡"
       "¿ʬνѿǤⲿǸȤʹƤΤϤ狼ʤ͡"))

(define (may-bill knpc kpc)
  (say knpc "ӥϤΤǯƬϤ褯ʤľǡڤäƤ롣"
       "褯ǿäƤ衣ƻҤȤ٤äƤ롣"))

(define (may-hackle knpc kpc)
  (say knpc "ϥåϤǤϤʤ衣ʬ˽Ǥ롣"
       "Ťε뤱ȡ¾ϲǤʤ"))

(define (may-room knpc kpc)
  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "ɤϤ⤦Ĥ衣6ˤޤȤ졣")
      (let ((door (eval 'bole-inn-room-door)))
        ;; is the room still open?
        (if (not (door-locked? (kobj-gob door)))
            ;; yes - remind player
            (say knpc "Ϥ⤦Ƥ衣")
            ;; no - ask if player needs a room
            (begin
              (say knpc "뤫")
              (if (kern-conv-get-yes-no? kpc)
                  ;; yes - player wants a room
                  (begin
                    (say knpc 
                         "" inn-room-price "͡"
                         "Įˤ¤겿٤ǤǤ롣"
                         "")
                    (if (kern-conv-get-yes-no? kpc)
                        ;; yes - player agrees to the price
                        (let ((gold (kern-player-get-gold)))
                          ;; does player have enough gold?
                          (if (>= gold inn-room-price)
                              ;; yes - player has enough gold
                              (begin
                                (kern-player-set-gold 
                                 (- gold 
                                    inn-room-price))
                                (say knpc "ɤ⡣ϱκ衣")
                                (send-signal knpc door 'unlock)
                                (kern-conv-end)
                                )
                              ;; no - player does not have enouvh gold)
                              (say knpc "⤬­ʤ衪")))
                        ;; no - player does not agree to the price
                        (say knpc 
                             "ʤ餽ǿФϵ˵դʡ")))
                  ;; no - player does not want a room
                  (say knpc "󤿤Τ褦ۤ⤤Ĥϵ٤衪")))))))
  
(define (may-thief knpc kpc)
  (say knpc "Ĥʪ"
       "äݤۤ衣ǶҤ褿"))

(define (may-trouble knpc kpc)
  (say knpc "󤿡ΤۤߤʸƼϤʤĤ򤷤Ƥ롣"
       "Ǥ⡢󤿤ϰԤʤ͡"))

(define may-conv
  (ifc nil
       (method 'default (lambda (knpc kpc) (say knpc "ɤ褦ʤ͡")))
       (method 'hail may-hail)
       (method 'bye  (lambda (knpc kpc) (say knpc "ФƤäФƤä")))
       (method 'job  may-job)
       (method 'name (lambda (knpc kpc) (say knpc "ᥤȸƤФƤ롣")))
       (method 'join (lambda (knpc kpc)
                       (say knpc "󤿤ΥХ˴ޤʤǤ졣")))

       (method 'buy   may-trade)
       (method 'food  may-trade)
       (method 'drin  may-trade)
       (method 'supp  may-trade)
       (method 'trade may-trade)

       (method 'bill  may-bill)
       (method 'comp  may-companion)
       (method 'thin  may-companion) ;; Ϣ
       (method 'gues  may-guests)
       (method 'clie  may-guests) ;; 
       (method 'hack  may-hackle)
       (method 'husb  may-husband)
       (method 'inn   may-tavern)
       (method 'melv  may-husband)
       (method 'other may-other-husbands)
       (method 'run   may-tavern)
       (method 'room  may-room)
       (method 'six   may-other-husbands)
       (method 'tave  may-tavern)
       (method 'thie  may-thief)
       (method 'trou  may-trouble)
       (method 'woma  may-woman)

       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-may)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     'ch_may ;;......tag
     "ᥤ" ;;.......name
     sp_human ;;.....species
     nil ;;..........occupation
     s_townswoman ;;...sprite
     faction-men ;;..faction
     0 ;;............custom strength modifier
     1 ;;............custom intelligence modifier
     0 ;;............custom dexterity modifier
     0 ;;............custom base hp modifier
     0 ;;............custom hp multiplier (per-level)
     0 ;;............custom base mp modifier
     0 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     may-start-lvl  ;;..current level
     #f ;;...........dead?
     'may-conv ;;...conversation (optional)
     sch_may ;;.....schedule (optional)
     'townsman-ai ;;..........custom ai (optional)
     nil ;;..........container (and contents)
     (list t_dagger) ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (may-mk)))
