;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define meaney-lvl 6)
(define meaney-species sp_human)
(define meaney-occ nil)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ѡζ᤯εϱ
;;----------------------------------------------------------------------------
(define meaney-bed poorh-bed1)
(define meaney-mealplace poorh-sup1)
(define meaney-workplace poorh-hall)
(define meaney-leisureplace poorh-dining)
(kern-mk-sched 'sch_meaney
               (list 0  0 meaney-bed          "sleeping")
               (list 5  0 meaney-mealplace    "eating")
               (list 6  0 meaney-workplace    "working")
               (list 12 0 meaney-mealplace    "eating")
               (list 13 0 meaney-workplace    "working")
               (list 18 0 meaney-mealplace    "eating")
               (list 19 0 meaney-leisureplace "idle")
               (list 21 0 meaney-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (meaney-mk) (list 0 #t))
(define (meaney-get-donated meaney) (car meaney))
(define (meaney-donated? meaney) (> (meaney-get-donated meaney) 
                                    0))
(define (meaney-donate! meaney q) (set-car! meaney (+ (car meaney) q)))
(define (meaney-has-ring meaney) (cadr meaney))
(define (meaney-remove-ring meaney) (set-car! (cdr meaney) #f))

(define (meaney-on-death knpc)
	(if  (meaney-has-ring (kobj-gob-data knpc))
		(kern-obj-put-at (kern-mk-obj t_skull_ring_m 1) (kern-obj-get-location knpc))
	))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; ߡˡϽϩĤηǡѡζ᤯εϱ˽Ǥ롣
;; ϤĤƻῼξȰγ±ä
;; ˴ȤʤäƥĹΤɤƤ롣
;;----------------------------------------------------------------------------

;; 
(define (meaney-hail knpc kpc)
  (say knpc "ʤ򴿷ޤޤι"))

(define (meaney-default knpc kpc)
  (say knpc "ϤǤޤ"))

(define (meaney-name knpc kpc)
  (say knpc "ƻΤΥߡˡǤ")
  (quest-data-update 'questentry-ghertie 'meaney-loc 1))

(define (meaney-join knpc kpc)
  (say knpc "ˤϤԤȲ򤷤Ԥؤε̳ޤ"))

(define (meaney-job knpc kpc)
  (say knpc "εϱ"
       "¤μԡϤԤΤƯƤޤ"))

(define (meaney-bye knpc kpc)
  (say knpc "褦ʤ顣"))

;; Second-tier responses
(define (meaney-get-donation knpc kpc)
  (define (rejected)
    (cond ((> (kern-player-get-gold) 0)
           (say knpc "ǤǤϤޤΤȤˡᤷؤ")
           (kern-conv-end))
          (else
           (say knpc "ʤɬפ⤷ޤ"))))
  (let ((meaney (kobj-gob-data knpc)))
    (if (not (meaney-donated? meaney))
        (begin
          (say knpc "ϤԤΤդ򤪴ꤤǤޤ")
          (if (kern-conv-get-yes-no? kpc)
              (let ((q (get-gold-donation knpc kpc)))
                (if (> q 0)
                    (begin
                      (say knpc "ι˽ʡ졪"
                           "ʤιԤϵǤ礦")
                      (meaney-donate! meaney q))
                    (rejected)))
              (rejected))))))

(define (meaney-poor knpc kpc)
  (say knpc "εϱǤ̤˴ͤȸɻٱ礷Ƥޤ"
       "ʤϽɬפǤ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "ʤдǿ򾯤ʬͿޤ礦")
      (meaney-get-donation knpc kpc)))

(define (meaney-sick knpc kpc)
  (say knpc "褿ԤɬפʤïǤ⼣ŤޤŤɬפǤ")
  (if (kern-conv-get-yes-no? kpc)
      (meaney-trade knpc kpc)
      (meaney-get-donation knpc kpc)))

(define (meaney-brot knpc kpc)
  (say knpc "ϽϩĤηǤ"
       "ζĤ¤ͤΥǡӥˤꡢ7ʾϤ͡ߤΩޤ"))

;; Trade...
(define (meaney-trade knpc kpc)
  (if (trade-services knpc kpc
                      (list
                       (svc-mk "ϲ" 0 heal-service)
                       (svc-mk "" 0 cure-service)
                       ))
      (begin
        (say knpc "¾˼ŤɬפʿͤϤޤ")
        (meaney-trade knpc kpc))
      (begin
        (say knpc "¾˲ɬפǤ")
        (if (kern-conv-get-yes-no? kpc)
            (meaney-trade knpc kpc)
            (meaney-get-donation knpc kpc)))))

;; Town & Townspeople

;; Quest-related
(define (meaney-pira knpc kpc)
	(quest-data-update 'questentry-ghertie 'meaney-loc 1)
	(say knpc "ϤĤƤϳ±ǤäΤΤȤǤ"
		"äΥƥȶ˻ῼ˾äƤޤ"
		"ϤνȤϤͤ˿Ƥޤ"))

(define (meaney-gher knpc kpc)
  (say knpc "ƥϻ䤿겼²Τ褦ˤĤäƤޤ"
       "ƱƼϤʤάåԤǡʶʤޤǤ⤢ޤ"
       "ϻ̤٤äǤ礦"
       "©ҤˤäƤʤ٤ǤϤޤǤ"))

(define (meaney-pena knpc kpc)
  (say knpc "Ͽ¿κȤƤοͤηήޤ"
       "Ĺ΢ڤꡢƵդ΢ڤޤ"))

(define (meaney-betr knpc kpc)
  (say knpc "겼ǶŤĹ򻦤åäΤʬޤ"
       "ʬʤСϼʬ򻦤ȻפǤΤǤ"
       "ǽͧ͡ƻϼǲˤʤäƤ֤򻦳ޤ"
       "äƤߤȡϻ䤿֤ƹԤäƤޤäΤǤ"))

(define (meaney-firs knpc kpc)
  (say knpc "ǽͧϥ硼Ȥ̾ΰޤǤ"
       "ǤιʿΤɤ±äƤʹޤ"
       "ФʹФ褤⤷ޤ")
       (quest-data-update 'questentry-ghertie 'jorn-forest 1))

(define (meaney-cook knpc kpc)
  (say knpc "åȤϻɤϴޤƤǤ礦"
       "Ǹ˲äΤϿˤˬ줿ȤǤ"
       "īܤФȢθƤޤ"
       "Ȣ϶Ǥ")
       (quest-data-update 'questentry-ghertie 'gholet-prison 1)
       )

(define (meaney-ring knpc kpc)
  (if (not (meaney-has-ring (kobj-gob-data knpc)))
      (say knpc "⤦μ줿ؤϸʤΤǤ")
      (begin
        (say knpc "Ϥϥƥ©ҡῼλؤĤƤޤ"
             "Ͽͻγ±ʤΤǤ")
        (prompt-for-key)
        (say knpc "ˤȤϤ褿¤ͤΥȤϡηˤäܤǤ"
              "ǺᤷƤޤ")
        (if (yes? kpc)
            (begin
              (say knpc "ηǹԤäƤиϤǤƤޤƬ򲼤")
              (kern-conv-end))
            (begin
              (say knpc "ʤϻῼ"
                    "λؤ̤ȤΤˤϤλؤ̤ʤФʤޤ"
                    "ˤϤλؤڤȤͦϤޤ󡣤ʤäƤޤ")
              (if (yes? kpc)
                  (begin
                    (say knpc "ΤʤμĤߡ᤯ؤڤȤ"
                          "áǻϼޤ"
                          "꤬Ȥޤ¤͡"
                          "⤷伣Ťɬפʤ顢ϤʤΤ˹Ԥޤ")
			(skullring-m-get nil kpc)
			(meaney-remove-ring (kobj-gob-data knpc))
                    )
                  (say knpc "ϤΰΤ줿ΤǤ")))))))

(define meaney-conv
  (ifc basic-conv

       ;; basics
       (method 'default meaney-default)
       (method 'hail meaney-hail)
       (method 'bye  meaney-bye)
       (method 'job  meaney-job)
       (method 'name meaney-name)
       (method 'join meaney-join)
       
       ;; trade
       (method 'trad meaney-trade)
       (method 'buy  meaney-trade)
       (method 'sell meaney-trade)

       ;; town & people

       ;; other responses
       (method 'poor meaney-poor)
       (method 'dest meaney-poor)
       (method 'sick meaney-sick)
       (method 'heal meaney-sick)
       (method 'affl meaney-sick)
       (method 'brot meaney-brot)
       (method 'hous meaney-job)

       ;; pirate quest replies
       (method 'pira meaney-pira)
       (method 'gher meaney-gher)
       ;(method 'ma   meaney-gher)
       (method 'capt meaney-gher)
       (method 'pena meaney-pena)
       (method 'betr meaney-betr)
       (method 'firs meaney-firs)
       (method 'cook meaney-cook)
       (method 'ring meaney-ring)
       (method 'skul meaney-ring)
       (method 'ghol meaney-cook)
       (method 'jorn meaney-firs)
       ))

(define (mk-meaney)
	(let ((knpc
    (kern-mk-char 
     'ch_meaney           ; tag
     "ߡˡ"           ; name
     meaney-species         ; species
     meaney-occ              ; occ
     s_companion_shepherd  ; sprite
     faction-men      ; starting alignment
     1 2 1            ; str/int/dex
     0 0              ; hp mod/mult
     0 0              ; mp mod/mult
     max-health ; hp
     -1                   ; xp
     max-health ; mp
     0
     meaney-lvl
     #f               ; dead
     'meaney-conv         ; conv
     sch_meaney           ; sched
     'townsman-ai              ; special ai

     ;;..........container (and contents)
     (mk-inventory
      (list
       (list 1 t_dagger)
       ))
     nil              ; readied
     )))
 (kern-char-force-drop knpc #t)
  (bind knpc (meaney-mk))
  (kern-obj-add-effect knpc 
           ef_generic_death
           'meaney-on-death)
	  knpc) )
  