;;----------------------------------------------------------------------------
;; Schedule
;;
;; ܥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_melvin
               (list 0  0  bole-bed-melvin      "sleeping")
               (list 7  0  bole-kitchen "working")
               (list 21 0  bole-bedroom-may      "idle")
               (list 22 0  bole-bed-melvin "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (melvin-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ϥܥνɤͤǤ롣
;; ϥᥤ(7ܤ)פǤ롣
;;----------------------------------------------------------------------------
(define melv-merch-msgs
  (list "줬ƤȤƤ졣7鿼ޤǤäƤ롣"
        "Τ" ;; buy
        nil ;; sell
        nil ;; trade
        "ʤ" ;; sold-something
        "ޤäƤߤʤ衣" ;; sold-nothing
        nil ;; bought-something
        nil ;; bought-nothing
        nil ;; traded-something
        nil ;; traded-nothing
   ))

(define melv-catalog
  (list
   (list t_beer  4 "ӡ롢īӤ")
   (list t_food  3 "Τꤸ㥷ɤΥѥڡ˥硦åɾȽ")
   ))

(define (melvin-buy knpc kpc) (conv-trade knpc kpc "buy" melv-merch-msgs melv-catalog))

;; basics...
(define (melvin-default knpc kpc)
  (say knpc "ᥤʹƤ졣ˤϤ狼"))

(define (melvin-hail knpc kpc)
  (say knpc "Τʤ줤ͤȲäϤä㤤"))

(define (melvin-name knpc kpc)
  (say knpc "ͤΥ"))

(define (melvin-job knpc kpc)
  (say knpc "ܥμȽɤʤΥᥤȤäƤ롣"
       "ơᥤФ"))

(define (melvin-join knpc kpc)
  (say knpc "äȤޤͤʡ"
       "ʤȤ⤳ˤǤ롣"))

(define (melvin-bye knpc kpc)
  (say knpc "꤬Ȥʢä餤ĤǤäƤ衣"))

;; other characters & town...
(define (melvin-may knpc kpc)
  (say knpc "ʤΥᥤʿޤʽˤΤ褦˱Ԥ"))

(define (melvin-kath knpc kpc)
  (say knpc "֤줤ʽ"
       "ˡȤ𤴤Ȥ˼ͤùۤɰߤƤ⤤ʤХǤʤ"
       "Ȥϸ󡣤νȤϢˤ϶Ťʡ"))

(define (melvin-bill knpc kpc)
  (say knpc "Ĥϥͥ1ܤ2ܳƤ롣Ǥ⤤ۤ"))

(define (melvin-thud knpc kpc)
  (say knpc "֤Ȱ褿ΤϿʹ֤ʤ"
       "Ǥ⡢ʤˤޤ٤ȥϸȤʤ"
       "褯狼󤬡ˡ⤷"))

(define (melvin-bole knpc kpc)
  (say knpc ""))

(define (melvin-hack knpc kpc)
  (say knpc "ϥåϤĮζϤäˤ롣"
       "ǤϤʤ"))


;; thief quest...
(define (melvin-thie knpc kpc)
  (say knpc "ǶۤΤˤʡϹĸߤ̤ޤäƤ"
       "֤Ƥˤʤʤäʤʤ˥ϥåäƤȻפ"
       "ִ̯ʤȤ"))

;; misc...
(define (melvin-wiza knpc kpc)
  (say knpc "ʤȤˤʤäƤ衪"
       "֤ˡȤѤۤδ֤ǲäƤ롣ˤϤ狼"))

(define (melvin-inn knpc kpc)
  (say knpc "뤫䤿ʪߤХᥤ˸äƤ졣"
       "ʢä鲶ˤäƤ졣"
       "˽Ф"))

(define (melvin-hung knpc kpc)
  (say knpc "ʢϸäƤ뤫")
  (if (kern-conv-get-yes-no? kpc)
      (melvin-buy knpc kpc)
      (say knpc "ʢä餽äƤ졪")))

(define melvin-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default melvin-default)
       (method 'hail melvin-hail)
       (method 'bye  melvin-bye)
       (method 'job  melvin-job)       
       (method 'name melvin-name)
       (method 'join melvin-join)

       (method 'buy  melvin-buy)
       (method 'food melvin-buy)
       (method 'drin melvin-buy)
       (method 'supp melvin-buy)
       (method 'trad melvin-buy)

       (method 'food melvin-buy)
       (method 'trad melvin-buy)
       (method 'buy  melvin-buy)

       (method 'bill melvin-bill)
       (method 'cook melvin-inn)
       (method 'inn  melvin-inn)
       (method 'kath melvin-kath)
       (method 'red  melvin-kath)
       (method 'lady melvin-kath)
       (method 'sorc melvin-kath)
       (method 'may  melvin-may)
       (method 'hack melvin-hack)
       (method 'hung melvin-hung)
       (method 'tave melvin-inn)
       (method 'thud melvin-thud)
       (method 'thin melvin-thud)
       (method 'pet  melvin-thud)

       (method 'thie melvin-thie)
       (method 'rogu melvin-thie)
       (method 'char melvin-thie)

       (method 'bole melvin-bole)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-melvin)
  (bind 
   (kern-mk-char 'ch_melvin          ; tag
                 ""        ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townsman          ; sprite
                 faction-men         ; starting alignment
                 2 0 1             ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'melvin-conv        ; conv
                 sch_melvin          ; sched
                 'townsman-ai         ; special ai
                 nil     				; container
                 (list t_dagger)   ; readied
                 )
   (melvin-mk)))
