;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define nate-start-lvl 2)

;;----------------------------------------------------------------------------
;; Schedule
;;
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (nate-mk) (list #f #f))
(define (nate-caught? gob) (car gob))
(define (nate-caught! gob) (set-car! gob #t))
(define (nate-met? gob) (cadr gob))
(define (nate-met! gob) (set-car! (cdr gob) #t))

;;----------------------------------------------------------------------------
;; Conv
;;
;; ͥȤ±ƬǤ롣
;;----------------------------------------------------------------------------
(define (nate-hail knpc kpc)
  (let ((nate (kobj-gob-data knpc)))
    (define (join)
      (say knpc "Թ礬Ȥ̩ˤĤʹƤöᡣ"
           "ޤФƨꤷ䤻")
      (join-player knpc)
      (give kpc t_arrow 20)
      (nate-caught! nate)
      (quest-data-update-with 'questentry-bandits 'captured-nate 1 (quest-notify nil))
      )
    (nate-met! nate)
    (cond ((nate-caught? nate)
           (say knpc "ǤäƤ")
           )
          (else
           (say knpc "Ԥ衢ͳϤʤ"
                "ߤϤäǤͻϤƤͤ"
                "Ƥ졣Ф̩򶵤Ƥ롣"
                "ɤ")
           (cond ((yes? kpc) (join))
                 (else
                  (say knpc "öᡪ򻦤̩ϲȰ˾äޤ"
                       "ࡢϤ󤿤֤ˤʤäơ󤿤Τäơ󤿤ŤϤΤȤƳ"
                       "ȴФꤷͤ"
                       "θǲ֥Ȣʤꡢƨʤ깥ʤ褦ˤƤ졣"
                       "ɤ")
                  (cond ((yes? kpc) (join))
                        (else
                         (say knpc "ۤ򻦤ʤƷޤʤۤ")
                         (kern-conv-end)
                         ))))))))

(define (nate-secr knpc kpc)
  (cond ((is-player-party-member? knpc)
         (cond ((equal? (get-place knpc) p_shard)
                (say knpc "֥ǥɤα줿򶵤ޤ"))
               (else
                (say knpc "öᡪϰǤϤޤ󤼡ؽФƤ줫ä䤷礦")
                )))
        (else
         (say knpc "ʤ̩ϰ")
         )))

(define (nate-brun knpc kpc)
  (if (is-player-party-member? knpc)
      (say knpc "öᡢƻ̤˿ʤνǥ֥ǥɤõ䤷礦"
           "ǹդ򶵤ޤ")
      (say knpc "θդʡ")))

(define (nate-pass knpc kpc)
  (if (is-player-party-member? knpc)
      (cond ((equal? (get-place knpc) p_brundegardt)
             (say knpc "褯Ĥ䤷öᡣդϡ"
                  "ϻ򤫤᤿"
                  "ĥΥϤ©ĤϹդϥΥ")
             (prompt-for-key)
             (say knpc "öᡢꤤ䤹"
                  "äĹ֥֡ǥɤˡõäȤΤȤ̩򸫤Ĥ䤷"
                  "ϢƹԤäƤӤ䤷礦ʤȿդƤ"
                  "ꤲ䤹")
             (cond ((yes? kpc)
                    (say knpc "ϰ˺䤻󡪤Ǥ⤳ĹȱƤ䤷"
                         "˲뤫ʬ䤻"
                         "ƻǤäƹԤ䤷礦")
                    (prompt-for-key)
                    (say knpc "Ǥ⡢ڤʤΤϡʸĴ礹뤿Ǥ䤹"
                         "öѻդǽϤФ褤ΤǤ䤹"
                         "θդФƤƤ֤򽪤С줬ɬɬפˤʤ롣"))
                   (else
                    (say knpc "ͤʤƤǤ⡢⤷ϢƹԤͤΤʤ顢"
                         "ٹʹƤ"
                         "öΤ褦ʤäȤΤǤ⡢ͤǥ֥ǥɤäƤϤ䤻"
                         "ߤ䶯åǽϤԤϢƤ٤Ǥ䤹")
                    )))
             (else
              (say knpc "Ǥöᡪϥ֥ǥɤǤϤ䤻")
              ))
      (say knpc "աιդ")
      ))

(define nate-conv
  (ifc basic-conv
       (method 'name (lambda (knpc kpc) (say knpc "ͥȤȸƤФƤ롣")))
       (method 'brun nate-brun)
       (method 'hail nate-hail)
       (method 'pass nate-pass)
       (method 'secr nate-secr)
       ))

(define nate-greetings
  (list
   "롪"
   "ʤǤ졪"
   "ޤƤ졪"
   "ΤࡢϴϢƹԤäƤ졪"
   ))

(define (nate-ai knpc)
  (let ((nate (kobj-gob-data knpc)))
    (cond ((nate-met? nate) (std-ai knpc))
          ((any-player-party-member-visible? knpc)
           (taunt knpc nil nate-greetings)
           #t)
          (else
           (std-ai knpc)
           )
          )))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-nate)
  (bind 
   (kern-char-arm-self
    (kern-mk-char 
     'ch_nate ;;..........tag
     "ͥ" ;;.......name
     sp_human ;;.....species
     oc_wrogue ;;.. .occupation
     s_companion_bard ;;..sprite
     faction-outlaw ;;..faction
     +1 ;;...........custom strength modifier
     0 ;;...........custom intelligence modifier
     +6 ;;...........custom dexterity modifier
     pc-hp-off ;;............custom base hp modifier
     pc-hp-gain ;;............custom hp multiplier (per-level)
     0 ;;............custom base mp modifier
     0 ;;............custom mp multiplier (per-level)
     max-health ;;..current hit points
     -1  ;;...........current experience points
     max-health ;;..current magic points
     0
     nate-start-lvl  ;;..current level
     #f ;;...........dead?
     'nate-conv ;;...conversation (optional)
     nil ;;sch_nate ;;.....schedule (optional)
     'nate-ai ;;..........custom ai (optional)

     ;;..............container (and contents)
     (mk-inventory
      (list
       (list 20 t_arrow)
       (list 1   t_bow)
       (list 1   t_dagger)
       (list 1   t_sword)
       (list 1   t_leather_helm)
       (list 1   t_armor_leather)
       (list 5   t_heal_potion)
       ))

     nil ;;.........readied arms (in addition to the container contents)
     nil ;;..........hooks in effect
     ))
   (nate-mk)))
