;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define necr-lvl 8)
(define necr-species sp_human)
(define necr-occ oc_wizard)

;;----------------------------------------------------------------------------
;; Schedule
;;----------------------------------------------------------------------------
(define necr-bed nl-bed)
(define necr-mealplace nl-tbl)
(define necr-workplace nl-lab)
(define necr-leisureplace nl-lib)
(kern-mk-sched 'sch_necr
               (list 0  0 necr-bed          "sleeping")
               (list 7  0 necr-mealplace    "eating")
               (list 8  0 necr-workplace    "working")
               (list 12 0 necr-mealplace    "eating")
               (list 13 0 necr-workplace    "working")
               (list 18 0 necr-mealplace    "eating")
               (list 19 0 necr-leisureplace "idle")
               (list 22 0 necr-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (necr-mk) 
  (mk-quest))
(define (necr-quest gob) gob)

;;----------------------------------------------------------------------------
;; Conv
;;----------------------------------------------------------------------------

;; Basics...
(define (necr-hail knpc kpc)
  (let ((quest (necr-quest (kobj-gob-data knpc))))
    (if (and (quest-offered? quest)
             (not (quest-done? quest))
             (in-inventory? kpc t_lich_skull)
             )
        (necr-meet-lich knpc kpc)
        (say knpc "ΤʤϿ餻ȹѻդȲä"
             "(ۥ)褦¤ͤ衣"))))

(define (necr-default knpc kpc)
  (say knpc "ϳǤऻƤ롣"))

(define (necr-heal knpc kpc)
  (begin
    (say knpc "\nϳǤ롣\n"
         "פΥۥϡΥ")
    (prompt-for-key)

    (say knpc "褤\n")
    (prompt-for-key)

    (say knpc "\n亮ġΥۥ")
    (prompt-for-key)

    (say knpc "\nΥϡ")
    (prompt-for-key)

    (say knpc "Υá")
    (kern-sleep 100)
    (say knpc "ݤ줿")
    (kern-sleep 100)
    (say knpc "Υϡϡ")
    (kern-sleep 3000)
    (say knpc "ġġġ")
    (prompt-for-key)

    (say knpc "\nۤ")
    (prompt-for-key)

    (if (in-player-party? 'ch_mesmeme)
	(begin	
	  (say knpc "\nۤ³ġ")
	  (kern-sleep 3000)
	  (aside kpc 'ch_mesmeme "ݤ줿Ѥ򸫤\n")
	  (aside kpc 'ch_amy "áᡪ")
	  (prompt-for-key)
	  )
	)

    (if (in-player-party? 'ch_nate)
	(begin
	  (say knpc "\nλˤʲΩƤƤ롣")
	  (kern-sleep 3000)
	  (aside kpc 'ch_nate "")
	  (kern-sleep 100)
	  (aside kpc 'ch_nate "ޤʡ")
	  (kern-sleep 1000)
	  (aside kpc 'ch_nate "ĥĤʪäƤä顩")
	  (kern-sleep 500)
	  (aside kpc 'ch_roland "ϼԡ̾ʤȤ")
	  (prompt-for-key)
	  )
	)
    
    (if (in-player-party? 'ch_amy)
	(begin
	  (aside kpc 'ch_amy "ɤˡ򷡤äۤ顩")
	  (prompt-for-key)
	  )
	)

    (kern-sleep 3000)
    (say knpc
	 "\nϤޤڻƤ롣\n"
	 "϶Τõꤷ\n"
	 "^c+b󡦥ޥˡס<IN VAS MANI CORP XEN>^c-\n"
	 "")
    ;; (vas-mani knpc)  ;; SAM: Alas, this invoked UI, and emitted extra messages
    (say knpc
	 "\nϵ夬ꡢ©ۤä\n"
	 "פȸäƤޤʡ")
    ))

(define (necr-name knpc kpc)
  (say knpc "亮ѻդ"))

(define (necr-join knpc kpc)
  (say knpc "亮ԤǤϤʤ"))

(define (necr-job knpc kpc)
  (say knpc "̩Ȥ"))

(define (necr-bye knpc kpc)
  (say knpc "ϳ򤷤ʤ餢ʤɤʧä"))

;; L2
(define (necr-dead knpc kpc)
  (say knpc "ࡩޤǤ̡ޤϤɤ")
  (if (yes? knpc)
      (say knpc "äƤ̤褦˸롣")
      (say knpc "ϻפ̡"
           "¿äƤޤȤϤʾäʤ褦")))

(define (necr-coug knpc kpc)
  (say knpc "äХäƤǤ⤿ޤ˵ۤ"))

(define (necr-spir knpc kpc)
  (say knpc "ĤΤȤƤŤˤΤȤΤäƤ롣(ۥ)"
       "⤷ΤꤿȤСΤɤˤϤ"))

;; Quest-related
(define (necr-meet-lich knpc kpc)
  (if (quest-done? (necr-quest (kobj-gob-data knpc)))
      (begin
        (say knpc "饯ޥ˲˿Ҥͤ衪ब뤫")
        (if (no? kpc)
            (begin
              (say knpc "顣Ǥ褤\n"
		   "ˡθդ򾧤"
		   "^c+b<WIS QUAS>^c-")
              (wis-quas knpc))
            (say knpc "")))
      (begin
        (say knpc "饯ޥ˲ƬäƤʡ"
             "Ǥ褤äʹ˰㤤ʤ"
             "Ԥơˡ")
        (kern-obj-remove-from-inventory kpc t_lich_skull 1)
        (say knpc "\nˡθդ򾧤\n"
             "^c+b롦󡦥󡦥<KAL AN XEN CORP>^c-"
             "饯ޥˤ衢衪")
        (kern-obj-put-at (mk-luximene)
                         (loc-offset (kern-obj-get-location knpc)
                                     south))
        (quest-done! (necr-quest (kobj-gob-data knpc)) #t)
        (say knpc "ब뤫")
        (if (no? kpc)
            (begin
              (say knpc "̵ϤΤʤԤˤϸ뤳ȤǤ̡\n"
                   "Ǥ褤\n"
                   "ˡθդ򾧤"
                   "^c+b<WIS QUAS>^c-")
              (wis-quas knpc))
            (say knpc "ǤΤȤʹʤ")))))

(define (necr-rune knpc kpc)
  (let ((quest (necr-quest (kobj-gob-data knpc))))
    (if (quest-offered? quest)
        (if (in-inventory? kpc t_lich_skull)
            (necr-meet-lich knpc kpc)
            (if (quest-done? quest)
                (begin
                  (say knpc "饯ޥ˲˿Ҥͤ衪ब뤫")
                  (if (no? kpc)
                      (begin
                        (say knpc "ĻμʸƤߤ褦\n"
			     "ˡθդ򾧤\n"
			     "^c+b<WIS QUAS>^c-\n"
			     "αƤäǤΤȤҤͤʤ")
			(wis-quas knpc)
			(kern-conv-end)
			)
                      (begin
			(say knpc "αƤ˿Ҥͤʤ")
			(kern-conv-end)
		      )
		  ))
                (say knpc "åȤʤä饯ޥ˲ƬäƤΤ"
                     "¿ΤȤ狼롣")))
        (if (not (any-in-inventory? kpc rune-types))
            (say knpc "¿Ǥ򸫤Ƥ(ۥ)"
                 "ĻäƤи뤫Τ̡")
            (begin
              (say knpc "դࡣ"
                   "Ǥ˽񤫤줿ʸϡĤƥ饯ޥ˲ǸΤƱ(ۥ)"
                   "˿ҤͤвƤ뤫⤷̡"
                   "¤ͤ衢ޤͦ͡")
              (if (no? kpc)
                  (say knpc "ǰʤ顣"
                         "Ǥ϶̣򤽤Τ(ۥ)")
                  (begin
                    (say knpc "Ȼפä"
                         "饯ޥ˲ϺǤϥåȤʤäƤ롣"
                         "Ǥ⶧˽ʡ"
                         "Фϲˤΰֽˤ롣"
                         "⤷ƬäƤСʤᡢä(ۥ)"
                         "ޤ򡢤μ겼ȶݤͤФʤ"
                         "ԻμԤŤʤˡΤäƤ뤫͡")
                    (quest-offered! quest #t)
                    (if (yes? kpc)
                        (say knpc "ܤԻμԤ򰷤ˤϺǤ褤ʸ")
                        (say knpc "ФƤ󡦥󡦥<An Xen Corp>"
                             "ǤͭʼʸǤ롣\n"
                             "^c+g^c-^c+gβγ^c-Ĵ礻衣\n"
                             "(ۥ)\n"
                             "餫ΤˤϤ"
                             "äƹԤäƤ褤"))
		    )))))))

(define (necr-absa knpc kpc)
  (say knpc "֥åȡŤԡϼ줿"
       "ԤäȤϤ뤫͡")
  (if (yes? kpc)
      (say knpc "ȤʤäƤѿΰפǤʤ")
      (begin
        (say knpc "饹ɥθʬٻ뤫͡")
        (if (yes? kpc)
            (say knpc "ϳʧ򤷤ƤĤ֤䤤"
                 "ĺǤϤˤϸ٤Τϲʤ")
            (say knpc "̩ƻ롣ϣѻդ˿ҤͤʤबΤäƤ롣")))))

;; the wise
(define (necr-ench knpc kpc)
  (say knpc "ζ򤫤ǯϥ亮줿Ԥΰ̣ȹͤƤ롪"
       "ۤϼʬƻͣƻǤϤʤȤ狼ʤ褦")
       )

(define (necr-man knpc kpc)
  (say knpc "ϾɬפʤȤ񤤤뤳Ȥ"
       "ƥ亮ʪäƤȤġ")
  (quest-data-update 'questentry-the-man 'common 1)
  )

(define (necr-alch knpc kpc)
  (say knpc "ˤ褭ƻʤǤ롣")
  (quest-data-update 'questentry-alchemist 'common 1)
  )

(define (necr-engi knpc kpc)
  (say knpc "ƹ񿴤˺ʤǤ롣"
       "ĤⲿäƤ롣"
       "꽪ȻפС̤ΤΤϤ롪(ۥ)"
       "ͤΤȸ礦ȤϷ褷ƤʤǤ")
       (quest-data-update 'questentry-engineer 'common 1)
       )

(define (necr-warr knpc kpc)
	(if (quest-data-assigned? 'questentry-wise)
		(begin
		  (say knpc "ϵƤޤä"
		       "ȵǲä"
		       "饹ɥλƳԤ˻줿Τ"
		       "ϲ򸫼ΤƤΤ졢β衢ޤΥɤˤ뤫")
		       (quest-data-update 'questentry-warritrix 'slain 1)
		 )
		 (say knpc "󤤲顢ۤɵ⤭ΤϤʤǤ")
       ))

(define (necr-vale knpc kpc)
  (say knpc "ŤϤȤΤƤ롣"))

(define (necr-wise knpc kpc)
  (say knpc "ϱ󤤲ΤǡΡѻաʤ餺Ԥƻ᤿Ԥ"
       "ΥɤƳΤ"
       "ĹκǡκǤŤˤޤǤΤܤ뤳ȤǤ롣"))

(define (necr-accu knpc kpc)
  (say knpc "٤Ԥ(ۥ)οĤ500ǯ⤷Ȥʾ˻ϤޤäƤȸŤäƤ줿"
       "̩Τ̡"
       "ʤʤϵˤϵʤ")
  (prompt-for-key)
  (say knpc "ϺǤƤ褦"
       "ޤǤοǼ줿ԤλԤ򸫤Ȥʤ"
       "줬Ǥ狼̤Τ"))

(define (necr-gate knpc kpc)
  (say knpc "ΰθ"
       "亮ñʤȹͤƤ롣"
       "ƻդʹƤߤʤϥ亮褯ΤäƤ롣"
       "亮ͤȲäʹƤߤ褦"))

(define (necr-necr knpc kpc)
  (say knpc "Υۥϥ亮ϻȷӤĤˡˤƤ롣"))

(define necr-conv
  (ifc basic-conv

       ;; basics
       (method 'default necr-default)
       (method 'hail necr-hail)
       (method 'bye necr-bye)
       (method 'job necr-job)
       (method 'name necr-name)
       (method 'join necr-join)
       (method 'heal necr-heal)
       
       (method 'dead necr-dead)
       (method 'coug necr-coug)
       (method 'spir necr-spir)
       (method 'rune necr-rune)
       (method 'absa necr-absa)
       (method 'ench necr-ench)
       (method 'man necr-man)
       (method 'alch necr-alch)
       (method 'engi necr-engi)
       (method 'warr necr-warr)
       (method 'vale necr-vale)
       (method 'wise necr-wise)
       (method 'accu necr-accu)
       (method 'gate necr-gate)
       (method 'demo necr-gate)
       (method 'necr necr-necr)
       ))

(define (mk-necromancer)
  (bind 
   (kern-mk-char 
    'ch_necr           ; tag
    "ѻ"       ; name
    necr-species         ; species
    necr-occ              ; occ
    s_necromancer     ; sprite
    faction-men      ; starting alignment
    1 6 0            ; str/int/dex
    0 0              ; hp mod/mult
    0 0              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    necr-lvl
    #f               ; dead
    'necr-conv         ; conv
    sch_necr         ; sched
    'townsman-ai              ; special ai
    nil              ; container
    (list t_staff)              ; readied
    )
   (necr-mk)))
