;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;;
;; ѡ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_oscar
               (list 0  0  oparine-innkeepers-bed "sleeping")
               (list 8  0  bilge-water-seat-3     "eating")
               (list 9  0  cheerful-counter       "working")
               (list 12 0  bilge-water-seat-3     "eating")
               (list 13 0  cheerful-counter       "working")
               (list 21 0  bilge-water-seat-3     "eating")
               (list 22 0  bilge-water-hall       "idle")
               (list 23 0  oparine-innkeepers-bed "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (oscar-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;;
;; ϥѡνɲǤ롣ϱڤε­򤷤Ƥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (oscar-hail knpc kpc)
  (say knpc "Τʤϱʡڤε­ˤȲäϤä㤤ġ"))

(define (oscar-default knpc kpc)
  (say knpc "Τޤ͡"))

(define (oscar-name knpc kpc)
  (say knpc "ɲΥ"))

(define (oscar-join knpc kpc)
  (say knpc "䤬Ƥ⤸ޤˤʤġ"))

(define (oscar-job knpc kpc)
  (say knpc "ɲ"
       "פ褦ˤϸʤ"
       "⤷פʤäƤ졣"))

(define (oscar-bye knpc kpc)
  (say knpc "ɤ⡣"))

;; Trade...
(define (oscar-trade knpc kpc)
  (if (not (string=? "working" (kern-obj-get-activity knpc)))
      (say knpc "ɲƱ͡פϸ99ޤǳƤ롣Ǥʤ"
           "ΤȤϸƤ졣")
      (let ((door (eval 'oparine-inn-room-1-door)))
        ;; is the room still open?
        (if (not (door-locked? (kobj-gob door)))
            ;; yes - remind player
            (say knpc "Ϥ⤦Ƥ롣")
            ;; no - ask if player needs a room
            (begin
              (say knpc "פΤ")
              (if (kern-conv-get-yes-no? kpc)
                  ;; yes - player wants a room
                  (begin
                    (say knpc 
                         "" oparine-inn-room-price ""
                         "Įˤ¤ꡢ٤ǤǤ롣"
                         "Ǥ")
                    (if (kern-conv-get-yes-no? kpc)
                        ;; yes - player agrees to the price
                        (let ((gold (kern-player-get-gold)))
                          ;; does player have enough gold?
                          (if (>= gold oparine-inn-room-price)
                              ;; yes - player has enough gold
                              (begin
                                (say knpc "1漼"
                                     "Ǥⵤʤ͡"
                                     "餫äƤ"
                                     "ʸϸʤǤ衣")
                                (kern-player-set-gold 
                                 (- gold 
                                    oparine-inn-room-price))
                                (send-signal knpc door 'unlock)
                                (kern-conv-end)
                                )
                              ;; no - player does not have enouvh gold)
                              (say knpc "ǰߤ­ʤʡ"
                                   "ΤäƤ̤ꡢϵϱǤϤʤ" )))
                        ;; no - player does not agree to the price
                        (say knpc 
                             "狼äƤ衣")))
                  ;; no - player does not want a room
                  (say knpc "͡"
                       "ҸʹƤߤ")))))))

;; Inn...
(define (oscar-inn knpc kpc)
  (say knpc "ۤ̾ˤ"
       "ѤȤϻפʤˤƤⱿ"))

(define (oscar-luck knpc kpc)
  (say knpc "νɤ̾Τ褦˴3漼ˤ"
       "±˴ܤ餻ʤ")
	(quest-data-assign-once 'questentry-ghertie)
	(quest-data-update 'questentry-ghertie 'ghertieloc 1))

(define (oscar-ghost knpc kpc)
  (say knpc "ƥȤҤ3漼Ǽʬμ겼˻줿"
       "˴ޤ뤫3漼ߤФʤ"
       "ʧäߤ͡")
	(quest-data-update 'questentry-ghertie 'ghertieid 1)
	(quest-data-update 'questentry-ghertie 'ghertieloc 1)
	(quest-data-assign-once 'questentry-ghertie))

;; Leg...
(define (oscar-leg knpc kpc)
  (say knpc "ˤʤꤿäǤïۤäƤʤä"
       "餷褦ˡʬ­ڤȤ"
       "ǤۤäƤʤä­򼺤ä"))

;; Townspeople...
(define (oscar-opar knpc kpc)
  (say knpc "ϹĮ"
       "ҤΤۤȤɤߤꤿ̤ظιͤ"))

(define (oscar-gher knpc kpc)
  (say knpc "ƥ϶±ä"
       "ʬμ겼˻졢Ⱥå줿")
	(quest-data-assign-once 'questentry-ghertie))

(define (oscar-alch knpc kpc)
  (say knpc "ŹϼΤȤʤˤ롣"
       "Ĥ褯狼ʤ¸ǻȤʪõƤ롣"))

(define (oscar-bart knpc kpc)
  (say knpc "СȤϤƻΤ礦ɸŹ¤ͤ"
       "ˤʤȤĤ̤˰Ǥ롣ȤƤ⤸ʤĤƤʤ"))

(define (oscar-seaw knpc kpc)
  (say knpc "ϤȤƤ⤭줤ͤ򤱤Ƥ롣"
       "ϻ̵뤷Ƥ롣"))

(define (oscar-henr knpc kpc)
  (say knpc "ʪĤΤ褦ˤФʤʤ"))

(define oscar-conv
  (ifc basic-conv

       ;; basics
       (method 'default oscar-default)
       (method 'hail oscar-hail)
       (method 'bye  oscar-bye)
       (method 'job  oscar-job)
       (method 'name oscar-name)
       (method 'join oscar-join)
       
       ;; trade
       (method 'trad oscar-trade)
       (method 'room oscar-trade)
       (method 'buy  oscar-trade)
       (method 'sell oscar-trade)

       ;; inn
       (method 'inn  oscar-inn)
       (method 'luck oscar-luck)
       (method 'ghos oscar-ghost)
       (method 'pira oscar-ghost)
       (method 'leg  oscar-leg)

       ;; town & people
       (method 'opar oscar-opar)
       (method 'alch oscar-alch)
       (method 'gher oscar-gher)
       (method 'ghas oscar-gher)
       (method 'henr oscar-henr)
       (method 'bart oscar-bart)
       (method 'sea  oscar-seaw)
       (method 'witc oscar-seaw)
       (method 'lia  oscar-seaw)

       ))

(define (mk-oscar)
  (bind 
   (kern-mk-char 'ch_oscar           ; tag
                 ""          ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_townsman          ; sprite
                 faction-men         ; starting alignment
                 1 1 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 1  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'oscar-conv         ; conv
                 sch_oscar           ; sched
                 'townsman-ai        ; special ai
                 nil                 ; container
                 (list t_dagger)     ; readied
                 )
   (oscar-mk)))
