;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; 饹ɥ
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_patch
               (list 0  0  gdp-bed "sleeping")
               (list 7  0  ghg-s1  "eating")
               (list 8  0  gh-ward "working")
               (list 11 0  ghg-s1  "eating")
               (list 12 0  gh-ward "working")
               (list 17 0  ghg-s1  "eating")
               (list 18 0  gc-hall "idle")
               (list 21 0  gdp-hut "idle")
               (list 22 0  gdp-bed "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (patch-mk) (list 'townsman))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 饹ɥ˽ϷͤѻդǡդȤƯƤ롣
;; ϴӤ򤷤ƤơִӤפȤΤƤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (patch-hail knpc kpc)
  (say knpc "ΤʤϴӤ򤷤ѻդϷͤȲä"
       "ˤϡι"))

(define (patch-default knpc kpc)
  (say knpc "ϼǤʤʡ"))

(define (patch-name knpc kpc)
  (say knpc "͡ϻӤȸƤǤ롣"))

(define (patch-join knpc kpc)
  (say knpc "䡣ˤΤ̳¤ͤ衣"))

(define (patch-job knpc kpc)
  (say knpc "±ƯƤ롣Ťɬפ͡")
  (if (kern-conv-get-yes-no? kpc)
      (patch-trade knpc kpc)
      (say knpc "ɬפʤȤ˼Ť褦")))

(define (patch-bye knpc kpc)
  (say knpc "ˡ"))

;; Trade...
(define (patch-trade knpc kpc)
  (if (trade-services knpc kpc
                      (list
                       (svc-mk "" 30 heal-service)
                       (svc-mk "" 30 cure-service)
                       (svc-mk "" 100 resurrect-service)))
      (begin
        (say knpc "¾˲뤳Ȥ뤫͡")
        (patch-trade knpc kpc))
      (begin
        (say knpc "¾˲뤫͡")
        (if (kern-conv-get-yes-no? kpc)
            (patch-trade knpc kpc)
            (say knpc "")))))
  
;; Patch...
(define (patch-patc knpc kpc)
  (say knpc "ݥꥹܤ򼺤äϤȤƤŤΤɬפʤäΤ"
       "ϸۤܤ򥦥󥯤"))

(define (patch-kurp knpc kpc)
  (say knpc "ΤµܤäƤ롣"
       "ơ㤤ʼ˽ƤȤϡˤΤ"))

(define (patch-tour knpc kpc)
  (say knpc "ƤΥ饹ɥλ̱ʼε̳롣"
       "ϰդä"))

(define (patch-medi knpc kpc)
  (say knpc "դϼŤεѤĹѻդ"
       "ƤΤˤ襤ٱ礹뤿դääƤ롣"
       "Ʈδ÷롣ûٻȤä"))

(define (patch-dagg knpc kpc)
  (say knpc "ûϻ⤭ĤˤȤäġ"
       "֤ǥΤ"))

(define (patch-dung knpc kpc)
  (say knpc "ʪϿʥޤ롣ۤ餬Ͼ˻ߤʤФʤʤ"
       "פ")
  (if (kern-conv-get-yes-no? kpc)
      (say knpc "̤ꡪΤϤ֤֤ƤΤ"
           "µܤǽɬפʤõʤˤϰդ롣")
      (say knpc "ۥ餬ܤļˤ˵äƤޤ")))

(define (patch-doc knpc kpc)
  (say knpc "ϰդŤɬפ͡")
  (if (kern-conv-get-yes-no? kpc)
      (patch-trade knpc kpc)
      (say knpc "ɬפˤʤä餳±ʤ"
           "Τ褦Ԥ襤Ǥɤܥܥˤʤ뤫ΤäƤ롪")))

(define (patch-hosp knpc kpc)
  (say knpc "饹ɥΤϾäƤ롣"
       "Ԥ¼µμԤǤ롣"))

;; Townspeople...

(define patch-conv
  (ifc glasdrin-conv

       ;; basics
       (method 'default patch-default)
       (method 'hail patch-hail)
       (method 'bye  patch-bye)
       (method 'job  patch-job)
       (method 'name patch-name)
       (method 'join patch-join)
       
       ;; trade
       (method 'trad patch-trade)
       (method 'heal patch-trade)
       (method 'cure patch-trade)
       (method 'resu patch-trade)
       (method 'help patch-trade)

       ;; patch
       (method 'patc patch-patc)
       (method 'kurp patch-kurp)
       (method 'tour patch-tour)
       (method 'medi patch-medi)
       (method 'dagg patch-dagg)
       (method 'dung patch-dung)
       (method 'doc  patch-doc)
       (method 'hosp patch-hosp)
       (method 'outp patch-dung)

       ;; town & people

       ))

(define (mk-patch)
  (bind 
   (kern-mk-char 'ch_patch           ; tag
                 ""              ; name
                 sp_human            ; species
                 oc_wizard           ; occ
                 s_companion_wizard  ; sprite
                 faction-glasdrin         ; starting alignment
                 1 3 0               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 6            ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'patch-conv         ; conv
                 sch_patch           ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_staff)))                 ; container
                 (list t_dagger)                 ; readied
                 )
   (patch-mk)))
