;;----------------------------------------------------
;; this is a collection place for updates to quests
;;
;; the function is an arbitary method call, but the ones here tend to
;; basically boil down to retreiving a bunch of flags from the quest payload
;; and updating the quest via (qst-set-descr! text)
;;
;; the boilerplate at the front of the methods just makes the quest data easily accessible
;; via a tbl-flag? method without needing to go through several level of redirection each time
;;

;;---------------
;; bandits
(define (quest-bandits-update)
  (println "quest-bandits-update")
  (let* ((quest (quest-data-get 'questentry-bandits))
         (quest-tbl (car (qst-payload quest)))
         (header (kern-ui-paginate-text
                  "úƤϷͥ쥴ˡǤ±"
                  "ߤޤ줿"
                  "")))
    (println "quest-tbl:" quest-tbl)
    (define (tbl-flag? tag) 
      (not (null? (tbl-get quest-tbl tag)))
      )
    (qst-set-descr! quest
                    (cond ((tbl-flag? 'done)
                           (kern-ui-paginate-text
                            "ͥȤФ"
                            ))
                          ((tbl-flag? 'nate-given-to-jailor)
                           (append header
                                   (kern-ui-paginate-text
                                    "ƾФηĹǥåϤ"
                                    "󽷤ä"
                                    )))
                          ((tbl-flag? 'captured-nate-and-talked-to-deric)
                           (append header
                                   (kern-ui-paginate-text
                                    "ͥȤФη̳ϢƹԤƾ"
                                    "ʤФʤʤ"
                                    )))
                          ((tbl-flag? 'captured-nate)
                           (append header
                                   (kern-ui-paginate-text 
                                    "±ƬͥȤ館ФϢƹԤ"
                                    "Ĺ𤷤ʤФʤʤ"
                                    )))
                          ((tbl-flag? 'talked-to-deric)
                           (append header
                                   (kern-ui-paginate-text 
                                    "ĹΥǥåϤޤˤʤʤ"
                                    "ˤʤ˲ä褦̿"
                                    ""
                                    )))
                          (else
                           (append header
                                   (kern-ui-paginate-text
                                    "쥴±ΤȤФǿҤͤ褦ˤ"
                                    "ä"
                                    )))
                          )

		)
	))

;;---------------
;; whereami

    (define (quest-whereami-update)
      (let* ((quest (quest-data-get 'questentry-whereami))
             (quest-tbl (car (qst-payload quest)))
             (qp-shard (tbl-get quest-tbl 'shard))
             (qp-wanderer (tbl-get quest-tbl 'wanderer)))

        (qst-set-descr! quest
                        
                        (if (not (null? (tbl-get quest-tbl 'nossifer)))

                            (kern-ui-paginate-text
                             "ʤϥɤˤ롣Ϲʵ⤫"
                             "ξҤä"
                             ""
                             "ϤˤʤƳΤϰβΥե"
                             "äϿθݤʬȤ"
                             "ɤ˸ƤӽФƻۤΤǤä"
                             ""
                             "礬ƥΥեƻ"
                             "ΤϤʤ"
                             )
                            
                            (append
                             ;;1 where
                             (cond ((null? qp-shard)
                                    (kern-ui-paginate-text
                                     "ĤȡʤϲεʤΤ"
                                     "ˤ "
                                     ""
                                     ))
                                   ((equal? 1 qp-shard)
                                    (kern-ui-paginate-text
                                     "ʤϸΤˤ롣͡ϤϤ򥷥"
                                     "ɤȸƤǤ롣"
                                     ""
                                     ))
                                   (#t (kern-ui-paginate-text
                                        "ʤϥɤˤ롣Ϲʵ⤫"
                                        "ξҤä"
                                        ""
                                        ))
                                   )


                             ;; how
                             (if (and (null? qp-wanderer) (null? qp-shard))
                                 (kern-ui-paginate-text "Ϥɤ")
                                 nil
                                 )
                             
                             (cond ((null? qp-wanderer)
                                    (kern-ui-paginate-text
                                     "ɤΤ褦ˤơƤʤ褿Τ"
                                     "줫ɤФ褤Τ"
                                     ))
                                   ((equal? 1 qp-wanderer)
                                    (kern-ui-paginate-text
                                     "ˤ⤢ʤΤ褦ˤž"
                                     "褦͡Ϥʤ¤͡פȸƤ֤"
                                     ""
                                     ""
                                     "ʤϤˤ롣줫ɤФ褤"
                                     "Τ"
                                     ))
                                   (#t (kern-ui-paginate-text
                                        "ʤΤ褦ž¤"
                                        "ϡĤ礭ʳ򤷤餷"
                                        ""
                                        "ʤϤϤǲ򸫤Τ"
                                        ))
                                   )

                             )
                            )
                        )
	))

;;-----------------------
;; calltoarms

(define (quest-calltoarms-update)
	(let* ((quest (quest-data-get 'questentry-calltoarms))
			(quest-tbl (car (qst-payload quest)))
			(header (kern-ui-paginate-text
					"ʤƻդȸƤФԤ顢Ǥ᤯"
					"񤤤褦ˡȤθդä"
					"")))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond ((tbl-flag? 'done)
		(kern-ui-paginate-text
			"ɤϤ򸫼븭ԤΰͤǤƻդζ"
			"Ϥ줿"
		))
	((tbl-flag? 'talked)
		(append header
		(kern-ui-paginate-text
			"ƻդȲäफϲζϤ"
			"ʤä"
		)))
	((tbl-flag? 'tower)
		(append header
		(kern-ui-paginate-text
			"Ӥƻդˤɤ夤"
			"Τ񤷤"
		)))
	((tbl-flag? 'directions)
		(append header
		(kern-ui-paginate-text
			"ƻդϡȥꥰ쥤̡֤ɤ"
			"μӤˤ뤽"
		)))
	(#t
		(append header
		(kern-ui-paginate-text
			"ɤ夯ޤǤƻΤϺŤƤԤ"
			"ҤͤȤ褤褦"
		)))
)

		)
	))

;; give some xp for reaching the tower
(define (quest-calltoarms-tower kplace kplayer)
	(quest-data-update-with 'questentry-calltoarms 'tower 1 (quest-notify (grant-xp-fn 5)))
	)

;;-----------------------
;; thiefrune

;; TODO: make the theft appear not to happen until the player is on the scene, by altering convs based on quest status

(define (quest-thiefrune-update)
	(let* ((quest (quest-data-get 'questentry-thiefrune))
			(quest-tbl (car (qst-payload quest)))
			(header (kern-ui-paginate-text
					"ƻդ㤫߽ФԤĴ褦ˤ"
					""
					"")))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond ((tbl-flag? 'recovered) 
		(append header
		(kern-ui-paginate-text
			"ťɤͤᡢƻդǤ᤹Ȥ"
			""
		)))
	((tbl-flag? 'talked)
		(append header
		(kern-ui-paginate-text
			"ťΥͥߤȤϸĤǤ"
		)))
	((tbl-flag? 'den5)
		(append header
		(kern-ui-paginate-text
			"ťαȤϥܥˤäǸ櫤ˤ"
			""
		)))
	((tbl-flag? 'den4)
		(append header
		(kern-ui-paginate-text
			"ťαȤϥܥˤäޤ3ˤ"
			"˲᤮ʤ"
		)))
	((tbl-flag? 'den3)
		(append header
		(kern-ui-paginate-text
			"ťαȤϥܥˤäޤ2ˤ"
			"˲᤮ʤ"
		)))
	((tbl-flag? 'den2)
		(append header
		(kern-ui-paginate-text
			"ťαȤϥܥˤäޤ1ˤ"
			"˲᤮ʤ"
		)))
	((tbl-flag? 'den1)
		(append header
		(kern-ui-paginate-text
			"ťαȤϥܥˤäϸǤ"
		)))
	((tbl-flag? 'bole)
		(append header
		(kern-ui-paginate-text
			"^c+mť^c-Ͽ̤ؿʤ褦"
			"ܥ줬Ǥ⤢ꤦ"
		)))
	((tbl-flag? 'tower)
		(append header
		(kern-ui-paginate-text
			"^c+mť^c-ϻƻ˸äƿʤ褦"
			"ޤФĴ٤Ȥ褵"
		)))
	(#t
		(append header
		(kern-ui-paginate-text
			"^c+mť^c-ϥȥꥰ쥤֤ؤȸä褦"
			"ĮοͤΤäƤ뤫⤷ʤ"
		)))
)

		)
	))

;; give some xp for getting through the dungeon
(define (quest-thiefrune-den1 kplace kplayer)
	(quest-data-update 'questentry-thiefrune 'tower 1)
	(quest-data-update 'questentry-thiefrune 'bole 1)
	(quest-data-update-with 'questentry-thiefrune 'den1 1 (quest-notify (grant-party-xp-fn 10)))
	)
(define (quest-thiefrune-den2 kplace kplayer)
	(quest-data-update-with 'questentry-thiefrune 'den2 1 (quest-notify (grant-party-xp-fn 10)))
	)
(define (quest-thiefrune-den3 kplace kplayer)
	(quest-data-update-with 'questentry-thiefrune 'den3 1 (quest-notify (grant-party-xp-fn 10)))
	)
(define (quest-thiefrune-den4 kplace kplayer)
	(quest-data-update-with 'questentry-thiefrune 'den4 1 (quest-notify (grant-party-xp-fn 10)))
	)
(define (quest-thiefrune-den5 kplace kplayer)
	(quest-data-update-with 'questentry-thiefrune 'den5 1 (quest-notify (grant-party-xp-fn 10)))
	)


;;-----------------------
;; runeinfo

;; TODO: runes are unidentified until you check in with abe?

(define (quest-runeinfo-update)
	(let* ((quest (quest-data-get 'questentry-runeinfo))
			(quest-tbl (car (qst-payload quest)))
			(header (kern-ui-paginate-text
				"ޤ줿Ǥϡťä餹Ƚʰ̣"
				"褦ƻդϤʤˤΰ̣Ĵ"
				"褦̿"
				""
				)))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"ʤλäƤǤϰθΰĤȸ"
			"Ƥ롣̤Τɤˤ뤽"
			"ΡԤˤä졢̡˱"
			""
		))
	((tbl-flag? 'gate)
		(append header
		(kern-ui-paginate-text
			"ǤϰθȤƤ롣̤Τ"
			"ˤ뤽ϱΡԤˤä"
			"졢̡˱줿"
		)))
	((tbl-flag? 'keys)
		(append header
		(kern-ui-paginate-text
			"ǤϰθȤƤ롣"
			"̣ΤϤ狼ʤ"
		)))
	((tbl-flag? 'abe)
		(append header
		(kern-ui-paginate-text
			"ϣѻդ^c+m^c-Ȳ񤦤Ȥ򴫤᤿Ф"
			"ˤơǤΤȤ򸦵椷Ƥ롣"
		)))
	(#t
		(append header
		(kern-ui-paginate-text
			"ϻϤ˥ѡ^c+mϣѻ^c-˲񤦤Ȥ褤"
			"ʤȸä"
		)))
)

		)
	))


;;-----------------------
;; dragon blood

(define (quest-dragon-update quest)
	(let* ((quest-tbl (car (qst-payload quest)))
			(header (kern-ui-paginate-text
				"ϣѻդεηäƤи򴹤ǤΤ"
				"򶵤ȸä"
				)))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"εηȸ򴹤ϣѻդǤΤ꤫ʹ"
			""
		))
	((in-inventory? (car (kern-party-get-members (kern-get-player))) t_dragons_blood 1)
		(append header
		(kern-ui-paginate-text
			""
			"1ӥεη줬ä"
		)))
	((tbl-flag? 'sea)
		(append header
		(kern-ui-paginate-text
			""
			"ϲФγõΤǤ褤Ǥȸä"
		)))
	(#t
		header
		)
)

		)
	))

;;-----------------------
;; deeps rune

(define (quest-rune-p-update)
	(let* ((quest (quest-data-get 'questentry-rune-p))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"Ǥϥݥꥹαˤä"
		))
	(#t
		(kern-ui-paginate-text
			"ϣѻդ饯ݥꥹα줿Ǥä"
			"ʹ"
			""
			"ΤϥݥꥹϲˤĤκ֤ۤ"
			"Ƥ롣ǤΰĤǤ⿼֤Ƥ"
			""
			""
			"֤ĤϤȥ٥뤬зФ"
			"ʤΤϷդޤȤͤΤ"
			"뤳Ȥ"
		))
)

		)
	))
	
	
;;-----------------------
;; spider rune

(define (quest-rune-f-update)
	(let* ((quest (quest-data-get 'questentry-rune-f))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"ӥμ줿Ǥ򥯥ν󥰥"
			"줿"
		))
	((and (tbl-flag? 'angrisslair) (tbl-flag? 'angriss))
		(kern-ui-paginate-text
			"ӥϤĤǤäƤ"
			"ϥ֥ΤȤ줿"
			""
			"֥󤿤äˤꥢ󥰥ꥹν߲ȤƳ"
			"줿ǤϤˤꤽ"
		))
	((tbl-flag? 'angriss)
		(kern-ui-paginate-text
			"ӥϤĤǤäƤ"
			"ϥ֥ΤȤ줿"
			""
			"֥Υޤ餽ξμ꤬"
			"(?)λ̮ܤˤ"
			""
		))
	((tbl-flag? 'kama)
		(kern-ui-paginate-text
			"ӥϤĤǤäƤ"
			"ϥ֥ΤȤ줿"
			""
			"֥󤿤ιΤäƤ褦⤷"
			"֥Υޤ򸫤Ĥ뤳ȤǤС"
			"ʤ"
		))
	((tbl-flag? 'gen)
		(kern-ui-paginate-text
			"ӥϤĤǤäƤ"
			"ϥ֥ΤȤ줿"
			""
			"֥󤿤ιΤäƤ褦ʹ"
			"ǤϷΥ󤬰֤褯ΤäƤ"
			""
		))
	(#t
		(kern-ui-paginate-text
			"ӥϤĤǤäƤ"
			"ϥ֥ΤȤ줿"
			""
			"֥󤿤ιΤäƤ褦"
			"ɤʹФФ"
		))
)

		)
	))
	
(define (quest-rune-f-lair kplace kplayer)
	(if (not (null? (quest-data-getvalue 'questentry-rune-f 'angriss)))
		(quest-data-update-with 'questentry-rune-f 'angrisslair 1 (quest-notify nil))
	))

;;-----------------------
;; void rune

;; todo add more sections? info on voidships, etc?

(define (quest-rune-d-update)
	(let* ((quest (quest-data-get 'questentry-rune-d))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"λǤ줿"
		))
	(#t
		(kern-ui-paginate-text
			"Ǥϵ˻ꡢǤ"
			"Ƥ뤽"
		))
)

		)
	))

;;-----------------------
;; pirate rune

(define (quest-rune-c-update)
	(let* ((quest (quest-data-get 'questentry-rune-c))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"Ǥ夲줿ῼǼ"
			""
		))
	((tbl-flag? 'shiploc)
		(append
			(kern-ui-paginate-text
			"±ƬƥϤĤǤäƤ"
			""
			)
			(kern-ui-paginate-text (string-append "ͩξ[" (number->string merciful-death-x) "," (number->string merciful-death-y) "]"))
			(if (tbl-flag? 'shipraise)
				(kern-ui-paginate-text
				""
				"ϡޥɥ쥤ݡλĴ"
				"礷<Vas Uus Ylem>μ"
				"ʸȤа夲롣"
				)
				nil
			)
		))
	((tbl-flag? 'info)
		(kern-ui-paginate-text
			"±ƬƥϤĤǤäƤ"
			""
			"ϥѡͩȤʤäƼ겼^c+m^c-Τõ"
			"Ƥ롣"
		))
	(#t
		(kern-ui-paginate-text
			"±ƬƥϤĤǤäƤ"
		))
)

		)
	))

;;-----------------------
;; pirate quest

(define (quest-ghertie-update)
	(let* ((quest (quest-data-get 'questentry-ghertie))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"ĤƳ±ƥͩѡνɤˤ"
			"Ȱˡξ"
			(string-append "뤳ȤǤ[" (number->string merciful-death-x) "," (number->string merciful-death-y) "]ˤ롣")
		))
	((tbl-flag? 'questinfo)
		(append
			(kern-ui-paginate-text
				"±ƥͩѡνɤˤ롣"
				"ΤἫʬ΢ڤä겼Ĥõ"
				"Ƥ롣"
				""
				"åȡ硼󡢤ƥߡˡϥƥ"
				"μ겼ξڤǤؤȤˤĤƤ롣ƥ"
				"ݤڵȤƻؤꡢ"
				"ȸ򴹤ξ򶵤ȸä"
			)
			(if (and (tbl-flag? 'ring-jorn)
						(tbl-flag? 'ring-meaney)
						(tbl-flag? 'ring-gholet))
				(kern-ui-paginate-text
					""
					"ɥλؤƼ줿"
				)
				(append
					(cond 
						((tbl-flag? 'ring-gholet)
							(kern-ui-paginate-text
								""
								"åȤΥɥλؤ줿"
							))
						((tbl-flag? 'gholet-price)
							(kern-ui-paginate-text
								""
								"åȤϥ饹ɥϲϴƤ"
								"롣1θƻȻؤ򴹤"
								"ä"
							))
						((tbl-flag? 'gholet-dungeon)
							(kern-ui-paginate-text
								""
								"åȤϥ饹ɥϲϴƤ"
								"롣"
							))
						((tbl-flag? 'gholet-prison)
							(kern-ui-paginate-text
								""
								"åȤϤ⤷ƤФɤϴˤ"
								""
							))
						(#t nil)
					)
					(cond 
						((tbl-flag? 'ring-jorn)
							(kern-ui-paginate-text
								""
								"硼Υɥλؤ줿"
							))
						((tbl-flag? 'jorn-loc)
							(kern-ui-paginate-text
								""
								"硼Ф򤭲ˤ롣"
							))
						((tbl-flag? 'jorn-forest)
							(kern-ui-paginate-text
								""
								"硼ϹʿΤɤ±äƤ롣"
							))
						(#t nil)
					)
					(cond 
						((tbl-flag? 'ring-meaney)
							(kern-ui-paginate-text
								""
								"ߡˡΥɥλؤ줿"
							))
						((tbl-flag? 'meaney-loc)
							(kern-ui-paginate-text
								""
								"ߡˡϥѡ̤ˤϱƯƤ"
								"롣"
							))
						(#t nil)
					)
				)
			)
		))
	(#t
		(kern-ui-paginate-text
			(string-append(if (tbl-flag? 'ghertieid)
					"±ƥͩ"
					"ͩ")
				(if (tbl-flag? 'ghertieloc)
					"ѡνɤˤ롣"
					"ѡˤ롣")
			)
			(if (tbl-flag? 'revenge)
				"^c+m^c-˾Ǥ롣С\nʤ˶Ϥ뤫⤷ʤ"
				(string-append "ʤ"
					(if (tbl-flag? 'ghertieid) "" "")
					"ϻǤ⤽˵¤äƤΤ"
				)
			)
		))
)

		)
	))


;;------------------------------------------------------------------------ 
;; Warritrix rune
;; 

(define (quest-rune-l-update)
	(let* ((quest (quest-data-get 'questentry-rune-l))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"ǤƮΤ˴äƤ"
		))
	((and (tbl-flag? 'located) (tbl-flag? 'know-hall))
		(kern-ui-paginate-text
			"ǤΰĤƮΤ⤤Ƥ롣"
			"ϥɤߤˤ뼺줿ƲǸ"
			""
			(string-append
			"[" 
			(number->string (loc-x lost-halls-loc)) "," (number->string (loc-y lost-halls-loc))
			"]ˤ롣"
			)
		))
	((and (tbl-flag? 'located) (tbl-flag? 'approx-hall))
		(kern-ui-paginate-text
			"ǤΰĤƮΤ⤤Ƥ롣"
			"ϥɤߤˤ뼺줿ƲǸ"
			""
		))
	((tbl-flag? 'located)
		(kern-ui-paginate-text
			"ǤΰĤƮΤ⤤Ƥ롣"
			"ϼ줿ƲǸĤ"
		))
	(#t
		(kern-ui-paginate-text
			"ǤΰĤƮΤ⤤Ƥ롣"
		))
)		

		)
	))

;;-----------------------
;; absalot rune

(define (quest-rune-s-update)
	(let* ((quest (quest-data-get 'questentry-rune-s))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'done)
		(kern-ui-paginate-text
			"֥åȤΰפǤ򸫤Ĥ"
		))
	((tbl-flag? 'silasinfo)
		(kern-ui-paginate-text
			"饹ϥ֥åȤΰפǤ򱣤Ƥ"
			"롣"
		))
	(#t
		(kern-ui-paginate-text
			"Ǥϥ֥åȤΤɤˤ"
		))
)

		)
	))

;;-----------------------
;; enchanter rune
;; tracks if the player has gotten the rune back from the enchanter

(define (quest-rune-k-update)
	(let* ((quest (quest-data-get 'questentry-rune-k))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond 
	((tbl-flag? 'entrusted-with-rune)
		(kern-ui-paginate-text
			"ƻդϤʤμǤ¤"
		))
	((tbl-flag? 'player-got-rune)
		(kern-ui-paginate-text
			"μǤƻդΤΤϤʤμ"
			"ˤ롣"
		))
	((tbl-flag? 'ench-should-have-rune)
		(kern-ui-paginate-text
			"μǤƻդΤΤ᤻"
			"ƻդο"
		))
	(#t
		(kern-ui-paginate-text
			"μǤƻդΤΤ"
		))
)

		)
	))

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Search for the Wise quest group

(define (quest-wise-init)
	(quest-data-assign-once 'questentry-wise)
	(map (lambda (tag)
		 (if (not (null? (quest-data-getvalue tag 'name)))
			(quest-data-assign-once tag)
		))
		(list 'questentry-enchanter 'questentry-warritrix  'questentry-alchemist
						'questentry-the-man 'questentry-engineer  'questentry-necromancer)
	))

(define (quest-wise-subinit tag)
	(quest-data-update tag 'name 1)
	(if (quest-data-assigned? 'questentry-wise)
		(quest-data-assign-once tag)
	)
	)

;; TODO- merge lost hall location info with rune quest	
(define (quest-warritrix-update)
	(let* ((quest (quest-data-get 'questentry-warritrix))
			(quest-tbl (car (qst-payload quest))))
		(define (tbl-flag? tag) (not (null? (tbl-get quest-tbl tag))))
		(qst-set-descr! quest
		
(cond
	((tbl-flag? 'avenged)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤä"
			"ϼ줿ƲԤˤƤ"
			""
			"΢ڤäԤβ˺ۤ줿"
		))
	((tbl-flag? 'found)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤä"
			"ϼ줿ƲԤˤƤ"
		))
	((tbl-flag? 'slain)
		(cond
			((tbl-flag? 'lost-hall-loc)
				(kern-ui-paginate-text
					"ƮΤϤλǺǤѤΤä"
					"κϺϵˤ롣"
					""
					"˴Ϥޤ줿Ʋˤ롣"
					(string-append
					"["
					(number->string (loc-x lost-halls-loc)) "," (number->string (loc-y lost-halls-loc))
					"]ˤ롣"
					)
				))
			((tbl-flag? 'lost-hall)
				(kern-ui-paginate-text
					"ƮΤϤλǺǤѤΤä"
					"κϺϵˤ롣"
					""
					"˴Ϥޤ줿Ʋˤ롣"
				))
			(#t
				(kern-ui-paginate-text
					"ƮΤϤλǺǤѤΤä"
					"κϺϵˤ롣"
					""
					"ƤȤϥ饹ɥĮ˻ŤƤ"
				))
		))
	((tbl-flag? 'lost-hall-loc)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤϺǼ"
			"줿Ʋ˱Ƥ롣"
			(string-append
			"["
			(number->string (loc-x lost-halls-loc)) "," (number->string (loc-y lost-halls-loc))
			"]ˤ롣"
			)
		))
	((tbl-flag? 'lost-hall)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤϺǼ"
			"줿Ʋ˱Ƥ롣"
		))
	((tbl-flag? 'assignment)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤϺǥ"
			"饹ɥΥƤ롣"
		))
	((tbl-flag? 'general-loc)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤʤ"
			"饹ɥˤ롣"
		))
	((tbl-flag? 'common)
		(kern-ui-paginate-text
			"ƮΤϤλǺǤѤΤ"
		))
	(#t
		(kern-ui-paginate-text
			"ƮΤϸԤΰͤ"
		))
)

		)
	))
