;;----------------------------------------------------------------------------
;; Gob
;;
;; Quest flags, etc, go here.
;;----------------------------------------------------------------------------
(define (roland-mk free? joined? greeted?) (list free? joined? greeted?))
(define (roland-is-free? knpc) (car (kobj-gob-data knpc)))
(define (roland-joined? knpc) (cadr (kobj-gob-data knpc)))
(define (roland-greeted? knpc) (caddr (kobj-gob-data knpc)))
(define (roland-set-free! knpc) (set-car! (kobj-gob-data knpc) #t))
(define (roland-set-joined! knpc) (set-car! (cdr (kobj-gob-data knpc)) #t))
(define (roland-set-greeted! knpc) (set-car! (cddr (kobj-gob-data knpc)) #t))

(define roland-greetings
  (list
   "ˤϡ"
   "⤷¤¡"
   ))

;;----------------------------------------------------------------------------
;; Custom AI
;; 
;; This AI controls Roland until he is freed. It constantly tries to pathfind
;; to the prison exit. Once it gets outside the cell it sets the "freed" flag
;; and resorts to the default kernel AI.
;;----------------------------------------------------------------------------
(define (roland-exit-point knpc)
  (mk-loc (kobj-place knpc)
          (rect-x slimey-cavern-prison-cell-exit)
          (rect-y slimey-cavern-prison-cell-exit)))

(define (roland-ai knpc)
  (define (out-of-cell?)
    (not (loc-in-rect? (kern-obj-get-location knpc)
                       slimey-cavern-prison-cell)))
  (define (try-to-escape)
    (kern-log-enable #f)
    (pathfind knpc (roland-exit-point knpc))
    (kern-log-enable #t))
  (define (set-free)
    (roland-set-free! knpc)
    (kern-char-set-ai knpc nil)
    (kern-being-set-base-faction knpc faction-men)
    )
  (or (roland-greeted? knpc)
      (and (any-player-party-member-visible? knpc)
           (begin
             (taunt knpc nil roland-greetings)
             (roland-set-greeted! knpc))))
  (if (out-of-cell?)
      (set-free knpc)
      (try-to-escape)))

;; Note: (can-pathfind? ...) will pathfind through the locked door nowadays, so
;; it cannot be relied on. Let's just let Roland try to get out and he'll know
;; he's free.
(define (roland-is-or-can-be-free? knpc)
  (roland-is-free? knpc))

(define (roland-join-player knpc)
  (or (roland-joined? knpc)
      (begin
        (join-player knpc)
        (roland-set-joined! knpc #t))))

;;----------------------------------------------------------------------------
;; Conv
;;
;; ɤιεΤǡӥ˻ŤƤ
;; ϺǤǴݤƶϴ館Ƥ롣
;; ɤ֤ˤʤ롣
;;----------------------------------------------------------------------------
(define (roland-join knpc kpc)
  (if (is-player-party-member? knpc)
      (say knpc "֤ˤʤäƤ롣Ƴ졪")
      (if (roland-joined? knpc)
          (begin
            (say knpc "Ƥ֤˲ääȤ̾˻פ")
            (join-player knpc)
            (kern-conv-end)
            )
          (if (roland-is-or-can-be-free? knpc)
              ;; yes - will the player accept his continued allegiance to
              ;; Froederick?
              (begin
                (say knpc "Ƥ줿Ȥ˴դ롪ʤ̿βͤʤ֤˲äꤿɤ")
                (if (yes? kpc)
                    (begin
                      (say knpc "ɤ˻פ"
                           "ʤ餺Ԥϻγʪåä"
                           "ΤˤϤ")
                      (roland-join-player knpc))
                    (say knpc "ᤷˡϤ˾ʤ顣")))
              (say knpc "ϴĤƤޤäΤФơ"
                   "֤ˤƤ졣")
              ))))
  
(define roland-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default 
               (lambda (knpc kpc) 
                 (say knpc "ǰʤ顢ϼǤˤʤ")))
       (method 'hail 
               (lambda (knpc kpc) 
                 (if (roland-joined? knpc)
                     (say knpc "Ǥʤ餢ʤΤ")
                     (roland-join knpc kpc))))

       (method 'bye (lambda (knpc kpc) (say knpc "褦ʤ顣")))
       (method 'job 
               (lambda (knpc kpc) 
                 (say knpc "ιεΤ")))
       (method 'name (lambda (knpc kpc) (say knpc "ϥɤ")))
       (method 'join roland-join)

       (method 'cell
               (lambda (knpc kpc)
                 (say knpc "ƻ񤬤򳫤롣"
                      "ǤʤС򳫤ʸ򾧤Ƥ졣")))
       (method 'clov
               (lambda (knpc kpc)
                 (say knpc "ϲݤ줿äƤΤ"
                      "ȻŨԤ˲񤤡򼺤ä"
                      "λƤäϹ˰̴򸫤"
                      "ܤФȡ±ˤΤ")))
       (method 'free
               (lambda (knpc kpc)
                 (say knpc "ԤˤƶͶƤޤäΤ"
                      "ۤϻ򤳤ϴĤᡢ׵ᤷƤ롣")))
       (method 'pick
               (lambda (knpc kpc)
                 (say knpc "±Ͼ˸ƻäƤ롣")))
       (method 'spel
               (lambda (knpc kpc)
                 (say knpc "ʸѻդʹƤ졣")))
       (method 'trig 
               (lambda (knpc kpc) 
                 (say knpc "ȥꥰ쥤֤̤ƻ򺹤Ȥˤ뾮Į"
                      "ˤĹˤ롣")))
       (method 'knig 
               (lambda (knpc kpc)
                 (say knpc "ϥ֥Τӥ˻ŤƤ"
                      "褬ꡢϲ褦ˤʤä")
                 ))
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-roland)
  (bind 
    (kern-mk-char 
     'ch_roland          ; tag
     ""        ; name
     sp_human            ; species
     oc_warrior          ; occ
     s_knight            ; sprite
     faction-prisoner    ; starting alignment
     6 0 6               ; str/int/dex
     pc-hp-off           ; hp bonus
     pc-hp-gain          ; hp per-level bonus
     0                   ; mp off
     0                   ; mp gain
     max-health          ; hp
     -1                  ; xp
     max-health          ; mp
     0                   ; ap
     3                   ; lvl
     #f                  ; dead
     'roland-conv        ; conv
     nil                 ; sched
     'roland-ai          ; special ai
     nil                 ; container
     nil                 ; readied
     )
    (roland-mk #f #f #f)))
