;; shroom.scm - Ф˽ˤΤϷ

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; Ф
;;----------------------------------------------------------------------------
(define (mk-zone x y w h) (list 'p_green_tower x y w h))
(kern-mk-sched 'sch_shroom
               (list 0  0  (mk-zone 51 9  1  1)  "sleeping")
               (list 5  0  (mk-zone 40 11 3  3)  "idle")
               (list 6  0  (mk-zone 49 6  7  1)  "working")
               (list 12 0  (mk-zone 50 9  1  1)  "eating")
               (list 13 0  (mk-zone 49 6  7  1)  "working")
               (list 18 0  (mk-zone 56 54 1  1)  "eating")
               (list 19 0  (mk-zone 53 50 4  7)  "idle")
               (list 21 0  (mk-zone 51 9  1  1)  "sleeping"))

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (shroom-mk gave-quest? finished-quest?) (list gave-quest? 
                                                      finished-quest?))
(define (shroom-gave-quest? shroom) (car shroom))
(define (shroom-quest-done? shroom) (cadr shroom))
(define (shroom-give-quest shroom) (set-car! shroom #t))
(define (shroom-set-quest-done! shroom) (set-car! (cdr shroom) #t))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 롼ȾǤꡢФäƤ롣
;; ϥ֥Ǥϥӥη襤βȸƤФƤ
;;----------------------------------------------------------------------------

(define shroom-merch-msgs
  (list "Υʤ󤫤äƤ롣ŹƤȤγѤʤ"
        "ΤɤǼΤ֤ΤäƤΤ"
        "ΤϤ뤫͡"
        "Υۤ롣㤦͡"
        "ĤƻȤäƤ衣"
        "ʬǼ˹ԤȤʡٰʤΤ˻衪"
        "Τäޤʡ"
        "ˤФ"
        "ɤ⡣"
        "̤ää"
   ))

(define shroom-catalog
  (list
   (list sulphorous_ash (*  2 reagent-price-mult) "ν򸫤Ĥˤϵ֤ΤäȸعԤͤФʤ")
   (list garlic         (*  3 reagent-price-mult) "ȪǼäΤܥͤ⤳Ĥ򵤤äƤ롣")
   (list ginseng        (*  3 reagent-price-mult) "ͤͻɤˤ뤫Ƥ줿")
   (list blood_moss     (*  4 reagent-price-mult) "ݤϡαλڤƤΤ")
   (list spider_silk    (*  5 reagent-price-mult) "λϤʤΤѤ")
   (list nightshade     (* 10 reagent-price-mult) "ʥȥɤζ᤯õͤФʤ")
   (list mandrake       (*  8 reagent-price-mult) "ޥɥ쥤ϤοƤ롣ɤˤΤΤäƤۤϾʤ")
   
   (list t_heal_potion  20 "ϴʤäȤΤäƤȤ褤")
   (list t_mana_potion  20 "õꡢμʸ򾧤ˤĤȤäƤ롣")
   (list t_cure_potion  20 "̵ѿǤ򿩤äƤޤä餳ĤȤФ")
   (list t_poison_immunity_potion 20 "Ǥξ¤õȤϤĤ⤳ĤǤ롣")
   (list t_slime_vial   20 "ۤϤ򹥤ࡣ⤤Ƥ롣ͥХͥФ餢äƤ­ʤ餤")
   ))

;; Shroom's merchant procedure
(define (shroom-trade knpc kpc) (conv-trade knpc kpc "trade" shroom-merch-msgs shroom-catalog))

;; Shroom's mushroom quest
(define (shroom-wards knpc kpc)
  (let ((shroom (kobj-gob-data knpc)))
    (if (shroom-gave-quest? shroom)
        ;; gave quest
        (if (shroom-quest-done? shroom)
            ;; quest already done
            (say knpc "¾Ϥߤ˺ޤä")
            ;; quest NOT yet done
            (begin
              (say knpc "ΥäƤвФμʸ򶵤褦"
                   "ФƤ뤫")
              (if (kern-conv-get-yes-no? kpc)
                  (say knpc "")
                  (say knpc "Τ©ϽαƤۤ褫"
                       "ĮΥ졢عԤȳζ᤯˻̮롣"
                       "ƶ"))))
        (begin
          (say knpc "Τ襤μʸ򤿤ΤäƤ"
               "Τꤿ")
          (if (kern-conv-get-yes-no? kpc)
              (begin
                (say knpc "ΤäƤʸϡФȤΤ"
                     "ޤߤʹƤ褤ʡ")
                (if (kern-conv-get-yes-no? kpc)
                    (begin
                      (say knpc "ƶˤϻ翧ΥΥƤ롣"
                           "äƤΤ狼äʡ")
                      (if (kern-conv-get-yes-no? kpc)
                          (begin
                            (say knpc "ƶϥͥХͥФ"
                                 "бӥ򤿤äƤ")
                            (shroom-give-quest shroom))
                          (say knpc "ʡݤ")))
                    (say knpc "Ǥϲ㤨󤾡㤤Ρ")))
              (say knpc "̵ʡ󤿤Τ褦ͥΤϡΤ褦ǯ鶵뤳ȤϲʤΤ͡"))))))
                               
(define (shroom-hail knpc kpc)
  (let ((shroom (kobj-gob-data knpc)))
    (display "shroom: ")
    (display shroom)(newline)
    (if (shroom-gave-quest? shroom)
        ;; gave quest
        (if (shroom-quest-done? shroom)
            ;; quest done
            (say knpc "ޤäʡ㤤¤ͤ衣")
            ;; quest not done yet
            (if (in-inventory? kpc t_royal_cape)
                (begin
                  ;; player has shrooms
                  (say knpc "줸㡪ΥΥ")
                  (kern-obj-remove-from-inventory kpc t_royal_cape 1)
                  (shroom-set-quest-done! shroom)
                  (say knpc "֤"
                       "μʸؤΥ󡦥եࡦ󥯥<In Flam Sanct>"
                       "륱βγǤĴ礷"
                       "򾧤ʬ֤ˤȡФȤʤʤΤ㡪"))
                ;; player does NOT have shrooms yet
                (say knpc "ޤ翧ΥΥϸĤ̤褦ʡ"
                      "뤳ȤϤʤ"
                      "ˤߤ͡")))
        ;; has NOT given quest yet
        (say knpc "ʤѤ͡"))))

(define (shroom-thie knpc kpc)
  (say knpc "ۤϸʤä͡"))

(define (shroom-roya knpc kpc)
  (say knpc "륱λȤΤäƤ뤫")
  (if (yes? kpc)
      (say knpc "ä˼ʤǴݤΤǸĤ뤳Ȥ롣")
      (say knpc "ĤˤϵۼϤ롪")))

(define (shroom-band knpc kpc)
  (say knpc "±ǯϿǤϵĤͤС"))

(define shroom-conv
  (ifc basic-conv
       ;; default if the only "keyword" which may (indeed must!) be longer than
       ;; 4 characters. The 4-char limit arises from the kernel's practice of
       ;; truncating all player queries to the first four characters. Default,
       ;; on the other hand, is a feature of the ifc mechanism (see ifc.scm).
       (method 'default (lambda (knpc kpc) (say knpc "ʹ褦ʵʡ")))
       (method 'hail shroom-hail)
       (method 'bye (lambda (knpc kpc) (say knpc "Ф㡣")))
       (method 'job (lambda (knpc kpc) (say knpc "ʤɤäƤ롣")))
       (method 'name (lambda (knpc kpc) (say knpc "롼ȸƤФƤ롣"
                                                "Ѥϲ͡")))
       (method 'cape shroom-roya)
       (method 'roya shroom-roya)
       (method 'shro (lambda (knpc kpc) (say knpc "ΥΤȤ褯ΤäƤ롣"
                                                "餢򥷥롼ȸƤ֤͡")))
       (method 'maid (lambda (knpc) (say knpc "ϲܤȴƤޤä򸫤"
                                           "ĤβȸƤФ줿ʤƿ뤫"
                                           "ϥ饱ȾФä")))
       (method 'mush shroom-trade)
       (method 'buy (lambda (knpc kpc) (conv-trade knpc kpc "buy" shroom-merch-msgs shroom-catalog)))
       (method 'trad shroom-trade)
       (method 'sell (lambda (knpc kpc) (conv-trade knpc kpc "sell" shroom-merch-msgs shroom-catalog)))
       (method 'reag shroom-trade)
       (method 'poti shroom-trade)
       (method 'join (lambda (knpc) (say knpc "ˤϼ㤹衢˷䡪")))
       (method 'gen (lambda (knpc) (say knpc "㤤Ȥϥϥ󥵥ä"
                                        "˥٥åɤΤ"
                                        "ʤäޤä"
                                        "֥ɤʤƤ")))
       (method 'stra (lambda (knpc) (say knpc "Ͽǥ֥ãȲ񤤡"
                                            "˼򤹤褦ˤʤä"
                                            "Ⱦʬ֥ߤʤΤ"
                                            "ۤΤޤͤƤǤ⡢"
                                            "⤦ΥХˤᤵ뤳ȤϤǤ衣")))
       (method 'gobl (lambda (knpc) (say knpc "ۤȤϺΤ⾦򤷤Ƥ롣"
                                            "ۤμѻդϤοοʪ褯ΤäƤ롣"
                                            "ۤθդϾʬ뤷ˡ⾯ʬ롣"
                                            "ۤФ˿ѤǤ")))
       (method 'thie shroom-thie)
       (method 'trus (lambda (knpc) (say knpc "֥ϵ񤬤л֤˰㤤ʤ"
                                          "ۤʤ餽롪")))
       (method 'wars (lambda (knpc) (say knpc "ϥ֥ɤä"
                                         "äΤΤȤͤ˺ޤä͡")))
       (method 'ward shroom-wards)
       (method 'spel shroom-wards)
       (method 'band shroom-band)
       ))

;;----------------------------------------------------------------------------
;; First-time constructor
;;----------------------------------------------------------------------------
(define (mk-shroom tag)
  (bind 
   (kern-mk-char tag                 ; tag
                 "롼"        ; name
                 sp_human            ; species
                 nil                 ; occ
                 s_companion_druid   ; sprite
                 faction-men         ; starting alignment
                 1 6 1               ; str/int/dex
                 0 0                 ; hp mod/mult
                 0 0                 ; mp mod/mult
                 max-health -1 max-health 0 3  ; hp/xp/mp/AP_per_turn/lvl
                 #f                  ; dead
                 'shroom-conv        ; conv
                 sch_shroom          ; sched
                 'townsman-ai                 ; special ai
                 (mk-inventory (list (list 1 t_sword)))                 ; container
                 (list t_armor_leather)                 ; readied
                 )
   (shroom-mk #f #f)))
