;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define silas-lvl 8)
(define silas-species sp_human)
(define silas-occ oc_wizard)
(define shrine-path-x 97)
(define shrine-path-y 5)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ť֥å
;;----------------------------------------------------------------------------
(define silas-bed oa-bed1)
(define silas-mealplace oa-tbl3)
(define silas-workplace oa-temple)
(define silas-leisureplace oa-baths)
(kern-mk-sched 'sch_silas
               (list 0  0 silas-bed          "sleeping")
               (list 7  0 silas-mealplace    "eating")
               (list 8  0 silas-workplace    "working")
               (list 12 0 silas-mealplace    "eating")
               (list 13 0 silas-workplace    "working")
               (list 18 0 silas-mealplace    "eating")
               (list 19 0 silas-leisureplace "idle")
               (list 22 0 silas-bed          "sleeping")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (silas-mk) 
  (list #f (mk-quest) #f))
(define (silas-set-will-help! gob) (set-car! gob #t))
(define (silas-will-help? gob) (car gob))
(define (silas-quest gob) (cadr gob))
(define (silas-met? gob) (caddr gob))
(define (silas-set-met! gob) (set-car! (cddr gob) #t))

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 饹ϼ줿ԤΰλƳԤǤ롣
;; ܤ٤ϤäѻդǤ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (silas-hail knpc kpc)
  (if (silas-met? (kobj-gob-data knpc))
      (say knpc "ޤäʡ¤ͤ衣")
      (begin
        (silas-set-met! (kobj-gob-data knpc))
        (say knpc "Τʤ̥ŪϷͤȲäϤ褦ι"
             "ιͤ㤤ǤʤС¤ͤǤɤ͡")
        (if (yes? kpc)
            (say knpc "ȻפäԤäƤ衣")
            (say knpc "餫ˤʤθȤ򿮤Ƥʤ"
                 "¿ʤΤʡ"
                 "äȷԤäƤ")))))

(define (silas-default knpc kpc)
  (say knpc "ǰϼǤ̡"))

(define (silas-name knpc kpc)
  (say knpc "顣ϥ饹"
       "ϡͧ衢鷺Ȥ褤"))

(define (silas-ask-help knpc kpc)
  (cond ((yes? kpc)
         (say knpc "ʹӤɽȤǤʤ"
              "¦ˤĤȤǡɤ˴˾Ȱο⤿餹ȤǤ"
              "ϤǤƤ뤫٤Ȥ롣")
         (silas-set-will-help! (kobj-gob-data knpc))
         (make-allies knpc kpc)
         )
        (else
         (say knpc "ΤޤޤǤϵ路"
              "ʤǺԤͤФʤʤ"
              "ǰΤäƤ"
              "¤ͤΤϾˤѤȤǤä"
              "¤ͤιԤĤ뤤ϹԤʤȡĤȤƤθοɴǯα̿᤿Τ")
         )))

(define (silas-join knpc kpc)
  (say knpc "ϾФäϼºݡ֤˲ä褦Ĥä"
       "ܤˤ϶ˤƺʻŻ롣Ϥȶˤ뤲Ǥ"
       "μ򤷤Ƥߤ̤")
  (silas-ask-help knpc kpc)
  )

(define (silas-job knpc kpc)
  (say knpc "ɸϤΥɤ˿⤿餹Ȥ"
       "¿ξ㳲ˤϲäƤ롣"
       "ƤŪΤˤϺǽԤɬפ"
       "¤ͤ衣μ򤷤Ƥߤ̤ʤ뤲ʤ")
  (silas-ask-help knpc kpc)
  )

(define (silas-help knpc kpc)
  (say knpc "μ򤷤Ƥߤ̤")
  (silas-ask-help knpc kpc)
  )

(define (silas-bye knpc kpc)
  (say knpc "褦ʤ顢¤͡ƹ"))

;; Tier 2
(define (silas-expe knpc kpc)
  (say knpc "褿ȤʹƤ"
       "٤ᤫ췯뤳ȤϤ狼äƤ"
       "¤ͤˤˤĤƤĴƤ롣"))
(define (silas-hist knpc kpc)
  (say knpc "Ͼο޽ۤϾƤȾεϿƤޤä"
       "¤ͤεϿϤˤ鷺ܤ˻ĤäƤΤ̡"
       "Ƭ򿶤ä"))
(define (silas-wand knpc kpc)
  (say knpc "Ƥ¤ͤϺŤ̤ä褿Τ褦ˤ̤礬뤳ȤΤäƤ뤫͡")
  (if (yes? kpc)
      (say knpc "褯狼äƤʡΤȤ")
      (say knpc "ϳΤ¸ߤ롣ȤΤƤΤ")))

(define (silas-demo knpc kpc)
  (say knpc "Ρϥɤ̤Ǥ"
       "Τȿβǡ"
       "ѻդϤ̤ͳ˹Ԥ褷"
       "μʪͭƤ")
  (prompt-for-key)
  (say knpc "ǽŪˤ꤬Ϥ᤿"
       "̤μԤȤäƼʼư¾Ϥ᤿Τ"
       "ɤ˿ʹ뤳Ȥ򶲤줿ѻդϡȬĤܤ"
       "ȬĤʬ줿뤳Ȥˤ"))

(define (silas-key knpc kpc)
  (if (any-in-inventory? kpc rune-types)
      (say knpc "ϷäƤ褦̤Ǥ")
      (say knpc "̤ǤǰϤλ˼Ƥޤä")))

(define (silas-rune knpc kpc)
  (say knpc "ŪΤƤμ줿ǤᤵʤФʤʤ"
       "˰ʱ뤳Ȥ򤷤ȤƤ⡢"
       "ǤιΤꡢư˴ʤФʤʤƱդ뤫͡")
  (if (yes? kpc)
      (say knpc "ϤޤäȤˤǤ")
      (say knpc "ͤƤߤ衣⤷ǤԤμ顢"
           "⤷ɤͤФʤʤȤ褿顢"
           "⤷̤νɬפˤʤäȤ顩"
           "褷ƳĤ꤬ʤȤƤ⡢褬ΤϤ褤Ȥ")))

;; Accursed, Wise
(define (silas-accu knpc kpc)
  (say knpc "ϾФäϤ̤ꡣϼ줿Ԥ"
       "ǰʤȤˡ¿μԤΰŪʶۤ餭Ƥ̾"
       "äˤϲ桹γưؤäƤȤƤ롣"
       "ϤƵǸ롣"
       "桹οιԤȤǼ۸򤹤뤳ȤϤǤʤ"
       "桹Ϥߤ̩äƤ뤫"))

(define (silas-secr knpc kpc)
  (say knpc "줿ԤζϳμԤˤ̩ˤƤ롣"
       "ƶ򤫤ʼԤޤͤ褦Ȥ뤳ȤɤǤ롪"
       "Ǵ̵ΤʼԤˤ̵ѤΤΤ"
       "Ǹ褦ϲΤʤ͡򴬤ΤǤϤʤ"))

(define (silas-wise knpc kpc)
  (say knpc "븭ԡΤäƤǤ"
       "ºɤ٤ƲͤΤΰĤʤȤ᤮βͤǤä"
       "Τ©ϺθԤϥɤźǤʤ˸ˤʤäƤ롣"
       "֥åȤǤιԤͤƤߤޤ"))
 
(define (silas-absa knpc kpc)
  (say knpc "ʤ鷯ϴְ㤤ʤ򤷤Ƥ"
       "ƻա桹ζ˴ְäʤߤļԤϼ줿ԤǤܤȤ˿åƤꡢ"
       "饹ɥԤϤ˵̴Ƥ롣"
       "ϥɤĮİ뤫ǤܤĤ"
       "֥åȤϺǤԹΤ褤ǽɸä˲᤮ʤ"
       "ϴñ˾ڵ夲¾Įƻդ˲褦⤭"
       "ΤäƤ̤"))

;; Philosophy
(define (silas-evil knpc kpc)
  (say knpc "ȤϲʤΤǰΤ˸ϰ¸ߤʤȸäƤΤǤϤʤ"
       "ȤϲȤޤǤηδǰ䤦ƤΤ"
       "⤷ҤΤԤ桹˲Ǥ뤫äʤС桹Ϥθդ򤽤Τޤ޼٤"
       "桹Ȥϰ㤦ҤΤԤϡ鼫ȤŪΤǤϤʤ"
       "ưϡǧ褦ǧޤȡơŪư˴ŤƤ롣")
  (prompt-for-key)
  (say knpc "Ƽºݤˡ¤ͤ衢٤ʤΤ"
       "ƤμԤϼȤפΤ臘٤줬ʿ񤤤Ǥ롣"
       "ͤϳȴФȤǤʤζʤΤ"
       "ݤ뤳Ȥϼݤ뤳ȤǤꡢ"
       "ʬפ¾Ԥפͥ褹٤ȤͤϡƶήǤ롣"))

(define (silas-good knpc kpc)
  (say knpc "ˤĤƿҤͤƤʤ褦ߤƤΤϲ"
       "ʪߤԤƽƲͤġ"
       "դ˿ͤߤ뤳ȤϰǤ뤫Τ褦ˡ˾ޤ褦Ƥ롣"
       "εդǤ롪"
       "˽̩򶵤褦μԤ˾ϡ¾μԤ˾򲡤ळȤ"))

(define (silas-desi knpc kpc)
  (say knpc "Τư褦ˡ˾ư"
       "˾ʤк̵ϤǶ"
       "줿Ԥϡʤ˾ĤޤˤƤˤƤҤͤΤΤϲΤ뤳Ȥ"))

(define (silas-sacr knpc kpc)
  (say knpc "줿ԤζǤϵ˾ΤϤǤ롣"
       "򤱤ʤ̤Ƥˤ뤳ȤϤǤʤ"
       "˾μ¸ܻؤʤ顢¾βǽϼ롣"
       "ڤλޤϤߤˤäڤȤ褦ˡιԤλʬ٤ڤȤ롣"
       "줬桹εǽڤλޤ򴢤뤳ȡΰ̣"))

;; People
(define (silas-ench knpc kpc)
  (say knpc "बΤ褦ʼ줿ԤŨǤ뤳Ȥϻǰ"
       "बŤͻ̤ưٰȷ᤿ΤϿǷ褷ѤʤȤȤ϶Ƥ롣"
       "ԹʤȤȰδǰϸäƤꡢļ¸Բǽ"))

(define (silas-deni knpc kpc)
  (say knpc "ǥ˥ϿܤΨľ˸äϤ˷礱㤤ˤ"))

(define (silas-sele knpc kpc)
  (say knpc "ͤϺǽΤ㤤"
       "ԹʤȤˡϤ˰ʤĵԤ˾ްƤ롣"))
 
;; Quest-related
(define (silas-ques knpc kpc)
  (let* ((gob (kobj-gob-data knpc))
        (quest (silas-quest gob)))

    (define (has-all-runes?)
      (all-in-inventory? kpc rune-types))

    (define (missing-only-s-rune?)
      (all-in-inventory? kpc
                         (filter (lambda (ktype)
                                   (not (eqv? ktype t_rune_s)))
                                 rune-types)))

    (define (give-last-rune)
      (say knpc "ǸΰĤƤǤäƤ褦ʡ"
           "٤ƤȤߤǸΰĤϻ䤬θť֥åȤ˱Τ"
           "򸫤ĤΤκǸλȹͤƤ졣")
	(quest-data-update-with 'questentry-rune-s 'silasinfo 1 (quest-notify nil))
	(quest-data-assign-once 'questentry-rune-s)
	)

    (define (continue-quest) 
      (say knpc "ǸΰĤĤʤ褦ʡ¤ͤ衢ʡ"
           "Ԥ˿Ҥ͡ʥõꡢ󤯹õΤ"))

    (define (end-quest)
      (quest-done! quest #t)
      (say knpc "褯ä¤ͤ衣줿ǡαɸλƤä"
           "ˤ褯ä")
      (prompt-for-key)
      (say knpc "ƤǤäݴɤʤФʤʤ"
           "ոǤޤʤϸԤǤδѤǤʤ"
           "ƻռȤǤ")
      (prompt-for-key)
      (say knpc "ͤƤ뤫Ϥ狼롢ͧ衢ǤϤʤ"
           "ǻ䤬뤳ȤʤǤʤ˾Ǥ⤤ʤ"
           "ǤϤʤäʹͤΤ")
      (prompt-for-key)
      (say knpc "¤ͤ衣ʤ٤褿"
           "Τ˷ɤ˸ƤФ줿ΤȻϻפäƤ롣"
           "˼ꡢõ򤯡θˤΤ̤롣"
           "ͦ򼨤ƿ褬ȤʤΤäƤ뤫")
      (if (yes? kpc)
          (say knpc "ʤиԤˤⱣ줿̩򶵤褦ϤޤƤ롢ŨƱ"
               "򸫤뤫Ϥ狼ʤΤȤϤ狼äƤ롧Ũ")
          (say knpc "ϸȤϤϷ餦٤ȤǤϤʤ¤ͤ衢ϤΤ褽Ԥ"
               "ʤȤ⡢ϰݴɤƤʤͤѤĤ꤬ʤΤǤС")))
           
    (define (offer-quest)
      (say knpc "¤ͤ衣٤ǤפʻŻ롣"
           "ȬĤθǤõäƤ뤫")
      (if (yes? kpc)
          (begin
            (quest-accepted! quest #t)
            (cond
            	((has-all-runes?)
            		(say knpc "ǤǤäƤʡ")
            		(prompt-for-key)
            		(end-quest)
            		)
            	((missing-only-s-rune?)
            		(give-last-rune))
            	(#t
            		(say knpc "ˤʤꤽʼԤΤäƤ롣Ǥ⸭ˡѡϣѻդ"
            		"⤷ȤǤΤäƤ뤫Τʤ"
            		"ǽ˿ҤͤȤ褤"))
             ))
          (say knpc "򸫤ĤΤϲ桹ε̳˾ͧ衣"
               "ˤϷͳ뤳Ȥϵʤ")))

    (if (silas-will-help? gob)
        (if (quest-done? quest)
            (say knpc "õ")
            (if (quest-accepted? quest)
                (if (has-all-runes?)
                    (end-quest)
                    (if (missing-only-s-rune?)
                        (give-last-rune)
                        (continue-quest)))
                (offer-quest)))
        (say knpc "֤ˤʤʤˤ¿Τ٤Ȥȱɸ롣"
             "ϤǺǤ̾⤤¤͡ĥɤǺǤʱͺĤˤʤǤ"))
    ))

(define (pissed-off-silas knpc kpc)
  (map (lambda (tag)
         (if (defined? tag)
             (let ((kchar (eval tag)))
               (if (is-alive? kchar)
                   (begin
                     (kern-being-set-base-faction kchar faction-accursed)
                     (kern-char-set-schedule kchar nil)
                     )))))
       (list 'ch_silas 'ch_dennis 'ch_selene))
  (make-enemies knpc kpc)
  )

(define (silas-noss knpc kpc)
  (say knpc "ɽĤͧ衢ɤΤ褦ˤƤ̾Τä")
  (kern-conv-get-reply kpc)
  (say knpc "¾μԤˤ⤽Τ褦̤ޤäƤΤ")
  (if (yes? kpc)
      (say knpc "ȤȤǰ̤Ȥ褿褦")
      (say knpc "ǤιԤ̵ˡǡƺϾʱĤƤ롣"
           "ϤǤϴޤʤ"
           "˵ʤ"))
  (pissed-off-silas knpc kpc)
  (kern-conv-end)
  )

(define silas-conv
  (ifc basic-conv

       ;; basics
       (method 'default silas-default)
       (method 'hail silas-hail)
       (method 'bye  silas-bye)
       (method 'job  silas-job)
       (method 'name silas-name)
       (method 'join silas-join)

       (method 'absa silas-absa)
       (method 'accu silas-accu)
       (method 'demo silas-demo)
       (method 'deni silas-deni)
       (method 'denn silas-deni)
       (method 'desi silas-desi)
       (method 'ench silas-ench)
       (method 'evil silas-evil)
       (method 'expe silas-expe)
       (method 'gate silas-demo)
       (method 'good silas-good)
       (method 'help silas-help)
       (method 'hist silas-hist)
       (method 'key  silas-key)
       (method 'keys silas-key)
       (method 'noss silas-noss)
       (method 'ques silas-ques)
       (method 'rune silas-rune)
       (method 'sacr silas-sacr)
       (method 'secr silas-secr)
       (method 'sele silas-sele)
       (method 'task silas-job)
       (method 'wand silas-wand)
       (method 'wise silas-wise)
       ))

(define (mk-silas)
  (bind 
   (kern-mk-char 
    'ch_silas           ; tag
    "饹"          ; name
    silas-species         ; species
    silas-occ              ; occ
    s_silas     ; sprite
    faction-men      ; starting alignment
    0 5 0            ; str/int/dex
    2 1              ; hp mod/mult
    2 1              ; mp mod/mult
    max-health ; hp
    -1                   ; xp
    max-health ; mp
	0
    silas-lvl
    #f               ; dead
    'silas-conv         ; conv
    sch_silas           ; sched
    'spell-sword-ai  ; special ai
    nil              ; container
    (list t_stun_wand) ; readied
    )
   (silas-mk)))
