;;----------------------------------------------------------------------------
;; Constants
;;----------------------------------------------------------------------------
(define slywan-lvl 2)
(define slywan-species sp_human)
(define slywan-occ oc_wrogue)

;;----------------------------------------------------------------------------
;; Schedule
;; 
;; ʪ¼
;;----------------------------------------------------------------------------
(kern-mk-sched 'sch_slywan
               (list 0 0 kun-road "working")
               (list 2 0 campfire-2 "sleeping")
               (list 9 0 cantina-9 "idle")
               (list 14 0 black-market "idle")
               (list 17 0 cantina-9 "idle")
               (list 23 0 kun-road "working")
               )

;;----------------------------------------------------------------------------
;; Gob
;;----------------------------------------------------------------------------
(define (slywan-mk) nil)

;;----------------------------------------------------------------------------
;; Conv
;; 
;; 饤ť(̾ͤǤ)ǡʪ¼˽Ǥ롣
;;----------------------------------------------------------------------------

;; Basics...
(define (slywan-hail knpc kpc)
  (kern-log-msg "ʤؤ㤤ˤȲä")
  (say knpc "褪")
  )

(define (slywan-default knpc kpc)
  (say knpc "ϸ򤹤ǦӾФ򤷤")
  )

(define (slywan-name knpc kpc)
  (say knpc "饤󡢲Ǥɤ")
  )

(define (slywan-join knpc kpc)
  (say knpc "ʡͧ衣")
  )

(define (slywan-job knpc kpc)
  (say knpc "Ȥ狼")
  )

(define (slywan-bye knpc kpc)
  (let ((q (min (kern-player-get-gold)
                (kern-dice-roll "1d20"))))
    (take-player-gold q)
    (kern-obj-add-to-inventory knpc t_gold_coins q)
    (say knpc "ޤʡ")
    ))

(define (slywan-this knpc kpc)
  (say knpc "Ƥ"))

(define (slywan-that knpc kpc)
  (say knpc "Ƥ"))

(define (slywan-bust knpc kpc)
  (say knpc "äȡԤʤƤϡ")
  (kern-obj-add-effect knpc ef_invisibility nil)
  (kern-char-set-fleeing knpc #t)
  (kern-being-set-current-faction knpc faction-outlaw)
  (kern-conv-end)
  )

(define (slywan-thie knpc kpc)
  (say knpc "ʤˡ줬ޥ饫ͤäơ")
  (if (yes? kpc)
      (begin
        (say knpc "ܤäƤ롩")
        (if (yes? kpc)
            (slywan-bust knpc kpc)
            (say knpc "Ĥؤäء󤽤ʡʡĤʤä")))
      (say knpc "褫äʡϤҤɤĮï⿮㤤ʤ")))

(define slywan-conv
  (ifc nil

       ;; basics
       (method 'default slywan-default)
       (method 'hail slywan-hail)
       (method 'bye  slywan-bye)
       (method 'job  slywan-job)
       (method 'name slywan-name)
       (method 'join slywan-join)

       (method 'this slywan-this)
       (method 'that slywan-that)
       (method 'bust slywan-bust)
       (method 'thie slywan-thie)
       (method 'gold slywan-thie)
       (method 'stol slywan-thie)
       ))

(define (mk-slywan)
  (bind 
   (kern-char-force-drop
   (kern-mk-char 
    'ch_slywan           ; tag
    "饤"         ; name
    slywan-species         ; species
    slywan-occ              ; occ
    s_brigand     ; sprite
    faction-men      ; starting alignment
    1 0 4            ; str/int/dex
    0  ; hp bonus
    0 ; hp per-level bonus
    0 ; mp off
    1 ; mp gain
    max-health ; hp
    -1                   ; xp
    max-health ; mp
    0
    slywan-lvl
    #f               ; dead
    'slywan-conv         ; conv
    sch_slywan           ; sched
    'townsman-ai              ; special ai
    (mk-inventory nil) ;; container
    (list t_sword
					         t_armor_leather
					         )               ; readied
    )
   #t)
   (slywan-mk)))
